/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.datasyn;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hrss.business.domain.search.service.ESSynSchemeConfigHelp;
import kd.hrmp.hrss.business.domain.search.service.common.DataSyncCheckUtil;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjDataSyncService;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjSyncConfService;

public class ESSynSchemeListPlugin
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(ESSynSchemeListPlugin.class);
    private static final String SYNSTATUS_EXCEPTION = "5";
    private Map<Long, DynamicObject> processDataMap = new HashMap<Long, DynamicObject>();

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)formOperate.getOperateKey(), (String)"createsyntask")) {
            boolean dtsEnable = DataSyncCheckUtil.dtsEnable();
            boolean esConfig = DataSyncCheckUtil.esServiceConfig();
            if (dtsEnable && !esConfig) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6eES\u73af\u5883\u540e\uff0c\u518d\u6267\u884c\u6570\u636e\u540c\u6b65\u3002", (String)"ESSynSchemeListPlugin_0", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (!dtsEnable && esConfig) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u542f\u7528DTS\u540e\u518d\u6267\u884c\u6570\u636e\u540c\u6b65\u3002", (String)"ESSynSchemeListPlugin_1", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (!dtsEnable && !esConfig) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u542f\u7528DTS\u540e\u518d\u6267\u884c\u6570\u636e\u540c\u6b65\u3002", (String)"ESSynSchemeListPlugin_2", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                ListSelectedRowCollection listSelectedData = args.getListSelectedData();
                DynamicObject[] dynamicObjects = ESSynSchemeConfigHelp.getInstance().loadESSynRecordBySchemeId(listSelectedData.get(0).getPrimaryKeyValue());
                DynamicObject searchObjByScheme = ESSynSchemeConfigHelp.getInstance().getSearchObjByScheme(listSelectedData.get(0).getPrimaryKeyValue(), this.getView());
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String synstatus = dynamicObject.getString("synstatus");
                    if (HRStringUtils.equals((String)"1", (String)synstatus)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u5f53\u524d\u5b58\u5728\u72b6\u6001\u4e3a\u672a\u5f00\u59cb\u7684\u540c\u6b65\u4efb\u52a1\uff0c\u65e0\u9700\u91cd\u590d\u521b\u5efa\u540c\u6b65\u4efb\u52a1\u3002", (String)"ESSynSchemeListPlugin_3", (String)"hrmp-hrss-formplugin", (Object[])new Object[]{searchObjByScheme.getLocaleString("name").getLocaleValue()}));
                        args.setCancel(true);
                        return;
                    }
                    if (!HRStringUtils.equals((String)"2", (String)synstatus)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u6b63\u5728\u6570\u636e\u540c\u6b65\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u521b\u5efa\u540c\u6b65\u4efb\u52a1\u3002", (String)"ESSynSchemeListPlugin_4", (String)"hrmp-hrss-formplugin", (Object[])new Object[]{searchObjByScheme.getLocaleString("name").getLocaleValue()}));
                    args.setCancel(true);
                    return;
                }
                DynamicObject schemeId = ESSynSchemeConfigHelp.getInstance().loadSynSchemeById(listSelectedData.get(0).getPrimaryKeyValue());
                String status = schemeId.getString("essynstatus");
                if (HRStringUtils.equals((String)"1", (String)status)) {
                    return;
                }
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.processDataMap.clear();
        DynamicObject[] dynamicObjects = ESSynSchemeConfigHelp.getInstance().loadAllESSynRecordBySchemeIdOrderByPlanTime();
        Map<Long, List<DynamicObject>> collect = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(records -> records.getDynamicObject("essyncschemeid") == null ? 0L : records.getDynamicObject("essyncschemeid").getLong("id")));
        for (Map.Entry<Long, List<DynamicObject>> collectMap : collect.entrySet()) {
            Long key = collectMap.getKey();
            List<DynamicObject> value = collectMap.getValue();
            if (CollectionUtils.isEmpty(value)) continue;
            value.sort((o1, o2) -> {
                if (o1.getDate("plansynctime") == null) {
                    return 1;
                }
                if (o2.getDate("plansynctime") == null) {
                    return -1;
                }
                return o2.getDate("plansynctime").compareTo(o1.getDate("plansynctime"));
            });
            this.processDataMap.put(key, value.get(0));
        }
    }

    private void showErrorMesForm(String errorType, String searchObjName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrss_errormessage");
        showParameter.setCustomParam("errorType", (Object)errorType);
        showParameter.setCustomParam("searchObjName", (Object)searchObjName);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"donothing_esconfig")) {
            this.openEsConfigPage();
        } else if (HRStringUtils.equals((String)operateKey, (String)"createsyntask")) {
            this.openEssyncrecordPage(args.getOperationResult().getSuccessPkIds());
        } else if (HRStringUtils.equals((String)operateKey, (String)"viewallrecord")) {
            ListShowParameter lsp = new ListShowParameter();
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setWidth("1100");
            css.setHeight("600");
            lsp.getOpenStyle().setInlineStyleCss(css);
            lsp.setShowTitle(false);
            lsp.setHasRight(true);
            lsp.setBillFormId("hrss_essynrecord");
            lsp.setLookUp(true);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (actionId.equals("confirmHandsSyn") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrss_essynrunning");
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection col = billList.getSelectedRows();
            if (col == null || col.size() == 0) {
                return;
            }
            Object primaryKeyValue = col.get(0).getPrimaryKeyValue();
            String recordId = this.getPageCache().get("recordId");
            showParameter.setCustomParam("recordId", (Object)Long.valueOf(recordId));
            DynamicObject synScheme = ESSynSchemeConfigHelp.getInstance().loadSynSchemeById(primaryKeyValue);
            DynamicObject dynamicObject = synScheme.getDynamicObject("searchobj");
            if (dynamicObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"ESSynSchemeListPlugin_6", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                return;
            }
            Object pkValue = synScheme.getDynamicObject("searchobj").getPkValue();
            String searchObjNumber = synScheme.getDynamicObject("searchobj").getString("number");
            showParameter.setCustomParam("searchobj", pkValue);
            showParameter.setCustomParam("searchObjNumber", (Object)searchObjNumber);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "essynrunning"));
            ESSynSchemeConfigHelp.getInstance().updateSchemeStatus(synScheme, "2");
            this.handsSyn((Long)pkValue, searchObjNumber, (Long)showParameter.getCustomParam("recordId"));
            this.getView().showForm(showParameter);
            this.writeOpLog("hrss_essynrecord");
        } else if (actionId.equals("confirmHandsSyn") && messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel) {
            String recordId = this.getPageCache().get("recordId");
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrss_essynrecord");
            hrBaseServiceHelper.deleteOne((Object)Long.valueOf(recordId));
        }
    }

    private void writeOpLog(String entityNumber) {
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u7acb\u5373\u540c\u6b65", "ESSynSchemeListPlugin_7", "hrmp-hrss-formplugin");
        appLogInfo.setOpName("startSync", langEnumBridge);
        this.getView().getFormShowParameter().getFormId();
        appLogInfo.setBizObjID(entityNumber);
        appLogInfo.setBizAppID(PermCommonUtil.getAppIdFromSuspectedAppNum((String)this.getView().getFormShowParameter().getAppId()));
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        service.addLog((AppLogInfo)appLogInfo);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (actionId.equals("essynrunning")) {
            String returnData = (String)event.getReturnData();
            if (HRStringUtils.equals((String)"success", (String)returnData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5df2\u5b8c\u6210\u3002", (String)"ESSynSchemeListPlugin_8", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
            } else if (HRStringUtils.equals((String)"fail", (String)returnData)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5931\u8d25\u3002", (String)"CustomFilterEditPlugin_13", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
            }
        } else if (actionId.equals("esconfig")) {
            String returnData = (String)event.getReturnData();
            if (HRStringUtils.equals((String)"cancel", (String)returnData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f", (String)"ESSynSchemeListPlugin_9", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
            }
        } else if ("createsyntask".equals(actionId)) {
            HashMap returnData = (HashMap)event.getReturnData();
            if (returnData == null) {
                return;
            }
            String synType = (String)returnData.get("synType");
            if (HRStringUtils.equals((String)"2", (String)synType)) {
                Long recordId = (Long)returnData.get("pkId");
                this.getPageCache().put("recordId", recordId.toString());
                HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)16);
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7acb\u5373\u540c\u6b65", (String)"ESSynSchemeListPlugin_7", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7cfb\u7edf\u5c06\u6309\u641c\u7d22\u5bf9\u8c61\u8fdb\u884c\u6570\u636e\u641c\u7d22\uff0c\u5e76\u5c06\u641c\u7d22\u7ed3\u679c\u6570\u636e\u540c\u6b65\u5230ES\u5e93\u3002\u5982\u641c\u7d22\u7ed3\u679c\u6570\u636e\u91cf\u8f83\u5927\uff0c\u5efa\u8bae\u91c7\u7528\u6309\u201c\u8ba1\u5212\u65f6\u95f4\u6267\u884c\u201d\u5728\u975e\u5de5\u4f5c\u65f6\u95f4\u6267\u884c\u3002\u786e\u8ba4\u7acb\u5373\u6267\u884c\u540c\u6b65\u5417\uff1f", (String)"ESSynSchemeListPlugin_10", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("confirmHandsSyn"), (Map)btnNameMaps);
            } else {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void handsSyn(Long searchObjId, String searchObjNumber, Long recordId) {
        ThreadPools.executeOnce((String)"handsSyn_thread", () -> {
            try {
                String traceId = RequestContext.get().getTraceId();
                LOGGER.info("handsSyn_thread searchObjId={}, searchObjNumber={},recordId={},traceId={}", new Object[]{searchObjId, searchObjNumber, recordId, traceId});
                SearchObjDataSyncService.getInstance().startFullSync(searchObjId, searchObjNumber, recordId);
            }
            catch (Exception exception) {
                LOGGER.info("ESSynSchemeListPlugin.handsSyn error", (Object)exception);
                SearchObjSyncConfService.syncException((Long)recordId, (String)exception.getMessage());
            }
        });
    }

    private void openEsConfigPage() {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("hrcs_esconfig");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("600");
        css.setHeight("330");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        DynamicObject esConfig = ESSynSchemeConfigHelp.getInstance().getEsConfig();
        if (!ObjectUtils.isEmpty((Object)esConfig)) {
            showParameter.setPkId(esConfig.getPkValue());
        }
        showParameter.setCustomParam("hrssEsSynFlag", (Object)"1");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openEssyncrecordPage(List<Object> successPkIds) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("hrss_essynrecord");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (successPkIds == null || successPkIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u6b65\u914d\u7f6e\u65b9\u6848\u4e0d\u5b58\u5728", (String)"ESSynSchemeListPlugin_11", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
            return;
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "createsyntask"));
        showParameter.setCaption(ResManager.loadKDString((String)"\u540c\u6b65\u4efb\u52a1", (String)"ESSynSchemeListPlugin_12", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("essyncschemeid", successPkIds.get(0));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void packageData(PackageDataEvent dataEvent) {
        super.packageData(dataEvent);
        DynamicObject rowData = dataEvent.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)dataEvent.getSource();
        String fieldKey = columnDesc.getFieldKey();
        String synStatus = rowData.getString("essynstatus");
        if (HRStringUtils.equals((String)"essynstatus", (String)fieldKey)) {
            if (this.processDataMap.containsKey(rowData.getPkValue())) {
                DynamicObject dynamicObject = this.processDataMap.get(rowData.getPkValue());
                if (dynamicObject != null) {
                    if (!HRStringUtils.equals((String)"1", (String)synStatus)) {
                        dataEvent.setFormatValue(dynamicObject.get("synstatus"));
                    }
                } else {
                    dataEvent.setFormatValue((Object)"");
                }
            } else {
                dataEvent.setFormatValue((Object)"");
            }
        }
    }
}

