/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.datasyn;

import com.google.common.collect.Maps;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hrss.business.domain.search.service.ESSynSchemeConfigHelp;
import kd.hrmp.hrss.business.domain.search.service.datasync.EsSynDataJobAndPlanService;

public class EsSynRecordFormPlugin
extends HRDataBaseEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button toolbar = (Button)this.getView().getControl("btnclose");
        toolbar.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue == null || pkValue == 0L) {
            this.getModel().setValue("synstatus", (Object)"1");
            Object schemeId = this.getView().getFormShowParameter().getCustomParam("essyncschemeid");
            this.getModel().setValue("essyncschemeid", schemeId);
            this.getModel().setValue("syntype", (Object)"1");
            this.getView().setVisible(Boolean.FALSE, new String[]{"know", "btncancelsync"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnclose", "btnsave"});
            DateTimeEdit plansynctime = (DateTimeEdit)this.getControl("plansynctime");
            plansynctime.setMustInput(true);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (HRStringUtils.equals((String)key, (String)"btnclose")) {
            this.getPageCache().put("btnclose", "1");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String btnclose = this.getPageCache().get("btnclose");
        if (HRStringUtils.isNotEmpty((String)btnclose)) {
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            String synType = (String)this.getModel().getValue("radiogroupfield");
            Date planDate = (Date)this.getModel().getValue("plansynctime");
            if (HRStringUtils.equals((String)"1", (String)synType)) {
                if (planDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6267\u884c\u8ba1\u5212\u65f6\u95f4\u201d\u3002", (String)"EsSynRecordFormPlugin_5", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            } else {
                this.getModel().setValue("plansynctime", (Object)new Date());
                return;
            }
            Instant endInstant = planDate.toInstant();
            Instant startInstant = Instant.now();
            ZoneId zone = KDDateUtils.getSysTimeZone().toZoneId();
            LocalDateTime startLocalDateTime = LocalDateTime.ofInstant(startInstant, zone);
            LocalDateTime endLocalDateTime = LocalDateTime.ofInstant(endInstant, zone);
            long betweenDay = ChronoUnit.DAYS.between(startLocalDateTime, endLocalDateTime);
            long betweenHours = ChronoUnit.HOURS.between(startLocalDateTime, endLocalDateTime);
            long betweenMinutes = ChronoUnit.MINUTES.between(startLocalDateTime, endLocalDateTime);
            Long hours = betweenHours - betweenDay * 24L;
            Long minutes = betweenMinutes - betweenDay * 24L * 60L - hours * 60L;
            if (betweenDay < 0L || hours < 0L || minutes < 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\u5e94\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u4e94\u5206\u949f\u4ee5\u4e0a", (String)"EsSynRecordFormPlugin_3", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (betweenDay == 0L && hours == 0L && minutes == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\u5e94\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u4e94\u5206\u949f\u4ee5\u4e0a", (String)"EsSynRecordFormPlugin_3", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (betweenDay == 0L && hours == 0L && minutes < 5L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\u5e94\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u4e94\u5206\u949f\u4ee5\u4e0a", (String)"EsSynRecordFormPlugin_3", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"btncancelsync")) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u53d6\u6d88\u540c\u6b65\u8ba1\u5212\uff1f", (String)"EsSynRecordFormPlugin_6", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmCancelSyn"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (success && HRStringUtils.equals((String)"save", (String)operateKey)) {
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
            returnData.put("synType", this.getModel().getValue("radiogroupfield"));
            returnData.put("pkId", afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().get(0));
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String name = evt.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"plansynctime")) {
            Label labelap = (Label)this.getControl("labelap");
            Date planDate = (Date)this.getModel().getValue("plansynctime");
            Instant endInstant = planDate.toInstant();
            Instant startInstant = Instant.now();
            ZoneId zone = KDDateUtils.getSysTimeZone().toZoneId();
            LocalDateTime startLocalDateTime = LocalDateTime.ofInstant(startInstant, zone);
            LocalDateTime endLocalDateTime = LocalDateTime.ofInstant(endInstant, zone);
            long betweenDay = ChronoUnit.DAYS.between(startLocalDateTime, endLocalDateTime);
            long betweenHours = ChronoUnit.HOURS.between(startLocalDateTime, endLocalDateTime);
            long betweenMinutes = ChronoUnit.MINUTES.between(startLocalDateTime, endLocalDateTime);
            Long hours = betweenHours - betweenDay * 24L;
            Long minutes = betweenMinutes - betweenDay * 24L * 60L - hours * 60L;
            labelap.setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8ddd\u79bb\u8ba1\u5212\u6267\u884c\u9884\u8ba1\u8fd8\u6709%1$s\u5929%2$s\u65f6%3$s\u5206\u949f\u3002", (String)"EsSynRecordFormPlugin_1", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]), betweenDay, hours, minutes));
        } else if (HRStringUtils.equals((String)"radiogroupfield", (String)name)) {
            DateTimeEdit plansynctime;
            ChangeData[] changeDataArr = evt.getChangeSet();
            String newValue = (String)changeDataArr[0].getNewValue();
            if ("2".equals(newValue)) {
                plansynctime = (DateTimeEdit)this.getControl("plansynctime");
                plansynctime.setMustInput(false);
                this.getModel().setValue("syntype", (Object)"2");
                this.getModel().setValue("synstatus", (Object)"2");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap6"});
            }
            if ("1".equals(newValue)) {
                plansynctime = (DateTimeEdit)this.getControl("plansynctime");
                plansynctime.setMustInput(true);
                this.getModel().setValue("syntype", (Object)"1");
                this.getModel().setValue("synstatus", (Object)"1");
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap6"});
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (actionId.equals("confirmCancelSyn") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            Long recordId = (Long)this.getModel().getDataEntity().getPkValue();
            String planNumber = "hrss_es_" + String.valueOf(recordId);
            EsSynDataJobAndPlanService.deleteJobAndPlan((String)planNumber);
            ESSynSchemeConfigHelp.getInstance().updateSynRecordStatus(this.getModel().getDataEntity().getPkValue(), "4");
            this.getView().returnDataToParent((Object)"cancel");
            this.getView().close();
        }
    }
}

