/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.filter;

import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRAppServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hrss.common.constants.search.filter.CustomFilterConstants;
import kd.hrmp.hrss.common.model.filter.FilterItemInfo;
import kd.hrmp.hrss.common.util.LocaleStringUtils;
import kd.hrmp.hrss.common.util.RulePreviewUtil;

public class CustomFilterEditPlugin
extends HRDataBaseEdit
implements HyperLinkClickListener,
CustomFilterConstants,
BeforeF7SelectListener {
    private static final String OP_ADD_ITEM = "additem";
    private static final String FILTER_ITEM_CALLBACK = "filterItemCallBack";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("basedata");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterLoadData(EventObject evt) {
        super.afterLoadData(evt);
        DynamicObjectCollection coll = this.getModel().getEntryEntity("entryentity");
        if (null != coll) {
            for (DynamicObject dy : coll) {
                if (!"1".equals(dy.getString("filtertype"))) continue;
                dy.set("displayrule", (Object)RulePreviewUtil.getConditionPreviewStr((String)dy.getString("filterrule")));
            }
            this.getModel().setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key = args.getProperty().getName();
        if (HRStringUtils.equals((String)"type", (String)key)) {
            String type = (String)args.getChangeSet()[0].getNewValue();
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl("basedata");
            if ("basedata".equals(type)) {
                basedataEdit.setMustInput(Boolean.TRUE.booleanValue());
            } else {
                basedataEdit.setMustInput(Boolean.FALSE.booleanValue());
            }
            this.getModel().deleteEntryData("entryentity");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (OP_ADD_ITEM.equals(evt.getItemKey())) {
            DynamicObject basedata;
            String type = (String)this.getModel().getValue("type");
            if (StringUtils.isEmpty((Object)type)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u9002\u7528\u7c7b\u578b\u201d\u3002", (String)"CustomFilterEditPlugin_1", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("basedata".equals(type) && null == (basedata = (DynamicObject)this.getModel().getValue("basedata"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u57fa\u7840\u8d44\u6599\u201d\u3002", (String)"CustomFilterEditPlugin_2", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openFilterItem(null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)FILTER_ITEM_CALLBACK) && null != evt.getReturnData()) {
            FilterItemInfo filterItemInfo = (FilterItemInfo)evt.getReturnData();
            this.addEntry(filterItemInfo);
        }
    }

    private void addEntry(FilterItemInfo filterItemInfo) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        String entryName = "entryentity";
        if (0 != filterItemInfo.getSeq()) {
            this.setEntry(model, filterItemInfo, filterItemInfo.getSeq() - 1);
        } else {
            int idx = model.createNewEntryRow(entryName);
            this.setEntry(model, filterItemInfo, idx);
        }
        model.endInit();
        this.getView().updateView(entryName);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        DynamicObject dy = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(evt.getRowIndex());
        FilterItemInfo info = new FilterItemInfo();
        this.dy2Info(dy, info);
        this.openFilterItem(info);
    }

    private void openFilterItem(FilterItemInfo filterItemInfo) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hrss_filteritem");
        String type = (String)this.getModel().getValue("type");
        parameter.setCustomParam("type", (Object)type);
        if ("basedata".equals(type)) {
            DynamicObject basedata = (DynamicObject)this.getModel().getValue("basedata");
            parameter.setCustomParam("entityNumber", (Object)basedata.getString("number"));
        }
        if (null != filterItemInfo) {
            parameter.setCustomParam("filterItemInfo", (Object)SerializationUtils.toJsonString((Object)filterItemInfo));
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FILTER_ITEM_CALLBACK));
        this.getView().showForm(parameter);
    }

    private void setEntry(AbstractFormDataModel model, FilterItemInfo filterItemInfo, int idx) {
        model.setValue("filternumber", (Object)filterItemInfo.getNumber(), idx);
        model.setValue("filtername", (Object)filterItemInfo.getName(), idx);
        model.setValue("filtertype", (Object)filterItemInfo.getDateFilterType(), idx);
        if ("1".equals(filterItemInfo.getDateFilterType())) {
            model.setValue("displayrule", (Object)RulePreviewUtil.getConditionPreviewStr((String)filterItemInfo.getFilterRule()), idx);
        }
        model.setValue("filterrule", (Object)filterItemInfo.getFilterRule(), idx);
        model.setValue("filterdescription", (Object)filterItemInfo.getDescription(), idx);
    }

    private void dy2Info(DynamicObject dy, FilterItemInfo filterItemInfo) {
        filterItemInfo.setSeq(dy.getInt("seq"));
        filterItemInfo.setNumber(dy.getString("filternumber"));
        filterItemInfo.setName(LocaleStringUtils.getLocaleString((Object)dy.get("filtername")));
        filterItemInfo.setFilterRule(dy.getString("filterrule"));
        filterItemInfo.setDateFilterType(dy.getString("filtertype"));
        filterItemInfo.setDescription(LocaleStringUtils.getLocaleString((Object)dy.get("filterdescription")));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propertyName = evt.getProperty().getName();
        if (HRStringUtils.equals((String)propertyName, (String)"basedata")) {
            Set appSet = HRAppServiceHelper.getAllHRAppIds();
            appSet.add("83bfebc8000037ac");
            appSet.add("0efa1992000000ac");
            evt.getFormShowParameter().setCustomParam("bizappids", (Object)SerializationUtils.toJsonString((Object)appSet));
            evt.getFormShowParameter().setCustomParam("extCloudId", (Object)"0QLCSO6KKZC9");
        }
    }
}

