/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.filter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.filter.control.Condition;
import kd.bos.ext.hr.ruleengine.constants.RuleConstants;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.OptUtils;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.hrmp.hrss.common.constants.search.filter.CustomFilterConstants;
import kd.hrmp.hrss.common.model.filter.FilterItemInfo;
import kd.hrmp.hrss.common.util.LocaleStringUtils;

public class FilterItemEditPlugin
extends HRBaseDataCommonEdit
implements RuleConstants,
CustomFilterConstants {
    private static final String DATA_FILTER_TYPE = "datafiltertype";
    private static final String CLASS_PATH = "classpath";
    private static final String CONTROL_KEY = "conditionap";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String filterItemInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("filterItemInfo");
        if (StringUtils.isNotEmpty((String)filterItemInfoStr)) {
            FilterItemInfo filterItemInfo = (FilterItemInfo)SerializationUtils.fromJsonString((String)filterItemInfoStr, FilterItemInfo.class);
            this.getModel().setValue("name", (Object)filterItemInfo.getName());
            this.getModel().setValue("description", (Object)filterItemInfo.getDescription());
            this.getModel().setValue("number", (Object)filterItemInfo.getNumber());
            this.getModel().setValue(DATA_FILTER_TYPE, (Object)filterItemInfo.getDateFilterType());
            String dateFilterType = filterItemInfo.getDateFilterType();
            if (!"1".equals(dateFilterType)) {
                this.getModel().setValue(CLASS_PATH, (Object)filterItemInfo.getFilterRule());
            }
        }
        this.showControl((String)this.getModel().getValue(DATA_FILTER_TYPE));
    }

    private void showControl(String dateFilterType) {
        boolean isRule = "1".equals(dateFilterType);
        this.getView().setVisible(Boolean.valueOf(!isRule), new String[]{CLASS_PATH});
        this.getView().setVisible(Boolean.valueOf(isRule), new String[]{CONTROL_KEY});
        TextEdit textEdit = (TextEdit)this.getControl(CLASS_PATH);
        textEdit.setMustInput(!isRule);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        Condition condition = this.getConditionControl();
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        data.put("onlyUpdateWeb", "true");
        this.handlerData(data);
        condition.setData((Map)data);
    }

    private void handlerData(Map<String, Object> data) {
        FilterItemInfo filterItemInfo;
        String dateFilterType;
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if ("basedata".equals(type)) {
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
            data.put("param", this.getBaseData(entityNumber));
            data.put("defaultParam", "basedata." + entityNumber + ".id");
        } else {
            data.put("param", this.getBaseProp(type));
            data.put("defaultParam", type);
        }
        String filterItemInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("filterItemInfo");
        if (StringUtils.isNotEmpty((String)filterItemInfoStr) && "1".equals(dateFilterType = (filterItemInfo = (FilterItemInfo)SerializationUtils.fromJsonString((String)filterItemInfoStr, FilterItemInfo.class)).getDateFilterType())) {
            data.put("value", filterItemInfo.getFilterRule());
            Condition condition = this.getConditionControl();
            condition.setValue(filterItemInfo.getFilterRule());
        }
    }

    private void switchCondition() {
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        data.put("initing", "true");
        this.handlerData(data);
        data.put("comparisonOpt", OptUtils.getComparisonOperatorsMap());
        HashMap conditionExpress = Maps.newHashMapWithExpectedSize((int)2);
        conditionExpress.put("value", "");
        data.put("conditionExpress", conditionExpress);
        data.put("containTarget", false);
        data.put("showValueType", false);
        data.put("showParam", false);
        data.put("ruleEngine", false);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(CONTROL_KEY, "v", (Object)data);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("enter".equals(operateKey) && args.getOperationResult().isSuccess()) {
            String filterItemInfoStr;
            String filter;
            String type = (String)this.getModel().getValue(DATA_FILTER_TYPE);
            if ("1".equals(type)) {
                Condition condition = (Condition)this.getControl(CONTROL_KEY);
                filter = condition.getValue();
                RuleValidateInfo conditionInfo = RuleValidateUtil.validCondition((String)filter);
                if (!conditionInfo.isSuccess()) {
                    StringBuilder errorMsg = new StringBuilder();
                    for (String msg : conditionInfo.getMsgList()) {
                        errorMsg.append(msg).append(',');
                    }
                    this.getView().showTipNotification(errorMsg.substring(0, errorMsg.length() - 1));
                    return;
                }
            } else {
                filter = (String)this.getModel().getValue(CLASS_PATH);
                if (StringUtils.isEmpty((String)filter)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7c7b\u8def\u5f84\u201d\u3002", (String)"FilterItemEditPlugin_2", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            FilterItemInfo info = StringUtils.isNotEmpty((String)(filterItemInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("filterItemInfo"))) ? (FilterItemInfo)SerializationUtils.fromJsonString((String)filterItemInfoStr, FilterItemInfo.class) : new FilterItemInfo();
            info.setNumber((String)this.getModel().getValue("number"));
            info.setName(LocaleStringUtils.getLocaleString((Object)this.getModel().getValue("name")));
            info.setDateFilterType((String)this.getModel().getValue(DATA_FILTER_TYPE));
            info.setDescription(LocaleStringUtils.getLocaleString((Object)this.getModel().getValue("description")));
            info.setFilterRule(filter);
            this.getView().returnDataToParent((Object)info);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData changeSet = args.getChangeSet()[0];
        if (DATA_FILTER_TYPE.equals(name)) {
            String dateFilterType = (String)changeSet.getNewValue();
            this.showControl(dateFilterType);
            if ("1".equals(dateFilterType)) {
                this.switchCondition();
            }
        } else if (HRStringUtils.equals((String)"ruledate", (String)name)) {
            Date newData = (Date)changeSet.getNewValue();
            if (null == newData) {
                return;
            }
            String dateFormat = this.getView().getPageCache().get("ruleDateFormat");
            String date = HRDateTimeUtils.format((Date)newData, (String)dateFormat);
            Condition condition = this.getConditionControl();
            condition.setDate(date);
        }
    }

    private Condition getConditionControl() {
        return (Condition)this.getView().getControl(CONTROL_KEY);
    }

    private List<Map<String, String>> getBaseProp(String type) {
        ArrayList paramData = Lists.newArrayListWithCapacity((int)10);
        HashMap param = Maps.newHashMapWithExpectedSize((int)2);
        param.put("text", ResManager.loadKDString((String)"\u57fa\u672c\u5c5e\u6027", (String)"FilterItemEditPlugin_1", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
        param.put("level", "1");
        String name = "";
        if ("number".equals(type)) {
            param.put("children", "[{\"number\":\"number\",\"dateFormat\":\"\",\"level\":\"2\",\"name\":\"" + name + "\",\"id\":\"number\",\"text\":\"" + name + "\",\"type\":\"number\",\"typeDetail\":\"number\"}]");
        } else if ("amount".equals(type)) {
            param.put("children", "[{\"number\":\"amount\",\"dateFormat\":\"\",\"level\":\"2\",\"name\":\"" + name + "\",\"id\":\"amount\",\"text\":\"" + name + "\",\"type\":\"number\",\"typeDetail\":\"number\"}]");
        } else {
            param.put("children", "[{\"number\":\"date\",\"dateFormat\":\"yyyy-MM-dd\",\"level\":\"2\",\"name\":\"" + name + "\",\"id\":\"date\",\"text\":\"" + name + "\",\"type\":\"date\",\"typeDetail\":\"date\"}]");
        }
        paramData.add(param);
        return paramData;
    }

    private List<Map<String, String>> getBaseData(String entityNumber) {
        ArrayList paramData = Lists.newArrayListWithCapacity((int)10);
        HashMap param = Maps.newHashMapWithExpectedSize((int)2);
        String name = "";
        param.put("text", "");
        param.put("level", "1");
        param.put("children", "[{\"level\":\"2\",\"entityNumber\":\"" + entityNumber + "\",\"multiple\":\"2\",\"type\":\"dynamicObject\",\"typeDetail\":\"dynamicObject\",\"number\":\"basedata." + entityNumber + ".id\",\"name\":\"" + name + "\",\"id\":\"basedata." + entityNumber + ".id\",\"text\":\"" + name + "\",\"category\":\"\"}]");
        paramData.add(param);
        return paramData;
    }

    protected List<String> getUnCheckField() {
        List uncheckFieldList = super.getUnCheckField();
        uncheckFieldList.add("name");
        uncheckFieldList.add("number");
        uncheckFieldList.add("description");
        uncheckFieldList.add(CLASS_PATH);
        uncheckFieldList.add(DATA_FILTER_TYPE);
        uncheckFieldList.add("ruledate");
        return uncheckFieldList;
    }
}

