/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.scene;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class SearchLabelTreePlugin
extends HRDynamicFormBasePlugin
implements TreeNodeClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
            TreeView labelTreeView = (TreeView)this.getView().getControl("tv_fields");
            boolean isFields = (Boolean)this.getView().getFormShowParameter().getCustomParam("isFields");
            HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
            if (isFields) {
                List labelCheckedNodes = labelTreeView.getTreeState().getCheckedNodes();
                if (labelCheckedNodes != null) {
                    objectObjectHashMap.put("labelReturn", labelCheckedNodes);
                }
                this.getView().returnDataToParent((Object)objectObjectHashMap);
            }
            this.getView().close();
        } else if ("btncancel".equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        String labelTreeNodes = (String)this.getView().getFormShowParameter().getCustomParam("labelTreeNodes");
        if (HRStringUtils.isNotEmpty((String)labelTreeNodes)) {
            this.fillLabelTreeNodes(labelTreeNodes);
        }
    }

    private void fillLabelTreeNodes(String labelTreeNodes) {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)labelTreeNodes, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl("tv_fields");
        tree.addNode(rootNode);
        this.checkNode(rootNode, tree);
    }

    private void checkNode(TreeNode rootNode, TreeView tree) {
        List children = rootNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                if (child.isCheckable()) {
                    tree.checkNode(child);
                }
                this.checkNode(child, tree);
            }
        }
    }
}

