/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.searchlog;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.QueryBuilderFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hrmp.hrss.business.domain.search.service.searchlog.QFilterSaveLogHelper;
import kd.hrmp.hrss.formplugin.web.search.searchlog.SearchQFilterTransFunction;

public class SearchKeyCountListProvider
extends ListDataProvider {
    private static final Log LOGGER = LogFactory.getLog(SearchKeyCountListProvider.class);
    private final Map<String, PKTempTable> tmpTableMap = new HashMap<String, PKTempTable>(16);
    private final int tmpTableThresh = 1000;

    public DynamicObjectCollection getData(int start, int limit) {
        QueryBuilder queryBuilder = QueryBuilderFactory.createQueryBuilder((IListDataProvider)this, (int)start, (int)limit, (boolean)false);
        DynamicObjectType returnEntityType = queryBuilder.getReturnEntityType();
        String orderBys = queryBuilder.getOrderBys();
        QFilter[] qFilters = queryBuilder.getFilters();
        return this.countSearchKey(start, limit, orderBys, qFilters, returnEntityType);
    }

    public int getBillDataCount() {
        return this.getRealCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRealCount() {
        long startTime = System.currentTimeMillis();
        QueryBuilder queryBuilder = QueryBuilderFactory.createQueryBuilder((IListDataProvider)this, (int)0, (int)100, (boolean)false);
        QFilter[] qFilters = queryBuilder.getFilters();
        int dataCount = 0;
        try {
            String countSql = this.genCountQueryDataSql(qFilters);
            dataCount = (Integer)HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)countSql, (Object[])new Object[0], rs -> {
                if (rs.next()) {
                    return rs.getInt("datacount");
                }
                return 0;
            });
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
        finally {
            this.closeTmpTableMap();
        }
        LOGGER.info("getRealCount time:{}ms", (Object)(System.currentTimeMillis() - startTime));
        return dataCount;
    }

    private void closeTmpTableMap() {
        for (Map.Entry<String, PKTempTable> entry : this.tmpTableMap.entrySet()) {
            LOGGER.info("SearchKeyCountListProvider close tmptable:{}", (Object)entry.getKey());
            entry.getValue().close();
        }
        this.tmpTableMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObjectCollection countSearchKey(int start, int limit, String orderBys, QFilter[] qFilters, DynamicObjectType returnEntityType) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(returnEntityType, null);
        try {
            String queryDataSql = this.genQueryDataSql(start, limit, orderBys, qFilters);
            HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)queryDataSql, (Object[])new Object[0], rs -> {
                dynamicObjectCollection.beginInit();
                int row = 1;
                while (rs.next()) {
                    DynamicObject dyn = new DynamicObject(returnEntityType);
                    dyn.set("id", (Object)row++);
                    dyn.set("searchscene_id", (Object)rs.getLong("searchsceneid"));
                    dyn.set("searchpage_id", (Object)rs.getLong("searchpageid"));
                    dyn.set("searchkey", (Object)rs.getString("searchkey"));
                    dyn.set("scount", (Object)rs.getInt("scount"));
                    dynamicObjectCollection.add((Object)dyn);
                }
                dynamicObjectCollection.endInit();
                return 0;
            });
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
        finally {
            this.closeTmpTableMap();
        }
        BusinessDataReader.loadRefence((Object[])dynamicObjectCollection.toArray((Object[])new DynamicObject[dynamicObjectCollection.size()]), (IDataEntityType)returnEntityType);
        return dynamicObjectCollection;
    }

    private String genCountQueryDataSql(QFilter[] qFilters) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select count(1) as datacount from (select 1 from t_hrss_usersearchlog ");
        sqlBuilder.append(" where fsearchkey != ' ' and fsearchkey != '' and fsearchkey is not null ");
        sqlBuilder.append((CharSequence)this.genWhereSql(qFilters));
        sqlBuilder.append(" group by fsearchsceneid, fsearchpageid, fsearchkey) as counttb");
        return sqlBuilder.toString();
    }

    private StringBuilder genWhereSql(QFilter[] qFilters) {
        StringBuilder whereSqlBuilder = new StringBuilder();
        if (qFilters != null && qFilters.length > 0) {
            Object[] qFiltersCopy = QFilterSaveLogHelper.copyQFilters((QFilter[])qFilters);
            Object[] flikeQFilters = QFilterSaveLogHelper.rebuidFlikeQFilterEx((QFilter[])qFiltersCopy, (String)"1");
            QFilter[] newOriginFilters = (QFilter[])Arrays.stream(ArrayUtils.addAll((Object[])flikeQFilters, (Object[])qFiltersCopy)).filter(Objects::nonNull).toArray(QFilter[]::new);
            SearchQFilterTransFunction transFunction = new SearchQFilterTransFunction();
            int n = newOriginFilters.length;
            for (int i = 0; i < n; ++i) {
                if (newOriginFilters[i] == null) continue;
                newOriginFilters[i] = newOriginFilters[i].trans((Function)transFunction);
            }
            for (QFilter newOriginFilter : newOriginFilters) {
                if (newOriginFilter == null) continue;
                String sqlStr = QFilterUtilHR.toQFilterString((QFilter)newOriginFilter, (boolean)true, (boolean)true, this.tmpTableMap, (DBRoute)DBRoute.of((String)"hmp"), (int)1000);
                whereSqlBuilder.append(" and ").append(sqlStr);
            }
        }
        return whereSqlBuilder;
    }

    private String genQueryDataSql(int start, int limit, String orderBys, QFilter[] qFilters) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ");
        sqlBuilder.append(" TOP ").append(limit).append(',').append(start).append(' ');
        sqlBuilder.append(" fsearchsceneid AS searchsceneid,fsearchpageid AS searchpageid,fsearchkey AS searchkey,count(fsearchkey) AS scount ");
        sqlBuilder.append(" FROM t_hrss_usersearchlog ");
        sqlBuilder.append(" where fsearchkey != ' ' and fsearchkey != '' and fsearchkey is not null ");
        sqlBuilder.append((CharSequence)this.genWhereSql(qFilters));
        sqlBuilder.append(" group by fsearchsceneid, fsearchpageid, fsearchkey ");
        sqlBuilder.append(" order by scount desc");
        return sqlBuilder.toString();
    }
}

