/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.searchobj;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.hr.filter.control.HRFilter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hrss.business.domain.search.service.ESSynSchemeConfigHelp;
import kd.hrmp.hrss.business.preset.PresetDataChangedService;
import kd.hrmp.hrss.common.constants.search.searchobj.SearchObjectConstants;
import kd.hrmp.hrss.formplugin.web.search.searchobj.processor.SearchObjCommonProcessor;
import kd.hrmp.hrss.formplugin.web.search.searchobj.processor.SearchObjDataProcessor;
import kd.hrmp.hrss.formplugin.web.search.searchobj.processor.SearchObjEntityProcessor;
import kd.hrmp.hrss.formplugin.web.search.searchobj.processor.SearchObjFieldProcessor;
import kd.hrmp.hrss.formplugin.web.search.searchobj.processor.SearchObjFormProcessor;
import kd.hrmp.hrss.formplugin.web.search.searchobj.processor.SearchObjInitProcessor;

public class SearchObjectEdit
extends HRDataBaseEdit
implements SearchObjectConstants {
    private final SearchObjCommonProcessor commonProcessor = new SearchObjCommonProcessor(this);
    private final SearchObjInitProcessor initProcessor = new SearchObjInitProcessor(this);
    private final SearchObjEntityProcessor entityProcessor = new SearchObjEntityProcessor(this);
    private final SearchObjFieldProcessor fieldProcessor = new SearchObjFieldProcessor(this);
    private final SearchObjDataProcessor dataProcessor = new SearchObjDataProcessor(this);
    private final SearchObjFormProcessor formProcessor = new SearchObjFormProcessor(this);

    public void propertyChanged(PropertyChangedArgs args) {
        String key = args.getProperty().getName();
        if (HRStringUtils.equals((String)"ruledate", (String)key)) {
            Date newData = (Date)args.getChangeSet()[0].getNewValue();
            if (null == newData) {
                return;
            }
            String data = HRDateTimeUtils.format((Date)newData, (String)"yyyy-MM-dd");
            this.getHRFilter().setDate(data);
            this.getModel().setValue("ruledate", null);
        }
    }

    public HRFilter getHRFilter() {
        return (HRFilter)this.getControl("hrfilterap");
    }

    public void customEvent(CustomEventArgs args) {
        if (HRStringUtils.equals((String)args.getEventName(), (String)"dragEntity")) {
            this.entityProcessor.dragEntity(args);
        } else if (HRStringUtils.equals((String)args.getEventName(), (String)"clickRelevance")) {
            this.entityProcessor.clickRelevance(args);
        } else if (HRStringUtils.equals((String)args.getEventName(), (String)"delEntity")) {
            this.entityProcessor.delEntity(args);
        } else if (HRStringUtils.equals((String)args.getEventName(), (String)"modifyFieldName")) {
            this.fieldProcessor.openModifyFieldPage(args);
        } else if (HRStringUtils.equals((String)args.getEventName(), (String)"getAllData")) {
            this.dataProcessor.getAllData(args);
        } else if (HRStringUtils.equals((String)args.getEventName(), (String)"setSearchLabel")) {
            this.formProcessor.openConfigSearchTargetPage();
        }
    }

    public void afterLoadData(EventObject eventObject) {
        super.afterLoadData(eventObject);
        this.initProcessor.initData();
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.getView().setVisible(Boolean.FALSE, new String[]{"laststepbtn", "bar_save"});
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id == 0L) {
            this.getView().getPageCache().put("isNew", "true");
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        boolean needGetAllConfigData;
        Tab tab = (Tab)this.getView().getControl("tabap");
        String nextTab = this.formProcessor.getNextTab(tab);
        if (HRStringUtils.equals((String)evt.getOperationKey(), (String)"nextstep")) {
            boolean numberValid = this.dataProcessor.validateNumber(nextTab);
            if (!numberValid) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4ec5\u652f\u6301\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u3002", (String)"SearchObjectEdit_3", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String initCompleted = this.getPageCache().get("initCompleted");
            if (HRStringUtils.equals((String)nextTab, (String)"definefield") && !HRStringUtils.equals((String)initCompleted, (String)"1")) {
                this.initProcessor.initCustomControl();
            } else if (nextTab.equals("definefield")) {
                this.formProcessor.sendFlagForToStep2();
            }
        }
        boolean bl = needGetAllConfigData = HRStringUtils.equals((String)evt.getOperationKey(), (String)"nextstep") && HRStringUtils.equals((String)nextTab, (String)"filterdata") || HRStringUtils.equals((String)evt.getOperationKey(), (String)"save") && HRStringUtils.equals((String)nextTab, (String)"filterdata");
        if (needGetAllConfigData) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"SearchObjectEdit_2", (String)"hrmp-hrss-formplugin", (Object[])new Object[0])));
            evt.setCancel(true);
            this.formProcessor.sendFlagForGetAllData(evt.getOperationKey(), nextTab);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        Tab tab = (Tab)this.getView().getControl("tabap");
        switch (operateKey) {
            case "save": {
                this.beforeSave(tab, args, op);
                break;
            }
            case "laststep": {
                this.beforeLastStepOption(tab);
                break;
            }
            case "nextstep": {
                this.beforeNextStepOption(tab, args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        super.afterDoOperation(args);
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)"save")) {
            this.getView().hideLoading();
            operationResult = args.getOperationResult();
            String dataSyncIsConfirm = this.getView().getPageCache().get("dataSyncIsConfirm");
            boolean isNewSave = HRStringUtils.equals((String)this.getPageCache().get("isNew"), (String)"true");
            if (operationResult.isSuccess() && (HRStringUtils.equals((String)dataSyncIsConfirm, (String)"true") || isNewSave)) {
                ESSynSchemeConfigHelp.getInstance().generESSynScheme((Long)args.getOperationResult().getSuccessPkIds().get(0));
            }
            this.saveIsChangeLog();
        } else if (HRStringUtils.equals((String)args.getOperateKey(), (String)"nextstep")) {
            this.afterNextStepOption(args);
            operationResult = args.getOperationResult();
            if (operationResult.isSuccess()) {
                this.getModel().setValue("status", (Object)"A");
                this.getModel().setDataChanged(false);
            }
        }
        String pageStatus = this.getPageCache().get("pageStatus");
        if (HRStringUtils.equals((String)pageStatus, (String)OperationStatus.VIEW.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
        }
    }

    private void saveIsChangeLog() {
        String isStepFirThrChange = this.getView().getPageCache().get("searchObjFirThrChange");
        String isStepSecChange = this.getView().getPageCache().get("searchObjSecondChange");
        if ("true".equals(isStepFirThrChange) || "true".equals(isStepSecChange)) {
            PresetDataChangedService.doPresetDataChanged((DynamicObject)this.getModel().getDataEntity());
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        if (HRStringUtils.equals((String)"hbp_setentityrelation", (String)event.getActionId()) && returnData != null) {
            this.entityProcessor.updateEntityRelation(returnData);
        } else if (HRStringUtils.equals((String)"hbp_modifyfieldname", (String)event.getActionId()) && returnData != null) {
            this.fieldProcessor.setFieldNewName(returnData);
        } else if (HRStringUtils.equals((String)"hrss_searchconfigtarget", (String)event.getActionId()) && returnData != null) {
            this.entityProcessor.setEntitySearchTarget((List)returnData);
        } else if (HRStringUtils.equals((String)"showConfirmReStartDataSync", (String)event.getActionId())) {
            this.dataProcessor.handleReStartDataSyncCloseCallBack((String)event.getReturnData());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        int result = event.getResult().getValue();
        if (HRStringUtils.equals((String)event.getCallBackId(), (String)"deleteMainEntity") || HRStringUtils.equals((String)event.getCallBackId(), (String)"deleteEntity")) {
            if (result == MessageBoxResult.Yes.getValue()) {
                this.entityProcessor.deleteEntityCustomEvent();
            }
            this.getPageCache().remove("delRefCalculateFieldNums");
        }
    }

    private void beforeSave(Tab tab, BeforeDoOperationEventArgs args, AbstractOperate op) {
        if (HRStringUtils.equals((String)tab.getCurrentTab(), (String)"definefield") && !this.dataProcessor.validateFieldDefineData()) {
            this.getView().hideLoading();
            args.setCancel(true);
            return;
        }
        if (HRStringUtils.equals((String)tab.getCurrentTab(), (String)"definefield")) {
            this.fieldProcessor.setBaseDataIdFields();
            this.fieldProcessor.setFieldComplexType();
            this.fieldProcessor.setFieldControlType();
        }
        if (this.dataProcessor.isDataChangedAndCancelSave()) {
            args.setCancel(true);
            return;
        }
        String joinEntities = this.getPageCache().get("joinEntities");
        String queryFields = this.getPageCache().get("queryFields");
        String entityRelations = this.getPageCache().get("entityRelations");
        op.getOption().setVariableValue("joinEntities", joinEntities);
        op.getOption().setVariableValue("queryFields", queryFields);
        op.getOption().setVariableValue("entityRelations", entityRelations);
        this.getModel().setValue("datafilter", (Object)this.getHRFilter().getValue());
        this.dataProcessor.checkValueModify();
    }

    private void beforeLastStepOption(Tab tab) {
        String lastTab;
        if ("filterdata".equals(tab.getCurrentTab())) {
            this.getModel().setValue("datafilter", (Object)this.getHRFilter().getValue());
            List<String> dataFilterRefFieldAlias = this.commonProcessor.getDataFilterRefFieldAlias();
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
            dataMap.put("method", "updateFilterFieldAliasList");
            dataMap.put("filterFieldAliasList", dataFilterRefFieldAlias);
            customcontrol.setData((Object)dataMap);
        }
        if ((lastTab = this.formProcessor.getLastTab(tab)) != null) {
            tab.activeTab(lastTab);
        } else {
            lastTab = tab.getCurrentTab();
        }
        this.formProcessor.setVisibleForBtn(lastTab, this.getView());
    }

    private void beforeNextStepOption(Tab tab, BeforeDoOperationEventArgs args) {
        String nextTab = this.formProcessor.getNextTab(tab);
        if (nextTab != null) {
            if (nextTab.equals("filterdata") && !this.dataProcessor.validateFieldDefineData()) {
                args.setCancel(true);
                this.getView().hideLoading();
                return;
            }
            if (nextTab.equals("filterdata")) {
                this.fieldProcessor.setFieldComplexType();
                this.fieldProcessor.setFieldControlType();
                this.fieldProcessor.setBaseDataIdFields();
            }
        }
    }

    private void afterNextStepOption(AfterDoOperationEventArgs args) {
        if (args.getOperationResult().isSuccess()) {
            Tab tab = (Tab)this.getView().getControl("tabap");
            String nextTab = this.formProcessor.getNextTab(tab);
            if (HRStringUtils.equals((String)nextTab, (String)"filterdata") && !this.dataProcessor.validateFieldDefineData()) {
                this.getView().hideLoading();
                return;
            }
            if (nextTab != null) {
                tab.activeTab(nextTab);
            } else {
                nextTab = tab.getCurrentTab();
            }
            this.formProcessor.setVisibleForBtn(nextTab, this.getView());
            if (nextTab.equals("definefield") || nextTab.equals("filterdata")) {
                this.initProcessor.initDataFilter();
            }
            this.getView().hideLoading();
        } else {
            Tab tab = (Tab)this.getView().getControl("tabap");
            String nextTab = this.formProcessor.getNextTab(tab);
            if (HRStringUtils.equals((String)nextTab, (String)"definefield")) {
                this.getPageCache().remove("initCompleted");
                this.getPageCache().remove("allFieldTreeNodes");
            }
            this.getView().hideLoading();
        }
    }
}

