/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.searchobj.processor;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.common.constants.search.searchobj.SearchObjectConstants;
import kd.hrmp.hrss.common.model.searchobj.SchObjEntityRelation;
import kd.hrmp.hrss.common.model.searchobj.SchObjJoinEntity;
import kd.hrmp.hrss.common.model.searchobj.SchObjQueryField;
import kd.hrmp.hrss.formplugin.web.search.searchobj.SearchObjectEdit;

public class SearchObjCommonProcessor
implements SearchObjectConstants {
    private SearchObjectEdit plugin;

    public SearchObjCommonProcessor(SearchObjectEdit plugin) {
        this.plugin = plugin;
    }

    public List<SchObjQueryField> getSelectedQueryFields(Object entityNodes) {
        if (entityNodes == null) {
            return Collections.emptyList();
        }
        String queryFieldsStr = this.getView().getPageCache().get("originQueryFields");
        Map<Object, Object> queryFieldMap = Collections.emptyMap();
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            List queryFieldBos = JSON.parseArray((String)queryFieldsStr, SchObjQueryField.class);
            queryFieldMap = queryFieldBos.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, field -> field));
        }
        ArrayList selectedQueryFields = Lists.newArrayListWithCapacity((int)10);
        List fieldTreeNodes = JSON.parseArray((String)SerializationUtils.toJsonString((Object)entityNodes), FieldTreeNode.class);
        for (FieldTreeNode fieldTreeNode : fieldTreeNodes) {
            if (!fieldTreeNode.getSelected().booleanValue() || !fieldTreeNode.getField().booleanValue()) continue;
            SchObjQueryField queryFieldBo = (SchObjQueryField)queryFieldMap.get(fieldTreeNode.getFieldAlias());
            if (queryFieldBo == null) {
                queryFieldBo = new SchObjQueryField();
            }
            queryFieldBo.setFieldName(fieldTreeNode.getName());
            queryFieldBo.setFieldNumber(fieldTreeNode.getFieldAlias());
            queryFieldBo.setEntityNumber(fieldTreeNode.getEntityNumber());
            queryFieldBo.setEntityName(fieldTreeNode.getEntityName());
            queryFieldBo.setFieldAlias(fieldTreeNode.getFieldAlias());
            queryFieldBo.setFieldPath(fieldTreeNode.getFieldPath());
            queryFieldBo.setValueType(fieldTreeNode.getValueType());
            queryFieldBo.setComplexType(fieldTreeNode.getComplexType());
            queryFieldBo.setBaseDataNum(fieldTreeNode.getBaseDataNum());
            queryFieldBo.setBaseDataIdType(fieldTreeNode.getBaseDataIdType());
            selectedQueryFields.add(queryFieldBo);
        }
        return selectedQueryFields;
    }

    public List<SchObjJoinEntity> getAllJoinEntity() {
        List joinEntityBos = Collections.emptyList();
        String entityStr = this.getView().getPageCache().get("joinEntities");
        if (HRStringUtils.isNotEmpty((String)entityStr)) {
            joinEntityBos = JSON.parseArray((String)entityStr, SchObjJoinEntity.class);
        }
        return joinEntityBos;
    }

    public List<SchObjEntityRelation> getEntityRelations() {
        List entityRelations = Lists.newArrayListWithCapacity((int)10);
        String entityRelationStr = this.getView().getPageCache().get("entityRelations");
        if (HRStringUtils.isNotEmpty((String)entityRelationStr)) {
            entityRelations = JSON.parseArray((String)entityRelationStr, SchObjEntityRelation.class);
        }
        return entityRelations;
    }

    public List<SchObjQueryField> getQueryFields() {
        List queryFields = Lists.newArrayListWithCapacity((int)10);
        String queryFieldStr = this.getView().getPageCache().get("queryFields");
        if (HRStringUtils.isNotEmpty((String)queryFieldStr)) {
            queryFields = JSON.parseArray((String)queryFieldStr, SchObjQueryField.class);
        }
        return queryFields;
    }

    public List<SchObjQueryField> getOriginalQueryFields() {
        List queryFields = Lists.newArrayListWithCapacity((int)10);
        String queryFieldStr = this.getView().getPageCache().get("originQueryFields");
        if (HRStringUtils.isNotEmpty((String)queryFieldStr)) {
            queryFields = JSON.parseArray((String)queryFieldStr, SchObjQueryField.class);
        }
        return queryFields;
    }

    public List<String> getDataFilterRefFieldAlias() {
        String dataFilter = (String)this.getModel().getValue("datafilter");
        if (HRStringUtils.isEmpty((String)dataFilter)) {
            return Lists.newArrayListWithCapacity((int)10);
        }
        RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)dataFilter, RuleConditionInfo.class);
        List paramList = conditionInfo.getConditionList().stream().map(ConditionInfo::getParam).collect(Collectors.toList());
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        if (HRStringUtils.isEmpty((String)queryFieldsStr)) {
            return Lists.newArrayListWithCapacity((int)10);
        }
        List queryFieldBoList = JSON.parseArray((String)queryFieldsStr, SchObjQueryField.class);
        return queryFieldBoList.stream().filter(queryFieldBo -> paramList.contains(queryFieldBo.getHRFilterParam())).map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toList());
    }

    public void setAllFieldsToCache(List<FieldTreeNode> entityAllFields) {
        String allFieldTreeNodesStr = this.getView().getPageCache().get("allFieldTreeNodes");
        if (HRStringUtils.isNotEmpty((String)allFieldTreeNodesStr)) {
            List fieldTreeNodes = JSON.parseArray((String)allFieldTreeNodesStr, FieldTreeNode.class);
            entityAllFields.forEach(field -> this.addFieldTreeNode((FieldTreeNode)field, fieldTreeNodes));
            this.getView().getPageCache().put("allFieldTreeNodes", SerializationUtils.toJsonString((Object)fieldTreeNodes));
        } else {
            ArrayList allFieldTreeNodes = Lists.newArrayListWithCapacity((int)10);
            entityAllFields.forEach(field -> this.addFieldTreeNode((FieldTreeNode)field, allFieldTreeNodes));
            this.getView().getPageCache().put("allFieldTreeNodes", SerializationUtils.toJsonString((Object)allFieldTreeNodes));
        }
    }

    private void addFieldTreeNode(FieldTreeNode node, List<FieldTreeNode> allFieldTreeNodes) {
        if (node.getField().booleanValue()) {
            allFieldTreeNodes.add(node);
        }
        if (node.getChildren() != null) {
            for (FieldTreeNode child : node.getChildren()) {
                this.addFieldTreeNode(child, allFieldTreeNodes);
            }
        }
    }

    public IFormView getView() {
        return this.plugin.getView();
    }

    public IDataModel getModel() {
        return this.plugin.getView().getModel();
    }

    public SearchObjectEdit getPlugin() {
        return this.plugin;
    }
}

