/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.searchobj.processor;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinConditionBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.common.constants.search.searchobj.SearchObjectConstants;
import kd.hrmp.hrss.common.model.searchobj.SchObjEntityRelation;
import kd.hrmp.hrss.common.model.searchobj.SchObjJoinEntity;
import kd.hrmp.hrss.common.model.searchobj.SchObjQueryField;
import kd.hrmp.hrss.formplugin.web.search.searchobj.SearchObjectEdit;
import kd.hrmp.hrss.formplugin.web.search.searchobj.processor.SearchObjCommonProcessor;

public class SearchObjDataProcessor
extends SearchObjCommonProcessor
implements SearchObjectConstants {
    private static final HRBaseServiceHelper SEARCH_OBJECT = new HRBaseServiceHelper("hrss_searchobject");

    public SearchObjDataProcessor(SearchObjectEdit plugin) {
        super(plugin);
    }

    public void getAllData(CustomEventArgs args) {
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)args.getEventArgs(), Map.class);
        Object entityNodes = dataMap.get("entityNodes");
        String joinEntitiesStr = SerializationUtils.toJsonString(entityNodes);
        this.getView().getPageCache().put("joinEntities", joinEntitiesStr);
        List<Object> entityRelationBos = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
            List queryEntityBos = JSON.parseArray((String)joinEntitiesStr, SchObjJoinEntity.class);
            List<EntityRelationCommonBo> entityRelationCommonBos = queryEntityBos.stream().map(JoinEntityCommonBo::getEntityRelation).filter(Objects::nonNull).collect(Collectors.toList());
            entityRelationBos = this.reverseEntityRelationBos(entityRelationCommonBos);
        }
        this.getView().getPageCache().put("entityRelations", SerializationUtils.toJsonString((Object)entityRelationBos));
        Object queryFields = dataMap.get("queryFields");
        List<SchObjQueryField> queryFieldBos = this.getSelectedQueryFields(queryFields);
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString(queryFieldBos));
        String operate = (String)dataMap.get("operate");
        if (HRStringUtils.equals((String)operate, (String)"nextStep")) {
            this.getView().invokeOperation("nextstep");
        } else if (HRStringUtils.equals((String)operate, (String)"save")) {
            this.getView().invokeOperation("save");
        }
    }

    public List<SchObjEntityRelation> reverseEntityRelationBos(List<EntityRelationCommonBo> entityRelationBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(entityRelationBos), SchObjEntityRelation.class);
    }

    public List<JoinEntityCommonBo> transferJoinEntityBos(List<SchObjJoinEntity> joinEntityBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(joinEntityBos), JoinEntityCommonBo.class);
    }

    public List<QueryFieldCommonBo> transferQueryFieldBos(List<SchObjQueryField> queryFieldBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(queryFieldBos), QueryFieldCommonBo.class);
    }

    public static List<EntityRelationCommonBo> transferEntityRelationBos(List<SchObjEntityRelation> entityRelationBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(entityRelationBos), EntityRelationCommonBo.class);
    }

    public boolean validateNumber(String nextTab) {
        if (HRStringUtils.equals((String)nextTab, (String)"definefield")) {
            String number = (String)this.getModel().getValue("number");
            return Pattern.matches("^[a-zA-Z0-9_]*$", number);
        }
        return true;
    }

    public boolean validateFieldDefineData() {
        List joinEntities = Collections.emptyList();
        List entityRelations = Collections.emptyList();
        String joinEntitiesStr = this.getView().getPageCache().get("joinEntities");
        String entityRelationsStr = this.getView().getPageCache().get("entityRelations");
        if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
            joinEntities = JSON.parseArray((String)joinEntitiesStr, SchObjJoinEntity.class);
        }
        if (HRStringUtils.isNotEmpty((String)entityRelationsStr)) {
            entityRelations = JSON.parseArray((String)entityRelationsStr, SchObjEntityRelation.class);
        }
        if (HRStringUtils.isEmpty((String)joinEntitiesStr) || joinEntities.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u540e\u91cd\u8bd5\u3002", (String)"SearchObjDataProcessor_1", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!this.validateEntityRelation(joinEntities, entityRelations)) {
            return false;
        }
        return this.validateFields();
    }

    public boolean isDataChangedAndCancelSave() {
        String dataSyncIsConfirm = this.getView().getPageCache().get("dataSyncIsConfirm");
        if (HRStringUtils.equals((String)dataSyncIsConfirm, (String)"true")) {
            return false;
        }
        String originJoinEntitiesStr = this.getView().getPageCache().get("originJoinEntities");
        Long searchObjId = (Long)this.getModel().getValue("id");
        if (HRStringUtils.isEmpty((String)originJoinEntitiesStr) || searchObjId == null || searchObjId == 0L) {
            return false;
        }
        HRBaseServiceHelper syncSchemeHelper = new HRBaseServiceHelper("hrss_essyncscheme");
        DynamicObject synSchemeDy = syncSchemeHelper.queryOriginalOne("id", new QFilter[]{new QFilter("searchobj", "=", (Object)searchObjId)});
        if (synSchemeDy == null) {
            return false;
        }
        HRBaseServiceHelper synRecordHelper = new HRBaseServiceHelper("hrss_essyncscheme");
        List synStatusList = Stream.of("2", "3").collect(Collectors.toList());
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)synSchemeDy.getLong("id")), new QFilter("essynstatus", "in", synStatusList)};
        if (!synRecordHelper.isExists(qFilters)) {
            return false;
        }
        boolean isChanged = this.checkSecondStepIsChange();
        if (isChanged) {
            this.showConfirmReStartDataSyncPage();
        }
        return isChanged;
    }

    private boolean checkSecondStepIsChange() {
        String originJoinEntitiesStr = this.getView().getPageCache().get("originJoinEntities");
        String originQueryFieldsStr = this.getView().getPageCache().get("originQueryFields");
        String originEntityRelationsStr = this.getView().getPageCache().get("originEntityRelations");
        List originJoinEntities = JSON.parseArray((String)originJoinEntitiesStr, SchObjJoinEntity.class);
        List originEntityRelations = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)originEntityRelationsStr)) {
            originEntityRelations = JSON.parseArray((String)originEntityRelationsStr, SchObjEntityRelation.class);
        }
        List originQueryFields = Lists.newArrayListWithCapacity((int)10);
        if (HRStringUtils.isNotEmpty((String)originQueryFieldsStr)) {
            originQueryFields = JSON.parseArray((String)originQueryFieldsStr, SchObjQueryField.class);
        }
        List<SchObjJoinEntity> currentJoinEntities = this.getAllJoinEntity();
        List<SchObjEntityRelation> currentEntityRelations = this.getEntityRelations();
        List<SchObjQueryField> currentQueryFields = this.getQueryFields();
        boolean isJoinEntityChanged = this.isJoinEntityChanged(originJoinEntities, currentJoinEntities);
        boolean isQueryFieldChanged = this.isQueryFieldChanged(originQueryFields, currentQueryFields);
        boolean isEntityRelationChanged = this.isEntityRelationChanged(originEntityRelations, currentEntityRelations);
        this.getView().getPageCache().put("searchObjSecondIsCheck", "true");
        boolean isChanged = isJoinEntityChanged || isQueryFieldChanged || isEntityRelationChanged;
        this.getView().getPageCache().put("searchObjSecondChange", isChanged ? "true" : "false");
        return isChanged;
    }

    public void checkValueModify() {
        String conditionStrDb;
        DynamicObject searchObj = this.getModel().getDataEntity();
        long id = (Long)searchObj.getPkValue();
        if (id == 0L) {
            return;
        }
        String isPreset = searchObj.getString("issyspreset");
        if ("false".equals(isPreset) || "0".equals(isPreset)) {
            return;
        }
        DynamicObject searchObjFromDb = SEARCH_OBJECT.queryOne((Object)id);
        if (!searchObj.getString("number").equals(searchObjFromDb.getString("number"))) {
            this.getView().getPageCache().put("searchObjFirThrChange", "true");
            return;
        }
        if (!searchObj.getString("name").equals(searchObjFromDb.getString("name"))) {
            this.getView().getPageCache().put("searchObjFirThrChange", "true");
            return;
        }
        if (!searchObj.getDynamicObject("cloud").getString("id").equals(searchObjFromDb.getDynamicObject("cloud").getString("id"))) {
            this.getView().getPageCache().put("searchObjFirThrChange", "true");
            return;
        }
        if (!searchObj.getString("description").equals(searchObjFromDb.getString("description"))) {
            this.getView().getPageCache().put("searchObjFirThrChange", "true");
            return;
        }
        String secStepCheck = this.getView().getPageCache().get("searchObjSecondIsCheck");
        if (!"true".equals(secStepCheck)) {
            this.checkSecondStepIsChange();
        }
        String conditionCur = searchObj.getString("datafilter");
        String conditionFromDb = searchObjFromDb.getString("datafilter");
        if (StringUtils.isEmpty((CharSequence)conditionCur) && StringUtils.isEmpty((CharSequence)conditionFromDb)) {
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)conditionCur) && StringUtils.isEmpty((CharSequence)conditionFromDb) || StringUtils.isEmpty((CharSequence)conditionCur) && !StringUtils.isEmpty((CharSequence)conditionFromDb)) {
            this.getView().getPageCache().put("searchObjFirThrChange", "true");
            return;
        }
        RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditionCur, RuleConditionInfo.class);
        RuleConditionInfo conditionInfoFromDb = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditionFromDb, RuleConditionInfo.class);
        String conditionStr = SerializationUtils.toJsonString((Object)conditionInfo);
        if (!conditionStr.equals(conditionStrDb = SerializationUtils.toJsonString((Object)conditionInfoFromDb))) {
            this.getView().getPageCache().put("searchObjFirThrChange", "true");
        }
    }

    public void handleReStartDataSyncCloseCallBack(String operateKey) {
        this.getView().hideLoading();
        if (HRStringUtils.equals((String)operateKey, (String)"nosync")) {
            this.getView().getPageCache().put("dataSyncIsConfirm", "true");
            this.getView().invokeOperation("save");
        } else if (HRStringUtils.equals((String)operateKey, (String)"syncdata")) {
            this.getView().getPageCache().put("dataSyncIsConfirm", "true");
            this.getView().invokeOperation("save");
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("hrss_essyncscheme");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void showConfirmReStartDataSyncPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hrss_confirmdatasync");
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.getPlugin(), "showConfirmReStartDataSync"));
        this.getView().showForm(parameter);
    }

    private boolean isJoinEntityChanged(List<SchObjJoinEntity> originJoinEntities, List<SchObjJoinEntity> currentJoinEntities) {
        if (originJoinEntities.size() != currentJoinEntities.size()) {
            return true;
        }
        for (int i = 0; i < originJoinEntities.size(); ++i) {
            SchObjJoinEntity current;
            SchObjJoinEntity origin = originJoinEntities.get(i);
            if (origin.equals((Object)(current = currentJoinEntities.get(i)))) continue;
            return true;
        }
        return false;
    }

    private boolean isQueryFieldChanged(List<SchObjQueryField> originQueryFields, List<SchObjQueryField> currentQueryFields) {
        originQueryFields.removeIf(field -> field.getFieldAlias().endsWith(".id"));
        currentQueryFields.removeIf(field -> field.getFieldAlias().endsWith(".id"));
        if (originQueryFields.size() != currentQueryFields.size()) {
            return true;
        }
        Map currentFieldMap = currentQueryFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, Function.identity()));
        for (SchObjQueryField origin : originQueryFields) {
            SchObjQueryField current;
            if (origin.equals((Object)(current = (SchObjQueryField)currentFieldMap.get(origin.getFieldAlias())))) continue;
            return true;
        }
        return false;
    }

    private boolean isEntityRelationChanged(List<SchObjEntityRelation> originEntityRelations, List<SchObjEntityRelation> currentEntityRelations) {
        if (originEntityRelations.size() != currentEntityRelations.size()) {
            return true;
        }
        for (int i = 0; i < originEntityRelations.size(); ++i) {
            SchObjEntityRelation current;
            SchObjEntityRelation origin = originEntityRelations.get(i);
            if (!origin.equals((Object)(current = currentEntityRelations.get(i)))) {
                return true;
            }
            List originConditions = origin.getConditions();
            List currentConditions = current.getConditions();
            if (originConditions.size() != currentConditions.size()) {
                return true;
            }
            for (int j = 0; j < originConditions.size(); ++j) {
                JoinConditionBo currentCondition;
                JoinConditionBo originCondition = (JoinConditionBo)originConditions.get(j);
                if (originCondition.equals((Object)(currentCondition = (JoinConditionBo)currentConditions.get(j)))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validateFields() {
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        List queryFields = Collections.emptyList();
        if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
            queryFields = JSON.parseArray((String)queryFieldsStr, SchObjQueryField.class);
        }
        if (queryFields.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5b57\u6bb5\u540e\u91cd\u8bd5\u3002", (String)"SearchObjDataProcessor_2", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateEntityRelation(List<SchObjJoinEntity> joinEntities, List<SchObjEntityRelation> entityRelations) {
        for (SchObjJoinEntity joinEntity : joinEntities) {
            if (HRStringUtils.equals((String)joinEntity.getType(), (String)"main")) continue;
            Optional<SchObjEntityRelation> relationOptional = entityRelations.stream().filter(relation -> relation != null && HRStringUtils.isNotEmpty((String)relation.getEntityAlias()) && HRStringUtils.equals((String)relation.getJoinEntityAlias(), (String)joinEntity.getEntityAlias())).findAny();
            boolean noSet = false;
            if (relationOptional.isPresent()) {
                EntityRelationCommonBo entityRelation;
                List conditions;
                if (HRStringUtils.equals((String)relationOptional.get().getJoinType(), (String)"none")) {
                    noSet = true;
                }
                if ((conditions = (entityRelation = (EntityRelationCommonBo)relationOptional.get()).getConditions()) == null || conditions.isEmpty() || HRStringUtils.isEmpty((String)entityRelation.getJoinType())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u672a\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb\u6761\u4ef6\uff0c\u8bf7\u64cd\u4f5c\u540e\u91cd\u8bd5\u3002", (String)"SearchObjDataProcessor_3", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                    return false;
                }
            } else {
                noSet = true;
            }
            if (!noSet) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u672a\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u64cd\u4f5c\u540e\u91cd\u8bd5\u3002", (String)"SearchObjDataProcessor_4", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

