/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.searchobj.processor;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.ModifyFieldNameBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.common.model.searchobj.SchObjQueryField;
import kd.hrmp.hrss.formplugin.web.search.searchobj.SearchObjectEdit;
import kd.hrmp.hrss.formplugin.web.search.searchobj.processor.SearchObjCommonProcessor;

public class SearchObjFieldProcessor
extends SearchObjCommonProcessor {
    public SearchObjFieldProcessor(SearchObjectEdit plugin) {
        super(plugin);
    }

    public void openModifyFieldPage(CustomEventArgs args) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hbp_modifyfieldname");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("modifyFieldNameParams", (Object)args.getEventArgs());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.getPlugin(), "hbp_modifyfieldname"));
        this.getView().showForm(parameter);
    }

    public void setFieldComplexType() {
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        if (HRStringUtils.isEmpty((String)queryFieldsStr)) {
            return;
        }
        List queryFieldBoList = JSON.parseArray((String)queryFieldsStr, SchObjQueryField.class);
        for (SchObjQueryField queryField : queryFieldBoList) {
            if (queryField.getComplexType() != null) continue;
            String baseDataNum = queryField.getBaseDataNum();
            if (HRStringUtils.isEmpty((String)baseDataNum)) {
                queryField.setComplexType(FieldComplexType.NORMAL.getValue());
                continue;
            }
            String baseDataType = AnalyseObjectUtil.getBaseDataType((String)baseDataNum);
            queryField.setComplexType(baseDataType);
        }
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString((Object)queryFieldBoList));
    }

    public void setFieldControlType() {
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        if (HRStringUtils.isEmpty((String)queryFieldsStr)) {
            return;
        }
        List queryFieldCommonBoList = JSON.parseArray((String)queryFieldsStr, QueryFieldCommonBo.class);
        AnalyseObjectUtil.setFieldControlType((List)queryFieldCommonBoList);
        List queryFieldBoList = JSON.parseArray((String)queryFieldsStr, SchObjQueryField.class);
        for (SchObjQueryField queryFieldBo : queryFieldBoList) {
            if (HRStringUtils.isNotEmpty((String)queryFieldBo.getControlType())) continue;
            queryFieldCommonBoList.stream().filter(field -> HRStringUtils.equals((String)field.getFieldAlias(), (String)queryFieldBo.getFieldAlias())).findAny().ifPresent(field -> queryFieldBo.setControlType(field.getControlType()));
        }
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString((Object)queryFieldBoList));
    }

    public void setBaseDataIdFields() {
        List<SchObjQueryField> queryFieldBos = this.getQueryFields();
        List<SchObjQueryField> originalQueryFields = this.getOriginalQueryFields();
        Map originalFieldMap = originalQueryFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, Function.identity()));
        String fieldTreeNodeStr = this.getView().getPageCache().get("allFieldTreeNodes");
        if (HRStringUtils.isEmpty((String)fieldTreeNodeStr)) {
            return;
        }
        List fieldTreeNodes = JSON.parseArray((String)fieldTreeNodeStr, FieldTreeNode.class);
        Map<String, SchObjQueryField> queryFieldBoMap = queryFieldBos.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, field -> field));
        Map<String, FieldTreeNode> treeNodeMap = fieldTreeNodes.stream().collect(Collectors.toMap(FieldTreeNode::getFieldAlias, treeNode -> treeNode));
        ArrayList newQueryFieldBoList = Lists.newArrayListWithCapacity((int)10);
        HashSet addAlias = Sets.newHashSetWithExpectedSize((int)16);
        for (SchObjQueryField queryFieldBo : queryFieldBos) {
            if (!AnalyseObjectUtil.isBaseDataType((String)queryFieldBo.getComplexType())) continue;
            String fieldAlias = queryFieldBo.getFieldAlias();
            fieldAlias = fieldAlias.substring(0, fieldAlias.lastIndexOf(".")) + ".id";
            SchObjQueryField originQueryField = (SchObjQueryField)originalFieldMap.get(fieldAlias);
            if (queryFieldBoMap.containsKey(fieldAlias) || !addAlias.add(fieldAlias)) continue;
            if (originQueryField != null) {
                newQueryFieldBoList.add(originQueryField);
                continue;
            }
            FieldTreeNode fieldTreeNode = treeNodeMap.get(fieldAlias);
            SchObjQueryField newQueryFieldBo = new SchObjQueryField();
            newQueryFieldBo.setFieldName(fieldTreeNode.getName());
            newQueryFieldBo.setFieldNumber(fieldTreeNode.getFieldAlias());
            newQueryFieldBo.setEntityNumber(fieldTreeNode.getEntityNumber());
            newQueryFieldBo.setEntityName(fieldTreeNode.getEntityName());
            newQueryFieldBo.setFieldAlias(fieldTreeNode.getFieldAlias());
            newQueryFieldBo.setFieldPath(fieldTreeNode.getFieldPath());
            newQueryFieldBo.setValueType(fieldTreeNode.getValueType());
            newQueryFieldBo.setComplexType(fieldTreeNode.getComplexType());
            newQueryFieldBo.setVirtualEntityField(false);
            newQueryFieldBoList.add(newQueryFieldBo);
        }
        if (newQueryFieldBoList.isEmpty()) {
            return;
        }
        queryFieldBos.addAll(newQueryFieldBoList);
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString(queryFieldBos));
    }

    public void setFieldNewName(Object returnData) {
        String queryFieldStr;
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "modifyFieldName");
        dataMap.put("data", returnData);
        customcontrol.setData((Object)dataMap);
        ModifyFieldNameBo bo = (ModifyFieldNameBo)returnData;
        String treeNodeStr = this.getView().getPageCache().get("allFieldTreeNodes");
        if (HRStringUtils.isNotEmpty((String)treeNodeStr)) {
            List fieldTreeNodes = JSON.parseArray((String)treeNodeStr, FieldTreeNode.class);
            fieldTreeNodes.stream().filter(node -> HRStringUtils.equals((String)bo.getFieldAlias(), (String)node.getFieldAlias())).findAny().ifPresent(node -> node.setName(bo.getName()));
            this.getView().getPageCache().put("allFieldTreeNodes", SerializationUtils.toJsonString((Object)fieldTreeNodes));
        }
        if (HRStringUtils.isNotEmpty((String)(queryFieldStr = this.getView().getPageCache().get("queryFields")))) {
            List queryFieldBoList = JSON.parseArray((String)queryFieldStr, SchObjQueryField.class);
            queryFieldBoList.stream().filter(fieldBo -> HRStringUtils.equals((String)bo.getFieldAlias(), (String)fieldBo.getFieldAlias())).findAny().ifPresent(fieldBo -> fieldBo.setFieldName(bo.getName()));
            this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString((Object)queryFieldBoList));
        }
    }
}

