/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.searchobj.processor;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.SearchSceneServiceHelp;
import kd.hrmp.hrss.common.constants.search.searchobj.SearchObjectConstants;
import kd.hrmp.hrss.common.model.searchobj.SchObjJoinEntity;
import kd.hrmp.hrss.formplugin.web.search.searchobj.SearchObjectEdit;
import kd.hrmp.hrss.formplugin.web.search.searchobj.processor.SearchObjCommonProcessor;

public class SearchObjFormProcessor
extends SearchObjCommonProcessor
implements SearchObjectConstants {
    private static final Log LOGGER = LogFactory.getLog(SearchObjFormProcessor.class);

    public SearchObjFormProcessor(SearchObjectEdit plugin) {
        super(plugin);
    }

    public void sendFlagForGetAllData(String operationKey, String nextTab) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "getAllData");
        dataMap.put("operate", "nextStep");
        dataMap.put("time", new Date());
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            dataMap.put("operate", "save");
        } else if (HRStringUtils.equals((String)nextTab, (String)"filterdata")) {
            dataMap.put("operate", "nextStep");
            dataMap.put("time", System.currentTimeMillis());
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            LOGGER.error((Throwable)ex);
        }
        customcontrol.setData((Object)dataMap);
    }

    public String getNextTab(Tab tab) {
        String currentTab = tab.getCurrentTab();
        List items = tab.getItems();
        String nextTab = null;
        boolean foundCurrent = false;
        for (Control item : items) {
            if (foundCurrent) {
                nextTab = item.getKey();
                break;
            }
            if (!HRStringUtils.equals((String)currentTab, (String)item.getKey())) continue;
            foundCurrent = true;
        }
        return nextTab;
    }

    public String getLastTab(Tab tab) {
        String currentTab = tab.getCurrentTab();
        List items = tab.getItems();
        String lastTab = ((Control)items.get(0)).getKey();
        if (HRStringUtils.equals((String)lastTab, (String)currentTab)) {
            return null;
        }
        for (int i = 1; i < items.size(); ++i) {
            if (HRStringUtils.equals((String)currentTab, (String)((Control)items.get(i)).getKey())) {
                return lastTab;
            }
            lastTab = ((Control)items.get(i)).getKey();
        }
        return lastTab;
    }

    public void setVisibleForBtn(String tab, IFormView view) {
        if (HRStringUtils.equals((String)tab, (String)"defineobj")) {
            view.setVisible(Boolean.TRUE, new String[]{"nextstepbtn"});
            view.setVisible(Boolean.FALSE, new String[]{"laststepbtn", "bar_save"});
        } else if (HRStringUtils.equals((String)tab, (String)"definefield")) {
            view.setVisible(Boolean.TRUE, new String[]{"laststepbtn", "nextstepbtn", "bar_save"});
        } else if (HRStringUtils.equals((String)tab, (String)"filterdata")) {
            view.setVisible(Boolean.TRUE, new String[]{"laststepbtn", "bar_save"});
            view.setVisible(Boolean.FALSE, new String[]{"nextstepbtn"});
        }
    }

    public void sendFlagForToStep2() {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("method", "toStep2");
        dataMap.put("uuid", UUID.randomUUID());
        customcontrol.setData((Object)dataMap);
    }

    public void openConfigSearchTargetPage() {
        List<SchObjJoinEntity> allJoinEntity;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hrss_searchconfigtarget");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        String pageState = this.getView().getPageCache().get("pageStatus");
        if (HRStringUtils.equals((String)pageState, (String)OperationStatus.VIEW.toString())) {
            parameter.setStatus(OperationStatus.VIEW);
        }
        if ((allJoinEntity = this.getAllJoinEntity()).isEmpty() || allJoinEntity.stream().noneMatch(SchObjJoinEntity::isTargetObjMainEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u641c\u7d22\u5bf9\u8c61\u5173\u8054\u7684\u5b9e\u4f53\u65e0\u76f8\u5173\u6807\u7b7e\u4fe1\u606f\uff0c\u65e0\u9700\u914d\u7f6e\u641c\u7d22\u6807\u7b7e\u3002", (String)"SearchObjFormProcessor_1", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
            return;
        }
        parameter.setCustomParam("joinEntities", (Object)this.getView().getPageCache().get("joinEntities"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.getPlugin(), "hrss_searchconfigtarget"));
        Long searchObjId = (Long)this.getModel().getValue("id");
        if (searchObjId != null && searchObjId != 0L) {
            HashSet refTargetEntityList = SearchSceneServiceHelp.usedLabelEntity((Long)searchObjId);
            parameter.setCustomParam("refTargetEntityList", (Object)SerializationUtils.toJsonString((Object)refTargetEntityList));
        }
        this.getView().showForm(parameter);
    }
}

