/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.searchobj.processor;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.hr.ruleengine.utils.RuleUtil;
import kd.hr.hbp.business.service.labelandreport.AnobjFilterUtil;
import kd.hr.hbp.business.service.labelandreport.FieldDefineService;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.model.complexobj.labelandreport.DataSourceCloudBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.SearchSceneServiceHelp;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;
import kd.hrmp.hrss.common.constants.search.searchobj.SearchObjectConstants;
import kd.hrmp.hrss.common.model.searchobj.SchObjEntityRelation;
import kd.hrmp.hrss.common.model.searchobj.SchObjJoinEntity;
import kd.hrmp.hrss.common.model.searchobj.SchObjQueryField;
import kd.hrmp.hrss.formplugin.web.search.searchobj.SearchObjectEdit;
import kd.hrmp.hrss.formplugin.web.search.searchobj.processor.SearchObjCommonProcessor;
import kd.hrmp.hrss.formplugin.web.search.searchobj.processor.SearchObjDataProcessor;

public class SearchObjInitProcessor
extends SearchObjCommonProcessor
implements SearchObjectConstants {
    private final SearchObjDataProcessor dataProcessor;

    public SearchObjInitProcessor(SearchObjectEdit plugin) {
        super(plugin);
        this.dataProcessor = new SearchObjDataProcessor(plugin);
    }

    public void initData() {
        SearchObjectService service = SearchObjectService.getInstance();
        Long id = (Long)this.getModel().getValue("id");
        List joinEntities = service.queryAndAssembleJoinEntities(id);
        SearchObjectService.getInstance().setTargetMainObject(joinEntities);
        List queryFields = service.queryAndAssembleQueryFields(id);
        List entityRelations = service.queryAndAssembleEntityRelations(id);
        for (SchObjEntityRelation entityRelation : entityRelations) {
            joinEntities.stream().filter(entityBo -> HRStringUtils.equals((String)entityBo.getEntityAlias(), (String)entityRelation.getJoinEntityAlias())).findAny().ifPresent(entityBo -> entityBo.setEntityRelation((EntityRelationCommonBo)entityRelation));
        }
        this.getView().getPageCache().put("joinEntities", SerializationUtils.toJsonString((Object)joinEntities));
        this.getView().getPageCache().put("originJoinEntities", SerializationUtils.toJsonString((Object)joinEntities));
        this.getView().getPageCache().put("queryFields", SerializationUtils.toJsonString((Object)queryFields));
        this.getView().getPageCache().put("originQueryFields", SerializationUtils.toJsonString((Object)queryFields));
        this.getView().getPageCache().put("entityRelations", SerializationUtils.toJsonString((Object)entityRelations));
        this.getView().getPageCache().put("originEntityRelations", SerializationUtils.toJsonString((Object)entityRelations));
    }

    public void initDataFilter() {
        String queryFields = this.getView().getPageCache().get("queryFields");
        if (HRStringUtils.isEmpty((String)queryFields)) {
            return;
        }
        List queryFieldBos = JSON.parseArray((String)queryFields, QueryFieldCommonBo.class);
        List inputMap = AnobjFilterUtil.getParamList((List)queryFieldBos);
        if (inputMap.isEmpty()) {
            return;
        }
        String value = (String)this.getModel().getValue("datafilter");
        HashMap data = Maps.newHashMapWithExpectedSize((int)4);
        data.put("param", inputMap);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            value = RuleUtil.getNewestConditionValue((String)value);
            data.put("value", value);
            this.getPlugin().getHRFilter().setValue(value);
            data.put("onlyUpdateWeb", "true");
        }
        String pageState = this.getView().getPageCache().get("pageStatus");
        data.put("pageState", pageState.toLowerCase(Locale.ROOT));
        this.getPlugin().getHRFilter().updateControlData((Map)data);
    }

    public void initCustomControl() {
        List joinEntities = Collections.emptyList();
        List queryFields = Collections.emptyList();
        List entityRelations = Collections.emptyList();
        List entityAllFields = Lists.newArrayListWithCapacity((int)10);
        String joinEntitiesStr = this.getView().getPageCache().get("joinEntities");
        String queryFieldsStr = this.getView().getPageCache().get("queryFields");
        String entityRelationsStr = this.getView().getPageCache().get("entityRelations");
        ArrayList selectedFieldKeys = Lists.newArrayListWithCapacity((int)10);
        if (this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
            if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
                joinEntities = JSON.parseArray((String)joinEntitiesStr, SchObjJoinEntity.class);
            }
            if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
                queryFields = JSON.parseArray((String)queryFieldsStr, SchObjQueryField.class);
                queryFields.stream().filter(queryField -> queryField.isVirtualEntityField() || !queryField.getFieldAlias().endsWith(".id")).forEach(queryField -> selectedFieldKeys.add(queryField.getFieldAlias()));
            }
            if (HRStringUtils.isNotEmpty((String)entityRelationsStr)) {
                entityRelations = JSON.parseArray((String)entityRelationsStr, SchObjEntityRelation.class);
            }
            FieldDefineService service = new FieldDefineService();
            service.setSetComplexType(false);
            HashSet refFieldAliasList = SearchSceneServiceHelp.queryUsedField((Long)((Long)this.getModel().getValue("id")));
            entityAllFields = service.getEntityAllFields(this.dataProcessor.transferJoinEntityBos(joinEntities), this.dataProcessor.transferQueryFieldBos(queryFields), (Set)refFieldAliasList);
            this.setAllFieldsToCache(entityAllFields);
        }
        FieldDefineService fieldDefineService = new FieldDefineService();
        List dataSourceCloudBos = fieldDefineService.getDataSourceTree();
        Map<String, Object> dataMap = this.assembleData(dataSourceCloudBos, joinEntities, entityRelations, entityAllFields, selectedFieldKeys);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData(dataMap);
        this.getView().getPageCache().put("initCompleted", "1");
    }

    private Map<String, Object> assembleData(List<DataSourceCloudBo> clouds, List<SchObjJoinEntity> joinEntities, List<SchObjEntityRelation> entityRelations, List<FieldTreeNode> entityAllFields, List<String> selectedFieldKeys) {
        for (SchObjJoinEntity joinEntity : joinEntities) {
            if (!HRStringUtils.equals((String)joinEntity.getType(), (String)"sub")) continue;
            entityRelations.stream().filter(relation -> HRStringUtils.equals((String)relation.getJoinEntityAlias(), (String)joinEntity.getEntityAlias())).findAny().ifPresent(arg_0 -> ((SchObjJoinEntity)joinEntity).setEntityRelation(arg_0));
        }
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        String statusParam = this.getPageStatus();
        dataMap.put("status", statusParam);
        dataMap.put("entityNodes", joinEntities);
        dataMap.put("clouds", clouds);
        if (HRStringUtils.equals((String)statusParam, (String)OperationStatus.VIEW.toString())) {
            entityAllFields.forEach(this::disableFieldTreeNode);
        }
        dataMap.put("fieldTreeNode", entityAllFields);
        List<String> dataFilterRefFieldAlias = this.getDataFilterRefFieldAlias();
        dataMap.put("filterFieldAliasList", dataFilterRefFieldAlias);
        dataMap.put("selectedFieldKeys", selectedFieldKeys);
        dataMap.put("method", "init");
        dataMap.put("isReport", Boolean.FALSE);
        FieldDefineService fieldDefineService = new FieldDefineService();
        dataMap.put("entities", fieldDefineService.getAllEntities(clouds));
        dataMap.put("dataSource", "business");
        return dataMap;
    }

    private void disableFieldTreeNode(FieldTreeNode node) {
        node.setDisabled(Boolean.TRUE);
        if (node.getChildren() != null) {
            for (FieldTreeNode child : node.getChildren()) {
                this.disableFieldTreeNode(child);
            }
        }
    }

    private String getPageStatus() {
        String dataStatus;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String statusParam = status.toString();
        boolean audit = HRBaseDataConfigUtil.getAudit((String)this.getView().getEntityId());
        if (audit && !HRStringUtils.equals((String)(dataStatus = (String)this.getModel().getValue("status")), (String)"A")) {
            statusParam = OperationStatus.VIEW.toString();
        }
        this.getView().getPageCache().put("pageStatus", statusParam);
        return statusParam;
    }
}

