/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.searchscenetest;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.openservicehelper.search.SearchServiceHelper;
import kd.hr.hbp.common.enums.smartsearch.SearchCategoryEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchKeyLogicEnum;
import kd.hr.hbp.common.model.smartsearch.search.SearchParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hrss.business.domain.search.service.SearchSceneServiceHelp;
import kd.hrmp.hrss.business.domain.search.service.SearchSceneTestHelp;
import kd.hrmp.hrss.business.domain.search.service.common.BaseDataFilterUtil;
import kd.hrmp.hrss.business.domain.search.service.searchweight.SearchWeightConfHelper;

public class SearchSceneTestFormPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(SearchSceneTestFormPlugin.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        SearchSceneTestHelp.getInstance().getInitData(this.getView());
    }

    public void customEvent(CustomEventArgs evt) {
        String key = evt.getKey();
        String evName = evt.getEventName();
        if ("changeScene".equals(evName)) {
            String eventArgs = evt.getEventArgs();
            Map clickData = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
            String sceneId = (String)clickData.get("sceneId");
            this.getPageCache().put("sceneId", sceneId);
            SearchSceneTestHelp.getInstance().changeSearchScene(this.getView(), Long.valueOf(sceneId));
            return;
        }
        if ("adjustWeight".equals(evName)) {
            String eventArgs = evt.getEventArgs();
            Map clickData = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
            String sceneId = (String)clickData.get("sceneId");
            DynamicObject[] weightBySceneId = SearchWeightConfHelper.getInstance().getWeightBySceneId(Long.valueOf(sceneId));
            if (weightBySceneId != null && weightBySceneId.length != 0) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("hrss_searchweight");
                showParameter.setPkId(weightBySceneId[0].getPkValue());
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "searchweight"));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6392\u5e8f\u6743\u91cd", (String)"SearchSceneTestFormPlugin_0", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
            }
        } else if ("searchResult".equals(evName)) {
            this.getView().showLoading(new LocaleString());
            try {
                String eventArgs = evt.getEventArgs();
                Map clickData = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
                String sceneId = (String)clickData.get("sceneId");
                String searchWord = (String)clickData.get("searchWord");
                String accurateType = (String)clickData.get("accurateType");
                List filterCondition = Collections.singletonList(clickData.get("filterCondition"));
                ArrayList qFilters = Lists.newArrayListWithCapacity((int)16);
                for (Object filter : filterCondition) {
                    List filterList = (List)filter;
                    for (Map stringObjectMap : filterList) {
                        QFilter qFilter;
                        QFilter qFilter2;
                        String number;
                        String filterNumber = (String)stringObjectMap.get("number");
                        if (stringObjectMap.containsKey("selectedID") && !filterNumber.contains("label_")) {
                            number = (String)stringObjectMap.get("selectedID");
                            String realEntityNumber = (String)stringObjectMap.get("realEntityNumber");
                            List selected = (List)stringObjectMap.get("selected");
                            if (selected.contains("-1") || CollectionUtils.isEmpty((Collection)selected)) continue;
                            List transformIDTypes = SearchSceneTestHelp.getInstance().transformIDType(realEntityNumber, selected);
                            qFilter2 = new QFilter(number, "in", (Object)transformIDTypes);
                            qFilters.add(qFilter2);
                            continue;
                        }
                        number = (String)stringObjectMap.get("number");
                        List selected = (List)stringObjectMap.get("selected");
                        String filterType = (String)stringObjectMap.get("filterType");
                        if (HRStringUtils.equals((String)"2", (String)filterType)) {
                            HashMap customerFilterMap = SearchSceneTestHelp.getInstance().queryCustomerFilter(selected, this.getView());
                            QFilter baseQFilter = null;
                            for (Map.Entry customerFilter : customerFilterMap.entrySet()) {
                                String customerKey = (String)customerFilter.getKey();
                                Object value = customerFilter.getValue();
                                QFilter qFilter3 = new QFilter(number + "$" + customerKey, "in", value);
                                if (baseQFilter == null) {
                                    baseQFilter = qFilter3;
                                    continue;
                                }
                                baseQFilter = baseQFilter.or(qFilter3);
                            }
                            if (baseQFilter == null) continue;
                            qFilters.add(baseQFilter);
                            continue;
                        }
                        if (filterNumber.contains("label_")) {
                            if (CollectionUtils.isEmpty((Collection)selected) || selected.contains("-1")) continue;
                            ArrayList labelIds = Lists.newArrayListWithCapacity((int)16);
                            for (String labelIdStr : selected) {
                                labelIds.add(Long.valueOf(labelIdStr));
                            }
                            qFilter2 = new QFilter(number, "in", (Object)labelIds);
                            qFilters.add(qFilter2);
                            continue;
                        }
                        List selectedName = (List)stringObjectMap.get("selectedName");
                        String realEntityNumber = (String)stringObjectMap.get("realEntityNumber");
                        String fieldType = SearchSceneTestHelp.getFieldType((IFormView)this.getView(), (String)filterNumber, (String)realEntityNumber);
                        if ("enum".equals(fieldType)) {
                            if (selected.contains("-1") || CollectionUtils.isEmpty((Collection)selectedName)) continue;
                            qFilter = new QFilter(number, "in", (Object)selected);
                            qFilters.add(qFilter);
                            continue;
                        }
                        if (selected.contains("-1") || CollectionUtils.isEmpty((Collection)selectedName)) continue;
                        qFilter = new QFilter(number, "in", (Object)selectedName);
                        qFilters.add(qFilter);
                    }
                }
                String searchType = (String)clickData.get("searchType");
                String searchRelation = (String)clickData.get("searchRelation");
                SearchKeyLogicEnum logicEnum = SearchKeyLogicEnum.of((String)searchRelation);
                SearchCategoryEnum categoryEnum = SearchCategoryEnum.of((String)searchType);
                SearchParam searchParam = new SearchParam(Long.valueOf(sceneId), null, categoryEnum, logicEnum, this.getPageCache().getPageId());
                searchParam.setSearchContent(searchWord);
                this.getPageCache().put("searchWord", searchWord);
                SearchSceneTestHelp.getInstance().searchSceneQuery(this.getView(), searchParam, Long.valueOf(accurateType), (List)qFilters);
                this.getView().hideLoading();
            }
            catch (Exception exception) {
                this.getView().hideLoading();
                LOGGER.error("searchResult error", (Throwable)exception);
                throw new KDBizException(exception.getMessage());
            }
        } else if ("getMorefilterData".equals(evName)) {
            String eventArgs = evt.getEventArgs();
            Map clickData = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
            List selected = (List)clickData.get("selected");
            String number = (String)clickData.get("number");
            this.getPageCache().put("fieldNumber", number);
            String sceneId = this.getPageCache().get("sceneId");
            this.getPageCache().put("index", String.valueOf(clickData.get("index")));
            String realEntityNumber = (String)clickData.get("realEntityNumber");
            String fieldType = (String)clickData.get("filedType");
            if ("label".equals(fieldType)) {
                DynamicObject searchSceneById = SearchSceneServiceHelp.getSearchSceneById((Object)Long.valueOf(sceneId));
                DynamicObject searchobj = searchSceneById.getDynamicObject("searchobj");
                ListShowParameter listShowParameter = SearchServiceHelper.getLabelValueF7ShowForm((String)number, (Long)((Long)searchobj.getPkValue()));
                listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "getMorefilterData"));
                this.getView().showForm((FormShowParameter)listShowParameter);
            } else {
                ListShowParameter listShowParameter = new ListShowParameter();
                if (!selected.contains("0")) {
                    List transformIDTypes = SearchSceneTestHelp.getInstance().transformIDType(realEntityNumber, selected);
                    listShowParameter.setSelectedRows(transformIDTypes.toArray());
                }
                StyleCss css = new StyleCss();
                css.setWidth("960px");
                css.setHeight("580px");
                listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                listShowParameter.setFormId("bos_listf7");
                List f7FilterList = BaseDataFilterUtil.getF7FilterList((String)realEntityNumber);
                listShowParameter.getListFilterParameter().getQFilters().addAll(f7FilterList);
                listShowParameter.setBillFormId(realEntityNumber);
                listShowParameter.setLookUp(true);
                listShowParameter.setShowTitle(false);
                listShowParameter.setMultiSelect(true);
                listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "getMorefilterData"));
                listShowParameter.getOpenStyle().setInlineStyleCss(css);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("getMorefilterData".equals(actionId)) {
            String fieldNumber = this.getPageCache().get("fieldNumber");
            Integer index = Integer.valueOf(this.getPageCache().get("index"));
            ListSelectedRowCollection checkedData = (ListSelectedRowCollection)event.getReturnData();
            if (checkedData == null) {
                return;
            }
            HashMap data = Maps.newHashMapWithExpectedSize((int)16);
            HashMap selectMap = Maps.newHashMapWithExpectedSize((int)16);
            String substring = fieldNumber;
            if (fieldNumber.contains(".")) {
                substring = fieldNumber.substring(0, fieldNumber.lastIndexOf(".") + 1);
            }
            selectMap.put("number", substring + "id");
            ArrayList selectedList = Lists.newArrayListWithCapacity((int)16);
            for (ListSelectedRow selectRow : checkedData) {
                selectedList.add(selectRow.getPrimaryKeyValue().toString());
            }
            selectMap.put("selected", selectedList);
            selectMap.put("selectedName", selectedList);
            selectMap.put("index", index);
            data.put("method", "getMorefilterData");
            data.put("random", System.currentTimeMillis());
            data.put("data", selectMap);
            CustomControl fieldTreeControl = (CustomControl)this.getView().getControl("customsearch");
            fieldTreeControl.setData((Object)SerializationUtils.toJsonString((Object)data));
        }
    }
}

