/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.weight;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hrmp.hrss.business.domain.search.service.SearchQueryHelper;
import kd.hrmp.hrss.common.dto.AISearchInfoDTO;
import kd.hrmp.hrss.common.util.FormShowUtils;

public class AISearchInfoPlugin
extends HRDynamicFormBasePlugin {
    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String aiWordName = (String)customParams.get("aiWordName");
        formShowParameter.setCaption(ResManager.loadKDString((String)"AI\u8bcd\u6027\u6392\u5e8f\u6743\u91cd\u8be6\u60c5_%s", (String)"AISearchInfoPlugin_0", (String)"hrmp-hrss-formplugin", (Object[])new Object[]{aiWordName}));
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long aiWordId = (Long)customParams.get("aiWordId");
        this.setEntryHandle(aiWordId);
    }

    private void setEntryHandle(Long aiWordId) {
        HashMap searchWeightMap = SearchQueryHelper.getInstance().getSearchWeightByAi(aiWordId);
        if (CollectionUtils.isEmpty((Map)searchWeightMap)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"search_flex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"nodata_flex"});
        } else {
            boolean flag = false;
            for (Map.Entry entry : searchWeightMap.entrySet()) {
                DynamicObject searchWeight = (DynamicObject)entry.getValue();
                DynamicObjectCollection dynamicObjectCollection = searchWeight.getDynamicObjectCollection("subentryentity");
                if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) continue;
                flag = true;
            }
            if (!flag) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"search_flex"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"nodata_flex"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"search_flex"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"nodata_flex"});
            }
            AtomicInteger count = new AtomicInteger();
            searchWeightMap.forEach((scene, searchWeightList) -> {
                Container flexPanel = (Container)this.getControl("search_flex");
                List<AISearchInfoDTO> dtoList = this.convertToDTO(scene.getLocaleString("name").getLocaleValue(), (DynamicObject)searchWeightList);
                if (dtoList.size() == 0) {
                    return;
                }
                HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
                paramMap.put("searchWeight", dtoList);
                FormShowParameter showParameter = FormShowUtils.setFlexFormShow((Container)flexPanel, (String)flexPanel.getKey().concat(String.valueOf(count)), (String)"hrss_searchresult_info", (Map)paramMap);
                this.getView().showForm(showParameter);
                count.getAndIncrement();
            });
        }
    }

    private List<AISearchInfoDTO> convertToDTO(String useSceneName, DynamicObject searchWeight) {
        ArrayList<AISearchInfoDTO> dtoList = new ArrayList<AISearchInfoDTO>();
        searchWeight.getDynamicObjectCollection("subentryentity").forEach(searchWeightEntry -> {
            AISearchInfoDTO dto = new AISearchInfoDTO();
            dto.setSceneName(useSceneName);
            DynamicObject dynamicObject = searchWeightEntry.getDynamicObject("searchobjentityid");
            if (dynamicObject != null) {
                dto.setSearchObj(searchWeightEntry.getDynamicObject("searchobjentityid").getPkValue().toString());
            }
            dto.setSearchField(searchWeightEntry.getLocaleString("fieldname").getLocaleValue());
            dto.setSearchGrade(searchWeightEntry.getString("grade.name"));
            dto.setSearchValue(searchWeightEntry.getString("grade.weightvalue"));
            dtoList.add(dto);
        });
        return dtoList;
    }
}

