/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.weight;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hrss.business.domain.search.service.SearchQueryHelper;
import kd.hrmp.hrss.business.domain.search.service.SearchSceneServiceHelp;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;
import kd.hrmp.hrss.business.domain.search.service.searchweight.SearchWeightConfHelper;
import kd.hrmp.hrss.common.model.searchobj.SchObjQueryField;

public class WeightConfigurePlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
TreeNodeClickListener,
RowClickEventListener {
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"obj", "field", "addaiwordpanelap", "fieldnamecopy"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit position = (BasedataEdit)this.getControl("grade");
        position.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit usescene = (BasedataEdit)this.getControl("usescene");
        usescene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit searchObjEntity = (BasedataEdit)this.getControl("searchobjentityid");
        searchObjEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((CardEntry)this.getControl("entryentity")).addRowClickListener((RowClickEventListener)this);
        ((SubEntryGrid)this.getControl("subentryentity")).addRowClickListener((RowClickEventListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getProperty().getName().equals("grade")) {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> listFilter = new ArrayList<QFilter>(1);
            DynamicObject sceneDyn = (DynamicObject)this.getModel().getValue("usescene");
            if (sceneDyn == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u641c\u7d22\u573a\u666f\u201d\u3002", (String)"WeightConfigurePlugin_9", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                listFilter.add(new QFilter("scenceid", "=", (Object)SearchQueryHelper.getInstance().getWeightGradeIdOfScene(Long.valueOf(sceneDyn.getLong("id")))));
                listShowParameter.getListFilterParameter().setQFilters(listFilter);
            }
        } else if (beforeF7SelectEvent.getProperty().getName().equals("usescene")) {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> listFilter = new ArrayList<QFilter>(1);
            DynamicObject[] dynamicObjects = SearchWeightConfHelper.getInstance().getAllSearchweight();
            List collect = Arrays.stream(dynamicObjects).map(dynamicObject -> {
                if (dynamicObject.getDynamicObject("usescene") == null) {
                    return 0;
                }
                return dynamicObject.getDynamicObject("usescene").getPkValue();
            }).collect(Collectors.toList());
            Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
            if (Objects.nonNull(pkValue) && pkValue != 0L) {
                DynamicObject searchweightById = SearchWeightConfHelper.getInstance().getSearchweightById((Object)pkValue);
                collect.remove(searchweightById.getDynamicObject("usescene").getPkValue());
            }
            listFilter.add(new QFilter("id", "not in", collect));
            listShowParameter.getListFilterParameter().setQFilters(listFilter);
        } else if (beforeF7SelectEvent.getProperty().getName().equals("searchobjentityid")) {
            Object value = this.getModel().getValue("usescene");
            if (Objects.isNull(value)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u641c\u7d22\u573a\u666f\u201d\u3002", (String)"WeightConfigurePlugin_9", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<QFilter> listFilter = new ArrayList<QFilter>(1);
            DynamicObject searchScene = (DynamicObject)this.getModel().getValue("usescene");
            Object pkValue = searchScene.getDynamicObject("searchobj").getPkValue();
            DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity("subentryentity");
            ArrayList entityNumbers = Lists.newArrayListWithCapacity((int)16);
            for (DynamicObject dynamicObject2 : subEntryEntity) {
                DynamicObject entity = dynamicObject2.getDynamicObject("searchobjentityid");
                if (entity == null) continue;
                entityNumbers.add(entity.getString("entitynumber"));
            }
            listFilter.add(new QFilter("searchobj", "=", pkValue));
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getListFilterParameter().setQFilters(listFilter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        String usesceneChangeFlag = this.getPageCache().get("usescenechangeflag");
        if (Objects.isNull(pkValue) || pkValue == 0L || "1".equals(usesceneChangeFlag)) {
            this.getPageCache().remove("usescenechangeflag");
            this.initAiWordCardEntry();
        } else {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("subentryentity");
            if (entryEntity == null) {
                return;
            }
            this.getModel().beginInit();
            for (int i = 0; i < entryEntity.size(); ++i) {
                OrmLocaleValue value = (OrmLocaleValue)this.getModel().getValue("fieldname", i);
                this.getModel().setValue("fieldnamecopy", (Object)value.getLocaleValue(), i);
            }
            this.getModel().endInit();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((EntryGrid)evt.getSource()).getEntryKey();
        int currentIndex = evt.getRow();
        if ("entryentity".equalsIgnoreCase(key)) {
            String isDefault = (String)this.getModel().getValue("isdefault", currentIndex);
            this.setViewaidefaultVisible(isDefault);
        } else if ("subentryentity".equalsIgnoreCase(key)) {
            this.getPageCache().put("paramConfigCurrentIndex", String.valueOf(currentIndex));
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        DynamicObject sceneDyn = (DynamicObject)this.getModel().getValue("usescene");
        this.getView().setEnable(Boolean.valueOf(sceneDyn != null), new String[]{"isdefault", "aiwordnumber"});
        this.getView().getPageCache().put("cache_codeUpdate", "0");
        this.getView().setVisible(Boolean.TRUE, new String[]{"cardentryfixrowap"});
        ((EntryGrid)this.getControl("entryentity")).selectRows(0);
        int selectRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        String isDefault = (String)this.getModel().getValue("isdefault", selectRowIndex);
        this.setViewaidefaultVisible(isDefault);
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        for (int index = 0; index < cardEntry.getEntryData().getDataEntitys().length; ++index) {
            String isDefaultEntry = (String)this.getModel().getValue("isdefault", index);
            if (HRStringUtils.equals((String)"1", (String)isDefaultEntry)) {
                cardEntry.setChildVisible(false, index, new String[]{"aiwordcategory", "deleteaiword"});
                cardEntry.setChildVisible(true, index, new String[]{"aiwordcategorytext"});
                continue;
            }
            cardEntry.setChildVisible(true, index, new String[]{"aiwordcategory", "deleteaiword"});
            cardEntry.setChildVisible(false, index, new String[]{"aiwordcategorytext"});
        }
    }

    private Object getEntryValue(String entry, String field) {
        int selectRowIndex = this.getModel().getEntryCurrentRowIndex(entry);
        return this.getModel().getValue(field, selectRowIndex);
    }

    private void setViewaidefaultVisible(String isDefault) {
        if (HRStringUtils.equals((String)isDefault, (String)"1")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_viewaidefault"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_viewaidefault"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_viewaidefault".equals(itemKey)) {
            FormShowParameter aiSearchInfo = new FormShowParameter();
            aiSearchInfo.setFormId("hrss_aisearchinfo");
            aiSearchInfo.getOpenStyle().setShowType(ShowType.Modal);
            DynamicObject dynamicObject = (DynamicObject)this.getEntryValue("entryentity", "aiwordcategory");
            aiSearchInfo.setCustomParam("aiWordId", (Object)dynamicObject.getLong("id"));
            aiSearchInfo.setCustomParam("aiWordName", (Object)dynamicObject.getString("name"));
            this.getView().showForm(aiSearchInfo);
        } else if ("addfield".equals(itemKey)) {
            Object value = this.getModel().getValue("usescene");
            if (Objects.isNull(value)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u641c\u7d22\u573a\u666f\u201d\u3002", (String)"WeightConfigurePlugin_9", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showSearchEntityField();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (HRStringUtils.equals((String)key, (String)"addaiwordpanelap")) {
            this.showAiWordF7();
        } else if (HRStringUtils.equals((String)key, (String)"fieldnamecopy")) {
            this.showFieldWindow();
        }
    }

    private void showFieldWindow() {
        DynamicObject searchScene = (DynamicObject)this.getModel().getValue("usescene");
        Object pkValue = searchScene.getDynamicObject("searchobj").getPkValue();
        List schObjQueryFields = SearchObjectService.getInstance().queryAndAssembleQueryFields((Long)pkValue);
        this.getPageCache().put("searchFieldCach", SerializationUtils.toJsonString((Object)schObjQueryFields));
        int rowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
        DynamicObject searchObjEntity = (DynamicObject)this.getModel().getValue("searchobjentityid", rowIndex);
        if (searchObjEntity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u641c\u7d22\u5bf9\u8c61\u201d\u3002", (String)"WeightConfigurePlugin_11", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
            return;
        }
        String fieldId = (String)this.getModel().getValue("fieldid", rowIndex);
        String[] split = fieldId.split(",");
        List<String> selectedFieldList = Arrays.asList(split);
        String entityNumber = searchObjEntity.getString("entitynumber");
        String entityAlias = searchObjEntity.getString("entityalias");
        String entityName = searchObjEntity.getLocaleString("entityname").getLocaleValue();
        String type = searchObjEntity.getString("type");
        boolean searchtarget = searchObjEntity.getBoolean("searchtarget");
        TreeNode rootNode = new TreeNode("", entityAlias, entityName);
        rootNode.setIsOpened(true);
        ArrayList treeNodes = Lists.newArrayListWithCapacity((int)16);
        List<String> allSelectField = this.getAllSelectField(entityAlias);
        allSelectField.removeAll(selectedFieldList);
        for (SchObjQueryField schObjQueryField : schObjQueryFields) {
            String fieldAlias = schObjQueryField.getFieldAlias();
            boolean judgeEntityAlias = SearchSceneServiceHelp.judgeEntityAlias((String)fieldAlias, (String)entityAlias, (String)entityNumber, (String)schObjQueryField.getEntityNumber());
            if (!judgeEntityAlias || allSelectField.contains(schObjQueryField.getFieldAlias())) continue;
            TreeNode sonNode = new TreeNode(rootNode.getId(), schObjQueryField.getFieldAlias(), schObjQueryField.getFieldName().getLocaleValue());
            for (String selectedField : selectedFieldList) {
                if (!HRStringUtils.equals((String)schObjQueryField.getFieldAlias(), (String)selectedField)) continue;
                sonNode.setCheckable(true);
                break;
            }
            rootNode.addChild(sonNode);
            treeNodes.add(sonNode);
        }
        if (!searchtarget) {
            rootNode.setChildren((List)treeNodes);
            String caption = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u9009\u62e9", (String)"WeightConfigurePlugin_12", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]);
            this.showFieldF7Form(rootNode, "fieldid", caption);
            return;
        }
        Map gptLabelResult = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSLabelService", (String)"queryLabelObjectsByEntityNumber", (Object[])new Object[]{entityNumber});
        boolean success = (Boolean)gptLabelResult.get("success");
        if (!success) {
            throw new KDBizException((String)gptLabelResult.get("msg"));
        }
        ArrayList distinctLabels = SearchSceneServiceHelp.distinctLabelResult((Map)gptLabelResult);
        for (Map objectMap : distinctLabels) {
            TreeNode fieldNode;
            Map labelName;
            Long labelId = (Long)objectMap.get("labelId");
            String labelType = (String)objectMap.get("labelType");
            if (!"10".equals(labelType)) continue;
            if ("main".equals(type)) {
                if (allSelectField.contains("label_" + labelId)) continue;
                labelName = (Map)objectMap.get("labelName");
                if (labelId == null || labelId == 0L || CollectionUtils.isEmpty((Map)labelName)) continue;
                fieldNode = new TreeNode(rootNode.getId(), "label_" + labelId, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff08\u6807\u7b7e\uff09", (String)"WeightConfigurePlugin_13", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]), labelName.get("GLang")));
                for (String selectedField : selectedFieldList) {
                    if (!HRStringUtils.equals((String)fieldNode.getId(), (String)selectedField)) continue;
                    fieldNode.setCheckable(true);
                    break;
                }
                rootNode.addChild(fieldNode);
                treeNodes.add(fieldNode);
                continue;
            }
            if (allSelectField.contains(entityAlias + "." + "label_" + labelId)) continue;
            labelName = (Map)objectMap.get("labelName");
            if (labelId == null || labelId == 0L || CollectionUtils.isEmpty((Map)labelName)) continue;
            fieldNode = new TreeNode(rootNode.getId(), entityAlias + "." + "label_" + labelId, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff08\u6807\u7b7e\uff09", (String)"WeightConfigurePlugin_13", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]), labelName.get("GLang")));
            for (String selectedField : selectedFieldList) {
                if (!HRStringUtils.equals((String)fieldNode.getId(), (String)selectedField)) continue;
                fieldNode.setCheckable(true);
                break;
            }
            rootNode.addChild(fieldNode);
            treeNodes.add(fieldNode);
        }
        rootNode.setChildren((List)treeNodes);
        String caption = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u9009\u62e9", (String)"WeightConfigurePlugin_12", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]);
        this.showFieldF7Form(rootNode, "fieldid", caption);
    }

    private List<String> getAllSelectField(String entityAlias) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("subentryentity");
        List entitylias = entryEntity.stream().filter(entryEntityDy -> HRStringUtils.equals((String)entityAlias, entryEntityDy.getDynamicObject("searchobjentityid") == null ? null : entryEntityDy.getDynamicObject("searchobjentityid").getString("entityalias"))).map(entityFilter -> entityFilter.getString("fieldid")).collect(Collectors.toList());
        ArrayList selectFieldList = Lists.newArrayListWithCapacity((int)16);
        for (String fieldId : entitylias) {
            String[] selectFieldArr = fieldId.split(",");
            List<String> selectedFieldList = Arrays.asList(selectFieldArr);
            selectFieldList.addAll(selectedFieldList);
        }
        return selectFieldList;
    }

    private void showFieldF7Form(TreeNode treeNode, String actionId, String caption) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrss_searchentityf7");
        String nodesJson = SerializationUtils.toJsonString((Object)treeNode);
        showParameter.setCustomParam("treenodes", (Object)nodesJson);
        showParameter.setCustomParam("isFields", (Object)Boolean.TRUE);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(caption);
        this.getView().showForm(showParameter);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String propertyName = evt.getProperty().getName();
        DynamicObject sceneDyn = (DynamicObject)this.getModel().getValue("usescene");
        switch (propertyName) {
            case "usescene": {
                this.updateScene(evt);
                this.getView().getPageCache().put("cache_codeUpdate", "0");
                break;
            }
            case "aiwordnumber": {
                DynamicObject[] searchWeights;
                DynamicObject aiwordDyn = (DynamicObject)this.getModel().getValue("aiwordnumber");
                if (sceneDyn == null || aiwordDyn == null || (searchWeights = SearchQueryHelper.getInstance().getSearchAIWeightDyn(Long.valueOf(sceneDyn.getLong("id")), Long.valueOf(aiwordDyn.getLong("id")))).length <= 0) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u641c\u7d22\u573a\u666f\u4e0b\u9488\u5bf9\u540c\u4e00\u4e2aAI\u8bcd\u6027\u4ec5\u53ef\u914d\u7f6e\u4e00\u5957\u6392\u5e8f\u6743\u91cd\uff0c\u8be5\u573a\u666f\u5df2\u5b58\u5728\u201c%s\u8bcd\u6027\u201d\u6392\u5e8f\u6743\u91cd\uff0c\u65e0\u9700\u91cd\u590d\u914d\u7f6e\u3002", (String)"WeightConfigurePlugin_14", (String)"hrmp-hrss-formplugin", (Object[])new Object[]{aiwordDyn.getString("name")}));
                this.getModel().setValue("aiwordnumber", null);
                break;
            }
            case "fieldnamecopy": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
                String newValue = (String)evt.getChangeSet()[0].getNewValue();
                if (!HRStringUtils.isEmpty((String)newValue)) break;
                this.getModel().setValue("fieldname", (Object)newValue, rowIndex);
                this.getModel().setValue("fieldid", (Object)"", rowIndex);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate.getOperateKey().equals("save")) {
            this.getModel().getValue("entryentity");
        }
    }

    private void showSearchEntityField() {
        DynamicObject useSceneDy = (DynamicObject)this.getModelVal("usescene");
        DynamicObject dynamicObject = SearchQueryHelper.getInstance().querySceneById((Long)useSceneDy.getPkValue());
        DynamicObject searchObj = dynamicObject.getDynamicObject("searchobj");
        if (Objects.isNull(searchObj)) {
            ResManager.loadKDString((String)"\u641c\u7d22\u573a\u666f\u7684\u641c\u7d22\u5bf9\u8c61\u4e3a\u7a7a", (String)"WeightConfigurePlugin_10", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]);
        }
        Long searchObjId = (Long)dynamicObject.getDynamicObject("searchobj").getPkValue();
        this.showSearchFieldF7(searchObjId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        MessageBoxResult result = evt.getResult();
        if ("switchScene".equals(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)result)) {
            this.getView().getPageCache().put("cache_codeUpdate", "1");
            if (this.getView().getPageCache().get("cache_newSceneId") == null) {
                this.getModel().setValue("usescene", null);
            } else {
                this.getModel().setValue("usescene", (Object)Long.valueOf(this.getView().getPageCache().get("cache_newSceneId")));
            }
            this.getModel().deleteEntryData("entryentity");
            this.getPageCache().put("usescenechangeflag", "1");
            this.getView().updateView();
        }
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        super.closedCallBack(callBackEvent);
        String actionId = callBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"hrss_searchentityf7")) {
            Map focusNode = (Map)callBackEvent.getReturnData();
            if (focusNode != null) {
                String pageNumber = (String)focusNode.get("id");
                String name = (String)focusNode.get("text");
                DynamicObject sceneDyn = (DynamicObject)this.getModel().getValue("usescene");
                this.getModel().setValue("sceneid", (Object)sceneDyn.getLong("id"));
                this.getModel().setValue("obj", (Object)name);
                this.getModel().setValue("objnumber", (Object)pageNumber);
            }
        } else if (HRStringUtils.equals((String)actionId, (String)"field")) {
            List checkedNodes = (List)callBackEvent.getReturnData();
            if (checkedNodes != null) {
                StringBuilder fieldKeySB = new StringBuilder();
                StringBuilder fieldSB = new StringBuilder();
                for (Map checkedNode : checkedNodes) {
                    String objnumber;
                    String fieldKey = (String)checkedNode.get("id");
                    if (fieldKey.contains(objnumber = (String)this.getModel().getValue("objnumber"))) {
                        fieldKey = fieldKey.substring(fieldKey.indexOf(46) + 1);
                    }
                    if (HRStringUtils.equals((String)fieldKey, (String)"0")) continue;
                    String fieldName = (String)checkedNode.get("text");
                    fieldKeySB.append(fieldKey).append(",");
                    fieldSB.append(fieldName).append(",");
                }
                this.getModel().setValue("field", (Object)HRStringUtils.substringBeforeLast((String)fieldSB.toString(), (String)","));
                this.getModel().setValue("fieldkey", (Object)HRStringUtils.substringBeforeLast((String)fieldKeySB.toString(), (String)","));
            }
        } else if (HRStringUtils.equals((String)actionId, (String)"aiwordf7")) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)callBackEvent.getReturnData();
            if (null != returnData) {
                this.fillAiWordEntry(returnData);
            }
        } else if (HRStringUtils.equals((String)actionId, (String)"searchentityfield")) {
            this.fillEntryEntity(callBackEvent);
        } else if (HRStringUtils.equals((String)actionId, (String)"fieldid")) {
            this.fillSubEntryEntity(callBackEvent);
        }
    }

    private void fillSubEntryEntity(ClosedCallBackEvent event) {
        List checkedNodes = (List)event.getReturnData();
        if (checkedNodes != null) {
            ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)checkedNodes.size());
            ArrayList fieldNameList = Lists.newArrayListWithExpectedSize((int)checkedNodes.size());
            int rowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
            for (Map checkedNode : checkedNodes) {
                String parentId = (String)checkedNode.get("parentid");
                if (HRStringUtils.isEmpty((String)parentId)) continue;
                String name = (String)checkedNode.get("text");
                fieldNameList.add(name);
                String fieldId = (String)checkedNode.get("id");
                fieldList.add(fieldId);
            }
            this.getModel().setValue("fieldid", (Object)String.join((CharSequence)",", fieldList), rowIndex);
            this.getModel().setValue("fieldnamecopy", (Object)String.join((CharSequence)",", fieldNameList), rowIndex);
            this.getModel().setValue("fieldname", (Object)String.join((CharSequence)",", fieldNameList), rowIndex);
        }
    }

    private void fillEntryEntity(ClosedCallBackEvent event) {
        DynamicObject[] searchFieldByIds;
        IDataModel model = this.getModel();
        ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)event.getReturnData();
        if (CollectionUtils.isEmpty((Collection)selectedRowCollection)) {
            return;
        }
        Object[] primaryKeyValues = selectedRowCollection.getPrimaryKeyValues();
        for (DynamicObject listSelectedRow : searchFieldByIds = SearchObjectService.getInstance().getSearchFieldByIds(primaryKeyValues)) {
            int count = model.getEntryRowCount("subentryentity");
            model.batchCreateNewEntryRow("subentryentity", 1);
            String number = (String)listSelectedRow.get("entitynumber");
            String fieldpath = (String)listSelectedRow.get("fieldpath");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)number);
            String displayName = entityType.getDisplayName().getLocaleValue();
            OrmLocaleValue fieldName = (OrmLocaleValue)listSelectedRow.get("fieldname");
            this.getModel().setValue("obj", (Object)displayName, count);
            this.getModel().setValue("objnumber", (Object)number, count);
            this.getModel().setValue("fieldkey", (Object)fieldpath, count);
            this.getModel().setValue("searchfieldid", listSelectedRow.getPkValue(), count);
            this.getModel().setValue("field", (Object)fieldName.getLocaleValue(), count);
        }
    }

    private void fillAiWordEntry(ListSelectedRowCollection aiWordCategoryIds) {
        if (aiWordCategoryIds.size() > 0) {
            this.getModel().beginInit();
            int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity", aiWordCategoryIds.size());
            for (int index = 0; index < aiWordCategoryIds.size(); ++index) {
                this.getModel().setValue("aiwordcategory", aiWordCategoryIds.get(index).getPrimaryKeyValue(), rowIndex[index]);
                this.getModel().setValue("isdefault", (Object)"0", rowIndex[index]);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
            ((EntryGrid)this.getControl("entryentity")).selectRows(rowIndex[rowIndex.length - 1]);
            CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
            cardEntry.setChildVisible(false, 0, new String[]{"aiwordcategory", "deleteaiword"});
            cardEntry.setChildVisible(true, 0, new String[]{"aiwordcategorytext"});
            for (int index = 1; index < cardEntry.getPageRow(); ++index) {
                cardEntry.setChildVisible(true, index, new String[]{"aiwordcategory", "deleteaiword"});
                cardEntry.setChildVisible(false, index, new String[]{"aiwordcategorytext"});
            }
            this.getPageCache().put("currentIndex", String.valueOf(rowIndex[rowIndex.length - 1]));
        }
    }

    private void updateScene(PropertyChangedArgs evt) {
        if (evt.getChangeSet()[0].getOldValue() != null && this.getView().getPageCache().get("cache_codeUpdate").equals("0")) {
            if (evt.getChangeSet()[0].getNewValue() != null) {
                Long newValue = ((DynamicObject)evt.getChangeSet()[0].getNewValue()).getLong("id");
                this.getView().getPageCache().put("cache_newSceneId", String.valueOf(newValue));
            } else {
                this.getView().getPageCache().put("cache_newSceneId", null);
            }
            Long oldValue = ((DynamicObject)evt.getChangeSet()[0].getOldValue()).getLong("id");
            this.getView().getPageCache().put("cache_oldSceneId", String.valueOf(oldValue));
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("switchScene");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u641c\u7d22\u573a\u666f\u540e\uff0c\u641c\u7d22\u7ed3\u679c\u6392\u5e8f\u6743\u91cd\u914d\u7f6e\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u5b9a\u5207\u6362\u5417\uff1f", (String)"WeightConfigurePlugin_5", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            this.getView().getPageCache().put("cache_codeUpdate", "1");
            this.getModel().setValue("usescene", (Object)oldValue);
        }
    }

    private void showAiWordF7() {
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("hrss_aiwordcategory");
        listShowParameter.setLookUp(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "aiwordf7"));
        listShowParameter.setShowUsed(true);
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("status", "=", (Object)"C"));
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List collect = entryEntity.stream().map(entry -> entry.getDynamicObject("aiwordcategory") == null ? Long.valueOf(0L) : entry.getDynamicObject("aiwordcategory").getPkValue()).collect(Collectors.toList());
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", collect));
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showSearchFieldF7(Long searchObjId) {
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("hrss_schobjqueryfield");
        listShowParameter.setLookUp(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "searchentityfield"));
        listShowParameter.setShowUsed(true);
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("searchobj", "=", (Object)searchObjId));
        DynamicObjectCollection subentry = this.getModel().getEntryEntity("subentryentity");
        List collect = subentry.stream().map(subDy -> {
            DynamicObject dynamicObject = subDy.getDynamicObject("searchfieldid");
            if (dynamicObject != null) {
                return dynamicObject.getPkValue();
            }
            return 1;
        }).collect(Collectors.toList());
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", collect));
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u641c\u7d22\u5b57\u6bb5\u540d\u79f0", (String)"WeightConfigurePlugin_15", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void initAiWordCardEntry() {
        this.getModel().beginInit();
        int rowIndex = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("aiwordcategorytext", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u641c\u7d22\u65b9\u6848", (String)"WeightConfigurePlugin_8", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]), rowIndex);
        this.getModel().setValue("isdefault", (Object)"1", rowIndex);
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        cardEntry.setChildVisible(false, 0, new String[]{"aiwordcategory", "deleteaiword"});
        cardEntry.setChildVisible(true, 0, new String[]{"aiwordcategorytext"});
        this.getModel().setDataChanged(false);
        this.getModel().endInit();
    }
}

