/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.formplugin.web.search.weight;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hrss.business.domain.search.service.SearchQueryHelper;
import org.apache.commons.lang3.tuple.Pair;

public class WeightGradePlugin
extends HRDataBaseEdit {
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"operate_toolbar"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        EntryGrid grid = (EntryGrid)this.getView().getControl("weight_entry");
        int[] selectRows = grid.getSelectRows();
        if (args.getSource() instanceof DeleteEntry) {
            DynamicObjectCollection weightList = this.getModel().getEntryEntity("weight_entry");
            ArrayList weightIdList = Lists.newArrayListWithExpectedSize((int)0);
            for (int selectRow : selectRows) {
                weightIdList.add(((DynamicObject)weightList.get(selectRow)).getLong("id"));
            }
            Pair pair = SearchQueryHelper.getInstance().isWeightQuoted((List)weightIdList);
            if (Objects.nonNull(pair) && ((Boolean)pair.getLeft()).booleanValue()) {
                String errorStr = ResManager.loadKDString((String)"\u6240\u9009\u6743\u91cd\u7b49\u7ea7%s\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"WeightGradePlugin_0", (String)"hrmp-hrss-formplugin", (Object[])new Object[]{pair.getRight()});
                this.getView().showErrorNotification(errorStr);
                args.setCancel(true);
            } else {
                this.getPageCache().put("weightId", Joiner.on((String)",").join((Iterable)weightIdList));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            OperationResult result = args.getOperationResult();
            List errorOrValidateInfoList = result.getAllErrorOrValidateInfo();
            if (CollectionUtils.isEmpty((Collection)errorOrValidateInfoList)) {
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WeightGradePlugin_1", (String)"hrmp-hrss-formplugin", (Object[])new Object[0]));
                this.getView().close();
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrss_searchwgentries");
            DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
            BusinessDataServiceHelper helper = new BusinessDataServiceHelper();
            BusinessDataServiceHelper.removeCache((DynamicObjectType)dynamicObject.getDynamicObjectType());
        }
    }
}

