/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;
import kd.hrmp.hrss.common.model.searchobj.SchObjJoinEntity;

public class ESSynSchemeConfigHelp {
    private HRBaseServiceHelper ES_SYN_HELP = new HRBaseServiceHelper("hrss_essyncscheme");
    private HRBaseServiceHelper GPT_SYN_HELP = new HRBaseServiceHelper("hrss_labelgptsync");
    private HRBaseServiceHelper ES_SYN_RECORD_HELP = new HRBaseServiceHelper("hrss_essynrecord");

    public static ESSynSchemeConfigHelp getInstance() {
        return Instance.INSTANCE;
    }

    public DynamicObject[] getEsSynData() {
        return this.ES_SYN_HELP.loadDynamicObjectArray(new QFilter[0]);
    }

    public DynamicObject[] getGptSynData() {
        return this.GPT_SYN_HELP.loadDynamicObjectArray(new QFilter[0]);
    }

    public DynamicObject getEsConfig() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_esconfig");
        QFilter qFilter = null;
        DynamicObject object = helper.loadDynamicObject(qFilter);
        return object;
    }

    public DynamicObject loadSynSchemeById(Object id) {
        return this.ES_SYN_HELP.loadSingle(id);
    }

    public DynamicObject[] loadESSynRecordBySchemeId(Object schemeId) {
        return this.ES_SYN_RECORD_HELP.loadDynamicObjectArray(new QFilter[]{new QFilter("essyncschemeid", "=", schemeId)});
    }

    public DynamicObject[] loadESSynRecordBySchemeIdOrderByCreateTime(Long schemeId) {
        return this.ES_SYN_RECORD_HELP.query("syntype,essyncschemeid,actualsyntime1,actualfinishtime,synstatus,syncount,plansynctime,modifier", new QFilter[]{new QFilter("essyncschemeid", "=", (Object)schemeId)}, "createtime desc");
    }

    public DynamicObject[] loadAllESSynRecordBySchemeIdOrderByPlanTime() {
        return this.ES_SYN_RECORD_HELP.query("syntype,essyncschemeid,actualsyntime1,actualfinishtime,synstatus,syncount,plansynctime,modifier", new QFilter[0]);
    }

    public DynamicObject[] loadESSynRecordBySchemeIdOrderByActualSynTime(Object schemeId) {
        return this.ES_SYN_RECORD_HELP.query("syntype,essyncschemeid,actualsyntime1,actualfinishtime,synstatus,syncount,plansynctime,modifier", new QFilter[]{new QFilter("essyncschemeid", "=", schemeId)}, "actualfinishtime desc");
    }

    public DynamicObject saveHandsSynRecord(Object synSchemeId) {
        DynamicObject dynamicObject = this.ES_SYN_RECORD_HELP.generateEmptyDynamicObject();
        dynamicObject.set("essyncschemeid", synSchemeId);
        dynamicObject.set("synstatus", (Object)"2");
        dynamicObject.set("syntype", (Object)"2");
        dynamicObject.set("plansynctime", (Object)new Date());
        this.ES_SYN_RECORD_HELP.saveOne(dynamicObject);
        return dynamicObject;
    }

    public DynamicObject[] existRunningSynRecord(Object schemeId) {
        return this.ES_SYN_RECORD_HELP.loadDynamicObjectArray(new QFilter[]{new QFilter("essyncschemeid", "=", schemeId), new QFilter("synstatus", "=", (Object)"2")});
    }

    public void updateSynRecordStatus(Object pkValue, String status) {
        DynamicObject dynamicObject = this.ES_SYN_RECORD_HELP.queryOne(pkValue);
        dynamicObject.set("synstatus", (Object)status);
        this.ES_SYN_RECORD_HELP.updateOne(dynamicObject);
    }

    public boolean getESSynRecordById(Object id) {
        return this.ES_SYN_RECORD_HELP.isExists(id);
    }

    public void generESSynScheme(Long searchObjId) {
        boolean exists = this.ES_SYN_HELP.isExists(new QFilter[]{new QFilter("searchobj", "=", (Object)searchObjId)});
        if (exists) {
            DynamicObject dynamicObject = this.ES_SYN_HELP.queryOne("essynstatus", new QFilter[]{new QFilter("searchobj", "=", (Object)searchObjId)});
            dynamicObject.set("essynstatus", (Object)"1");
            this.ES_SYN_HELP.updateOne(dynamicObject);
            return;
        }
        DynamicObject dynamicObject = this.ES_SYN_HELP.generateEmptyDynamicObject();
        dynamicObject.set("searchobj", (Object)searchObjId);
        dynamicObject.set("essynstatus", (Object)"1");
        this.ES_SYN_HELP.saveOne(dynamicObject);
    }

    public DynamicObject querySynRecordOne(Object id) {
        return this.ES_SYN_RECORD_HELP.queryOne(id);
    }

    public String querySyncStatus(Object id) {
        DynamicObject dynamicObject = this.ES_SYN_RECORD_HELP.queryOne("synstatus", id);
        if (dynamicObject != null) {
            return dynamicObject.getString("synstatus");
        }
        return "";
    }

    public int queryPercent(Long searchObjId, Long recordId) {
        List<SchObjJoinEntity> joinEntities = SearchObjectService.getInstance().queryAndAssembleJoinEntities(searchObjId);
        Optional<SchObjJoinEntity> mainEntityBo = joinEntities.stream().filter(entity -> HRStringUtils.equals((String)entity.getType(), (String)"main")).findFirst();
        if (!mainEntityBo.isPresent()) {
            throw new KDBizException("mainEntity not exist");
        }
        String mainEntityNumber = mainEntityBo.get().getEntityNumber();
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(mainEntityNumber);
        Double count = baseServiceHelper.count(mainEntityNumber, new QFilter[0]);
        DynamicObject dynamicObject = this.ES_SYN_RECORD_HELP.queryOne("syncount", (Object)recordId);
        int syncount = dynamicObject.getInt("syncount");
        Double percent = (double)syncount / count;
        return (int)(percent * 100.0);
    }

    public void updateSchemeStatus(DynamicObject synSchemeDy, String status) {
        String esSynStatus = synSchemeDy.getString("essynstatus");
        if (HRStringUtils.equals((String)"1", (String)esSynStatus)) {
            synSchemeDy.set("essynstatus", (Object)status);
            this.ES_SYN_HELP.updateOne(synSchemeDy);
        }
    }

    public void updateRunningEsSynRecordStatus(Object primaryKeyValue) {
        DynamicObject[] dynamicObjects = ESSynSchemeConfigHelp.getInstance().existRunningSynRecord(primaryKeyValue);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("synstatus", (Object)"4");
        }
        this.ES_SYN_RECORD_HELP.update(dynamicObjects);
    }

    public DynamicObject getSearchObjByScheme(Object schemeId, IFormView view) {
        DynamicObject synScheme = ESSynSchemeConfigHelp.getInstance().loadSynSchemeById(schemeId);
        DynamicObject dynamicObject = synScheme.getDynamicObject("searchobj");
        if (dynamicObject == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"ESSynSchemeConfigHelp_0", (String)"hrmp-hrss-business", (Object[])new Object[0]));
            return null;
        }
        return synScheme.getDynamicObject("searchobj");
    }

    private static class Instance {
        private static ESSynSchemeConfigHelp INSTANCE = new ESSynSchemeConfigHelp();

        private Instance() {
        }
    }
}

