/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.hr.hbp.common.util.HRStringUtils;

public class QueryEntityServiceHelper {
    public static List<Map<String, String>> getQueryEntity(String entityId) {
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        QueryEntity queryEntity = (QueryEntity)metadata.getRootEntity();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        Map<String, String> mainEntityMap = QueryEntityServiceHelper.getMainEntity(queryEntity);
        result.add(mainEntityMap);
        List<Map<String, String>> joinEntityList = QueryEntityServiceHelper.getJoinEntity(queryEntity);
        result.addAll(joinEntityList);
        return result;
    }

    public static Map<String, String> getMainEntity(QueryEntity queryEntity) {
        String entityName = queryEntity.getEntityName();
        String entityAlias = queryEntity.getEntityAlias();
        HashMap mainEntityMap = Maps.newHashMapWithExpectedSize((int)16);
        mainEntityMap.put("entityName", entityName);
        mainEntityMap.put("entityAlias", entityAlias);
        mainEntityMap.put("entityNumber", entityName);
        mainEntityMap.put("isMainEntity", "true");
        return mainEntityMap;
    }

    public static List<Map<String, String>> getJoinEntity(QueryEntity queryEntity) {
        List joinEntities = queryEntity.getJoinEntitys();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)joinEntities.size());
        for (JoinEntity joinEntity : joinEntities) {
            HashMap entityMap = Maps.newHashMapWithExpectedSize((int)16);
            entityMap.put("entityName", joinEntity.getDisplayName());
            entityMap.put("entityAlias", joinEntity.getAlias());
            entityMap.put("entityNumber", joinEntity.getEntityName());
            result.add(entityMap);
        }
        return result;
    }

    public static List<Map<String, String>> getQuerySelectFields(String entityId, String entityAlias) {
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        QueryEntity queryEntity = (QueryEntity)metadata.getRootEntity();
        List selectFields = queryEntity.getSelectFields();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)selectFields.size());
        if (selectFields.size() > 0) {
            List<String> joinEntityAlias = QueryEntityServiceHelper.getJoinEntityAlias(queryEntity);
            boolean isMainEntity = false;
            if (!joinEntityAlias.contains(entityAlias)) {
                isMainEntity = true;
            }
            int size = selectFields.size();
            for (int i = 0; i < size; ++i) {
                QuerySelectField selectField = (QuerySelectField)selectFields.get(i);
                String fieldAlias = selectField.getAlias();
                String fieldEntityAlias = QueryEntityServiceHelper.getEntityAliasByFieldName(fieldAlias);
                if (!QueryEntityServiceHelper.isCurrentEntityFields(isMainEntity, entityAlias, fieldEntityAlias, joinEntityAlias)) continue;
                HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)16);
                String displayName = selectField.getDisplayName();
                fieldMap.put("fieldName", displayName);
                fieldMap.put("fieldAlias", fieldAlias);
                result.add(fieldMap);
            }
        }
        return result;
    }

    public static List<Map<String, String>> getAllQuerySelectFields(String entityId, String entityAlias) {
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        QueryEntity queryEntity = (QueryEntity)metadata.getRootEntity();
        List selectFields = queryEntity.getSelectFields();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)selectFields.size());
        if (selectFields.size() > 0) {
            int size = selectFields.size();
            for (int i = 0; i < size; ++i) {
                QuerySelectField selectField = (QuerySelectField)selectFields.get(i);
                String fieldAlias = selectField.getAlias();
                String fieldEntityAlias = QueryEntityServiceHelper.getEntityAliasByFieldName(fieldAlias);
                HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)16);
                String displayName = selectField.getDisplayName();
                fieldMap.put("fieldName", displayName);
                fieldMap.put("fieldAlias", fieldAlias);
                result.add(fieldMap);
            }
        }
        return result;
    }

    private static boolean isCurrentEntityFields(boolean isMainEntity, String entityAlias, String fieldEntityAlias, List<String> joinEntityAlias) {
        return !isMainEntity && HRStringUtils.equals((String)entityAlias, (String)fieldEntityAlias) || isMainEntity && !joinEntityAlias.contains(fieldEntityAlias);
    }

    private static List<String> getJoinEntityAlias(QueryEntity queryEntity) {
        List joinEntities = queryEntity.getJoinEntitys();
        return joinEntities.stream().map(JoinEntity::getAlias).collect(Collectors.toList());
    }

    private static String getEntityAliasByFieldName(String fieldName) {
        String[] fieldNames = fieldName.split("\\.");
        String entityAlias = null;
        if (fieldNames.length > 1) {
            entityAlias = fieldNames[0];
        }
        return entityAlias;
    }
}

