/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.entity.tree.TreeNode;
import kd.hr.hbp.common.util.HRStringUtils;

public class QueryTreeNodeParseHelper {
    public static TreeNode buildEntityTreeNode(List<Map<String, String>> queryEntityList, String text) {
        TreeNode rootNode = QueryTreeNodeParseHelper.buildParentEntityTreeNode(queryEntityList, text);
        if (rootNode == null) {
            return null;
        }
        List<TreeNode> treeNodes = QueryTreeNodeParseHelper.buildChildEntityTreeNode(queryEntityList, rootNode.getId());
        rootNode.setChildren(treeNodes);
        return rootNode;
    }

    public static TreeNode buildQueryFieldTreeNode(List<Map<String, String>> queryFieldList, String pageNum, String pageName) {
        TreeNode rootNode = new TreeNode("", "0", pageName);
        rootNode.setIsOpened(true);
        List<TreeNode> treeNodes = QueryTreeNodeParseHelper.buildChildFieldsTreeNode(queryFieldList, pageNum, pageName);
        rootNode.setChildren(treeNodes);
        return rootNode;
    }

    private static TreeNode buildParentEntityTreeNode(List<Map<String, String>> queryEntityList, String text) {
        for (Map<String, String> queryEntityMap : queryEntityList) {
            String isMainEntity = queryEntityMap.get("isMainEntity");
            if (!HRStringUtils.isNotEmpty((String)isMainEntity)) continue;
            TreeNode rootNode = new TreeNode("", queryEntityMap.get("entityAlias"), text);
            rootNode.setIsOpened(true);
            return rootNode;
        }
        return null;
    }

    private static List<TreeNode> buildChildEntityTreeNode(List<Map<String, String>> queryEntityList, String parentId) {
        ArrayList treeNodes = Lists.newArrayListWithCapacity((int)queryEntityList.size());
        for (Map<String, String> queryEntityMap : queryEntityList) {
            String isMainEntity = queryEntityMap.get("isMainEntity");
            if (!HRStringUtils.isEmpty((String)isMainEntity)) continue;
            TreeNode node = new TreeNode("", queryEntityMap.get("entityAlias"), queryEntityMap.get("entityName"));
            node.setIsOpened(true);
            node.setParentid(parentId);
            treeNodes.add(node);
        }
        return treeNodes;
    }

    private static List<TreeNode> buildChildFieldsTreeNode(List<Map<String, String>> queryFieldList, String parentId, String pageName) {
        ArrayList treeNodes = Lists.newArrayListWithCapacity((int)queryFieldList.size());
        for (Map<String, String> fieldMap : queryFieldList) {
            String fieldName = fieldMap.get("fieldName");
            TreeNode node = new TreeNode(parentId, fieldMap.get("fieldAlias"), fieldName);
            node.setIsOpened(true);
            treeNodes.add(node);
        }
        return treeNodes;
    }
}

