/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hrss.business.domain.search.service.SearchSceneServiceHelp;
import kd.hrmp.hrss.common.constants.search.SearchRangeModel;
import kd.hrmp.hrss.common.constants.search.SearchSceneModel;
import kd.hrmp.hrss.common.constants.search.SearchSceneVO;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SearchQueryHelper {
    private final HRBaseServiceHelper SEARCHSCENE_HELPER = new HRBaseServiceHelper("hrss_searchscene");
    private final HRBaseServiceHelper SEARCHWEIGHT_HELPER = new HRBaseServiceHelper("hrss_searchweight");
    private final HRBaseServiceHelper SEARCHWTGRADE_HELPER = new HRBaseServiceHelper("hrss_searchwtgrade");

    public static SearchQueryHelper getInstance() {
        return Instance.INSTANCE;
    }

    public DynamicObject getWeightGradeDyn(Long gradeId) {
        return this.SEARCHWTGRADE_HELPER.queryOne((Object)gradeId);
    }

    public Map<DynamicObject, List<DynamicObject>> selectSearchWeight(Long aiWordId) {
        QFilter qFilter = new QFilter("aiwordnumber", "=", (Object)aiWordId);
        Object[] searchWeights = this.SEARCHWEIGHT_HELPER.loadDynamicObjectArray(qFilter.toArray());
        if (ArrayUtils.isEmpty((Object[])searchWeights)) {
            return null;
        }
        return Arrays.stream(searchWeights).collect(Collectors.groupingBy(searchWeight -> searchWeight.getDynamicObject("usescene")));
    }

    public HashMap<DynamicObject, DynamicObject> getSearchWeightByAi(Long aiWordId) {
        QFilter qFilter = new QFilter("entryentity.aiwordcategory.id", "=", (Object)aiWordId);
        DynamicObject[] searchWeights = this.SEARCHWEIGHT_HELPER.loadDynamicObjectArray(qFilter.toArray());
        HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject searchWeight : searchWeights) {
            DynamicObjectCollection dynamicObjectCollection = searchWeight.getDynamicObjectCollection("entryentity");
            DynamicObject useScene = searchWeight.getDynamicObject("usescene");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                DynamicObject aiWordCategory = dynamicObject.getDynamicObject("aiwordcategory");
                if (aiWordCategory == null || !aiWordId.equals(aiWordCategory.getPkValue())) continue;
                objectObjectHashMap.put(useScene, dynamicObject);
            }
        }
        if (CollectionUtils.isEmpty((Map)objectObjectHashMap)) {
            return null;
        }
        return objectObjectHashMap;
    }

    public DynamicObject[] querySceneByAppId(String appId) {
        QFilter appFilter = new QFilter("app.fbasedataid", "=", (Object)appId);
        return this.SEARCHSCENE_HELPER.loadDynamicObjectArray(new QFilter[]{appFilter});
    }

    public List<SearchSceneVO> getScene(String appId) {
        DynamicObject[] sceneDyn = this.querySceneByAppId(appId);
        ArrayList sceneVOs = Lists.newArrayListWithExpectedSize((int)sceneDyn.length);
        for (DynamicObject dynamicObject : sceneDyn) {
            String name = dynamicObject.getString("name");
            long sceneId = dynamicObject.getLong("id");
            SearchSceneVO searchSceneVO = new SearchSceneVO(name, Long.valueOf(sceneId));
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("sceneentryentity");
            for (DynamicObject object : entryentity) {
                String fieldname = object.getString("displayname");
                String fieldkey = object.getString("identity");
                searchSceneVO.addSearchField(fieldkey, fieldname);
            }
            sceneVOs.add(searchSceneVO);
        }
        return sceneVOs;
    }

    public Map<String, String> getSearchConfig(Long sceneId) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject scene = this.querySceneById(sceneId);
        result.put("seaCategory", scene.getString("searchcategory"));
        result.put("seaKeyType", scene.getString("searchkeytype"));
        return result;
    }

    public DynamicObject querySceneById(Long sceneId) {
        return this.SEARCHSCENE_HELPER.loadSingle((Object)sceneId);
    }

    public DynamicObject[] queryAllScene() {
        QFilter appFilter = new QFilter("enable", "=", (Object)"1");
        return this.SEARCHSCENE_HELPER.loadDynamicObjectArray(new QFilter[]{appFilter});
    }

    public DynamicObject[] getSearchDftWeightDyn(Long sceneId) {
        QFilter qFilter = new QFilter("usescene", "=", (Object)sceneId);
        qFilter.and("isdefault", "=", (Object)"1");
        return this.SEARCHWEIGHT_HELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    public DynamicObject[] getSearchAIWeightDyn(Long sceneId, Long aiwordnumber) {
        QFilter qFilter = new QFilter("usescene", "=", (Object)sceneId);
        qFilter.and("aiwordnumber", "=", (Object)aiwordnumber);
        return this.SEARCHWEIGHT_HELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    public String getSceneEntityId(Long sceneId) {
        DynamicObject sceneDyn = this.querySceneById(sceneId);
        return sceneDyn.getString("queryentity.id");
    }

    public String getSceneEntityName(Long sceneId) {
        DynamicObject sceneDyn = this.querySceneById(sceneId);
        return sceneDyn.getString("queryentity.name");
    }

    public Pair<Boolean, String> isWeightQuoted(List<Long> weightIdList) {
        QFilter qFilter = new QFilter("entryentity.subentryentity.grade", "in", weightIdList);
        Object[] searchWeightList = this.SEARCHWEIGHT_HELPER.loadDynamicObjectArray(qFilter.toArray());
        if (ArrayUtils.isEmpty((Object[])searchWeightList)) {
            return Pair.of((Object)Boolean.FALSE, null);
        }
        List entryentity = Arrays.stream(searchWeightList).map(searchWeight -> searchWeight.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).collect(Collectors.toList());
        List searchResultList = entryentity.stream().map(searchWeight -> searchWeight.getDynamicObjectCollection("subentryentity")).flatMap(Collection::stream).distinct().filter(searchResult -> weightIdList.contains(searchResult.getLong("grade.id"))).collect(Collectors.toList());
        String gradeNameStr = searchResultList.stream().map(searchResult -> "\"".concat(searchResult.getString("grade.name").concat("\""))).distinct().collect(Collectors.joining("\u3001"));
        return Pair.of((Object)Boolean.TRUE, (Object)gradeNameStr);
    }

    public List<QFilter> getCloudFilters() {
        Set<String> cloudIdSet = this.getCloudIdSet();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter("id", "in", cloudIdSet));
        return qFilters;
    }

    public Set<String> getCloudIdSet() {
        HRBaseServiceHelper cloudHelper = new HRBaseServiceHelper("hbss_cloud");
        DynamicObject[] clouds = cloudHelper.queryOriginalArray("cloud,index", new QFilter[0]);
        return Arrays.stream(clouds).map(el -> el.getString("cloud")).collect(Collectors.toSet());
    }

    public List<QFilter> getAppFilters() {
        Set<String> cloudIdSet = this.getCloudIdSet();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter("bizcloud", "in", cloudIdSet));
        return qFilters;
    }

    public List<QFilter> getAppFilters(String id) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter("bizcloud", "=", (Object)id));
        return qFilters;
    }

    public SearchSceneModel getSearchSceneById(Long sceneId) {
        QFilter qFilter = new QFilter("id", "=", (Object)sceneId);
        DynamicObject scene = this.SEARCHSCENE_HELPER.loadDynamicObject(qFilter);
        SearchSceneModel sceneModel = new SearchSceneModel(scene.getString("number"), scene.getString("name"), scene.getDynamicObject("cloud"), scene.getDynamicObject("app"), scene.getDynamicObject("queryentity"), scene.getString("searchcategory"), scene.getString("searchkeytype"), scene.getString("description"));
        DynamicObjectCollection collection = scene.getDynamicObjectCollection("sceneentryentity");
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dyn : collection) {
            SearchRangeModel searchRangeModel = SearchSceneServiceHelp.getSearchRangeModel(dyn.getString("searchtype"), (OrmLocaleValue)dyn.get("displayname"), dyn.getString("entityorfield"), dyn.getString("rangenumber"), dyn.getString("searchmode"), (OrmLocaleValue)dyn.get("inputprompt"));
            list.add(searchRangeModel);
        }
        sceneModel.setSearchRangeModelList((List)list);
        return sceneModel;
    }

    public List<QFilter> getQueryFilters(String id) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter("bizappid", "=", (Object)id));
        return qFilters;
    }

    public Long getWeightGradeIdOfScene(Long sceneId) {
        QFilter qFilter = new QFilter("usescene.id", "=", (Object)sceneId);
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject[] searchWtGrade = this.SEARCHWTGRADE_HELPER.loadDynamicObjectArray(qFilter.toArray());
        if (searchWtGrade.length == 0) {
            return null;
        }
        return searchWtGrade[0].getLong("id");
    }

    private static class Instance {
        private static SearchQueryHelper INSTANCE = new SearchQueryHelper();

        private Instance() {
        }
    }
}

