/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.common.LabelFieldUtil;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;
import kd.hrmp.hrss.business.domain.search.service.searchweight.SearchWeightConfHelper;
import kd.hrmp.hrss.common.constants.search.RangeEntityModel;
import kd.hrmp.hrss.common.constants.search.SearchFieldLabelVO;
import kd.hrmp.hrss.common.constants.search.SearchRangeModel;
import kd.hrmp.hrss.common.constants.search.SearchSceneConstants;
import kd.hrmp.hrss.common.enums.SearchModeEnum;
import kd.hrmp.hrss.common.enums.SearchSceneEnum;
import kd.hrmp.hrss.common.model.searchobj.SchObjJoinEntity;
import kd.hrmp.hrss.common.model.searchobj.SchObjQueryField;
import kd.hrmp.hrss.common.searchscene.FieldType;

public class SearchSceneServiceHelp
implements SearchSceneConstants {
    private static final Log LOG = LogFactory.getLog(SearchSceneServiceHelp.class);
    private static HRBaseServiceHelper joinEntityHelper = new HRBaseServiceHelper("hrss_schobjjoinentity");
    private static HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrss_schobjqueryfield");
    private static HRBaseServiceHelper searchSceneHelper = new HRBaseServiceHelper("hrss_searchscene");
    private static HRBaseServiceHelper searchConfigHelper = new HRBaseServiceHelper("hrss_searchconfig");

    public static String getSearchTypeValue(String key) {
        return SearchSceneEnum.getValue((String)key);
    }

    public static String getSearchTypeKey(String value) {
        return SearchSceneEnum.getKey((String)value);
    }

    public static String getSearchModeKey(String value) {
        return SearchModeEnum.getKey((String)value);
    }

    public static String getSearchModeValue(String key) {
        return SearchModeEnum.getValue((String)key);
    }

    public static SearchRangeModel getSearchRangeModel(String rangeType, OrmLocaleValue name, String entityOrField, String rangeNumber, String searchMode, OrmLocaleValue inputPrompt) {
        SearchRangeModel srm = new SearchRangeModel();
        srm.setRangeType(rangeType);
        srm.setName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)name));
        srm.setInputPrompt(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)inputPrompt));
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        String[] entityOrFields = SearchSceneServiceHelp.getSplitString(entityOrField);
        String[] rangeNumbers = SearchSceneServiceHelp.getSplitString(rangeNumber);
        String[] searchModes = SearchSceneServiceHelp.getSplitString(searchMode.substring(1));
        for (int i = 0; i < entityOrFields.length; ++i) {
            RangeEntityModel rem = new RangeEntityModel();
            rem.setSearchMode(searchModes[i]);
            rem.setDisplayName(entityOrFields[i]);
            rem.setRangeNumber(rangeNumbers[i]);
            list.add(rem);
        }
        srm.setRangeEntityList((List)list);
        return srm;
    }

    public static String[] getSplitString(String value) {
        return value.split(",");
    }

    @ExcludeFromJacocoGeneratedReport
    public static String mappingString(String value) {
        String[] splitString = SearchSceneServiceHelp.getSplitString(value);
        StringBuilder sbr = new StringBuilder();
        for (String str : splitString) {
            sbr.append(SearchSceneServiceHelp.getSearchModeKey(str)).append(",");
        }
        return HRStringUtils.substringBeforeLast((String)sbr.toString(), (String)",");
    }

    @ExcludeFromJacocoGeneratedReport
    public static List<Map<String, String>> getFilterResult(List<Map<String, String>> querySelect, DynamicObjectCollection collection, boolean isFields) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        List rangeNumbers = collection.stream().map(dyn -> dyn.getString("rangenumber")).collect(Collectors.toList());
        String key = isFields ? "fieldAlias" : "entityAlias";
        for (Map<String, String> map : querySelect) {
            if (rangeNumbers.contains(map.get(key))) continue;
            result.add(map);
        }
        return result;
    }

    @ExcludeFromJacocoGeneratedReport
    public static String getVerificationText(Object type, Object name, Object inputprompt, DynamicObjectCollection collection) {
        StringBuilder sbr = new StringBuilder(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"SearchSceneServiceHelp_0", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        if (null == type) {
            sbr.append(ResManager.loadKDString((String)"\u201c\u8303\u56f4\u7c7b\u578b\u201d", (String)"SearchSceneServiceHelp_1", (String)"hrmp-hrss-business", (Object[])new Object[0])).append("\u3001");
        }
        if (((OrmLocaleValue)name).size() == 0 || ((OrmLocaleValue)name).getLocaleValue().isEmpty()) {
            sbr.append(ResManager.loadKDString((String)"\u201c\u641c\u7d22\u8303\u56f4\u540d\u79f0\u201d", (String)"SearchSceneServiceHelp_2", (String)"hrmp-hrss-business", (Object[])new Object[0])).append("\u3001");
        }
        if (((OrmLocaleValue)inputprompt).size() == 0 || ((OrmLocaleValue)inputprompt).getLocaleValue().isEmpty()) {
            String errorTip = ResManager.loadKDString((String)"\u201d\u9ed8\u8ba4\u641c\u7d22\u63d0\u793a\u6587\u6848\u201d\u3001", (String)"SearchSceneServiceHelp_9", (String)"hrmp-hrss-business", (Object[])new Object[0]);
            sbr.append(errorTip);
        }
        if (collection.size() == 0) {
            sbr.append(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d", (String)"SearchSceneServiceHelp_3", (String)"hrmp-hrss-business", (Object[])new Object[0])).append("\u3001");
            sbr.append(ResManager.loadKDString((String)"\u201d\u641c\u7d22\u65b9\u5f0f\u201c", (String)"SearchSceneServiceHelp_4", (String)"hrmp-hrss-business", (Object[])new Object[0])).append("\u3001");
        } else {
            for (DynamicObject dyn : collection) {
                if (null != dyn.get("searchmode")) continue;
                sbr.append(ResManager.loadKDString((String)"\u201c\u641c\u7d22\u65b9\u5f0f\u201d", (String)"SearchSceneServiceHelp_5", (String)"hrmp-hrss-business", (Object[])new Object[0])).append("\u3001");
                break;
            }
        }
        return HRStringUtils.substringBeforeLast((String)sbr.toString(), (String)"\u3001");
    }

    public static String getVerificationText(Object name, Object category, Object type) {
        StringBuilder sbr = new StringBuilder(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199", (String)"SearchSceneServiceHelp_6", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        if (((OrmLocaleValue)name).size() == 0 || ((OrmLocaleValue)name).getLocaleValue().isEmpty()) {
            sbr.append(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d", (String)"SearchSceneServiceHelp_3", (String)"hrmp-hrss-business", (Object[])new Object[0])).append("\u3001");
        }
        if (null == category) {
            sbr.append(ResManager.loadKDString((String)"\u201c\u9ed8\u8ba4\u641c\u7d22\u5206\u7c7b\u201d", (String)"SearchSceneServiceHelp_7", (String)"hrmp-hrss-business", (Object[])new Object[0])).append("\u3001");
        }
        if (null == type) {
            sbr.append(ResManager.loadKDString((String)"\u201c\u9ed8\u8ba4\u641c\u7d22\u6761\u4ef6\u95f4\u5173\u7cfb\u201d", (String)"SearchSceneServiceHelp_8", (String)"hrmp-hrss-business", (Object[])new Object[0])).append("\u3001");
        }
        return HRStringUtils.substringBeforeLast((String)sbr.toString(), (String)"\u3001") + "\u3002";
    }

    public static String spliceStringNoMapping(DynamicObjectCollection collection, String key) {
        StringBuilder sbr = new StringBuilder();
        for (DynamicObject dyn : collection) {
            sbr.append(dyn.getString(key)).append(",");
        }
        return HRStringUtils.substringBeforeLast((String)sbr.toString(), (String)",");
    }

    public static boolean checkEntity(DynamicObjectCollection collection) {
        for (DynamicObject dyn : collection) {
            if (null != dyn.get("searchmode")) continue;
            return false;
        }
        return true;
    }

    public static Set<String> getSearchPageNumber(Long searchSceneId) {
        Set<Object> set = Sets.newHashSetWithExpectedSize((int)16);
        DynamicObject searchSceneDy = searchSceneHelper.queryOne("id,name,number,searchpage", (Object)searchSceneId);
        DynamicObjectCollection searchPageColl = searchSceneDy.getDynamicObjectCollection("searchpage");
        if (searchPageColl != null && searchPageColl.size() > 0) {
            Set collect = searchPageColl.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
            DynamicObject[] dynamicObjects = searchConfigHelper.loadDynamicObjectArray(collect.toArray());
            set = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getString("basedatafield.number")).collect(Collectors.toSet());
        }
        return set;
    }

    public static Set<String> getSearchPageNumberList(List<Object> searchSceneIds) {
        DynamicObject[] searchSceneDys;
        Set<Object> set = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject searchSceneDy : searchSceneDys = searchSceneHelper.query("id,name,number,searchpage", new QFilter[]{new QFilter("id", "in", searchSceneIds)})) {
            DynamicObjectCollection searchPageColl = searchSceneDy.getDynamicObjectCollection("searchpage");
            if (searchPageColl == null || searchPageColl.size() <= 0) continue;
            Set collect = searchPageColl.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
            DynamicObject[] dynamicObjects = searchConfigHelper.loadDynamicObjectArray(collect.toArray());
            set = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getString("basedatafield.number")).collect(Collectors.toSet());
        }
        return set;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void removeDynamicFormControl(List<Object> searchSceneIds) {
        Set<String> searchPageNumberSet = SearchSceneServiceHelp.getSearchPageNumberList(searchSceneIds);
        if (searchPageNumberSet.size() == 0) {
            return;
        }
        OperationResult result = (OperationResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDynamicFormControlService", (String)"batchRemove", (Object[])new Object[]{searchPageNumberSet});
        if (result.isSuccess()) {
            LOG.info("searchScene removeDynamicFormControl success,number:{} ", searchPageNumberSet);
        } else {
            LOG.error("searchScene removeDynamicFormControl fail,number:{} ", searchPageNumberSet);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void addDynamicFormControl(Long searchSceneId) {
        OperationResult result;
        Set<String> searchPageNumberSet = SearchSceneServiceHelp.getSearchPageNumber(searchSceneId);
        if (searchPageNumberSet.size() == 0) {
            return;
        }
        DynamicObject searchSceneDy = searchSceneHelper.queryOne("id,name,number,searchpage,sceneentryentity,sceneentryentity.searchfieldtype,sceneentryentity.queryfield", (Object)searchSceneId);
        DynamicObjectCollection sceneEntity = searchSceneDy.getDynamicObjectCollection("sceneentryentity");
        if (sceneEntity == null || sceneEntity.size() == 0) {
            OperationResult result2 = (OperationResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDynamicFormControlService", (String)"batchRemove", (Object[])new Object[]{searchPageNumberSet});
            if (result2.isSuccess()) {
                LOG.info("searchScene batchRemove success,number:{} ", searchPageNumberSet);
            } else {
                LOG.error("searchScene batchRemove fail,", (Object)result2.toString());
            }
            return;
        }
        Map objectMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDynamicFormControlService", (String)"batchGetForMap", (Object[])new Object[]{searchPageNumberSet});
        DynamicObjectCollection newCollection = new DynamicObjectCollection();
        DynamicObjectCollection updateCollection = new DynamicObjectCollection();
        MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();
        for (String searchPageNumber : searchPageNumberSet) {
            SearchSceneServiceHelp.setEntry(sceneEntity, searchPageNumber, objectMap, newCollection, updateCollection, entityTypeUtil);
        }
        if (newCollection.size() > 0) {
            result = (OperationResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDynamicFormControlService", (String)"batchSave", (Object[])new Object[]{newCollection});
            if (result.isSuccess()) {
                LOG.info("searchScene newCollection success,number:{} ", searchPageNumberSet);
            } else {
                LOG.error("searchScene newCollection fail,", (Object)result.toString());
            }
        }
        if (updateCollection.size() > 0) {
            result = (OperationResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDynamicFormControlService", (String)"batchSave", (Object[])new Object[]{updateCollection});
            if (result.isSuccess()) {
                LOG.info("searchScene updateCollection success,number:{} ", searchPageNumberSet);
            } else {
                LOG.error("searchScene updateCollection fail,", (Object)result.toString());
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static void setEntry(DynamicObjectCollection sceneEntry, String searchPageNumber, Map<String, DynamicObject> objectMap, DynamicObjectCollection newCollection, DynamicObjectCollection collection, MainEntityTypeUtil entityTypeUtil) {
        DynamicObject dynFormCtrl = objectMap.get(searchPageNumber);
        if (dynFormCtrl == null) {
            HRBaseServiceHelper hrBaseServiceHelper = HRBaseServiceHelper.create((String)"hrcs_dynaformctrl");
            dynFormCtrl = hrBaseServiceHelper.generateEmptyDynamicObject();
            HRBaseServiceHelper entityObject = new HRBaseServiceHelper("bos_entityobject");
            DynamicObject dynamicObject = entityObject.queryOne("bizappid", (Object)searchPageNumber);
            dynFormCtrl.set("entitytype", (Object)dynamicObject);
            dynFormCtrl.set("app", dynamicObject.get("bizappid.id"));
            newCollection.add((Object)dynFormCtrl);
        } else {
            collection.add((Object)dynFormCtrl);
        }
        if (sceneEntry != null) {
            Map<String, Map<String, String>> fieldMap = SearchSceneServiceHelp.getBaseDataCtrlMap(sceneEntry, entityTypeUtil);
            ArrayList numberList = Lists.newArrayListWithExpectedSize((int)fieldMap.size());
            for (Map map : fieldMap.values()) {
                if (map.get("baseDataNum") == null) continue;
                numberList.add(map.get("baseDataNum"));
            }
            HRBaseServiceHelper entityObject = new HRBaseServiceHelper("bos_entityobject");
            DynamicObject[] dynamicObjectArray = entityObject.query("id", new QFilter[]{new QFilter("id", "in", (Object)numberList)});
            Map<String, DynamicObject> boMap = Arrays.stream(dynamicObjectArray).collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy));
            DynamicObjectCollection entryEntity = dynFormCtrl.getDynamicObjectCollection("entryentity");
            entryEntity.clear();
            DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
            for (Map.Entry<String, Map<String, String>> stringMapEntry : fieldMap.entrySet()) {
                String key = stringMapEntry.getKey();
                Map<String, String> value = stringMapEntry.getValue();
                DynamicObject entryDyna = new DynamicObject(dynamicObjectType);
                entryDyna.set("propkey", (Object)key);
                entryDyna.set("propname", (Object)value.get("name"));
                if (value.get("baseDataNum") != null) {
                    entryDyna.set("bdtype", (Object)boMap.get(value.get("baseDataNum")));
                    String baseDataNum = value.get("baseDataNum");
                    if (HRStringUtils.equals((String)baseDataNum, (String)"bos_org")) {
                        entryDyna.set("bucafunc", (Object)value.get("bucafunc"));
                    }
                }
                entryDyna.set("issyspreset", (Object)"0");
                entryEntity.add((Object)entryDyna);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static Map<String, Map<String, String>> getBaseDataCtrlMap(DynamicObjectCollection sceneEntry, MainEntityTypeUtil entityTypeUtil) {
        DynamicObject[] dynamicObjects;
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)sceneEntry.size());
        ArrayList ctrlList = Lists.newArrayListWithExpectedSize((int)sceneEntry.size());
        List queryFieldIds = sceneEntry.stream().map(dy -> dy.getLong("queryfield.id")).collect(Collectors.toList());
        DynamicObject[] queryFieldArray = queryFieldHelper.loadDynamicObjectArray(queryFieldIds.toArray());
        HashMap queryFields = Maps.newHashMapWithExpectedSize((int)queryFieldArray.length);
        for (DynamicObject queryFieldDy : queryFieldArray) {
            SchObjQueryField queryField = new SchObjQueryField();
            queryField.setFieldAlias(queryFieldDy.getString("fieldalias"));
            queryField.setComplexType(queryFieldDy.getString("complextype"));
            queryField.setValueType(queryFieldDy.getString("valuetype"));
            queryField.setControlType(queryFieldDy.getString("controltype"));
            queryFields.put(queryFieldDy.getLong("id"), queryField);
        }
        for (DynamicObject dynamicObject : sceneEntry) {
            long queryFieldId = dynamicObject.getLong("queryfield.id");
            SchObjQueryField schObjQueryField = (SchObjQueryField)queryFields.get(queryFieldId);
            if (schObjQueryField == null) continue;
            String complexType = schObjQueryField.getComplexType();
            String controlType = schObjQueryField.getControlType();
            String searchFieldType = "";
            if (HRStringUtils.equals((String)controlType, (String)FieldControlType.COMBO.getValue()) || HRStringUtils.equals((String)controlType, (String)FieldControlType.MUL_COMBO.getValue())) {
                searchFieldType = FieldType.ENUM.getValue();
            }
            if (AnalyseObjectUtil.isBaseDataType((String)complexType) && SearchSceneServiceHelp.isBaseDataEnd(schObjQueryField.getFieldAlias())) {
                searchFieldType = FieldType.BASE_DATA.getValue();
            }
            if (!HRStringUtils.equals((String)searchFieldType, (String)FieldType.BASE_DATA.getValue()) && !HRStringUtils.equals((String)searchFieldType, (String)FieldType.ENUM.getValue())) continue;
            ctrlList.add(dynamicObject);
        }
        List searchFieldIdList = ctrlList.stream().map(dy -> dy.getLong("queryfield.id")).collect(Collectors.toList());
        for (DynamicObject dynamicObject : dynamicObjects = queryFieldHelper.loadDynamicObjectArray(searchFieldIdList.toArray())) {
            String name = dynamicObject.getString("fieldname");
            String fieldAlias = dynamicObject.getString("fieldalias");
            String complexType = dynamicObject.getString("complextype");
            String entityNumber = dynamicObject.getString("entitynumber");
            String fieldPath = dynamicObject.getString("fieldpath");
            String orgFunc = "";
            if (AnalyseObjectUtil.isBaseDataType((String)complexType) && SearchSceneServiceHelp.isBaseDataEnd(fieldAlias)) {
                Map baseDataNumAndPkType = AnalyseObjectUtil.parseFieldAliasGetBaseDataNumAndPkType((String)entityNumber, (String)fieldAlias, (MainEntityTypeUtil)entityTypeUtil);
                String baseDataNum = (String)baseDataNumAndPkType.get("baseDataNum");
                fieldAlias = fieldAlias.substring(0, fieldAlias.lastIndexOf("."));
                String number = fieldPath = fieldPath.substring(0, fieldPath.lastIndexOf("."));
                if (fieldPath.contains(entityNumber + ".")) {
                    number = fieldPath.replaceAll(entityNumber + ".", "");
                }
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                IDataEntityProperty property = null;
                if (number.contains(".")) {
                    String[] split = number.split("\\.");
                    IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)mainEntityType.getProperties().get((Object)split[0]);
                    MainEntityType mainEntityTypeSub = MetadataServiceHelper.getDataEntityType((String)((BasedataProp)iDataEntityProperty).getBaseEntityId());
                    property = mainEntityTypeSub.findProperty(split[1]);
                } else {
                    property = mainEntityType.findProperty(number);
                }
                if (property instanceof OrgProp) {
                    OrgProp orgProp = (OrgProp)property;
                    orgFunc = orgProp.getOrgFunc();
                }
                fieldMap.put(fieldAlias, SearchSceneServiceHelp.genMap(fieldAlias, name, baseDataNum, orgFunc));
                continue;
            }
            fieldMap.put(fieldAlias, SearchSceneServiceHelp.genMap(fieldAlias, name));
        }
        return fieldMap;
    }

    private static boolean isBaseDataEnd(String number) {
        return number.endsWith("name") || number.endsWith("number") || number.endsWith("id");
    }

    private static Map<String, String> genMap(String number, String name, String baseDataNum, String data) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("number", number);
        map.put("name", name);
        map.put("baseDataNum", baseDataNum);
        map.put("bucafunc", data);
        return map;
    }

    private static Map<String, String> genMap(String number, String name) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("number", number);
        map.put("name", name);
        return map;
    }

    public static DynamicObject[] getAllSearchScene() {
        return searchSceneHelper.loadDynamicObjectArray(new QFilter[0]);
    }

    public static DynamicObject getSearchSceneById(Object pkvalue) {
        return searchSceneHelper.queryOne(pkvalue);
    }

    @ExcludeFromJacocoGeneratedReport
    public static ArrayList<SchObjQueryField> orderSchObjQueryFields(List<SchObjQueryField> schObjQueryFields, DynamicObject searchSceneById) {
        DynamicObjectCollection dynamicObjectCollection = searchSceneById.getDynamicObjectCollection("sceneentryentity");
        ArrayList result = Lists.newArrayListWithCapacity((int)16);
        block0: for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String fieldSource = dynamicObject.getString("fieldsource");
            Long pkvalue = null;
            if (HRStringUtils.equals((String)"1", (String)fieldSource)) {
                DynamicObject queryField = (DynamicObject)dynamicObject.get("queryfield");
                if (queryField == null) continue;
                pkvalue = (Long)queryField.getPkValue();
            } else {
                DynamicObject label = (DynamicObject)dynamicObject.get("label");
                if (label == null) continue;
                pkvalue = (Long)label.getPkValue();
            }
            for (SchObjQueryField schObjQueryField2 : schObjQueryFields) {
                String queryFieldId = schObjQueryField2.getId();
                if (!"1".equals(fieldSource) || !pkvalue.toString().equals(queryFieldId)) continue;
                result.add(schObjQueryField2);
                continue block0;
            }
        }
        List collect = result.stream().map(schObjQueryField -> schObjQueryField.getId()).collect(Collectors.toList());
        List addSchObjQueryField = schObjQueryFields.stream().filter(schObjQueryField -> !collect.contains(schObjQueryField.getId())).collect(Collectors.toList());
        result.addAll(addSchObjQueryField);
        return result;
    }

    public static void addFieldEntry(IFormView view, String nodeId, String parentId) {
        String entityCach = view.getPageCache().get("searchEntityCach");
        List schObjJoinEntities = SerializationUtils.fromJsonStringToList((String)entityCach, SchObjJoinEntity.class);
        String fieldCach = view.getPageCache().get("searchFieldCach");
        List schObjQueryFields = SerializationUtils.fromJsonStringToList((String)fieldCach, SchObjQueryField.class);
        String labelCach = view.getPageCache().get("searchFieldLabelCach");
        List labelCachs = SerializationUtils.fromJsonStringToList((String)labelCach, SearchFieldLabelVO.class);
        String[] split = nodeId.split("_");
        if (parentId.contains("entity_")) {
            parentId = parentId.split("_")[1];
        }
        if (nodeId.startsWith("entity_")) {
            String entityId = split[1];
            String entityNumber = "";
            String entityType = "";
            for (SchObjJoinEntity schObjJoinEntity : schObjJoinEntities) {
                String id = schObjJoinEntity.getId();
                if (!entityId.equals(id)) continue;
                entityNumber = schObjJoinEntity.getEntityAlias();
                entityType = schObjJoinEntity.getType();
                break;
            }
            view.getModel().beginInit();
            for (SchObjQueryField schObjQueryField : schObjQueryFields) {
                String entityAlias = "";
                if ("main".equals(entityType)) {
                    entityAlias = schObjQueryField.getEntityNumber();
                } else {
                    String fieldAlias = schObjQueryField.getFieldAlias();
                    if (fieldAlias.contains(".")) {
                        entityAlias = fieldAlias.substring(0, fieldAlias.indexOf("."));
                    }
                }
                if (!entityNumber.equals(entityAlias)) continue;
                LocaleString fieldName = schObjQueryField.getFieldName();
                String id = schObjQueryField.getId();
                if (SearchSceneServiceHelp.alerdyExist(id, view)) continue;
                String fieldAlias = schObjQueryField.getFieldAlias();
                String complexType = schObjQueryField.getComplexType();
                String controlType = schObjQueryField.getControlType();
                String valueType = schObjQueryField.getValueType();
                String baseDataNum = schObjQueryField.getBaseDataNum();
                int count = view.getModel().createNewEntryRow("sceneentryentity");
                view.getModel().setValue("fieldnumber", (Object)fieldAlias, count);
                view.getModel().setValue("fieldtext", (Object)fieldName, count);
                view.getModel().setValue("queryfield", (Object)schObjQueryField.getId(), count);
                view.getModel().setValue("fieldsource", (Object)"1", count);
                view.getModel().setValue("searchobjentityid", (Object)Long.valueOf(entityId), count);
                SearchSceneServiceHelp.setFieldType(view, count, fieldAlias, complexType, controlType, valueType, "searchfieldtype", baseDataNum);
            }
            for (SearchFieldLabelVO labelVO : labelCachs) {
                String labelEntityNumber = labelVO.getEntityNumber();
                if (!entityNumber.equals(labelEntityNumber) || SearchSceneServiceHelp.alerdyExistLabel(labelVO.getId().toString(), view)) continue;
                int count = view.getModel().createNewEntryRow("sceneentryentity");
                view.getModel().setValue("fieldnumber", (Object)labelVO.getNumber(), count);
                view.getModel().setValue("fieldtext", (Object)labelVO.getName(), count);
                view.getModel().setValue("label", (Object)labelVO.getId(), count);
                view.getModel().setValue("fieldsource", (Object)"2", count);
                view.getModel().setValue("searchfieldtype", (Object)"label", count);
                view.getModel().setValue("searchobjentityid", (Object)Long.valueOf(entityId), count);
            }
            view.getModel().endInit();
        } else if (nodeId.contains("field")) {
            String fieldId = split[1];
            view.getModel().beginInit();
            for (SchObjQueryField schObjQueryField : schObjQueryFields) {
                String fieldEntityNumber = schObjQueryField.getEntityNumber();
                String id = schObjQueryField.getId();
                if (SearchSceneServiceHelp.alerdyExist(id, view) || !fieldId.equals(id)) continue;
                LocaleString fieldName = schObjQueryField.getFieldName();
                String fieldAlias = schObjQueryField.getFieldAlias();
                String complexType = schObjQueryField.getComplexType();
                String controlType = schObjQueryField.getControlType();
                String valueType = schObjQueryField.getValueType();
                String baseDataNum = schObjQueryField.getBaseDataNum();
                int count = view.getModel().createNewEntryRow("sceneentryentity");
                view.getModel().setValue("fieldnumber", (Object)fieldAlias, count);
                view.getModel().setValue("fieldtext", (Object)fieldName, count);
                view.getModel().setValue("queryfield", (Object)schObjQueryField.getId(), count);
                view.getModel().setValue("fieldsource", (Object)"1", count);
                view.getModel().setValue("searchobjentityid", (Object)Long.valueOf(parentId), count);
                SearchSceneServiceHelp.setFieldType(view, count, fieldAlias, complexType, controlType, valueType, "searchfieldtype", baseDataNum);
            }
            view.getModel().endInit();
        } else if (nodeId.contains("label")) {
            String fieldId = split[1];
            view.getModel().beginInit();
            for (SearchFieldLabelVO schLabelVo : labelCachs) {
                Long id = schLabelVo.getId();
                if (SearchSceneServiceHelp.alerdyExistLabel(id.toString(), view) || !fieldId.equals(id.toString())) continue;
                int count = view.getModel().createNewEntryRow("sceneentryentity");
                view.getModel().setValue("fieldnumber", (Object)schLabelVo.getNumber(), count);
                view.getModel().setValue("fieldtext", (Object)schLabelVo.getName(), count);
                view.getModel().setValue("label", (Object)schLabelVo.getId(), count);
                view.getModel().setValue("fieldsource", (Object)2, count);
                view.getModel().setValue("searchfieldtype", (Object)"label", count);
                view.getModel().setValue("searchobjentityid", (Object)Long.valueOf(parentId), count);
            }
            view.getModel().endInit();
        }
        view.updateView("sceneentryentity");
    }

    private static boolean alerdyExist(String id, IFormView view) {
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("sceneentryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            Long fieldId;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            String source = dynamicObject.getString("fieldsource");
            DynamicObject queryFieldDy = dynamicObject.getDynamicObject("queryfield");
            if (queryFieldDy == null || !id.equals((fieldId = (Long)dynamicObject.getDynamicObject("queryfield").getPkValue()).toString()) || !"1".equals(source)) continue;
            return true;
        }
        return false;
    }

    @ExcludeFromJacocoGeneratedReport
    private static boolean alerdyExistLabel(String id, IFormView view) {
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("sceneentryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            Long fieldId;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            String source = dynamicObject.getString("fieldsource");
            DynamicObject queryFieldDy = dynamicObject.getDynamicObject("label");
            if (queryFieldDy == null || !id.equals((fieldId = (Long)dynamicObject.getDynamicObject("label").getPkValue()).toString()) || !"2".equals(source)) continue;
            return true;
        }
        return false;
    }

    public static void setFieldType(IFormView view, int index, String fieldAlias, String complexType, String controlType, String valueType, String field, String baseDataNum) {
        if (HRStringUtils.equals((String)controlType, (String)FieldControlType.COMBO.getValue()) || HRStringUtils.equals((String)controlType, (String)FieldControlType.MUL_COMBO.getValue())) {
            view.getModel().setValue(field, (Object)FieldType.ENUM.getValue(), index);
            return;
        }
        if (HRStringUtils.equals((String)controlType, (String)FieldControlType.AMOUNT.getValue())) {
            view.getModel().setValue(field, (Object)FieldType.MONEY.getValue(), index);
            return;
        }
        if (AnalyseObjectUtil.isBaseDataType((String)complexType) && SearchSceneServiceHelp.isBaseDataEnd(fieldAlias)) {
            view.getModel().setValue(field, (Object)FieldType.BASE_DATA.getValue(), index);
            view.getModel().setValue("entitytype", (Object)baseDataNum, index);
        } else if (HRStringUtils.equals((String)valueType, (String)"integer") || HRStringUtils.equals((String)valueType, (String)"long") || HRStringUtils.equals((String)valueType, (String)"bigdecimal")) {
            view.getModel().setValue(field, (Object)FieldType.NUMBER.getValue(), index);
        } else if (HRStringUtils.equals((String)valueType, (String)"boolean")) {
            view.getModel().setValue(field, (Object)FieldType.BOOLEAN.getValue(), index);
        } else {
            view.getModel().setValue(field, (Object)valueType, index);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void deleteFieldEntry(IFormView view, String nodeId) {
        String entityCach = view.getPageCache().get("searchEntityCach");
        List schObjJoinEntities = SerializationUtils.fromJsonStringToList((String)entityCach, SchObjJoinEntity.class);
        String fieldCach = view.getPageCache().get("searchFieldCach");
        List schObjQueryFields = SerializationUtils.fromJsonStringToList((String)fieldCach, SchObjQueryField.class);
        String labelCach = view.getPageCache().get("searchFieldLabelCach");
        List labelCachs = SerializationUtils.fromJsonStringToList((String)labelCach, SearchFieldLabelVO.class);
        String[] split = nodeId.split("_");
        HashSet rowIndexList = Sets.newHashSetWithExpectedSize((int)16);
        if (nodeId.contains("entity")) {
            String entityNubmer = "";
            for (SchObjJoinEntity schObjJoinEntity : schObjJoinEntities) {
                String id = schObjJoinEntity.getId();
                if (!id.equals(split[1])) continue;
                entityNubmer = schObjJoinEntity.getEntityAlias();
            }
            DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("sceneentryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                String source = dynamicObject.getString("fieldsource");
                if (HRStringUtils.equals((String)"1", (String)source)) {
                    String number;
                    DynamicObject queryFieldDy = dynamicObject.getDynamicObject("queryfield");
                    if (queryFieldDy == null || !entityNubmer.equals(number = dynamicObject.getDynamicObject("searchobjentityid").getString("entityAlias"))) continue;
                    rowIndexList.add(i);
                    continue;
                }
                DynamicObject labelDy = dynamicObject.getDynamicObject("label");
                if (labelDy == null) continue;
                for (SearchFieldLabelVO labelVO : labelCachs) {
                    String labelEntityNumber = labelVO.getEntityNumber();
                    Long id = labelVO.getId();
                    if (!id.toString().equals(labelDy.getPkValue().toString()) || !labelEntityNumber.equals(entityNubmer)) continue;
                    rowIndexList.add(i);
                }
            }
        } else if (nodeId.contains("field")) {
            DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("sceneentryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                Long fieldId;
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                String source = dynamicObject.getString("fieldsource");
                DynamicObject queryFieldDy = dynamicObject.getDynamicObject("queryfield");
                if (queryFieldDy == null || !split[1].equals((fieldId = (Long)dynamicObject.getDynamicObject("queryfield").getPkValue()).toString()) || !"1".equals(source)) continue;
                rowIndexList.add(i);
            }
        } else if (nodeId.contains("label")) {
            DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("sceneentryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                Long fieldId;
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                String source = dynamicObject.getString("fieldsource");
                DynamicObject queryFieldDy = dynamicObject.getDynamicObject("label");
                if (queryFieldDy == null || !split[1].equals((fieldId = (Long)dynamicObject.getDynamicObject("label").getPkValue()).toString()) || !"2".equals(source)) continue;
                rowIndexList.add(i);
            }
        }
        SearchSceneServiceHelp.deleteEntryRows(view, new ArrayList<Integer>(rowIndexList));
    }

    @ExcludeFromJacocoGeneratedReport
    public static void deleteEntryRows(IFormView view, ArrayList<Integer> rowIndexList) {
        if (!CollectionUtils.isEmpty(rowIndexList)) {
            int[] indexArr = new int[rowIndexList.size()];
            for (int i = 0; i < rowIndexList.size(); ++i) {
                indexArr[i] = rowIndexList.get(i);
            }
            view.getModel().deleteEntryRows("sceneentryentity", indexArr);
        }
    }

    private static String getBaseDataNum(String id, List<SchObjQueryField> schObjQueryFields) {
        for (SchObjQueryField schObjQueryField : schObjQueryFields) {
            String objQueryFieldId = schObjQueryField.getId();
            if (!id.equals(objQueryFieldId)) continue;
            return schObjQueryField.getEntityNumber();
        }
        return null;
    }

    public static HashSet<String> queryUsedField(Long searchObjectId) {
        DynamicObject[] searchScene = searchSceneHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("searchobj", "=", (Object)searchObjectId)});
        HashSet usedFields = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList objects = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dynamicObject : searchScene) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sceneentryentity");
            dynamicObjectCollection.stream().forEach(searchField -> {
                String fieldSource = (String)searchField.get("fieldsource");
                if (HRStringUtils.equals((String)"1", (String)fieldSource)) {
                    DynamicObject queryField = searchField.getDynamicObject("queryfield");
                    if (queryField == null) {
                        return;
                    }
                    objects.add(queryField.getPkValue());
                }
            });
            DynamicObjectCollection searchCollection = dynamicObject.getDynamicObjectCollection("searchentryentity");
            for (int i = 0; i < searchCollection.size(); ++i) {
                String searchInfoType = ((DynamicObject)searchCollection.get(i)).getString("searchinfotype");
                String rangeNumber = ((DynamicObject)searchCollection.get(i)).getString("rangenumber");
                String[] split = rangeNumber.split(",");
                if (!HRStringUtils.equals((String)searchInfoType, (String)SearchSceneEnum.FIELDS.getValue()) && split.length <= 0) continue;
                usedFields.addAll(Arrays.asList(split));
            }
            DynamicObjectCollection filterCollection = dynamicObject.getDynamicObjectCollection("filterentryentity");
            for (DynamicObject dyn : filterCollection) {
                String fieldType = dyn.getString("fieldtype");
                if (HRStringUtils.equals((String)"label", (String)fieldType)) continue;
                DynamicObject queryField = dyn.getDynamicObject("searchobjfield");
                objects.add(queryField.getPkValue());
            }
        }
        DynamicObject[] ids = queryFieldHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)objects)});
        Arrays.stream(ids).forEach(searchField -> usedFields.add(searchField.getString("fieldAlias")));
        return usedFields;
    }

    public static HashSet<String> queryUsedEntity(Long searchObjectId) {
        DynamicObject[] searchScene = searchSceneHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("searchobj", "=", (Object)searchObjectId)});
        HashSet usedEntity = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : searchScene) {
            DynamicObjectCollection searchCollection = dynamicObject.getDynamicObjectCollection("searchentryentity");
            for (int i = 0; i < searchCollection.size(); ++i) {
                String searchInfoType = ((DynamicObject)searchCollection.get(i)).getString("searchinfotype");
                String rangeNumber = ((DynamicObject)searchCollection.get(i)).getString("rangenumber");
                String[] split = rangeNumber.split(",");
                if (!HRStringUtils.equals((String)searchInfoType, (String)SearchSceneEnum.ENTITY.getValue()) && split.length <= 0) continue;
                usedEntity.addAll(Arrays.asList(split));
            }
        }
        return usedEntity;
    }

    public static HashSet<String> usedLabelEntity(Long searchObjectId) {
        HashSet usedLabelEntity = Sets.newHashSetWithExpectedSize((int)16);
        DynamicObject[] searchScene = searchSceneHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("searchobj", "=", (Object)searchObjectId)});
        List<SchObjJoinEntity> joinEntities = SearchObjectService.getInstance().queryAndAssembleJoinEntities(searchObjectId);
        Optional<SchObjJoinEntity> mainEntityBo = joinEntities.stream().filter(entity -> HRStringUtils.equals((String)entity.getType(), (String)"main")).findFirst();
        if (!mainEntityBo.isPresent()) {
            return usedLabelEntity;
        }
        String mainEntityNumber = mainEntityBo.get().getEntityNumber();
        block0: for (DynamicObject dynamicObject : searchScene) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sceneentryentity");
            dynamicObjectCollection.stream().forEach(searchField -> {
                String fieldSource = (String)searchField.get("fieldsource");
                if (!HRStringUtils.equals((String)"1", (String)fieldSource)) {
                    DynamicObject searchEntity = searchField.getDynamicObject("searchobjentityid");
                    if (searchEntity == null) {
                        return;
                    }
                    String entityNumber = searchEntity.getString("entitynumber");
                    usedLabelEntity.add(entityNumber);
                }
            });
            DynamicObjectCollection searchRangeEntry = dynamicObject.getDynamicObjectCollection("searchentryentity");
            for (DynamicObject searchRange : searchRangeEntry) {
                String rangeNumber = searchRange.getString("rangenumber");
                String[] split = rangeNumber.split(",");
                if (split == null || split.length <= 0) continue;
                for (String field : split) {
                    if (!LabelFieldUtil.isLabelField(field)) continue;
                    if (field.startsWith("label_")) {
                        usedLabelEntity.add(mainEntityNumber);
                        continue;
                    }
                    String entityNumber = field.substring(0, field.indexOf("."));
                    usedLabelEntity.add(entityNumber);
                }
            }
            DynamicObjectCollection filterEntry = dynamicObject.getDynamicObjectCollection("filterentryentity");
            for (DynamicObject filterDy : filterEntry) {
                String fieldType = filterDy.getString("fieldtype");
                if (!HRStringUtils.equals((String)"label", (String)fieldType)) continue;
                String labelType = filterDy.getString("labeltype");
                if (HRStringUtils.equals((String)"1", (String)labelType)) {
                    for (SchObjJoinEntity joinEntity : joinEntities) {
                        if (!joinEntity.isSearchTarget()) continue;
                        usedLabelEntity.add(joinEntity.getEntityNumber());
                    }
                    continue block0;
                }
                String labelEntity = filterDy.getString("labelentity");
                usedLabelEntity.add(labelEntity);
            }
        }
        SearchWeightConfHelper.getInstance().getSearchWeightLabelEntity(usedLabelEntity, searchObjectId);
        LOG.info("usedLabelEntity={}", (Object)usedLabelEntity);
        return usedLabelEntity;
    }

    public static ArrayList<Map<String, Object>> distinctLabelResult(Map<String, Object> gptLabelResult) {
        ArrayList resultList = (ArrayList)gptLabelResult.get("resultList");
        ArrayList distinctLabels = Lists.newArrayListWithCapacity((int)16);
        for (Map stringObjectMap : resultList) {
            Object labels = stringObjectMap.get("labels");
            if (labels == null) continue;
            ArrayList labelList = (ArrayList)labels;
            distinctLabels.addAll(labelList);
        }
        distinctLabels = distinctLabels.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Map>(Comparator.comparing(labelMap -> (Long)labelMap.get("labelId")))), ArrayList::new));
        return distinctLabels;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean judgeEntityAlias(String fieldAlias, String entityAlias, String entityNumber, String fieldEntityNumber) {
        if (fieldAlias.contains("\u03b4")) {
            if (!entityAlias.contains("\u03b4")) return false;
            if (fieldAlias.contains(entityAlias)) return true;
            return false;
        }
        if (entityAlias.contains("\u03b4")) {
            return false;
        }
        if (fieldEntityNumber.equals(entityNumber)) return true;
        return false;
    }
}

