/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.smartsearch.HRSmartSearchService;
import kd.hr.hbp.business.service.smartsearch.SearchSceneService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.enums.smartsearch.SearchCategoryEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchKeyLogicEnum;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.smartsearch.scene.SearchCustomFilterBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFieldBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFilterBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchRangeBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchSceneBo;
import kd.hr.hbp.common.model.smartsearch.search.SearchParam;
import kd.hr.hbp.common.model.smartsearch.search.SmartSearchResp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.SearchSceneServiceHelp;
import kd.hrmp.hrss.business.domain.search.service.ai.SmartSearchGptService;
import kd.hrmp.hrss.business.domain.search.service.common.GptFilterUtil;
import kd.hrmp.hrss.business.domain.search.service.common.LabelFieldUtil;
import kd.hrmp.hrss.business.domain.search.service.common.SearchResultUtil;
import kd.hrmp.hrss.business.domain.search.service.common.SystemParamUtil;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;
import kd.hrmp.hrss.business.domain.search.service.searchscene.SearchSceneBusQueryService;
import kd.hrmp.hrss.business.domain.search.service.searchweight.SearchWeightConfHelper;
import kd.hrmp.hrss.common.constants.search.FilterConditionVo;
import kd.hrmp.hrss.common.constants.search.FilterOptionVo;
import kd.hrmp.hrss.common.constants.search.GptAiWordVo;
import kd.hrmp.hrss.common.constants.search.SearchEntityVo;
import kd.hrmp.hrss.common.constants.search.SearchFieldVo;
import kd.hrmp.hrss.common.constants.search.SearchLinkVo;
import kd.hrmp.hrss.common.constants.search.SearchRangeVo;
import kd.hrmp.hrss.common.constants.search.SearchResultTableHead;
import kd.hrmp.hrss.common.constants.search.SearchResultVO;
import kd.hrmp.hrss.common.constants.search.SearchSceneTestVo;
import kd.hrmp.hrss.common.model.searchobj.SchObjJoinEntity;
import org.apache.commons.collections.MapUtils;

public class SearchSceneTestHelp {
    private static final Log LOGGER = LogFactory.getLog(SearchSceneTestHelp.class);

    public static SearchSceneTestHelp getInstance() {
        return Instance.INSTANCE;
    }

    public void getInitData(IFormView view) {
        DynamicObject[] allSearchScene = SearchSceneServiceHelp.getAllSearchScene();
        if (allSearchScene == null || allSearchScene.length == 0) {
            return;
        }
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList objects = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dynamicObject : allSearchScene) {
            HashMap sceneHashMap = Maps.newHashMapWithExpectedSize((int)16);
            sceneHashMap.put("sceneId", dynamicObject.getPkValue().toString());
            sceneHashMap.put("displayName", dynamicObject.getLocaleString("name").toString());
            sceneHashMap.put("defaultQuestion", dynamicObject.getLocaleString("copywriting").toString());
            objects.add(sceneHashMap);
        }
        Long sceneId = (Long)allSearchScene[0].getPkValue();
        view.getPageCache().put("sceneId", sceneId.toString());
        SearchSceneTestVo searchSceneTestVo = this.getSearchSceneTestVo(view, sceneId);
        data.put("searchScenes", objects);
        data.put("defaultSearchScene", searchSceneTestVo);
        data.put("method", "init");
        data.put("random", System.currentTimeMillis());
        CustomControl fieldTreeControl = (CustomControl)view.getControl("customsearch");
        fieldTreeControl.setData((Object)SerializationUtils.toJsonString((Object)data));
    }

    public void changeSearchScene(IFormView view, Long sceneId) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        SearchSceneTestVo searchSceneTestVo = this.getSearchSceneTestVo(view, sceneId);
        data.put("defaultSearchScene", searchSceneTestVo);
        data.put("method", "changeScene");
        data.put("random", System.currentTimeMillis());
        CustomControl fieldTreeControl = (CustomControl)view.getControl("customsearch");
        fieldTreeControl.setData((Object)SerializationUtils.toJsonString((Object)data));
    }

    private SearchSceneTestVo getSearchSceneTestVo(IFormView view, Long sceneId) {
        HrApiResponse searchSceneBoHrApiResponse = SearchSceneService.querySearchScene((Long)sceneId);
        if (!searchSceneBoHrApiResponse.isSuccess()) {
            throw new KDBizException(searchSceneBoHrApiResponse.getErrorMessage());
        }
        SearchSceneBo searchSceneBo = (SearchSceneBo)searchSceneBoHrApiResponse.getData();
        view.getPageCache().put("searchSceneBo", SerializationUtils.toJsonString((Object)searchSceneBo));
        SearchSceneTestVo searchSceneTestVo = new SearchSceneTestVo();
        searchSceneTestVo.setDisplayname(searchSceneBo.getSceneName());
        searchSceneTestVo.setDefSearchPrompt(searchSceneBo.getDefSearchPrompt());
        searchSceneTestVo.setSceneId(searchSceneBo.getSceneId().toString());
        SearchCategoryEnum defCategory = searchSceneBo.getDefCategory();
        searchSceneTestVo.setDefCategory(defCategory.getValue());
        SearchKeyLogicEnum defSearchKeyLogic = searchSceneBo.getDefSearchKeyLogic();
        searchSceneTestVo.setDefSearchKeyLogic(defSearchKeyLogic.getValue());
        ArrayList filterConditions = Lists.newArrayListWithCapacity((int)16);
        List searchFilterList = searchSceneBo.getSearchFilterList();
        for (SearchFilterBo searchFilterBo : searchFilterList) {
            FilterConditionVo filterConditionVo = new FilterConditionVo();
            List searchCustomFilterList = searchFilterBo.getSearchCustomFilterList();
            filterConditionVo.setDisplayName(searchFilterBo.getDisplayName());
            filterConditionVo.setFiledType(searchFilterBo.getFilterFieldType().getValue());
            filterConditionVo.setNumber(searchFilterBo.getFieldAlias());
            filterConditionVo.setRealEntityNumber(searchFilterBo.getRealEntityNumber());
            ArrayList filterOptionVos = Lists.newArrayListWithCapacity((int)16);
            FilterOptionVo filterOptionVoNoLimit = new FilterOptionVo();
            filterOptionVoNoLimit.setId("-1");
            filterOptionVoNoLimit.setFilterName(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"SearchSceneTestHelp_2", (String)"hrmp-hrss-business", (Object[])new Object[0]));
            filterOptionVos.add(filterOptionVoNoLimit);
            Map partFilterValMap = searchFilterBo.getPartFilterValMap();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)searchCustomFilterList)) {
                filterConditionVo.setFilterType("1");
                if (MapUtils.isNotEmpty((Map)partFilterValMap)) {
                    partFilterValMap.forEach((key, value) -> {
                        FilterOptionVo filterOptionVo = new FilterOptionVo();
                        filterOptionVo.setId(key.toString());
                        if (value == null) {
                            return;
                        }
                        filterOptionVo.setFilterName(value.toString());
                        filterOptionVos.add(filterOptionVo);
                    });
                }
                filterConditionVo.setFilterOption((List)filterOptionVos);
            } else {
                filterConditionVo.setFilterType("2");
                for (SearchCustomFilterBo searchCustomFilterBo : searchCustomFilterList) {
                    FilterOptionVo filterOptionVo = new FilterOptionVo();
                    filterOptionVo.setId(searchCustomFilterBo.getKey());
                    filterOptionVo.setFilterName(searchCustomFilterBo.getName());
                    filterOptionVos.add(filterOptionVo);
                    filterConditionVo.setFilterOption((List)filterOptionVos);
                }
            }
            filterConditions.add(filterConditionVo);
        }
        searchSceneTestVo.setFilterCondition((List)filterConditions);
        List searchRangeList = searchSceneBo.getSearchRangeList();
        ArrayList searchRangeVos = Lists.newArrayListWithCapacity((int)16);
        SearchRangeVo searchRangeVoOne = new SearchRangeVo();
        searchRangeVoOne.setDisplayName(ResManager.loadKDString((String)"\u5168\u6587\u68c0\u7d22", (String)"SearchSceneTestHelp_0", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        searchRangeVoOne.setPrimaryKey("1");
        searchRangeVos.add(searchRangeVoOne);
        for (SearchRangeBo searchRangeBo : searchRangeList) {
            SearchRangeVo searchRangeVo = new SearchRangeVo();
            searchRangeVo.setDisplayName(searchRangeBo.getDisplayName());
            searchRangeVo.setSearchTargetType(searchRangeBo.getSearchTargetType().getValue());
            searchRangeVo.setPrimaryKey(searchRangeBo.getPrimaryKey().toString());
            searchRangeVos.add(searchRangeVo);
        }
        searchSceneTestVo.setSearchRange((List)searchRangeVos);
        view.getPageCache().put("searchSceneTestVo", SerializationUtils.toJsonString((Object)searchSceneTestVo));
        return searchSceneTestVo;
    }

    public void searchSceneQuery(IFormView view, SearchParam searchParam, Long primarKey, List<QFilter> qFilters) {
        String searchSceneBoStr = view.getPageCache().get("searchSceneBo");
        SearchSceneBo searchSceneBo = (SearchSceneBo)SerializationUtils.fromJsonString((String)searchSceneBoStr, SearchSceneBo.class);
        searchParam.setSearchObjId(searchSceneBo.getSearchObjId());
        List searchRangeList = searchSceneBo.getSearchRangeList();
        for (SearchRangeBo searchRangeBo : searchRangeList) {
            if (!primarKey.equals(searchRangeBo.getPrimaryKey())) continue;
            searchParam.setSearchTargetType(searchRangeBo.getSearchTargetType());
            searchParam.setSearchRangFieldList(searchRangeBo.getSearchRangFieldList());
        }
        String highLightPreTag = "<p class='highLignt' style='background: yellow;display: inline'>";
        String highLightPostTag = "</p>";
        String permCtlDymNum = SearchSceneBusQueryService.queryUniqueSearchPermCtrlPage(searchSceneBo.getSceneId());
        if (HRStringUtils.isEmpty((String)permCtlDymNum)) {
            permCtlDymNum = "hrss_searchscenetest";
        }
        searchParam.setPermCtlDymNum(permCtlDymNum);
        HrApiResponse search = HRSmartSearchService.search((SearchParam)searchParam, null, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)highLightPreTag, (String)highLightPostTag, (int)0, (int)100);
        if (!search.isSuccess()) {
            throw new KDBizException(search.getErrorMessage());
        }
        SmartSearchResp searchData = (SmartSearchResp)search.getData();
        SearchResultVO searchResultVO = new SearchResultVO();
        List searchFieldBoList = searchSceneBo.getSearchFieldList();
        ArrayList tableHeadList = Lists.newArrayListWithCapacity((int)16);
        for (SearchFieldBo searchFieldBo : searchFieldBoList) {
            boolean displayView = searchFieldBo.isDisplayView();
            if (!displayView) continue;
            SearchResultTableHead searchResultTableHead = new SearchResultTableHead();
            searchResultTableHead.setCode(searchFieldBo.getFieldAlias());
            searchResultTableHead.setName(searchFieldBo.getDisplayName());
            tableHeadList.add(searchResultTableHead);
        }
        searchResultVO.setTableHead((List)tableHeadList);
        List heads = tableHeadList.stream().map(tableHead -> tableHead.getCode()).collect(Collectors.toList());
        List<Map<String, Object>> sourceList = SearchResultUtil.dataSpread(searchData.getRowDataList(), highLightPreTag, highLightPostTag);
        ArrayList resultFieldList = Lists.newArrayListWithCapacity((int)16);
        for (Map map : sourceList) {
            HashMap resultFieldMap = Maps.newHashMapWithExpectedSize((int)16);
            map.forEach((key, fieldvValue) -> {
                if (heads.contains(key)) {
                    resultFieldMap.put(key, fieldvValue);
                }
            });
            resultFieldList.add(resultFieldMap);
        }
        searchResultVO.setValueList((List)resultFieldList);
        SearchLinkVo searchLinkVo = new SearchLinkVo();
        String string = view.getPageCache().get("searchWord");
        searchLinkVo.setSearchWord(string);
        searchResultVO.setSearchLink(searchLinkVo);
        DynamicObject[] weightBySceneId = SearchWeightConfHelper.getInstance().getWeightBySceneId(searchParam.getSceneId());
        if (weightBySceneId.length == 0) {
            HashMap data = Maps.newHashMapWithExpectedSize((int)16);
            searchLinkVo.setSearchEntity(new ArrayList());
            data.put("data", searchResultVO);
            data.put("method", "searchResult");
            data.put("random", System.currentTimeMillis());
            CustomControl fieldTreeControl = (CustomControl)view.getControl("customsearch");
            fieldTreeControl.setData((Object)SerializationUtils.toJsonString((Object)data));
            return;
        }
        ArrayList aiWordParam = Lists.newArrayListWithCapacity((int)16);
        if (weightBySceneId != null && weightBySceneId.length != 0) {
            DynamicObjectCollection dynamicObjectCollection = weightBySceneId[0].getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
                DynamicObject aiWordCategory = dynamicObject.getDynamicObject("aiwordcategory");
                if (aiWordCategory == null) continue;
                String number = aiWordCategory.getString("number");
                String name = aiWordCategory.getLocaleString("name").toString();
                objectObjectHashMap.put("k", number);
                objectObjectHashMap.put("v", name);
                aiWordParam.add(objectObjectHashMap);
            }
        }
        DynamicObject searchSceneById = SearchSceneServiceHelp.getSearchSceneById(searchParam.getSceneId());
        Integer id = 0;
        if (SystemParamUtil.gptEnable().booleanValue()) {
            long promptId = 0L;
            if (SystemParamUtil.useBosGpt()) {
                DynamicObject gptPromptDyo = searchSceneById.getDynamicObject("gptprompt");
                if (gptPromptDyo == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201cGPT\u63d0\u793a\u8bcd\u201d\u3002", (String)"SearchSceneTestHelp_1", (String)"hrmp-hrss-business", (Object[])new Object[0]));
                }
                promptId = gptPromptDyo.getLong("id");
            }
            Map<String, String> categoryMap = null;
            try {
                QFilter gptFilterResult = SmartSearchGptService.getQFilterByGpt(string, aiWordParam, promptId);
                categoryMap = GptFilterUtil.getCategoryMap(gptFilterResult, aiWordParam);
            }
            catch (KDBizException kdBizException) {
                LOGGER.error("getWordCategory fail:" + kdBizException.getMessage());
            }
            if (MapUtils.isEmpty(categoryMap)) {
                this.defaultSearchScheme(searchLinkVo, weightBySceneId[0], searchSceneById, id);
            } else {
                LOGGER.info("getWordCategory result:{}", categoryMap);
                DynamicObjectCollection dynamicObjectCollection = weightBySceneId[0].getDynamicObjectCollection("entryentity");
                ArrayList searchGpts = Lists.newArrayListWithCapacity((int)16);
                searchLinkVo.setGptAiWord((List)searchGpts);
                for (Map.Entry<String, String> categoryMapEntry : categoryMap.entrySet()) {
                    Integer n = id;
                    Integer n2 = id = Integer.valueOf(id + 1);
                    GptAiWordVo gptAiWordVo = new GptAiWordVo();
                    searchGpts.add(gptAiWordVo);
                    String number = categoryMapEntry.getKey();
                    String name = categoryMapEntry.getValue();
                    gptAiWordVo.setId(id.toString());
                    gptAiWordVo.setNumber(number);
                    gptAiWordVo.setName(name);
                    ArrayList searchEntitys = Lists.newArrayListWithCapacity((int)16);
                    gptAiWordVo.setSearchEntity((List)searchEntitys);
                    for (DynamicObject dynamicObject : dynamicObjectCollection) {
                        String aiCategoryNumber;
                        Integer n3 = id;
                        Integer n4 = id = Integer.valueOf(id + 1);
                        DynamicObject aiWordCategory = dynamicObject.getDynamicObject("aiwordcategory");
                        if (aiWordCategory == null || !(aiCategoryNumber = aiWordCategory.getString("number")).equals(number)) continue;
                        DynamicObjectCollection subentry = dynamicObject.getDynamicObjectCollection("subentryentity");
                        Map<String, List<DynamicObject>> entityGroup = subentry.stream().collect(Collectors.groupingBy(sub -> sub.getDynamicObject("searchobjentityid").getString("entitynumber")));
                        DynamicObject[] searchFieldArr = this.getSearchFieldBySearchObjId((Long)searchSceneById.getDynamicObject("searchobj").getPkValue());
                        for (Map.Entry<String, List<DynamicObject>> entry : entityGroup.entrySet()) {
                            Integer n5 = id;
                            Integer n6 = id = Integer.valueOf(id + 1);
                            String key2 = entry.getKey();
                            List<DynamicObject> value = entry.getValue();
                            SearchEntityVo searchEntityVo = new SearchEntityVo();
                            searchEntitys.add(searchEntityVo);
                            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)key2);
                            searchEntityVo.setName(dataEntityType.getDisplayName().toString());
                            searchEntityVo.setId(id.toString());
                            searchEntityVo.setNumber(key2);
                            ArrayList searchFields = Lists.newArrayListWithCapacity((int)16);
                            searchEntityVo.setSearchField((List)searchFields);
                            for (DynamicObject object : value) {
                                Integer n7 = id;
                                Integer n8 = id = Integer.valueOf(id + 1);
                                this.getSearchFieldVo(id, searchFieldArr, searchFields, object);
                            }
                        }
                    }
                }
            }
        } else {
            this.defaultSearchScheme(searchLinkVo, weightBySceneId[0], searchSceneById, id);
        }
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        data.put("data", searchResultVO);
        data.put("method", "searchResult");
        data.put("random", System.currentTimeMillis());
        CustomControl fieldTreeControl = (CustomControl)view.getControl("customsearch");
        fieldTreeControl.setData((Object)SerializationUtils.toJsonString((Object)data));
    }

    private void defaultSearchScheme(SearchLinkVo searchLinkVo, DynamicObject dynamicObject1, DynamicObject searchSceneById, Integer id) {
        ArrayList searchEntitys = Lists.newArrayListWithCapacity((int)16);
        DynamicObjectCollection dynamicObjectCollection = dynamicObject1.getDynamicObjectCollection("entryentity");
        searchLinkVo.setSearchEntity((List)searchEntitys);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Integer n = id;
            Integer n2 = id = Integer.valueOf(id + 1);
            String isDefault = dynamicObject.getString("isdefault");
            if (!isDefault.equals("1")) continue;
            DynamicObjectCollection subentry = dynamicObject.getDynamicObjectCollection("subentryentity");
            Map<String, List<DynamicObject>> entityGroup = subentry.stream().collect(Collectors.groupingBy(sub -> sub.getDynamicObject("searchobjentityid").getString("entitynumber")));
            DynamicObject[] searchFieldArr = this.getSearchFieldBySearchObjId((Long)searchSceneById.getDynamicObject("searchobj").getPkValue());
            for (Map.Entry<String, List<DynamicObject>> entry : entityGroup.entrySet()) {
                Integer n3 = id;
                Integer n4 = id = Integer.valueOf(id + 1);
                String key = entry.getKey();
                List<DynamicObject> value = entry.getValue();
                SearchEntityVo searchEntityVo = new SearchEntityVo();
                searchEntitys.add(searchEntityVo);
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)key);
                searchEntityVo.setName(dataEntityType.getDisplayName().toString());
                searchEntityVo.setId(id.toString());
                searchEntityVo.setNumber(key);
                ArrayList searchFields = Lists.newArrayListWithCapacity((int)16);
                searchEntityVo.setSearchField((List)searchFields);
                for (DynamicObject object : value) {
                    Integer n5 = id;
                    Integer n6 = id = Integer.valueOf(id + 1);
                    this.getSearchFieldVo(id, searchFieldArr, searchFields, object);
                }
            }
        }
    }

    private void getSearchFieldVo(Integer id, DynamicObject[] searchFieldArr, ArrayList<SearchFieldVo> searchFields, DynamicObject object) {
        String fieldIdStr = object.getString("fieldid");
        String[] split = fieldIdStr.split(",");
        if (split != null && split.length > 0) {
            for (String field : split) {
                Integer n = id;
                id = Integer.valueOf(id + 1);
                DynamicObject[] dynamicObjectArray = id;
                SearchFieldVo searchFieldVo = new SearchFieldVo();
                searchFields.add(searchFieldVo);
                searchFieldVo.setId(id.toString());
                searchFieldVo.setNumber(field);
                if (!LabelFieldUtil.isLabelField(field)) {
                    for (DynamicObject searchField : searchFieldArr) {
                        String fieldalias = searchField.getString("fieldalias");
                        if (!field.equals(fieldalias)) continue;
                        searchFieldVo.setName(searchField.getLocaleString("fieldname").toString());
                    }
                    continue;
                }
                String labelId = field.substring(field.lastIndexOf("_") + 1);
                DynamicObject labelById = this.getLabelById(Long.valueOf(labelId));
                searchFieldVo.setName(labelById.getLocaleString("name").toString());
            }
        } else {
            for (DynamicObject searchField : searchFieldArr) {
                Integer searchFieldVo = id;
                Integer n = id = Integer.valueOf(id + 1);
                searchFieldVo = new SearchFieldVo();
                searchFields.add((SearchFieldVo)searchFieldVo);
                searchFieldVo.setId(id.toString());
                searchFieldVo.setNumber(searchField.getString("fieldalias"));
                searchFieldVo.setName(searchField.getLocaleString("fieldname").toString());
            }
        }
    }

    public DynamicObject[] getSearchFieldBySearchObjId(Long searchObjId) {
        HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrss_schobjqueryfield");
        return queryFieldHelper.query("entitynumber,fieldname,fieldalias,fieldpath", new QFilter[]{new QFilter("searchobj", "=", (Object)searchObjId)});
    }

    public DynamicObject getLabelById(Long labelId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrcs_label");
        return hrBaseServiceHelper.queryOne((Object)labelId);
    }

    public List<Object> transformIDType(String entityNumber, List<String> selected) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataTypeEnum dataType = dataEntityType.getPrimaryKey().getPropertyType() == String.class ? DataTypeEnum.STRING : DataTypeEnum.LONG;
        ArrayList selectedResult = Lists.newArrayListWithCapacity((int)16);
        if (dataType.getDataTypeKey().equals(DataTypeEnum.STRING.getDataTypeKey())) {
            for (String businessId : selected) {
                selectedResult.add(String.valueOf(businessId));
            }
        } else {
            for (String businessId : selected) {
                selectedResult.add(Long.valueOf(businessId));
            }
        }
        return selectedResult;
    }

    public HashMap<String, Object> queryCustomerFilter(List<String> selected, IFormView view) {
        HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
        String searchSceneBoStr = view.getPageCache().get("searchSceneBo");
        SearchSceneBo searchSceneBo = (SearchSceneBo)SerializationUtils.fromJsonString((String)searchSceneBoStr, SearchSceneBo.class);
        List searchFilterList = searchSceneBo.getSearchFilterList();
        for (SearchFilterBo searchFilterBo : searchFilterList) {
            List searchCustomFilterList = searchFilterBo.getSearchCustomFilterList();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)searchCustomFilterList)) continue;
            for (SearchCustomFilterBo searchCustomFilterBo : searchCustomFilterList) {
                String key = searchCustomFilterBo.getKey();
                if (!selected.contains(key)) continue;
                objectObjectHashMap.put(key, searchCustomFilterBo.getFilterRule());
            }
        }
        return objectObjectHashMap;
    }

    public HashSet<String> getLabelBySearchObj(Long searchObjId) {
        HashSet labelSet = Sets.newHashSetWithExpectedSize((int)16);
        List<SchObjJoinEntity> schObjJoinEntities = SearchObjectService.getInstance().queryAndAssembleJoinEntities(searchObjId);
        for (SchObjJoinEntity schObjJoinEntity : schObjJoinEntities) {
            boolean searchTarget = schObjJoinEntity.isSearchTarget();
            if (!searchTarget) continue;
            Map gptLabelResult = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSLabelService", (String)"queryLabelObjectsByEntityNumber", (Object[])new Object[]{schObjJoinEntity.getEntityNumber()});
            boolean success = (Boolean)gptLabelResult.get("success");
            if (!success) {
                throw new KDBizException((String)gptLabelResult.get("msg"));
            }
            ArrayList<Map<String, Object>> distinctLabels = SearchSceneServiceHelp.distinctLabelResult(gptLabelResult);
            if (CollectionUtils.isEmpty(distinctLabels)) continue;
            for (Map<String, Object> objectMap : distinctLabels) {
                Long labelId = (Long)objectMap.get("labelId");
                String labelType = (String)objectMap.get("labelType");
                if (!"10".equals(labelType)) continue;
                labelSet.add(labelId.toString());
            }
        }
        return labelSet;
    }

    public String getMainEntityBySearchObj(Long searchObjectId) {
        List<SchObjJoinEntity> joinEntities = SearchObjectService.getInstance().queryAndAssembleJoinEntities(searchObjectId);
        Optional<SchObjJoinEntity> mainEntityBo = joinEntities.stream().filter(entity -> HRStringUtils.equals((String)entity.getType(), (String)"main")).findFirst();
        if (!mainEntityBo.isPresent()) {
            return "";
        }
        String mainEntityNumber = mainEntityBo.get().getEntityNumber();
        return mainEntityNumber;
    }

    public static String getFieldType(IFormView view, String fieldNumber, String realEntityNumber) {
        SearchSceneTestVo searchSceneVo;
        String searchSceneVoStr = view.getPageCache().get("searchSceneTestVo");
        if (HRStringUtils.isNotEmpty((String)searchSceneVoStr) && (searchSceneVo = (SearchSceneTestVo)SerializationUtils.fromJsonString((String)searchSceneVoStr, SearchSceneTestVo.class)) != null) {
            List filterCondition = searchSceneVo.getFilterCondition();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)filterCondition)) {
                return "";
            }
            for (FilterConditionVo filterConditionVo : filterCondition) {
                String number = filterConditionVo.getNumber();
                String realEntityNumberVo = filterConditionVo.getRealEntityNumber();
                if (!HRStringUtils.equals((String)fieldNumber, (String)number) || !HRStringUtils.equals((String)realEntityNumber, (String)realEntityNumberVo)) continue;
                return filterConditionVo.getFiledType();
            }
        }
        return "";
    }

    private static class Instance {
        private static SearchSceneTestHelp INSTANCE = new SearchSceneTestHelp();

        private Instance() {
        }
    }
}

