/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.ai;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.common.constants.search.AISearchConstants;
import kd.hrmp.hrss.common.constants.search.ai.WordAnalysisVO;
import kd.hrmp.hrss.common.util.AIAnalysisUtil;
import kd.hrmp.hrss.common.util.HttpClientUtil;
import org.apache.commons.collections.CollectionUtils;

public class AISearchService {
    private static final Log LOGGER = LogFactory.getLog(AISearchService.class);

    public static AISearchService getInstance() {
        return Instance.INSTANCE;
    }

    public List<WordAnalysisVO> wordAIAnalysis(String searchKeyWords) {
        String responseStr = this.postWordAIAnalysis(searchKeyWords);
        if (HRStringUtils.isEmpty((String)responseStr)) {
            return Collections.emptyList();
        }
        return this.handleHttpResult(responseStr, searchKeyWords);
    }

    public String postWordAIAnalysis(String searchKeyWords) {
        String url = System.getProperty("elasticsearch.server.search.wordanalysis");
        LOGGER.info("AISearchService.url is {}", (Object)url);
        return HttpClientUtil.doPost((String)this.generateEntityMap(searchKeyWords), (String)url);
    }

    @ExcludeFromJacocoGeneratedReport
    private List<WordAnalysisVO> handleHttpResult(String responseStr, String searchContent) {
        HashMap response;
        try {
            response = (HashMap)JSON.parseObject((String)responseStr, HashMap.class);
        }
        catch (JSONException exception) {
            LOGGER.error("ai word analysis fiald:", (Throwable)exception);
            return Collections.emptyList();
        }
        Integer statusCode = (Integer)response.get("statusCode");
        if (null == statusCode || !statusCode.equals(AISearchConstants.AI_SUCCESS)) {
            return Collections.emptyList();
        }
        ArrayList returnList = Lists.newArrayListWithExpectedSize((int)10);
        List data = (List)response.get("data");
        LOGGER.info("ai word analysis result data={}", (Object)JSON.toJSONString((Object)data));
        Map<String, List> groupByCategory = data.stream().collect(Collectors.toMap(entry -> (String)entry.get("category"), entry -> (List)entry.get("entities")));
        for (Map.Entry<String, List<Map<String, Object>>> entry2 : groupByCategory.entrySet()) {
            List<WordAnalysisVO> wordAnalysisVOS = this.generateWordAnalysisVOList(searchContent, entry2);
            if (!CollectionUtils.isNotEmpty(wordAnalysisVOS)) continue;
            returnList.addAll(wordAnalysisVOS);
        }
        LOGGER.info("ai word analysis compare result={}", (Object)JSON.toJSONString((Object)returnList));
        return returnList;
    }

    @ExcludeFromJacocoGeneratedReport
    private List<WordAnalysisVO> generateWordAnalysisVOList(String searchContent, Map.Entry<String, List<Map<String, Object>>> category) {
        List<Map<String, Object>> entries = category.getValue();
        String[] splits = searchContent.trim().split(" ");
        List searchKeyWords = Arrays.stream(splits).collect(Collectors.toList());
        ArrayList analysisVOList = Lists.newArrayListWithCapacity((int)entries.size());
        for (Map<String, Object> entry : entries) {
            for (String searchKeyWord : searchKeyWords) {
                boolean isSimilar = AIAnalysisUtil.isSimilarKeyWord((String)searchKeyWord, (String)((String)entry.get("value")));
                if (!isSimilar) continue;
                entry.put("value", searchKeyWord);
                WordAnalysisVO wordAnalysisVO = new WordAnalysisVO(category.getKey(), entry);
                analysisVOList.add(wordAnalysisVO);
            }
        }
        return analysisVOList;
    }

    private String generateEntityMap(String searchKeyWords) {
        HashMap entityMap = Maps.newHashMap();
        entityMap.put("parse_field", new String[0]);
        entityMap.put("raw_text", searchKeyWords);
        return JSON.toJSONString((Object)entityMap);
    }

    private static class Instance {
        private static final AISearchService INSTANCE = new AISearchService();

        private Instance() {
        }
    }
}

