/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.ai;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.ai.SmartSearchGptService;
import kd.hrmp.hrss.business.domain.search.service.common.SystemParamUtil;
import kd.hrmp.hrss.business.domain.search.service.searchscene.SearchSceneBusQueryService;
import kd.hrmp.hrss.business.domain.search.service.searchweight.SearchWeightConfHelper;

public class EsSearchByGptService {
    private static final Log LOGGER = LogFactory.getLog(EsSearchByGptService.class);

    public static EsSearchByGptService getInstance() {
        return Instance.INSTANCE;
    }

    public QFilter wordGPTAnalysis(String searchContent, Long sceneId) {
        long promptId;
        LOGGER.info("DO_SEARCH_LOGwordGPTAnalysis param:[searchKeyWords:{}, sceneId:{}]", (Object)searchContent, (Object)sceneId);
        if (HRStringUtils.isEmpty((String)searchContent)) {
            return null;
        }
        if (!SystemParamUtil.gptEnable().booleanValue()) {
            LOGGER.info("DO_SEARCH_LOGwordGPTAnalysis GPT disable");
            return null;
        }
        List<Map<String, String>> aiWordParam = EsSearchByGptService.getWordCategoryMap(sceneId);
        if (aiWordParam.isEmpty()) {
            LOGGER.info("DO_SEARCH_LOGwordGPTAnalysis ai word empty!");
            return null;
        }
        DynamicObject sceneDyo = SearchSceneBusQueryService.loadSceneConf(sceneId);
        boolean useBosGpt = SystemParamUtil.useBosGpt();
        LOGGER.info("wordGPTAnalysis use bos GPT:{}", (Object)useBosGpt);
        if (useBosGpt) {
            DynamicObject gptPromptDyo = sceneDyo.getDynamicObject("gptprompt");
            if (gptPromptDyo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u573a\u666f\u7684\u201cGPT\u63d0\u793a\u8bcd\u201d\u4e3a\u7a7a\u3002", (String)"EsSearchByGptService_1", (String)"hrmp-hrss-business", (Object[])new Object[0]));
            }
            promptId = gptPromptDyo.getLong("id");
        } else {
            promptId = 0L;
        }
        QFilter gptFilterResult = EsSearchByGptService.execWordCategory(searchContent, aiWordParam, promptId);
        LOGGER.info("DO_SEARCH_LOGGTP Analysis result:{}", (Object)gptFilterResult);
        return gptFilterResult;
    }

    public static List<Map<String, String>> getWordCategoryMap(Long sceneId) {
        DynamicObject sceneWeightDyo = SearchWeightConfHelper.getInstance().querySearchWeightBySceneId(sceneId);
        if (sceneWeightDyo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u6392\u5e8f\u6743\u91cd\u201d\u3002", (String)"EsSearchByGptService_0", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        ArrayList aiWordParam = Lists.newArrayListWithCapacity((int)16);
        DynamicObjectCollection weightConfColl = sceneWeightDyo.getDynamicObjectCollection("entryentity");
        for (DynamicObject weightConfDyo : weightConfColl) {
            HashMap wordCategoryMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObject aiWordCategory = weightConfDyo.getDynamicObject("aiwordcategory");
            if (aiWordCategory == null) continue;
            String number = aiWordCategory.getString("number");
            String name = aiWordCategory.getLocaleString("name").getLocaleValue();
            wordCategoryMap.put("k", number);
            wordCategoryMap.put("v", name);
            aiWordParam.add(wordCategoryMap);
        }
        return aiWordParam;
    }

    private static QFilter execWordCategory(String searchWord, List<Map<String, String>> aiWordParam, long promptId) {
        QFilter gptFilterResult;
        try {
            gptFilterResult = SmartSearchGptService.getQFilterByGpt(searchWord, aiWordParam, promptId);
        }
        catch (KDBizException kdBizException) {
            LOGGER.error("DO_SEARCH_LOGgetWordCategory fail:" + kdBizException.getMessage());
            return null;
        }
        return gptFilterResult;
    }

    private static class Instance {
        private static final EsSearchByGptService INSTANCE = new EsSearchByGptService();

        private Instance() {
        }
    }
}

