/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.ai;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.ai.QFilterByHRFunction;
import kd.hrmp.hrss.business.domain.search.service.ai.QFilterFunction;
import kd.hrmp.hrss.business.domain.search.service.common.SystemParamUtil;
import kd.sdk.hr.hrmp.hrss.extpoint.IGptCustomPlugin;

public class SmartSearchGptService
implements IGptCustomPlugin {
    private static final Log LOGGER = LogFactory.getLog(SmartSearchGptService.class);

    public static QFilter getQFilterByGpt(String input, List<Map<String, String>> wordPropRelation, long promptId) {
        LOGGER.info("getQFilterByGpt.input:{},promptId:{}\uff0cwordPropRelation:{}", new Object[]{input, promptId, wordPropRelation});
        if (!SystemParamUtil.gptEnable().booleanValue()) {
            return null;
        }
        long start = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(wordPropRelation)) {
            throw new KDBizException("getQFilterByGpt.wordPropRelation is Empty!");
        }
        ArrayList wordKeys = Lists.newArrayListWithExpectedSize((int)16);
        wordPropRelation.forEach(propRelationMap -> wordKeys.add(propRelationMap.get("k")));
        if (SystemParamUtil.useCustomerGpt()) {
            HRPluginProxy proxy = new HRPluginProxy((Object)new SmartSearchGptService(), IGptCustomPlugin.class, "kd.sdk.hr.hrmp.hrss.extpoint.IGptCustomPlugin", null);
            List callAfter = proxy.callReplace(p -> p.getGptSQLResult(input, wordPropRelation));
            LOGGER.info("getQFilterByGpt.callAfter");
            if (!CollectionUtils.isEmpty((Collection)callAfter)) {
                long end = System.currentTimeMillis();
                LOGGER.info("getQFilterByGpt.result.IGptCustomPlugin promptObj :{}; total cost:{};", (Object)SerializationUtils.toJsonString(callAfter.get(0)), (Object)(end - start));
                return SmartSearchGptService.processQFilterByExt((QFilter)callAfter.get(0), wordKeys);
            }
        } else if (SystemParamUtil.useBosGpt()) {
            if (promptId == 0L) {
                throw new KDBizException("getQFilterByGpt.promptId is Empty!");
            }
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
            paramMap.put("wordPropRelation", SerializationUtils.toJsonString(wordPropRelation));
            Object promptObj = HRMServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])new Object[]{promptId, input, paramMap});
            long end = System.currentTimeMillis();
            LOGGER.info("getQFilterByGpt.result promptObj :{}; total cost:{}", (Object)SerializationUtils.toJsonString((Object)promptObj), (Object)(end - start));
            try {
                String data = SmartSearchGptService.processGptResp(promptObj);
                if (HRStringUtils.isNotEmpty((String)data)) {
                    QFilter qFilter = QFilter.of((String)data, (Object[])new Object[0]);
                    return SmartSearchGptService.processQFilterByHR(qFilter, wordKeys);
                }
            }
            catch (Exception exception) {
                LOGGER.error("getQFilterByGpt:", (Throwable)exception);
            }
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private static String processGptResp(Object promptObj) {
        if (!(promptObj instanceof Map)) {
            return null;
        }
        Map promptMap = (Map)promptObj;
        if (!"0".equals(promptMap.get("errCode"))) {
            return null;
        }
        Map dataMap = (Map)promptMap.get("data");
        if (dataMap == null || dataMap.isEmpty()) {
            return null;
        }
        String llmValueOrg = dataMap.getOrDefault("llmValue", "");
        String llmValue = llmValueOrg.replace("```json", "").replace("```", "");
        if (StringUtils.isEmpty((CharSequence)llmValue)) {
            return null;
        }
        try {
            Map valueMap = (Map)SerializationUtils.fromJsonString((String)llmValue, Map.class);
            return (String)valueMap.get("result");
        }
        catch (Exception exception) {
            LOGGER.error("getQFilterByGpt.parse prompt result llmValue error", (Throwable)exception);
            return null;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static QFilter processQFilterByHR(QFilter qFilter, List<String> wordKeys) {
        if (qFilter == null || CollectionUtils.isEmpty(wordKeys)) {
            return null;
        }
        LOGGER.info("SmartSearchGptService.processGptResp.qFilter:{},wordKeys\uff1a{}", (Object)qFilter, wordKeys);
        QFilterByHRFunction qFilterFunction = new QFilterByHRFunction(wordKeys);
        QFilter trans = qFilter.trans((Function)qFilterFunction);
        QFilter reTrans = trans.trans((Function)qFilterFunction);
        if (reTrans == null || HRStringUtils.equals((String)reTrans.getProperty(), (String)"1") && CollectionUtils.isEmpty((Collection)reTrans.getNests(false))) {
            return null;
        }
        return reTrans;
    }

    @ExcludeFromJacocoGeneratedReport
    private static QFilter processQFilterByExt(QFilter qFilter, List<String> wordKeys) {
        if (qFilter == null || CollectionUtils.isEmpty(wordKeys)) {
            return null;
        }
        LOGGER.info("SmartSearchGptService.processGptResp.qFilter:{},wordKeys\uff1a{}", (Object)qFilter, wordKeys);
        QFilterFunction qFilterFunction = new QFilterFunction(wordKeys);
        QFilter trans = qFilter.trans((Function)qFilterFunction);
        if (trans == null) {
            return null;
        }
        QFilter reTrans = trans.trans((Function)qFilterFunction);
        if (reTrans == null || HRStringUtils.equals((String)reTrans.getProperty(), (String)"1") && CollectionUtils.isEmpty((Collection)reTrans.getNests(false))) {
            return null;
        }
        return reTrans;
    }

    public QFilter getGptSQLResult(String input, List<Map<String, String>> wordPropRelation) {
        return null;
    }
}

