/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.common;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjConditionRow;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.common.FieldParseUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ContextParseService {
    private static final Log LOGGER = LogFactory.getLog(ContextParseService.class);

    public static QFilter[] getRightQueryFilter(HRComplexObjContext context, HRComplexObjJoinRelation objJoinRelation, Map<String, DynamicObject[]> entityDyoArrMap) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        for (HRComplexObjConditionRow conditionRow : objJoinRelation.getCondition()) {
            if (conditionRow.isRightFieldItem()) {
                QFilter qFilter = ContextParseService.genConditionFilter(context, entityDyoArrMap, conditionRow);
                qFilterList.add(qFilter);
                continue;
            }
            String leftItem = conditionRow.getLeftItem();
            String rightEntityAlias = ContextParseService.getRelEntityAlias(context, leftItem);
            if (rightEntityAlias != null) {
                leftItem = leftItem.replaceFirst(rightEntityAlias + "\\.", "");
            }
            QFilter qFilter = new QFilter(leftItem, conditionRow.getCompareOp(), ContextParseService.condExprTransObj(conditionRow.getRightItem()));
            qFilterList.add(qFilter);
        }
        qFilterList.remove(null);
        return qFilterList.toArray(new QFilter[0]);
    }

    public static Object condExprTransObj(String expr) {
        if (!HRStringUtils.isEmpty((String)expr)) {
            if (expr.startsWith("'") && expr.endsWith("'")) {
                return expr.substring(1, expr.length() - 1);
            }
            if (expr.startsWith("{ts'") && expr.endsWith("'}")) {
                String dateStr = expr.substring(4, expr.length() - 2);
                try {
                    return HRDateTimeUtils.parseDate((String)dateStr);
                }
                catch (ParseException parseException) {
                }
            } else if (StringUtils.isNumeric((CharSequence)expr)) {
                try {
                    if (expr.indexOf(46) > 0) {
                        BigDecimal bigDecimal = new BigDecimal(expr);
                        return bigDecimal.doubleValue();
                    }
                    return Long.parseLong(expr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return expr;
    }

    private static QFilter genConditionFilter(HRComplexObjContext context, Map<String, DynamicObject[]> entityDyoArrMap, HRComplexObjConditionRow conditionRow) {
        String fieldNoPrefix;
        String leftItem = conditionRow.getLeftItem();
        String entityAlias = ContextParseService.getRelEntityAlias(context, leftItem);
        if (entityAlias == null) {
            fieldNoPrefix = leftItem;
            entityAlias = context.getEntityNumber();
        } else {
            fieldNoPrefix = leftItem.replaceFirst(entityAlias + "\\.", "");
        }
        DynamicObject[] leftDyoArr = entityDyoArrMap.get(entityAlias);
        if (leftDyoArr == null) {
            return null;
        }
        List leftJoinData = Arrays.stream(leftDyoArr).map(dyo -> dyo.get(fieldNoPrefix)).collect(Collectors.toList());
        String rightItem = conditionRow.getRightItem();
        String rightEntityAlias = ContextParseService.getRelEntityAlias(context, rightItem);
        if (rightEntityAlias != null) {
            rightItem = rightItem.replaceFirst(rightEntityAlias + "\\.", "");
        }
        if (leftJoinData.isEmpty()) {
            return QFilter.of((String)"1!=1", (Object[])new Object[0]);
        }
        return new QFilter(rightItem, "in", leftJoinData);
    }

    public static String getRelEntityAlias(HRComplexObjContext context, String fieldAlias) {
        Map<String, String> relEntityMap = context.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        return ContextParseService.getRelEntityAlias(relEntityMap, fieldAlias);
    }

    public static String getRelEntityAlias(Map<String, String> relEntityMap, String fieldAlias) {
        String[] split = fieldAlias.split("\\.");
        String mayEntityAlias = split[0];
        String relEntityNumber = relEntityMap.get(mayEntityAlias);
        if (relEntityNumber == null) {
            return null;
        }
        return mayEntityAlias;
    }

    public static Map<String, Set<String>> getAllNeedQueryFieldMap(HRComplexObjContext context, MainEntityTypeUtil entityTypeUtil) {
        Set allSelectField = context.getComplexObjFieldInfoList().stream().filter(field -> field.getFieldType().equals("1")).map(HRComplexObjFieldInfo::getAlias).collect(Collectors.toSet());
        allSelectField.add("id");
        for (HRComplexObjJoinRelation joinRelation : context.getJoinRelationList()) {
            allSelectField.add(joinRelation.getRelEntityAlias() + "." + "id");
            List conditionRows = joinRelation.getCondition();
            for (HRComplexObjConditionRow conditionRow : conditionRows) {
                allSelectField.add(conditionRow.getLeftItem());
                if (!conditionRow.isRightFieldItem()) continue;
                allSelectField.add(conditionRow.getRightItem());
            }
        }
        Map<String, String> relEntityMap = context.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        HashMap<String, Set<String>> entityAllFieldMap = new HashMap<String, Set<String>>(16);
        Iterator iterator = allSelectField.iterator();
        while (iterator.hasNext()) {
            MainEntityType entityType;
            IDataEntityProperty fieldProperty;
            String fieldAlias;
            String fullPropName = fieldAlias = (String)iterator.next();
            String[] split = fieldAlias.split("\\.");
            String mayEntityAlias = split[0];
            String curEntityNumber = context.getEntityNumber();
            String relEntityNumber = relEntityMap.get(mayEntityAlias);
            if (relEntityNumber == null) {
                mayEntityAlias = context.getEntityNumber();
            } else {
                curEntityNumber = relEntityNumber;
                fullPropName = fullPropName.replaceFirst(mayEntityAlias + "\\.", "");
            }
            if ((fieldProperty = FieldParseUtil.getFieldProperty((DynamicObjectType)(entityType = entityTypeUtil.getMainEntityType(curEntityNumber)), fullPropName, entityTypeUtil)) instanceof ISimpleProperty && PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)fieldProperty)) continue;
            HashSet<String> singEntityField = (HashSet<String>)entityAllFieldMap.get(mayEntityAlias);
            if (singEntityField == null) {
                singEntityField = new HashSet<String>(16);
            }
            singEntityField.add(fieldAlias);
            if (fieldProperty instanceof EntryProp) {
                String[] entryPropArr = fullPropName.split("\\.");
                if (fieldProperty.getName().equals(entryPropArr[0]) && entryPropArr.length > 2) {
                    singEntityField.add(fieldAlias.substring(0, fieldAlias.lastIndexOf(".")));
                }
            }
            entityAllFieldMap.put(mayEntityAlias, singEntityField);
        }
        return entityAllFieldMap;
    }

    public static HRComplexObjContext optimizeRelEntity(HRComplexObjContext context, String relEntityNumber) {
        Set relEntityLongNumberSet = context.getJoinRelationList().stream().filter(relEntity -> relEntity.getRelEntityNumber().equals(relEntityNumber)).map(HRComplexObjJoinRelation::getRelEntityLongNumber).collect(Collectors.toSet());
        HashSet<String> allLongNumbers = new HashSet<String>(relEntityLongNumberSet.size());
        for (String longNumber : relEntityLongNumberSet) {
            allLongNumbers.add(longNumber);
            while (longNumber.contains("!")) {
                longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
                allLongNumbers.add(longNumber);
            }
        }
        HRComplexObjContext copyContext = new HRComplexObjContext();
        ArrayList<HRComplexObjJoinRelation> joinRelationList = new ArrayList<HRComplexObjJoinRelation>(10);
        for (HRComplexObjJoinRelation joinRelation : context.getJoinRelationList()) {
            if (!allLongNumbers.contains(joinRelation.getRelEntityLongNumber())) continue;
            joinRelationList.add(joinRelation);
        }
        copyContext.setJoinRelationList(joinRelationList);
        copyContext.setEntityTable(context.getEntityTable());
        copyContext.setEntityNumber(context.getEntityNumber());
        ContextParseService.checkContext(copyContext);
        return copyContext;
    }

    public static HRComplexObjContext optimizeRelEntity(HRComplexObjContext context, List<QFilter> qfilterList) {
        Set<String> relEntityAliasSet = ContextParseService.getQFilterContainAllEntityAlias(context, qfilterList);
        HRComplexObjContext copyContext = new HRComplexObjContext();
        copyContext.setEntityTable(context.getEntityTable());
        copyContext.setEntityNumber(context.getEntityNumber());
        if (CollectionUtils.isNotEmpty(relEntityAliasSet)) {
            Set relEntityLongNumberSet = context.getJoinRelationList().stream().filter(relEntity -> relEntityAliasSet.contains(relEntity.getRelEntityAlias())).map(HRComplexObjJoinRelation::getRelEntityLongNumber).collect(Collectors.toSet());
            HashSet<String> allLongNumbers = new HashSet<String>(relEntityLongNumberSet.size());
            for (String longNumber : relEntityLongNumberSet) {
                allLongNumbers.add(longNumber);
                while (longNumber.contains("!")) {
                    longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
                    allLongNumbers.add(longNumber);
                }
            }
            ArrayList<HRComplexObjJoinRelation> joinRelationList = new ArrayList<HRComplexObjJoinRelation>(10);
            for (HRComplexObjJoinRelation joinRelation : context.getJoinRelationList()) {
                if (!allLongNumbers.contains(joinRelation.getRelEntityLongNumber())) continue;
                joinRelationList.add(joinRelation);
            }
            copyContext.setJoinRelationList(joinRelationList);
        }
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        List<HRComplexObjFieldInfo> complexObjFieldInfoList = ContextParseService.genAllPkQueryFieldList(copyContext.getEntityNumber(), mainEntityTypeUtil, copyContext.getJoinRelationList());
        copyContext.setComplexObjFieldInfoList(complexObjFieldInfoList);
        ContextParseService.checkContext(copyContext);
        return copyContext;
    }

    public static Set<String> getQFilterContainAllEntityAlias(HRComplexObjContext context, List<QFilter> qFilters) {
        if (CollectionUtils.isEmpty(qFilters)) {
            return null;
        }
        Set<String> relEntityAlias = context.getJoinRelationList().stream().map(HRComplexObjJoinRelation::getRelEntityAlias).collect(Collectors.toSet());
        HashSet<String> containRelEntityAlias = new HashSet<String>(16);
        for (QFilter qFilter : qFilters) {
            ContextParseService.findRelEntityAlias(relEntityAlias, containRelEntityAlias, qFilter);
            List nestList = qFilter.getNests(false);
            for (QFilter.QFilterNest nest : nestList) {
                ContextParseService.findRelEntityAlias(relEntityAlias, containRelEntityAlias, nest.getFilter());
            }
        }
        return containRelEntityAlias;
    }

    private static void findRelEntityAlias(Set<String> relEntityAlias, Set<String> containRelEntityAlias, QFilter qFilter) {
        String property = qFilter.getProperty();
        String[] split = property.split("\\.");
        if (relEntityAlias.contains(split[0])) {
            containRelEntityAlias.add(split[0]);
        }
    }

    public static void checkContext(HRComplexObjContext context) {
        List joinRelationList = context.getJoinRelationList();
        for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
            List conditionRows = joinRelation.getCondition();
            if (CollectionUtils.isEmpty((Collection)conditionRows)) {
                LOGGER.warn("joinRelation error:{}", (Object)joinRelation);
                throw new KDBizException("entityAlias:" + joinRelation.getRelEntityAlias() + " condition is Null");
            }
            boolean existsEq = false;
            for (HRComplexObjConditionRow conditionRow : conditionRows) {
                if (!conditionRow.isRightFieldItem()) continue;
                existsEq = true;
                break;
            }
            if (existsEq) continue;
            LOGGER.warn("joinRelation error:{}", (Object)joinRelation);
            throw new KDBizException("entityAlias:" + joinRelation.getRelEntityAlias() + " condition error");
        }
    }

    public static List<HRComplexObjContext> splitContextQueryPK(HRComplexObjContext context, int splitSize) {
        List joinRelationList = context.getJoinRelationList();
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        if (joinRelationList.size() <= splitSize) {
            HRComplexObjContext splitContext = new HRComplexObjContext();
            splitContext.setEntityTable(context.getEntityTable());
            splitContext.setEntityNumber(context.getEntityNumber());
            List<HRComplexObjFieldInfo> complexObjFieldInfoList = ContextParseService.genAllPkQueryFieldList(context.getEntityNumber(), mainEntityTypeUtil, joinRelationList);
            splitContext.setJoinRelationList(joinRelationList);
            splitContext.setComplexObjFieldInfoList(complexObjFieldInfoList);
            ContextParseService.checkContext(splitContext);
            return Collections.singletonList(splitContext);
        }
        Map<String, Integer> lgNumberPrexCountMap = ContextParseService.countFirstLayer(joinRelationList);
        LOGGER.info("splitContextQueryPK:countdata:{}", lgNumberPrexCountMap);
        List<List<Map.Entry<String, Integer>>> groupedEntityCount = ContextParseService.groupByMapValue(lgNumberPrexCountMap, splitSize);
        LOGGER.info("splitContextQueryPK:groupedEntityCount:{}", groupedEntityCount);
        ArrayList<HRComplexObjContext> contextList = new ArrayList<HRComplexObjContext>(16);
        for (List<Map.Entry<String, Integer>> groupPrexList : groupedEntityCount) {
            HRComplexObjContext splitContext = new HRComplexObjContext();
            splitContext.setEntityTable(context.getEntityTable());
            splitContext.setEntityNumber(context.getEntityNumber());
            List curLongNumberPrex = groupPrexList.stream().map(Map.Entry::getKey).collect(Collectors.toList());
            ArrayList<HRComplexObjJoinRelation> splitRelationList = new ArrayList<HRComplexObjJoinRelation>(16);
            for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
                String longNumber = joinRelation.getRelEntityLongNumber();
                String prex = ContextParseService.getLongNumberPrex(longNumber);
                if (!curLongNumberPrex.contains(prex)) continue;
                splitRelationList.add(joinRelation);
            }
            splitContext.setJoinRelationList(splitRelationList);
            List<HRComplexObjFieldInfo> complexObjFieldInfoList = ContextParseService.genAllPkQueryFieldList(context.getEntityNumber(), mainEntityTypeUtil, splitRelationList);
            splitContext.setComplexObjFieldInfoList(complexObjFieldInfoList);
            ContextParseService.checkContext(splitContext);
            contextList.add(splitContext);
        }
        return contextList;
    }

    public static List<HRComplexObjFieldInfo> genAllPkQueryFieldList(String mainEntityNumber, MainEntityTypeUtil mainEntityTypeUtil, List<HRComplexObjJoinRelation> splitRelationList) {
        ArrayList<HRComplexObjFieldInfo> complexObjFieldInfoList = new ArrayList<HRComplexObjFieldInfo>(10);
        MainEntityType dataEntityType = mainEntityTypeUtil.getMainEntityType(mainEntityNumber);
        DataTypeEnum dataType = dataEntityType.getPrimaryKey().getPropertyType() == String.class ? DataTypeEnum.STRING : DataTypeEnum.LONG;
        HRComplexObjFieldInfo idField = new HRComplexObjFieldInfo("id", "1", "id", dataType, null);
        complexObjFieldInfoList.add(idField);
        for (HRComplexObjJoinRelation joinRelation : splitRelationList) {
            MainEntityType relEntityType = mainEntityTypeUtil.getMainEntityType(joinRelation.getRelEntityNumber());
            DataTypeEnum relEntitypkDataType = relEntityType.getPrimaryKey().getPropertyType() == String.class ? DataTypeEnum.STRING : DataTypeEnum.LONG;
            HRComplexObjFieldInfo relEntityIdField = new HRComplexObjFieldInfo(joinRelation.getRelEntityNumber() + '.' + "id", "1", joinRelation.getRelEntityAlias() + '.' + "id", relEntitypkDataType, null);
            complexObjFieldInfoList.add(relEntityIdField);
        }
        return complexObjFieldInfoList;
    }

    public static boolean containMainFilter(Set<String> relEntityAlias, List<QFilter> qFilterList) {
        for (QFilter qFilter : qFilterList) {
            if (!ContextParseService.containMainFilter(relEntityAlias, qFilter)) continue;
            return true;
        }
        return false;
    }

    private static boolean containMainFilter(Set<String> relEntityAlias, QFilter qFilter) {
        String property = qFilter.getProperty();
        String[] split = property.split("\\.");
        if (!relEntityAlias.contains(split[0])) {
            return true;
        }
        List nestList = qFilter.getNests(false);
        for (QFilter.QFilterNest nest : nestList) {
            if (!ContextParseService.containMainFilter(relEntityAlias, nest.getFilter())) continue;
            return true;
        }
        return false;
    }

    public static List<QFilter> getOnlyMainQFilter(Set<String> relEntityAlias, List<QFilter> qFilterList) {
        if (CollectionUtils.isEmpty(qFilterList) || CollectionUtils.isEmpty(relEntityAlias)) {
            return qFilterList;
        }
        ArrayList<QFilter> qFilterCopyList = new ArrayList<QFilter>(10);
        for (QFilter filter : qFilterList) {
            boolean canSpread = ContextParseService.canSpread(filter);
            if (!canSpread) continue;
            qFilterCopyList.add(filter);
        }
        ArrayList<QFilter> mainQFilterList = new ArrayList<QFilter>(10);
        for (QFilter qFilter : qFilterCopyList) {
            ContextParseService.reserveMainFilter(relEntityAlias, mainQFilterList, qFilter);
        }
        return mainQFilterList;
    }

    private static void reserveMainFilter(Set<String> relEntityAlias, List<QFilter> mainQFilterList, QFilter qFilter) {
        if (ContextParseService.isMainQFilter(relEntityAlias, qFilter)) {
            mainQFilterList.add(new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue()));
        }
        List nests = qFilter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            ContextParseService.reserveMainFilter(relEntityAlias, mainQFilterList, nest.getFilter());
        }
    }

    private static boolean canSpread(QFilter filter) {
        List nests = filter.getNests(true);
        if (CollectionUtils.isEmpty((Collection)nests)) {
            return true;
        }
        for (QFilter.QFilterNest qFilterNest : nests) {
            if (!"OR".equals(qFilterNest.getOp()) && ContextParseService.canSpread(qFilterNest.getFilter())) continue;
            return false;
        }
        return true;
    }

    private static boolean isMainQFilter(Set<String> relEntityAlias, QFilter qFilter) {
        String property = qFilter.getProperty();
        String[] split = property.split("\\.");
        return !relEntityAlias.contains(split[0]);
    }

    private static Map<String, Integer> countFirstLayer(List<HRComplexObjJoinRelation> joinRelationList) {
        HashMap<String, Integer> lgNumberPrexCountMap = new HashMap<String, Integer>(joinRelationList.size());
        for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
            String longNumber = joinRelation.getRelEntityLongNumber();
            String prex = ContextParseService.getLongNumberPrex(longNumber);
            Integer count = (Integer)lgNumberPrexCountMap.get(prex);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            lgNumberPrexCountMap.put(prex, count);
        }
        return lgNumberPrexCountMap;
    }

    private static String getLongNumberPrex(String longNumber) {
        int layer = longNumber.length() - longNumber.replace("!", "").length();
        String prex = longNumber;
        if (layer > 1) {
            String[] split = longNumber.split("!");
            prex = split[0] + "!" + split[1];
        }
        return prex;
    }

    public static List<List<Map.Entry<String, Integer>>> groupByMapValue(Map<String, Integer> lgNumberPrexCountMap, int splitSize) {
        ArrayList<List<Map.Entry<String, Integer>>> groups = new ArrayList<List<Map.Entry<String, Integer>>>();
        Iterator<Map.Entry<String, Integer>> iterator = lgNumberPrexCountMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> entry = iterator.next();
            if (entry.getValue() > splitSize) {
                groups.add(Collections.singletonList(entry));
                iterator.remove();
                continue;
            }
            boolean added = false;
            for (List list : groups) {
                if (list.stream().mapToInt(Map.Entry::getValue).sum() + entry.getValue() > splitSize) continue;
                list.add(entry);
                iterator.remove();
                added = true;
                break;
            }
            if (added) continue;
            ArrayList<Map.Entry<String, Integer>> newGroup = new ArrayList<Map.Entry<String, Integer>>();
            newGroup.add(entry);
            groups.add(newGroup);
            iterator.remove();
        }
        return groups;
    }
}

