/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.common;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.common.ContextParseService;
import kd.hrmp.hrss.business.domain.search.service.common.SObjCacheService;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;
import org.apache.commons.collections.MapUtils;

public class HRContextCache {
    private static final Log LOGGER = LogFactory.getLog(HRContextCache.class);
    private static final String SEARCHOBJ_CACHE_KEY = "cache_search_obj_conf_";

    public static HRComplexObjContext getComplexObjContext(Long searchObjId) {
        HRComplexObjContext complexObjContext = SearchObjectService.getInstance().getComplexObjContext(searchObjId);
        ContextParseService.checkContext(complexObjContext);
        return complexObjContext;
    }

    public static Map<String, String> getRelEntityMapFromCache(Long searchObjId) {
        String cacheKey = "REL_ENTITY_ALIASMAP_" + searchObjId;
        SObjCacheService cacheService = SObjCacheService.getInstance();
        String cacheJson = cacheService.get(cacheKey);
        Map<String, String> relEntityMap = null;
        if (HRStringUtils.isNotEmpty((String)cacheJson)) {
            LOGGER.info("getRelEntityMap from cache searchObjId:{}", (Object)searchObjId);
            try {
                relEntityMap = (Map<String, String>)SerializationUtils.fromJsonString((String)cacheJson, Map.class);
            }
            catch (Exception exception) {
                LOGGER.error((Throwable)exception);
            }
        }
        if (MapUtils.isEmpty(relEntityMap)) {
            LOGGER.info("getRelEntityMap from cache error searchObjId:{}", (Object)searchObjId);
            relEntityMap = SearchObjectService.getInstance().queryRelEntityAliasMap(searchObjId);
            cacheService.put(cacheKey, SerializationUtils.toJsonString(relEntityMap));
        }
        return relEntityMap;
    }

    public static void clearSearchObjConfCache(Long searchObjId) {
        LOGGER.info("clearSearchObjConfCache appcache:{}", (Object)searchObjId);
    }
}

