/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.common;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SObjCacheService {
    private static final Log LOGGER = LogFactory.getLog(SObjCacheService.class);
    private static String region = CacheKeyUtil.getAcctId() + "hrmp_hrss_LocalCacheService";
    private static String type = "sobj_conf";
    private LocalMemoryCache lcache;
    private static SObjCacheService instance = new SObjCacheService();

    private SObjCacheService() {
        CacheConfigInfo localConfig = new CacheConfigInfo();
        localConfig.setMaxItemSize(500);
        localConfig.setTimeout(3600);
        localConfig.setMaxMemSize(100);
        this.lcache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, type, localConfig);
    }

    public static SObjCacheService getInstance() {
        return instance;
    }

    public void put(String key, String value) {
        this.lcache.put(key, (Object)value);
    }

    public String get(String key) {
        return (String)this.lcache.get(key);
    }

    public boolean contains(String key) {
        return this.lcache.contains(key);
    }

    public void remove(String key) {
        this.lcache.remove(new String[]{key});
    }
}

