/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.common;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.param.AppParam;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.util.OrgServiceUtil;

public class SystemParamUtil {
    private static final int DEF_SYNC_BATCH_SIZE = 1000;

    public static int getBatchSize() {
        return Integer.getInteger("dts.fulltext.init.batchsize", 1000);
    }

    public static Boolean gptEnable() {
        return SystemParamUtil.gptEnable(SystemParamUtil.queryHRSSSystemConfig());
    }

    public static Boolean gptEnable(Map<String, Object> systemConfig) {
        Object objVal = systemConfig.get("enablegpt");
        if (objVal instanceof Boolean) {
            return (Boolean)objVal;
        }
        return Boolean.FALSE;
    }

    public static String getGptType() {
        return SystemParamUtil.getGptType(SystemParamUtil.queryHRSSSystemConfig());
    }

    public static String getGptType(Map<String, Object> systemConfig) {
        Object objVal = systemConfig.get("radiogroupfield");
        if (objVal instanceof String) {
            return (String)objVal;
        }
        return null;
    }

    public static Map<String, Object> queryHRSSSystemConfig() {
        long orgId = RequestContext.get().getOrgId() == 0L ? OrgServiceUtil.getHRRootOrgId() : RequestContext.get().getOrgId();
        AppParam appParam = new AppParam("2K8WVB+D8QPE", Long.valueOf(orgId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
    }

    public static boolean useBosGpt() {
        Map<String, Object> systemConfig = SystemParamUtil.queryHRSSSystemConfig();
        if (SystemParamUtil.gptEnable(systemConfig).booleanValue()) {
            return "1".equals(SystemParamUtil.getGptType(systemConfig));
        }
        return false;
    }

    public static boolean useCustomerGpt() {
        Map<String, Object> systemConfig = SystemParamUtil.queryHRSSSystemConfig();
        if (SystemParamUtil.gptEnable(systemConfig).booleanValue()) {
            return "2".equals(SystemParamUtil.getGptType(systemConfig));
        }
        return false;
    }
}

