/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.datasync;

import java.sql.ResultSet;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.LockSupport;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dts.configoperator.DtsConfigOperatorInfo;
import kd.bos.dts.enmu.DtsDestTypeEnum;
import kd.bos.dts.init.DtsSnapConfigDao;
import kd.bos.dts.operator.DtsConfigOperatorImpl;
import kd.bos.dts.service.DtsConfigMonitor;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang.StringUtils;

public class DtsService {
    private static final Log LOGGER = LogFactory.getLog(DtsService.class);

    public static void saveDtsConfig(List<DtsConfigOperatorInfo> dtsConfigInfoList) {
        for (DtsConfigOperatorInfo dtsConfigInfo : dtsConfigInfoList) {
            DtsConfigOperatorImpl.checkParams((Object)dtsConfigInfo);
        }
        Date createTime = new Date();
        for (DtsConfigOperatorInfo dtsConfigInfo : dtsConfigInfoList) {
            DtsService.insertDataSyncConfig(dtsConfigInfo, createTime);
        }
        LOGGER.info("saveDtsConfig success");
        DtsConfigMonitor.get().queryAndSend();
    }

    private static void insertDataSyncConfig(DtsConfigOperatorInfo info, Date createTime) {
        long id = IDService.get().genLongId();
        String mappingRule = info.getMappingRule();
        if (mappingRule == null || "".equals(mappingRule.trim())) {
            mappingRule = " ";
        }
        String entityFields = StringUtils.join((Object[])info.getEntityFields(), (String)",");
        String sql = "insert into t_dts_datasyncconfig(fentitynumber,fdestinationtype,fregion,fbusinesstype,fmappingrule,fentityfields,fenable,ftimingsequence,fid,fcreatetime) values(?,?,?,?,?,?,?,?,?,?)";
        DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{info.getEntityNumber(), info.getDtsDestType().getCode(), info.getRegion(), info.getBusinessType(), mappingRule, entityFields, info.getEnable(), info.getTimingSequence(), id, createTime});
    }

    public static void disableDtsConfig(boolean enable, String businessType, String region, String mappingRule) {
        if (HRStringUtils.isEmpty((String)mappingRule)) {
            return;
        }
        String fulltextCode = DtsDestTypeEnum.FULLTEXT.getCode();
        String enableStr = enable ? "1" : "0";
        String sql = "update t_dts_datasyncconfig set fenable = ?  where fregion = ? and fbusinesstype = ? and fmappingrule= ? and fdestinationtype= ? ";
        DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{enableStr, region, businessType, mappingRule, fulltextCode});
        DtsConfigMonitor.get().queryAndSend();
    }

    public static void deleteDtsConfig(String mainEntityNumber, String businessType, String region, String mappingRule) {
        if (HRStringUtils.isEmpty((String)mappingRule)) {
            return;
        }
        String fulltextCode = DtsDestTypeEnum.FULLTEXT.getCode();
        String querySql = "select fid from t_dts_datasyncconfig where fregion = ? and fbusinesstype = ? and fmappingrule= ? and fdestinationtype= ? ";
        boolean existsData = (Boolean)HRDBUtil.query((DBRoute)DBRoute.basedata, (String)querySql, (Object[])new Object[]{region, businessType, mappingRule, fulltextCode}, ResultSet::next);
        LOGGER.info("deleteDtsConfig existsData:{}", (Object)existsData);
        if (existsData) {
            String sql = "delete from t_dts_datasyncconfig where fregion = ? and fbusinesstype = ? and fmappingrule= ? and fdestinationtype= ? ";
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{region, businessType, mappingRule, fulltextCode});
            DtsConfigMonitor.get().queryAndSend();
            LOGGER.info("deleteDtsConfig done:mappingRule{}", (Object)mappingRule);
            while (!DtsSnapConfigDao.instance.getDtsConfigChanged(mainEntityNumber, fulltextCode, region, mappingRule).isEmpty()) {
                LockSupport.parkNanos(2000000000L);
            }
            LOGGER.info("deleteDtsConfig success:mappingRule{}", (Object)mappingRule);
        }
    }
}

