/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.datasync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.model.Tuple2;
import kd.hr.hbp.business.service.query.es.EsPropertyValue;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.HRComplexObjConditionRow;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.common.ContextParseService;
import kd.hrmp.hrss.business.domain.search.service.datasync.EsSyncServiceHelper;
import kd.hrmp.hrss.business.domain.search.service.datasync.LabelLoadBo;
import kd.hrmp.hrss.business.domain.search.service.datasync.SyncParam;
import kd.hrmp.hrss.business.domain.search.service.datasync.SyncParamService;
import kd.hrmp.hrss.business.domain.search.service.query.SearchObjQueryService;
import org.apache.commons.collections.CollectionUtils;

public class EntityDataLoadService {
    private static final Log LOGGER = LogFactory.getLog(EntityDataLoadService.class);

    public static Map<String, Map<String, DynamicObject[]>> splitDataByMainEntity(HRComplexObjContext context, Map<String, DynamicObject[]> entityDyoArrMap) {
        DynamicObject[] mainEntityDyoArr;
        HashMap<String, Map<String, DynamicObject[]>> idEntityDataMap = new HashMap<String, Map<String, DynamicObject[]>>(16);
        String mainEntityNumber = context.getEntityNumber();
        for (DynamicObject mainEntityDyo : mainEntityDyoArr = entityDyoArrMap.get(mainEntityNumber)) {
            String mainEntityPk = mainEntityDyo.getString("id");
            HashMap<String, DynamicObject[]> entityDataMap = new HashMap<String, DynamicObject[]>(1);
            entityDataMap.put(mainEntityNumber, new DynamicObject[]{mainEntityDyo});
            for (HRComplexObjJoinRelation joinRelation : context.getJoinRelationList()) {
                String relEntityAlias = joinRelation.getRelEntityAlias();
                DynamicObject[] relEntityDyoArr = entityDyoArrMap.get(relEntityAlias);
                ArrayList<Tuple2> mulJoinOnDataList = new ArrayList<Tuple2>(10);
                for (HRComplexObjConditionRow conditionRow : joinRelation.getCondition()) {
                    String leftFieldNoPrefix;
                    if (relEntityDyoArr == null) break;
                    if (!conditionRow.isRightFieldItem()) continue;
                    String leftItem = conditionRow.getLeftItem();
                    String leftEntityAlias = ContextParseService.getRelEntityAlias(context, leftItem);
                    if (leftEntityAlias == null) {
                        leftFieldNoPrefix = leftItem;
                        leftEntityAlias = context.getEntityNumber();
                    } else {
                        leftFieldNoPrefix = leftItem.replaceFirst(leftEntityAlias + "\\.", "");
                    }
                    DynamicObject[] leftDyo = (DynamicObject[])entityDataMap.get(leftEntityAlias);
                    if (leftDyo == null) {
                        LOGGER.warn("splitDataByMainEntity left entity:{} data is null:", (Object)leftEntityAlias);
                        relEntityDyoArr = null;
                        continue;
                    }
                    String rightItem = conditionRow.getRightItem();
                    String rightEntityAlias = ContextParseService.getRelEntityAlias(context, rightItem);
                    String rightFieldNoPrefix = rightEntityAlias == null ? rightItem : rightItem.replaceFirst(rightEntityAlias + "\\.", "");
                    HashSet<String> filterStrSet = new HashSet<String>(4);
                    for (DynamicObject object : leftDyo) {
                        String filterVal = object.getString(leftFieldNoPrefix);
                        if (HRStringUtils.isEmpty((String)filterVal)) {
                            LOGGER.warn("splitDataByMainEntity join on is null, leftEntityAlias:{}, relEntityAlias:{}, leftItem:{}, leftFieldNoPrefix:{}, mainEntityPk:{}", new Object[]{leftEntityAlias, relEntityAlias, leftItem, leftFieldNoPrefix, mainEntityPk});
                            continue;
                        }
                        filterStrSet.add(filterVal);
                    }
                    if (CollectionUtils.isEmpty(filterStrSet)) {
                        relEntityDyoArr = null;
                        continue;
                    }
                    Tuple2 tuple2 = new Tuple2((Object)rightFieldNoPrefix, filterStrSet);
                    mulJoinOnDataList.add(tuple2);
                }
                if (relEntityDyoArr != null && mulJoinOnDataList.size() > 0) {
                    relEntityDyoArr = (DynamicObject[])((Stream)Arrays.stream(relEntityDyoArr).parallel()).filter(dyo -> {
                        boolean allMatch = true;
                        for (Tuple2 tuple2 : mulJoinOnDataList) {
                            String rightField = (String)tuple2.t1;
                            Set filterStrSet = (Set)tuple2.t2;
                            String rightValStr = dyo.getString(rightField);
                            boolean match = HRStringUtils.isNotEmpty((String)rightValStr) && filterStrSet.contains(rightValStr);
                            if (match) continue;
                            allMatch = false;
                            break;
                        }
                        return allMatch;
                    }).toArray(DynamicObject[]::new);
                }
                entityDataMap.put(relEntityAlias, relEntityDyoArr);
            }
            idEntityDataMap.put(mainEntityPk, entityDataMap);
        }
        return idEntityDataMap;
    }

    private static Map<String, LabelLoadBo> loadLabelData(Map<String, Map<Object, DynamicObject>> entityDyoPkMap, String mainEntityNumber, Map<String, String> relEntityMap, Map<String, LabelLoadBo> labelLoadBoMap) {
        entityDyoPkMap.forEach((entityAlias, pkDyoMap) -> {
            Set<Object> pkSet = pkDyoMap.keySet();
            String entityName = (String)relEntityMap.get(entityAlias);
            if (HRStringUtils.isEmpty((String)entityName)) {
                entityName = mainEntityNumber;
            }
            if (CollectionUtils.isNotEmpty(pkSet)) {
                LabelLoadBo labelLoadBo = new LabelLoadBo(entityName, (String)entityAlias);
                labelLoadBo.addAllPkVal(pkSet);
                labelLoadBoMap.put((String)entityAlias, labelLoadBo);
            }
        });
        HashMap<String, Integer> labelCountCache = new HashMap<String, Integer>(16);
        HashMap<String, List<Map<String, Object>>> labelResultListCache = new HashMap<String, List<Map<String, Object>>>(16);
        for (LabelLoadBo labelLoadBo : labelLoadBoMap.values()) {
            Map<Object, List<EsPropertyValue>> labelEsPropValMap = EsSyncServiceHelper.buildLabelEsPropertyValue(labelLoadBo.getEntityNumber(), labelLoadBo.getPkList(), labelCountCache, labelResultListCache);
            labelLoadBo.setEsDataMap(labelEsPropValMap);
        }
        return labelLoadBoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Map<String, DynamicObject[]>> loadSearchObjAllEntityDataMap(HRComplexObjContext context, Map<String, Set<String>> allNeedQueryFieldMap, List<Object> idList, Map<String, LabelLoadBo> labelLoadBoMap, Long searchObjId) {
        try {
            CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
            SyncParam syncParam = SyncParamService.querySyncParam(searchObjId);
            int relEntityLoadMaxSize = syncParam.getRelMaxLoadSize();
            HashMap<String, DynamicObject[]> entityDyoArrMap = new HashMap<String, DynamicObject[]>(16);
            String mainEntityNumber = context.getEntityNumber();
            long startTime = System.currentTimeMillis();
            idList = EntityDataLoadService.filterMainDataId(context, idList, mainEntityNumber);
            long idFilterTime = System.currentTimeMillis();
            LOGGER.info("SO_DTS_COSTbuildBatchValueNew idFilter time:{}", (Object)(idFilterTime - startTime));
            if (CollectionUtils.isEmpty(idList)) {
                Map<String, Map<String, DynamicObject[]>> map = null;
                return map;
            }
            Set<String> mainEntityFields = allNeedQueryFieldMap.get(mainEntityNumber);
            DynamicObject[] mainDyoArr = EntityDataLoadService.loadEntityData(mainEntityNumber, mainEntityNumber, mainEntityFields, new QFilter[]{new QFilter("id", "in", idList)}, relEntityLoadMaxSize);
            long mainDyoQueryTime = System.currentTimeMillis();
            LOGGER.info("SO_DTS_COSTbuildBatchValueNew mainDyoQuery time:{}", (Object)(mainDyoQueryTime - idFilterTime));
            if (mainDyoArr == null) {
                Map<String, Map<String, DynamicObject[]>> map = null;
                return map;
            }
            entityDyoArrMap.put(mainEntityNumber, mainDyoArr);
            List<HRComplexObjContext> splitContextList = ContextParseService.splitContextQueryPK(context, syncParam.getContextSplitSize());
            long startQueryRelPkTime = System.currentTimeMillis();
            Map<Object, Map<String, Set<Object>>> mainPkRelEntityPkMap = EntityDataLoadService.queryAllRelEntityPk(idList, splitContextList, syncParam.getJoinMaxLoadSize());
            long endQueryRelPkTime = System.currentTimeMillis();
            LOGGER.info("SO_DTS_COSTbuildBatchValueNew queryRelPk time:{}", (Object)(endQueryRelPkTime - startQueryRelPkTime));
            EntityDataLoadService.loadRelEntityDyoArrFullMap(context, allNeedQueryFieldMap, entityDyoArrMap, mainPkRelEntityPkMap, relEntityLoadMaxSize);
            long endQueryRelDataTime = System.currentTimeMillis();
            LOGGER.info("SO_DTS_COSTbuildBatchValueNew queryRelData time:{}", (Object)(endQueryRelDataTime - endQueryRelPkTime));
            HashMap<String, Map<Object, DynamicObject>> entityDyoPkMap = new HashMap<String, Map<Object, DynamicObject>>(entityDyoArrMap.size());
            entityDyoArrMap.forEach((entityAlias, renEntityDyoArr) -> {
                Map dyoPkMap = Arrays.stream(renEntityDyoArr).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (a, b) -> a));
                entityDyoPkMap.put((String)entityAlias, dyoPkMap);
            });
            Map<String, String> relEntityMap = context.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
            long startLoadLabel = System.currentTimeMillis();
            EntityDataLoadService.loadLabelData(entityDyoPkMap, mainEntityNumber, relEntityMap, labelLoadBoMap);
            long endLoadLabel = System.currentTimeMillis();
            LOGGER.info("SO_DTS_COSTbuildBatchValueNew loadLabel time:{}", (Object)(endLoadLabel - startLoadLabel));
            Map<String, Map<String, DynamicObject[]>> idEntityDataMap = EntityDataLoadService.entityDataJoin(mainEntityNumber, mainPkRelEntityPkMap, entityDyoPkMap);
            long endJoinDataTime = System.currentTimeMillis();
            LOGGER.info("SO_DTS_COSTbuildBatchValueNew joinAllData time:{}", (Object)(endJoinDataTime - endLoadLabel));
            Map<String, Map<String, DynamicObject[]>> map = idEntityDataMap;
            return map;
        }
        finally {
            CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
        }
    }

    private static Map<String, Map<String, DynamicObject[]>> entityDataJoin(String mainEntityNumber, Map<Object, Map<String, Set<Object>>> mainPkRelEntityPkMap, Map<String, Map<Object, DynamicObject>> entityDyoPkMap) {
        HashMap<String, Map<String, DynamicObject[]>> idEntityDataMap = new HashMap<String, Map<String, DynamicObject[]>>(16);
        mainPkRelEntityPkMap.forEach((mainEntityPk, relEntityPkMap) -> {
            HashMap<String, DynamicObject[]> relEntityDyoArrMap = new HashMap<String, DynamicObject[]>(16);
            relEntityPkMap.forEach((entityAlias, entityPkSet) -> {
                Map dyoPkMap = (Map)entityDyoPkMap.get(entityAlias);
                DynamicObject[] dyoArr = (DynamicObject[])entityPkSet.stream().map(dyoPkMap::get).toArray(DynamicObject[]::new);
                relEntityDyoArrMap.put((String)entityAlias, dyoArr);
            });
            Map dyoPkMap = (Map)entityDyoPkMap.get(mainEntityNumber);
            DynamicObject mainDyo = (DynamicObject)dyoPkMap.get(mainEntityPk);
            relEntityDyoArrMap.put(mainEntityNumber, new DynamicObject[]{mainDyo});
            idEntityDataMap.put(String.valueOf(mainEntityPk), relEntityDyoArrMap);
        });
        return idEntityDataMap;
    }

    private static void loadRelEntityDyoArrFullMap(HRComplexObjContext context, Map<String, Set<String>> allNeedQueryFieldMap, Map<String, DynamicObject[]> entityDyoArrMap, Map<Object, Map<String, Set<Object>>> mainPkRelEntityPkMap, int relEntityLoadMaxSize) {
        List joinRelationList = context.getJoinRelationList();
        for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
            String relEntityAlias = joinRelation.getRelEntityAlias();
            Set relEntityPkSet = mainPkRelEntityPkMap.values().stream().map(map -> (Set)map.get(relEntityAlias)).filter(pkS -> pkS != null && pkS.size() > 0).flatMap(Collection::stream).collect(Collectors.toSet());
            LOGGER.info("loadRelEntityData:relEntityAlias:{},idSize:{}", (Object)relEntityAlias, (Object)relEntityPkSet.size());
            if (relEntityPkSet.size() == 0) {
                LOGGER.warn("join Filter is Null joinRelation:{}", (Object)joinRelation);
                continue;
            }
            Set<String> relEntityFields = allNeedQueryFieldMap.get(relEntityAlias);
            long startTime = System.currentTimeMillis();
            if (relEntityPkSet.size() > relEntityLoadMaxSize) {
                throw new KDBizException("loadRelEntityData too big relEntityAlias:" + relEntityAlias + ",size:" + relEntityPkSet.size());
            }
            DynamicObject[] rightDyoArr = EntityDataLoadService.loadEntityData(joinRelation.getRelEntityNumber(), relEntityAlias, relEntityFields, new QFilter[]{new QFilter("id", "in", relEntityPkSet)}, relEntityLoadMaxSize);
            long endTime = System.currentTimeMillis();
            long cost = endTime - startTime;
            if (cost > 500L) {
                LOGGER.warn("loadRelEntityData timeout 500ms entityNumber:{}", (Object)joinRelation.getRelEntityNumber());
            }
            entityDyoArrMap.put(relEntityAlias, rightDyoArr);
        }
    }

    private static Map<Object, Map<String, Set<Object>>> queryAllRelEntityPk(List<Object> idList, List<HRComplexObjContext> splitContextList, int maxJoinSize) {
        HashMap<Object, Map<String, Set<Object>>> mainPkRelEntityPkMap = new HashMap<Object, Map<String, Set<Object>>>(idList.size());
        for (HRComplexObjContext complexObjContext : splitContextList) {
            List<Map<String, Object>> pkDataList = SearchObjQueryService.queryListMap(complexObjContext, idList, maxJoinSize);
            List joinRelationList = complexObjContext.getJoinRelationList();
            if (pkDataList == null || pkDataList.size() == 0) continue;
            for (Map<String, Object> dataMap : pkDataList) {
                Object mainPk = dataMap.get("id");
                HashMap<String, HashSet<Object>> relEntityPkMap = (HashMap<String, HashSet<Object>>)mainPkRelEntityPkMap.get(mainPk);
                if (relEntityPkMap == null) {
                    relEntityPkMap = new HashMap<String, HashSet<Object>>(16);
                }
                for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
                    String relEntityAlias = joinRelation.getRelEntityAlias();
                    Object relEntityId = dataMap.get(relEntityAlias + "." + "id");
                    if (Objects.isNull(relEntityId)) continue;
                    HashSet<Object> pkSet = (HashSet<Object>)relEntityPkMap.get(relEntityAlias);
                    if (pkSet == null) {
                        pkSet = new HashSet<Object>(16);
                    }
                    pkSet.add(relEntityId);
                    relEntityPkMap.put(relEntityAlias, pkSet);
                }
                mainPkRelEntityPkMap.put(mainPk, relEntityPkMap);
            }
            pkDataList.clear();
        }
        return mainPkRelEntityPkMap;
    }

    private static List<Object> filterMainDataId(HRComplexObjContext context, List<Object> idList, String mainEntityNumber) {
        try {
            Set<String> relEntityAliasSet = context.getJoinRelationList().stream().map(HRComplexObjJoinRelation::getRelEntityAlias).collect(Collectors.toSet());
            List qfilterList = context.getQfilterList();
            if (CollectionUtils.isNotEmpty((Collection)qfilterList) && ContextParseService.containMainFilter(relEntityAliasSet, qfilterList)) {
                LOGGER.info("filterMainDataId_ query mainentity data mainEntityNumber:{}, idList.size:{}", (Object)mainEntityNumber, (Object)idList.size());
                HRComplexObjContext idQueryContent = ContextParseService.optimizeRelEntity(context, qfilterList);
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
                qFilterList.addAll(qfilterList);
                qFilterList.add(new QFilter("id", "in", idList));
                idQueryContent.setQfilterList(qFilterList);
                if (idQueryContent.getJoinRelationList() == null) {
                    idQueryContent.setJoinRelationList(new ArrayList(0));
                }
                idList = SearchObjQueryService.queryFieldValues(idQueryContent);
                LOGGER.info("filterMainDataId_ query mainentity data end mainEntityNumber:{}, idList.size:{}", (Object)mainEntityNumber, (Object)idList.size());
            }
            return idList.stream().distinct().collect(Collectors.toList());
        }
        catch (Exception exception) {
            LOGGER.warn("filterMainDataId_ exception:", (Throwable)exception);
            return idList;
        }
    }

    private static DynamicObject[] loadEntityData(String entityNumber, String entityAlias, Set<String> mainEntityFields, QFilter[] qFilters, int loadSize) {
        if (qFilters == null || qFilters.length == 0) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        String fieldPrefix = entityAlias + ".";
        String prefixRegex = entityAlias + "\\.";
        String selectField = mainEntityFields.stream().map(field -> {
            if (field.startsWith(fieldPrefix)) {
                return field.replaceFirst(prefixRegex, "");
            }
            return field;
        }).collect(Collectors.joining(","));
        if (HRStringUtils.isEmpty((String)selectField)) {
            selectField = "id";
        }
        return serviceHelper.query(selectField, qFilters, "", loadSize);
    }
}

