/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.datasync;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.lang.Lang;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hrmp.hrss.business.domain.search.service.datasync.EsSynTask;

public class EsSynDataJobAndPlanService {
    private static final String jobNumberPrifix = "hrss_es_";
    private static final String planNumberPrifix = "hrss_es_";
    private static final DBRoute Sch_Route = DBRoute.basedata;

    protected static String getTaskClassName() {
        return EsSynTask.class.getName();
    }

    protected static String getNamePreFix() {
        return ResManager.loadKDString((String)"ES\u540c\u6b65\u65b9\u6848", (String)"EsSynDataJobAndPlanService_0", (String)"hrmp-hrss-business", (Object[])new Object[0]);
    }

    public static void fixedTimeRelease(Map<String, Object> jobParam, Date fixedTime) {
        String name = (String)jobParam.get("name");
        String jobNumber = "hrss_es_" + String.valueOf(jobParam.get("recordId"));
        String planNumber = "hrss_es_" + String.valueOf(jobParam.get("recordId"));
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        String jobId = UUID.randomUUID().toString();
        jobInfo.setAppId("hrss");
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setTaskClassname(EsSynDataJobAndPlanService.getTaskClassName());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setName(EsSynDataJobAndPlanService.getNamePreFix() + "job_" + name);
        jobInfo.setId(jobId);
        jobInfo.setNumber(jobNumber);
        jobInfo.setEnable(true);
        jobInfo.setParams(jobParam);
        ScheduleServiceHelper.createJob((JobInfo)jobInfo);
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(jobId);
        planInfo.setNumber(planNumber);
        planInfo.setName(EsSynDataJobAndPlanService.getNamePreFix() + "plan_" + name);
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(fixedTime);
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(fixedTime);
        endTime.add(5, 1);
        planInfo.setStartTime(startTimeCalendar);
        planInfo.setEndTime(endTime);
        ScheduleServiceHelper.createPlan((PlanInfo)planInfo);
    }

    public static void deleteJobAndPlanByQueryEntityName(String queryNumber, String recordId) {
        String planNumber = "hrss_es_" + queryNumber.concat("_").concat(recordId);
        EsSynDataJobAndPlanService.deleteJobAndPlan(planNumber);
    }

    public static void deleteJobAndPlan(String planNumber) {
        Map<String, List<String>> map = EsSynDataJobAndPlanService.getJobAndPlanIds(planNumber);
        if (map == null) {
            return;
        }
        List<String> listJobId = map.get("jobId");
        List<String> listScheduleId = map.get("scheduleId");
        ScheduleServiceHelper scheduleServiceHelper = new ScheduleServiceHelper();
        if (!CollectionUtils.isEmpty(listJobId)) {
            for (String jobId : listJobId) {
                ScheduleServiceHelper.deleteJob((String)jobId);
            }
        }
        if (!CollectionUtils.isEmpty(listScheduleId)) {
            for (String scheduleId : listScheduleId) {
                ScheduleService.getInstance().getObjectFactory().getScheduleDao().disableSchedule(scheduleId);
                ScheduleServiceHelper.deletePlan((String)scheduleId);
            }
        }
    }

    private static Map<String, List<String>> getJobAndPlanIds(String planNumber) {
        String sql = "SELECT FID,FJOBID FROM T_SCH_SCHEDULE WHERE fnumber = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":fnumber", 12, (Object)planNumber)};
        final HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        final ArrayList listJobId = new ArrayList();
        final ArrayList listScheduleId = new ArrayList();
        map.put("jobId", listJobId);
        map.put("scheduleId", listScheduleId);
        DB.query((DBRoute)Sch_Route, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, List<String>>>(){

            public Map<String, List<String>> handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    listScheduleId.add(rs.getString("FID"));
                    listJobId.add(rs.getString("FJOBID"));
                }
                return map;
            }
        });
        return map;
    }
}

