/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.datasync;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.query.es.EsDataType;
import kd.hr.hbp.business.service.query.es.EsPropertyValue;
import kd.hr.hbp.business.service.smartsearch.EsQueryFactory;
import kd.hr.hbp.business.service.smartsearch.EsQueryService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.common.HRContextCache;
import kd.hrmp.hrss.business.domain.search.service.datasync.LabelSgtService;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjDataSyncService;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjDataTransService;
import kd.hrmp.hrss.business.domain.search.service.query.LabelService;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;
import kd.hrmp.hrss.common.enums.EnumDataChangeType;
import kd.hrmp.hrss.common.model.searchobj.SchObjJoinEntity;

public class EsSyncServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(EsSyncServiceHelper.class);
    private static String HRCS_ESSYNRECORD = "hrss_essynrecord";
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HRCS_ESSYNRECORD);

    public static String getStatusById(Long id) {
        DynamicObject object = serviceHelper.queryOriginalOne("status", (Object)id);
        return object.getString("status");
    }

    public static DynamicObject load(Long pkid) {
        return serviceHelper.loadSingle((Object)pkid);
    }

    public static Object saveOne(DynamicObject dobj) {
        return serviceHelper.saveOne(dobj);
    }

    public static void deleteOne(Long id) {
        serviceHelper.deleteOne((Object)id);
    }

    public static boolean isExists(Long pkid) {
        return serviceHelper.isExists((Object)pkid);
    }

    public static void updateSynStatus(Long recordId, String status) {
        DynamicObject record = EsSyncServiceHelper.load(recordId);
        record.set("synstatus", (Object)status);
        EsSyncServiceHelper.saveOne(record);
    }

    public static Map<Object, List<EsPropertyValue>> buildLabelEsPropertyValue(String entityNumber, List ids, Map<String, Integer> labelCountCache, Map<String, List<Map<String, Object>>> labelResultListCache) {
        Map labelObjectRes = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSLabelService", (String)"queryLabelObjectsByEntityNumber", (Object[])new Object[]{entityNumber});
        boolean success = (Boolean)labelObjectRes.get("success");
        if (!success) {
            throw new KDBizException((String)labelObjectRes.get("msg"));
        }
        ArrayList resultList = (ArrayList)labelObjectRes.get("resultList");
        HashMap labelAndLabelObjMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap labelNameMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap labelTypeMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map stringObjectMap : resultList) {
            ArrayList labelList;
            Object labels = stringObjectMap.get("labels");
            Long labelObjectId = (Long)stringObjectMap.get("labelObjectId");
            if (labels == null || CollectionUtils.isEmpty((Collection)(labelList = (ArrayList)labels))) continue;
            for (Map objectMap : labelList) {
                Long labelId = (Long)objectMap.get("labelId");
                Map labelName = (Map)objectMap.get("labelName");
                String labelType = (String)objectMap.get("labelType");
                if (labelId == null || labelId == 0L || CollectionUtils.isEmpty((Map)labelName)) continue;
                Set orDefault = labelAndLabelObjMap.getOrDefault(labelId, Sets.newHashSetWithExpectedSize((int)16));
                orDefault.add(labelObjectId);
                labelAndLabelObjMap.put(labelId, orDefault);
                labelNameMap.put(labelId, labelName.get("GLang"));
                labelTypeMap.put(labelId, labelType);
            }
        }
        ArrayList allResultList = Lists.newArrayListWithCapacity((int)16);
        for (Map.Entry entry : labelAndLabelObjMap.entrySet()) {
            Long key = (Long)entry.getKey();
            Set labelObjIds = (Set)entry.getValue();
            for (Long labelObjId : labelObjIds) {
                HashMap filters = Maps.newHashMapWithExpectedSize((int)16);
                filters.put("pkIds", ids);
                String cacheKey = labelObjId + "_" + key + ids.toString();
                Integer labelCount = labelCountCache.get(cacheKey);
                if (labelCount == null) {
                    labelCount = LabelService.getLabelResultCount(labelObjId, key, filters);
                    labelCountCache.put(cacheKey, labelCount);
                }
                if (labelCount == 0) continue;
                ArrayList labelResultList = labelResultListCache.get(cacheKey);
                if (labelResultList == null) {
                    Map<String, Object> getLabelResult = LabelService.getLabelResult(labelObjId, key, (Map<String, Object>)filters, 0, 1100);
                    boolean labelResult = (Boolean)getLabelResult.get("success");
                    if (!labelResult) {
                        throw new KDBizException((String)labelObjectRes.get("msg"));
                    }
                    labelResultList = (ArrayList)getLabelResult.get("resultList");
                }
                LOGGER.info("buildLabelEsPropertyValue getLabelResult resultList={}", labelResultList);
                allResultList.addAll(labelResultList);
            }
        }
        return EsSyncServiceHelper.bizidGroup(allResultList, labelNameMap, labelTypeMap);
    }

    private static Map<Object, List<EsPropertyValue>> bizidGroup(ArrayList<Map<String, Object>> labelResultList, HashMap<Long, String> labelNameMap, HashMap<Long, String> labelTypeMap) {
        Map<Object, List<Map>> idGroupMap = labelResultList.stream().collect(Collectors.groupingBy(labelResult -> labelResult.get("id")));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Object, List<Map>> group : idGroupMap.entrySet()) {
            List<Map> value = group.getValue();
            Object key = group.getKey();
            ArrayList allLabels = Lists.newArrayListWithCapacity((int)16);
            for (Map stringObjectMap : value) {
                ArrayList labels = (ArrayList)stringObjectMap.get("labels");
                Object labelObjectId = stringObjectMap.get("labelObjectId");
                for (Map label : labels) {
                    label.put("labelObjectId", labelObjectId);
                    allLabels.add(label);
                }
            }
            Map<Object, List<Map>> labelIdGroup = allLabels.stream().collect(Collectors.groupingBy(allLabel -> allLabel.get("labelId")));
            ArrayList esPropertyValues = Lists.newArrayListWithCapacity((int)16);
            HashSet<String> allLabelFields = new HashSet<String>(16);
            for (Map.Entry entry : labelIdGroup.entrySet()) {
                List labelGroupList = (List)entry.getValue();
                Object labelId = entry.getKey();
                String labelKey = "label_" + labelId.toString();
                allLabelFields.add(labelKey);
                EsPropertyValue singleEsPropVal = new EsPropertyValue(labelKey, EsDataType.NESTED, null);
                ArrayList<EsPropertyValue> singleLableEsPropList = new ArrayList<EsPropertyValue>(10);
                EsPropertyValue labelNameProperty = new EsPropertyValue("labelName", (Object)labelNameMap.get(labelId));
                singleLableEsPropList.add(labelNameProperty);
                EsPropertyValue labelTypeProperty = new EsPropertyValue("labelType", (Object)labelTypeMap.get(labelId));
                singleLableEsPropList.add(labelTypeProperty);
                Set labelObjectIds = labelGroupList.stream().map(labelGroupMap -> labelGroupMap.get("labelObjectId")).collect(Collectors.toSet());
                EsPropertyValue labelObjectIdsProperty = new EsPropertyValue("labelObjectIds", labelObjectIds);
                singleLableEsPropList.add(labelObjectIdsProperty);
                ArrayList labelValuesResutl = Lists.newArrayListWithCapacity((int)16);
                ArrayList labelValuePksResult = Lists.newArrayListWithCapacity((int)16);
                ArrayList labelValuePkNameResult = Lists.newArrayListWithCapacity((int)16);
                for (Map label : labelGroupList) {
                    String type = (String)label.get("type");
                    Object labelValName = null;
                    if (HRStringUtils.equals((String)"10", (String)type)) {
                        labelValName = label.get("labelValueName");
                    } else if (HRStringUtils.equals((String)"20", (String)type)) {
                        labelValName = label.get("labelBizValue");
                    }
                    labelValuesResutl.add(labelValName);
                    Object labelValueId = label.get("labelValueId");
                    labelValuePksResult.add(labelValueId);
                    labelValuePkNameResult.add(labelValueId + "," + labelValName);
                }
                EsPropertyValue labelValuesProperty = new EsPropertyValue("labelValues", (Object)labelValuesResutl);
                EsPropertyValue labelValuePksProperty = new EsPropertyValue("labelValuePks", (Object)labelValuePksResult);
                EsPropertyValue labelValuePkNameProperty = new EsPropertyValue("labelValuePkNames", (Object)labelValuePkNameResult);
                singleLableEsPropList.add(labelValuesProperty);
                singleLableEsPropList.add(labelValuePksProperty);
                singleLableEsPropList.add(labelValuePkNameProperty);
                singleEsPropVal.nests.add(singleLableEsPropList);
                esPropertyValues.add(singleEsPropVal);
            }
            EsPropertyValue allLabelKeys = new EsPropertyValue("all_label_keys", allLabelFields);
            esPropertyValues.add(allLabelKeys);
            resultMap.put(key, esPropertyValues);
        }
        LOGGER.info("bizidGroup={}", (Object)resultMap);
        return resultMap;
    }

    public static void labelSynESByLastUpdateTime(String mqFlag, Long labelIdByMq, Long labelObjectIdByMq) {
        DynamicObject[] query;
        Date currentDate = new Date();
        HRBaseServiceHelper searchObjectHelper = new HRBaseServiceHelper("hrss_searchobject");
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        DynamicObject[] synRecords = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("synstatus", "=", (Object)"3")});
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrss_essyntimerecord");
        HashSet searchObjIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject synRecord : synRecords) {
            DynamicObject searchObDyna;
            DynamicObject schemeDy = synRecord.getDynamicObject("essyncschemeid");
            if (schemeDy == null || (searchObDyna = schemeDy.getDynamicObject("searchobj")) == null) continue;
            searchObjIdSet.add((Long)searchObDyna.getPkValue());
        }
        for (DynamicObject searchObj : query = searchObjectHelper.query(new QFilter[]{new QFilter("id", "in", (Object)searchObjIdSet)})) {
            List<SchObjJoinEntity> joinEntities = SearchObjectService.getInstance().queryAndAssembleJoinEntities((Long)searchObj.getPkValue());
            Optional<SchObjJoinEntity> mainEntityBo = joinEntities.stream().filter(entity -> HRStringUtils.equals((String)entity.getType(), (String)"main")).findFirst();
            if (!mainEntityBo.isPresent()) continue;
            String mainEntityNumber = mainEntityBo.get().getEntityNumber();
            if (SearchObjDataSyncService.getInstance().isFullSync(searchObj.getString("number"), mainEntityNumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5168\u91cf\u540c\u6b65\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"EsSyncServiceHelper_0", (String)"hrmp-hrss-business", (Object[])new Object[0]));
            }
            EsQueryService esQuery = EsQueryFactory.getEsQuery((String)"hr");
            if (esQuery == null) {
                throw new KDBizException("Init EsQueryService fail");
            }
            List<SchObjJoinEntity> schObjJoinEntities = SearchObjectService.getInstance().queryAndAssembleJoinEntities((Long)searchObj.getPkValue());
            for (SchObjJoinEntity schObjJoinEntity : schObjJoinEntities) {
                Object stringObjectMap2;
                Map gptLabelResult;
                boolean success;
                boolean searchTarget = schObjJoinEntity.isSearchTarget();
                if (!searchTarget) continue;
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)schObjJoinEntity.getEntityNumber());
                DataTypeEnum dataType = dataEntityType.getPrimaryKey().getPropertyType() == String.class ? DataTypeEnum.STRING : DataTypeEnum.LONG;
                DynamicObject[] lastUpdateTimeRecord = baseServiceHelper.query("lastupdatetime", new QFilter[]{new QFilter("searchobjid", "=", searchObj.getPkValue()), new QFilter("entitynumber", "=", (Object)schObjJoinEntity.getEntityAlias())}, "lastupdatetime desc");
                Date lastupdatetime = null;
                if (lastUpdateTimeRecord != null && lastUpdateTimeRecord.length > 0) {
                    lastupdatetime = lastUpdateTimeRecord[0].getDate("lastupdatetime");
                }
                if (!(success = ((Boolean)(gptLabelResult = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSLabelService", (String)"queryLabelObjectsByEntityNumber", (Object[])new Object[]{schObjJoinEntity.getEntityNumber()})).get("success")).booleanValue())) {
                    throw new KDBizException((String)gptLabelResult.get("msg"));
                }
                ArrayList resultList = (ArrayList)gptLabelResult.get("resultList");
                LOGGER.info("queryLabelObjectsByEntityNumber resultList={}", (Object)resultList);
                ArrayList allLabels = Lists.newArrayListWithCapacity((int)16);
                for (Object stringObjectMap2 : resultList) {
                    Object labels = stringObjectMap2.get("labels");
                    Object labelObjectId = stringObjectMap2.get("labelObjectId");
                    if (labels == null) continue;
                    ArrayList labelList = (ArrayList)labels;
                    for (Map objectMap : labelList) {
                        objectMap.put("labelObjectId", labelObjectId);
                        allLabels.add(objectMap);
                    }
                }
                Map<Object, List<Map>> labelIdGroup = allLabels.stream().collect(Collectors.groupingBy(allLabel -> allLabel.get("labelId")));
                stringObjectMap2 = labelIdGroup.entrySet().iterator();
                while (stringObjectMap2.hasNext()) {
                    Map.Entry labelIdGroupEntry = (Map.Entry)stringObjectMap2.next();
                    List labelGroupList = (List)labelIdGroupEntry.getValue();
                    Long labelId = (Long)labelIdGroupEntry.getKey();
                    for (Map stringObjectMap3 : labelGroupList) {
                        Long labelObjectId = (Long)stringObjectMap3.get("labelObjectId");
                        HashMap filters = Maps.newHashMapWithExpectedSize((int)16);
                        if (lastupdatetime != null) {
                            filters.put("lastUpdateTime", lastupdatetime);
                        }
                        int labelCount = 0;
                        if (HRStringUtils.equals((String)"1", (String)mqFlag)) {
                            if (!labelIdByMq.equals(labelId) || !labelObjectIdByMq.equals(labelObjectId)) continue;
                            labelCount = LabelService.getLabelResultCount(labelObjectId, labelId, null);
                            LOGGER.info("getLabelResultCount from mq ={}", (Object)labelCount);
                            if (labelCount == 0) continue;
                            EsSyncServiceHelper.doEsUpateRecursion(0, labelCount, lastupdatetime, labelObjectId, labelId, schObjJoinEntity, searchObj.getString("number"), dataType, mqFlag, labelIdByMq, labelObjectIdByMq, null);
                            continue;
                        }
                        labelCount = LabelService.getLabelResultCount(labelObjectId, labelId, filters);
                        LOGGER.info("getLabelResultCount ={}", (Object)labelCount);
                        if (labelCount == 0) continue;
                        EsSyncServiceHelper.doEsUpateRecursion(0, labelCount, lastupdatetime, labelObjectId, labelId, schObjJoinEntity, searchObj.getString("number"), dataType, mqFlag, labelIdByMq, labelObjectIdByMq, null);
                    }
                }
                if (!HRStringUtils.equals((String)"1", (String)mqFlag)) {
                    DynamicObject dynamicObject = baseServiceHelper.generateEmptyDynamicObject();
                    dynamicObject.set("searchobjid", searchObj.getPkValue());
                    dynamicObject.set("entitynumber", (Object)schObjJoinEntity.getEntityAlias());
                    dynamicObject.set("lastupdatetime", (Object)currentDate);
                    baseServiceHelper.saveOne(dynamicObject);
                }
                LOGGER.info("labelSynESByLastUpdateTime end & start-syncLbSgtDataByTread");
                HRComplexObjContext complexObjContext = HRContextCache.getComplexObjContext(searchObj.getLong("id"));
                LabelSgtService.syncLbSgtDataByTread(complexObjContext, searchObj.getLong("id"));
            }
        }
    }

    private static void doEsUpateRecursion(int start, int count, Date lastupdatetime, Long labelObjectId, Long labelId, SchObjJoinEntity schObjJoinEntity, String searchObjNumber, DataTypeEnum dataType, String mqFlag, Long labelIdByMq, Long labelObjectIdByMq, Object[] objSortValues) {
        try {
            boolean isSuccess;
            HashMap filters = Maps.newHashMapWithExpectedSize((int)16);
            if (lastupdatetime != null) {
                filters.put("lastUpdateTime", lastupdatetime);
            }
            Map<Object, Object> getLabelResult = Maps.newHashMapWithExpectedSize((int)16);
            if (HRStringUtils.equals((String)"1", (String)mqFlag) ? labelIdByMq.equals(labelId) && labelObjectIdByMq.equals(labelObjectId) && !(isSuccess = ((Boolean)(getLabelResult = LabelService.getLabelResult(labelObjectId, labelId, null, 5000, objSortValues)).get("success")).booleanValue()) : !(isSuccess = ((Boolean)(getLabelResult = LabelService.getLabelResult(labelObjectId, labelId, (Map<String, Object>)filters, 5000, objSortValues)).get("success")).booleanValue())) {
                throw new KDBizException((String)getLabelResult.get("msg"));
            }
            ArrayList labelResultList = (ArrayList)getLabelResult.get("resultList");
            LOGGER.info("getLabelResult resultList={}", (Object)labelResultList);
            Map<Object, List<Map>> idGroupMap = labelResultList.stream().collect(Collectors.groupingBy(labelResult -> labelResult.get("id")));
            Set<Object> businessIds = idGroupMap.keySet();
            if (dataType.getDataTypeKey().equals(DataTypeEnum.STRING.getDataTypeKey())) {
                HashSet strBusinessId = Sets.newHashSetWithExpectedSize((int)16);
                for (Object businessId : businessIds) {
                    strBusinessId.add(String.valueOf(businessId));
                }
                SearchObjDataTransService.deltaUpdateDate(searchObjNumber, schObjJoinEntity.getEntityNumber(), EnumDataChangeType.LABEL_UPDATE.getType(), new ArrayList<Object>(strBusinessId));
            } else {
                HashSet longBusinessId = Sets.newHashSetWithExpectedSize((int)16);
                for (Object businessId : businessIds) {
                    longBusinessId.add(Long.valueOf((String)businessId));
                }
                SearchObjDataTransService.deltaUpdateDate(searchObjNumber, schObjJoinEntity.getEntityNumber(), EnumDataChangeType.LABEL_UPDATE.getType(), new ArrayList<Object>(longBusinessId));
            }
            Object objSortValuesObj = getLabelResult.get("objSortValues");
            Object[] curSortValObjArr = null;
            if (objSortValuesObj != null && objSortValuesObj.getClass().isArray()) {
                curSortValObjArr = (Object[])objSortValuesObj;
            }
            LOGGER.info("getLabelResult curSortValObjArr={}", curSortValObjArr);
            if (count > start + 5000) {
                EsSyncServiceHelper.doEsUpateRecursion(start + 5000, count, lastupdatetime, labelObjectId, labelId, schObjJoinEntity, searchObjNumber, dataType, mqFlag, labelIdByMq, labelObjectIdByMq, curSortValObjArr);
            }
        }
        catch (Exception exception) {
            LOGGER.error("doEsUpateRecursion error", (Throwable)exception);
            throw exception;
        }
    }
}

