/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.datasync;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hrmp.hrss.business.domain.search.service.common.HRContextCache;
import kd.hrmp.hrss.business.domain.search.service.datasync.LabelSgtService;

public class LabelSgtDataSyncTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(LabelSgtDataSyncTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("LabelSgtDataSyncTask task ===========");
        try {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrss_searchobject");
            DynamicObject[] searchObjectDyoArr = serviceHelper.queryOriginalArray("id", null);
            if (searchObjectDyoArr == null) {
                return;
            }
            for (DynamicObject dynamicObject : searchObjectDyoArr) {
                long searchObjPk = dynamicObject.getLong("id");
                try {
                    LOGGER.info("LabelSgtDataSyncTask start-syncLbSgtDataByTread searchObjId:{}", (Object)searchObjPk);
                    HRComplexObjContext complexObjContext = HRContextCache.getComplexObjContext(searchObjPk);
                    LabelSgtService.syncLbSgtData(complexObjContext, searchObjPk, true);
                }
                catch (Exception exception) {
                    LOGGER.info("LabelSgtDataSyncTask single exception searchObjId:{}", (Object)searchObjPk);
                }
            }
            LOGGER.info("LabelSgtDataSyncTask task end==============");
        }
        catch (Exception exception) {
            LOGGER.error("LabelSgtDataSyncTask exception ", (Throwable)exception);
        }
    }
}

