/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.datasync;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.query.es.EsBatchValue;
import kd.hr.hbp.business.service.query.es.EsContext;
import kd.hr.hbp.business.service.query.es.EsDataType;
import kd.hr.hbp.business.service.query.es.EsMappingProperty;
import kd.hr.hbp.business.service.query.es.EsPropertyValue;
import kd.hr.hbp.business.service.query.es.EsTokenizerType;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.common.enums.smartsearch.SearchTargetTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.query.BosEsErrorCode;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFieldBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchRangFieldBo;
import kd.hr.hbp.common.model.smartsearch.search.LabelValCompParam;
import kd.hr.hbp.common.model.smartsearch.search.LabelValCompResp;
import kd.hr.hbp.common.util.EsCommonUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.common.AnalyzerUtil;
import kd.hrmp.hrss.business.domain.search.service.common.HRContextCache;
import kd.hrmp.hrss.business.domain.search.service.common.LabelFieldUtil;
import kd.hrmp.hrss.business.domain.search.service.common.LangUtil;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjEsOperateService;
import kd.hrmp.hrss.business.domain.search.service.es.SmartSearchEsEsStorage;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;
import kd.hrmp.hrss.common.constants.datasync.LabelSuggestConstants;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;

public class LabelSgtService {
    private static final Log LOGGER = LogFactory.getLog(LabelSgtService.class);

    public static String getSgtIndexName(Long searchObjId) {
        String indexName = EsCommonUtils.getAISearchIndexAliasName((String)"hr", (Long)searchObjId);
        return indexName + "_lbsgt";
    }

    public static List<LabelValCompResp> labelCompletion(LabelValCompParam compParam) {
        LabelSgtService.checkParamAndQueryField(compParam);
        Long searchObjId = compParam.getSearchObjId();
        SmartSearchEsEsStorage esEsStorage = new SmartSearchEsEsStorage();
        String sgtIndexName = LabelSgtService.getSgtIndexName(searchObjId);
        if (!esEsStorage.isIndexExist(sgtIndexName).booleanValue()) {
            LOGGER.warn("labelCompletion fail index:{} not exists", (Object)sgtIndexName);
            return Collections.emptyList();
        }
        List<SearchFieldBo> labelFieldList = SearchObjectService.getInstance().queryAllLabelFieldsFromCache(searchObjId);
        if (CollectionUtils.isEmpty(labelFieldList)) {
            LOGGER.info("labelCompletion fail not exists labelField, searchObject:{}", (Object)searchObjId);
            return Collections.emptyList();
        }
        List<String> contexts = LabelSgtService.findSearchFieldList(compParam, searchObjId, labelFieldList);
        if (CollectionUtils.isEmpty(contexts)) {
            LOGGER.info("labelCompletion fail not exists labelField, compParam:{}", (Object)compParam);
            return Collections.emptyList();
        }
        List<LabelValCompResp> respList = LabelSgtService.lbSuggest(compParam, esEsStorage, sgtIndexName, contexts);
        int compSize = respList.size();
        if (compSize < compParam.getSize()) {
            int querySize = compParam.getSize() - compSize;
            LabelSgtService.compByLike(compParam, esEsStorage, sgtIndexName, contexts, respList, querySize);
        }
        return respList;
    }

    private static List<LabelValCompResp> lbSuggest(LabelValCompParam compParam, SmartSearchEsEsStorage esEsStorage, String sgtIndexName, List<String> contexts) {
        ArrayList<String> retHitField = new ArrayList<String>(1);
        retHitField.add("label_val_id");
        retHitField.add("label_key");
        List<Map<String, Object>> suggest = esEsStorage.suggest(sgtIndexName, "label_val_name", "labelkey_completion", compParam.getInputText(), contexts, retHitField, compParam.getSize());
        ArrayList<LabelValCompResp> respList = new ArrayList<LabelValCompResp>(10);
        for (Map<String, Object> dataMap : suggest) {
            LabelValCompResp resp = new LabelValCompResp();
            resp.setDisplayName((String)dataMap.get("text"));
            resp.setLabelValKey(Long.valueOf((String)dataMap.get("label_val_id")));
            String fieldAlias = (String)dataMap.get("label_key");
            resp.setFieldAlias(fieldAlias);
            resp.setLabelFilterProp(fieldAlias);
            respList.add(resp);
        }
        return respList;
    }

    private static List<String> findSearchFieldList(LabelValCompParam compParam, Long searchObjId, List<SearchFieldBo> labelFieldList) {
        List<String> contexts;
        List<String> allLabelFieldList = labelFieldList.stream().filter(SearchFieldBo::isLabelField).map(SearchFieldBo::getFieldAlias).collect(Collectors.toList());
        SearchTargetTypeEnum searchTargetType = compParam.getSearchTargetType();
        if (searchTargetType == null) {
            contexts = allLabelFieldList;
        } else {
            contexts = new ArrayList<String>(10);
            List searchRangFieldList = compParam.getSearchRangFieldList();
            Set searchRangNumber = searchRangFieldList.stream().map(SearchRangFieldBo::getRangeNumber).collect(Collectors.toSet());
            if (searchTargetType == SearchTargetTypeEnum.ENTITY) {
                Map<String, String> relEntityMap = HRContextCache.getRelEntityMapFromCache(searchObjId);
                for (String entityAlias : searchRangNumber) {
                    String relEntityNumber = relEntityMap.get(entityAlias);
                    boolean mainField = HRStringUtils.isEmpty((String)relEntityNumber);
                    for (String labelField : allLabelFieldList) {
                        String[] split = labelField.split("\\.");
                        if (mainField && relEntityMap.containsKey(split[0])) {
                            contexts.add(labelField);
                            continue;
                        }
                        if (mainField || !split[0].equals(entityAlias)) continue;
                        contexts.add(labelField);
                    }
                }
            } else {
                for (String fieldAlias : searchRangNumber) {
                    if (!LabelFieldUtil.isLabelField(fieldAlias)) continue;
                    contexts.add(fieldAlias);
                }
            }
        }
        return contexts;
    }

    private static void compByLike(LabelValCompParam compParam, SmartSearchEsEsStorage esEsStorage, String sgtIndexName, List<String> contexts, List<LabelValCompResp> respList, int querySize) {
        LOGGER.info("compByLike query, indexName:{}, querySize:{}", (Object)sgtIndexName, (Object)querySize);
        Set labelValKeySet = respList.stream().map(LabelValCompResp::getLabelValKey).collect(Collectors.toSet());
        String[] queryFieldArr = LabelSuggestConstants.ALL_LBSGT_FIELD;
        ArrayList<EsFilterField> filterList = new ArrayList<EsFilterField>(10);
        EsFilterField esFilter = new EsFilterField(null, "label_val_name_text", "like", new Object[]{"%" + compParam.getInputText() + "%"});
        filterList.add(esFilter);
        EsFilterField rangeFilter = new EsFilterField(null, "label_key", "in", contexts.toArray());
        filterList.add(rangeFilter);
        if (CollectionUtils.isNotEmpty(labelValKeySet)) {
            EsFilterField labelValFilter = new EsFilterField(null, "label_val_id", "not in", labelValKeySet.toArray());
            filterList.add(labelValFilter);
        }
        QueryBuilder queryBuilder = esEsStorage.buidQueryBuilder(filterList);
        SearchResponse search = esEsStorage.search(sgtIndexName, queryFieldArr, queryBuilder, 0, querySize);
        SearchObjEsOperateService esOperateService = new SearchObjEsOperateService();
        List<Map<String, Object>> resultList = esOperateService.getHighLightResult(Arrays.asList(queryFieldArr), search);
        HashSet<String> cache = new HashSet<String>(16);
        for (Map<String, Object> dataMap : resultList) {
            String labelValPk = (String)dataMap.get("label_val_id");
            if (cache.contains(labelValPk)) continue;
            LabelValCompResp resp = new LabelValCompResp();
            resp.setDisplayName((String)dataMap.get("label_val_name_text"));
            resp.setLabelValKey(Long.valueOf((String)dataMap.get("label_val_id")));
            String fieldAlias = (String)dataMap.get("label_key");
            resp.setFieldAlias(fieldAlias);
            resp.setLabelFilterProp(fieldAlias);
            respList.add(resp);
            cache.add(labelValPk);
        }
    }

    private static void checkParamAndQueryField(LabelValCompParam compParam) {
        if (HRStringUtils.isEmpty((String)compParam.getInputText())) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u8054\u60f3\u6587\u672c", (String)"LabelSgtService_0", (String)"hrmp-hrss-business", (Object[])new Object[0])});
        }
        if (!SearchObjectService.getInstance().isExistsSearchObj(compParam.getSearchObjId())) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u641c\u7d22\u5bf9\u8c61\u914d\u7f6e\u9519\u8bef", (String)"LabelSgtService_1", (String)"hrmp-hrss-business", (Object[])new Object[0])});
        }
    }

    private static String getLockPath(Long searchObjectId) throws KDException {
        String index = (String)EsCommonUtils.getServerConfig((String)"hr").get("index");
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        if (StringUtils.isEmpty((String)accountId)) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{"getAccountIdtr error:" + accountId});
        }
        StringBuilder sbPath = new StringBuilder(index);
        sbPath.append("/");
        if (!StringUtils.isEmpty((String)tenantId)) {
            sbPath.append(tenantId);
            sbPath.append("/");
        }
        sbPath.append(accountId.replace("/", ""));
        sbPath.append("/labelsuggestdatasync/");
        sbPath.append(searchObjectId);
        return sbPath.toString().toLowerCase();
    }

    public static void syncLbSgtDataByTread(HRComplexObjContext complexObjContext, Long searchObjId) {
        LOGGER.info("LBSGT_asyncLbSgtData,searchObjId:{}", (Object)searchObjId);
        String traceId = RequestContext.get().getTraceId();
        ThreadPools.executeOnce((String)"LBSGT_asyncLbSgtData", () -> {
            LOGGER.info("LBSGT_asyncLbSgtData trigger-traceId:{}", (Object)traceId);
            String lockKey = LabelSgtService.getLockPath(searchObjId) + "_lock";
            DLock lock = DLock.create((String)lockKey);
            try {
                boolean locked = lock.tryLock();
                if (!locked) {
                    throw new KDBizException("LBSGT_asyncLbSgtData get lock fail!");
                }
                LOGGER.info("LBSGT_asyncLbSgtData start param:[searchObjId:{}, complexObjContext:{}]", (Object)searchObjId, (Object)complexObjContext);
                LabelSgtService.syncLbSgtData(complexObjContext, searchObjId, false);
                LOGGER.info("LBSGT_asyncLbSgtData success param:[searchObjId:{}]", (Object)searchObjId);
            }
            finally {
                try {
                    lock.unlock();
                }
                catch (Exception ignore) {
                    LOGGER.error("LBSGT_asyncLbSgtData lock.unlock()_exception: {}", (Object)CommonUtil.getStackTrace((Exception)ignore));
                }
            }
        });
    }

    public static void syncLbSgtData(HRComplexObjContext complexObjContext, Long searchObjId, boolean reSetIndex) {
        LOGGER.info("LBSGT_asyncLbSgtData start run ,searchObjId:{}", (Object)searchObjId);
        List<SearchFieldBo> labelFieldList = SearchObjectService.getInstance().queryAllLabelFields(searchObjId, false);
        if (CollectionUtils.isEmpty(labelFieldList)) {
            LOGGER.info("LBSGT_asyncLbSgtData label field is Empty: searchObjId{}", (Object)searchObjId);
            return;
        }
        SmartSearchEsEsStorage esEsStorage = new SmartSearchEsEsStorage();
        String srcDataIndexName = EsCommonUtils.getAISearchIndexAliasName((String)"hr", (Long)searchObjId);
        if (!esEsStorage.isIndexExist(srcDataIndexName).booleanValue()) {
            LOGGER.info("LBSGT_asyncLbSgtData srcDataIndexName:{} not exists: searchObjId{}", (Object)srcDataIndexName, (Object)searchObjId);
            return;
        }
        String sgtIndexName = LabelSgtService.getSgtIndexName(searchObjId);
        LabelSgtService.createSgtIndex(esEsStorage, sgtIndexName, reSetIndex);
        Set<String> relEntityAliasSet = complexObjContext.getJoinRelationList().stream().map(HRComplexObjJoinRelation::getRelEntityAlias).collect(Collectors.toSet());
        for (SearchFieldBo searchFieldBo : labelFieldList) {
            if (!searchFieldBo.isLabelField()) continue;
            String fieldAlias = searchFieldBo.getFieldAlias();
            LabelSgtService.syncSignleLabelSgtData(esEsStorage, sgtIndexName, srcDataIndexName, relEntityAliasSet, fieldAlias);
        }
    }

    private static void syncSignleLabelSgtData(SmartSearchEsEsStorage esEsStorage, String sgtIndexName, String srcDataIndexName, Set<String> relEntityAliasSet, String fieldAlias) {
        LOGGER.info("syncSignleLabelSgtData start: fieldAlias:{}, sgtIndexName:{}", (Object)fieldAlias, (Object)sgtIndexName);
        try {
            String[] split = fieldAlias.split("\\.");
            String nestPath = null;
            if (relEntityAliasSet.contains(split[0])) {
                nestPath = split[0];
            }
            String labelValNameKeyword = fieldAlias + "." + "labelValuePkNames";
            List<String> distinctFieldList = Collections.singletonList(labelValNameKeyword);
            List<Map<String, Object>> dataList = esEsStorage.distinctComposite(srcDataIndexName, nestPath, distinctFieldList, false);
            ArrayList<EsFilterField> listEsFilterField = new ArrayList<EsFilterField>();
            EsFilterField esFilterField = new EsFilterField(null, "label_key", "=", new Object[]{fieldAlias});
            listEsFilterField.add(esFilterField);
            List<EsBatchValue> esBatchValues = LabelSgtService.buildBatchValue(fieldAlias, dataList, labelValNameKeyword);
            LOGGER.info("syncSignleLabelSgtData-delete data sgtIndexName:{}, filter:{}", (Object)sgtIndexName, listEsFilterField);
            esEsStorage.deleteByQuery(sgtIndexName, "t_data", listEsFilterField);
            if (CollectionUtils.isEmpty(esBatchValues)) {
                return;
            }
            LOGGER.info("syncSignleLabelSgtData-batchSave data sgtIndexName:{}, size:{}", (Object)sgtIndexName, (Object)esBatchValues.size());
            esEsStorage.batchSave(sgtIndexName, "t_data", esBatchValues.toArray(new EsBatchValue[0]));
            LOGGER.info("syncSignleLabelSgtData end: fieldAlias:{}, sgtIndexName:{}", (Object)fieldAlias, (Object)sgtIndexName);
        }
        catch (Exception exception) {
            LOGGER.error("syncSignleLabelSgtData exception:", (Throwable)exception);
        }
    }

    private static List<EsBatchValue> buildBatchValue(String labelFieldAlias, List<Map<String, Object>> dataList, String dataKey) {
        ArrayList<EsBatchValue> batchValueList = new ArrayList<EsBatchValue>(10);
        long[] longs = IDService.get().genLongIds(dataList.size());
        Queue longQueue = LongStream.of(longs).boxed().collect(Collectors.toCollection(ArrayDeque::new));
        for (Map<String, Object> dataMap : dataList) {
            ArrayList<EsPropertyValue> esPropValues = new ArrayList<EsPropertyValue>(10);
            String dataVal = String.valueOf(dataMap.get(dataKey));
            if (dataVal == null || !dataVal.contains(",")) continue;
            int index = dataVal.indexOf(",");
            String id = dataVal.substring(0, index);
            String value = dataVal.substring(index + 1);
            EsPropertyValue labelKeyProp = new EsPropertyValue("label_key", (Object)labelFieldAlias);
            esPropValues.add(labelKeyProp);
            EsPropertyValue labelPkProp = new EsPropertyValue("label_val_id", (Object)id);
            esPropValues.add(labelPkProp);
            EsPropertyValue labelNameProp = new EsPropertyValue("label_val_name", (Object)value);
            esPropValues.add(labelNameProp);
            EsPropertyValue labelNameTextProp = new EsPropertyValue("label_val_name_text", (Object)value);
            esPropValues.add(labelNameTextProp);
            EsBatchValue batchValue = new EsBatchValue(longQueue.poll(), esPropValues.toArray(new EsPropertyValue[0]));
            batchValueList.add(batchValue);
        }
        return batchValueList;
    }

    public static void createSgtIndex(SmartSearchEsEsStorage esEsStorage, String sgtIndexName, boolean reSetIndex) {
        if (esEsStorage.isIndexExist(sgtIndexName).booleanValue()) {
            if (reSetIndex) {
                esEsStorage.deleteIndex(sgtIndexName);
            } else {
                return;
            }
        }
        try {
            esEsStorage.createIndex("hr", sgtIndexName, null);
        }
        catch (ElasticsearchStatusException e) {
            LOGGER.error("createSgtIndex es mapping exception: {}", (Object)CommonUtil.getStackTrace((Exception)((Object)e)));
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efaES\u7d22\u5f15\u62a5\u9519,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SearchObjEsOperateService_0", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        LOGGER.info("es createIndex, indexName:{}", (Object)sgtIndexName);
        List<EsMappingProperty> esPropList = LabelSgtService.buildLbSgtMapping();
        esEsStorage.addMappingIndex(sgtIndexName, "t_data", "strict", esPropList.toArray(new EsMappingProperty[0]));
    }

    private static List<EsMappingProperty> buildLbSgtMapping() {
        ArrayList<EsMappingProperty> esMappingPropertyList = new ArrayList<EsMappingProperty>(10);
        EsMappingProperty labelKeyProp = new EsMappingProperty("label_key", EsDataType.KEYWORD);
        esMappingPropertyList.add(labelKeyProp);
        EsMappingProperty labelValNameTextProp = new EsMappingProperty("label_val_name_text", EsDataType.TEXT);
        AnalyzerUtil.fitAnalyzer(labelValNameTextProp);
        esMappingPropertyList.add(labelValNameTextProp);
        EsMappingProperty labelValIdProp = new EsMappingProperty("label_val_id", EsDataType.LONG);
        esMappingPropertyList.add(labelValIdProp);
        Set<String> enableLangNums = LangUtil.getEnableLangNums();
        for (String langNum : enableLangNums) {
            esMappingPropertyList.add(LabelSgtService.genLabelCompletionProp("label_val_name_l." + langNum));
        }
        esMappingPropertyList.add(LabelSgtService.genLabelCompletionProp("label_val_name"));
        return esMappingPropertyList;
    }

    private static EsMappingProperty genLabelCompletionProp(String fieldName) {
        ArrayList<EsContext> esContextList = new ArrayList<EsContext>(1);
        EsContext esContext = new EsContext();
        esContext.setName("labelkey_completion");
        esContext.setPath("label_key");
        esContext.setType("category");
        esContextList.add(esContext);
        EsMappingProperty mappingProp = new EsMappingProperty(fieldName, EsDataType.COMPLETION);
        mappingProp.setTokenizerType(EsTokenizerType.KEYWORD);
        mappingProp.setSearchTokenizerType(EsTokenizerType.KEYWORD);
        mappingProp.setEsContextList(esContextList);
        return mappingProp;
    }
}

