/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.datasync;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.service.complexobj.util.FieldFullPathParseUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.util.QueryEntityUtil;

public class SearchObjContextParseService {
    public static void parseSelectField(HRComplexObjContext context, Set<String> mainProps, Set<String> nestProps) {
        List joinRelationList = context.getJoinRelationList();
        Map<String, String> relEntityMap = joinRelationList.stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        String mainEntityNumber = context.getEntityNumber();
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        for (HRComplexObjFieldInfo fieldInfo : context.getComplexObjFieldInfoList()) {
            MainEntityType relationEntityType;
            String entityNumber;
            String fieldAlias = fieldInfo.getAlias();
            boolean mainFlags = false;
            String entityAlias = FieldFullPathParseUtil.getFieldEntityAlias(relEntityMap, (String)fieldAlias);
            if (entityAlias == null) {
                entityAlias = mainEntityNumber;
                entityNumber = mainEntityNumber;
                mainFlags = true;
            } else {
                entityNumber = relEntityMap.get(entityAlias);
            }
            try {
                relationEntityType = mainEntityTypeUtil.getMainEntityType(entityNumber);
            }
            catch (Exception ex) {
                throw new KDBizException("Read entity meta data from cache error! entity name: " + entityNumber);
            }
            IDataEntityProperty joinProperty = SearchObjContextParseService.transBaseDataToId(mainEntityTypeUtil, relationEntityType, fieldAlias);
            if (joinProperty instanceof BasedataProp) {
                fieldAlias = fieldAlias + ".id";
            }
            if (mainFlags) {
                mainProps.add(fieldAlias);
                continue;
            }
            if (!fieldAlias.contains(entityAlias)) {
                fieldAlias = entityAlias + "." + fieldAlias;
            }
            nestProps.add(fieldAlias);
        }
        mainProps.remove(null);
        nestProps.remove(null);
        mainProps.add("id");
        for (String relEntityAlias : relEntityMap.keySet()) {
            nestProps.add(relEntityAlias + ".id");
        }
    }

    private static IDataEntityProperty transBaseDataToId(MainEntityTypeUtil mainEntityTypeUtil, MainEntityType entityType, String property) {
        String[] split;
        String propertyStrCopy = property;
        String entityTypeName = entityType.getName();
        if (propertyStrCopy.startsWith(entityTypeName + ".")) {
            propertyStrCopy = propertyStrCopy.replace(entityTypeName + ".", "");
        }
        if (1 > (split = propertyStrCopy.split("\\.")).length || split.length > 4) {
            return null;
        }
        if (split.length == 1) {
            return entityType.getProperty(split[0]);
        }
        DynamicProperty bdProp = entityType.getProperty(split[0]);
        if (bdProp instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)bdProp;
            String newProp = propertyStrCopy.replace(split[0] + ".", "");
            return SearchObjContextParseService.transBaseDataToId(mainEntityTypeUtil, mainEntityTypeUtil.getMainEntityType(basedataProp.getBaseEntityId()), newProp);
        }
        return bdProp;
    }

    public String transferBaseData(MainEntityType entityType, String property, boolean isMapping) {
        IDataEntityProperty joinProperty = QueryEntityUtil.findProperty((MainEntityType)entityType, (String)property);
        if (joinProperty instanceof IComplexProperty) {
            property = joinProperty.getName() + (isMapping ? ".id" : "_id");
        }
        return property;
    }
}

