/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.datasync;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.dts.configoperator.DtsConfigOperator;
import kd.bos.dts.configoperator.DtsConfigOperatorFactory;
import kd.bos.dts.configoperator.DtsConfigOperatorInfo;
import kd.bos.dts.enmu.DtsDestTypeEnum;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.util.EsCommonUtils;
import kd.hrmp.hrss.business.domain.search.service.common.DataSyncCheckUtil;
import kd.hrmp.hrss.business.domain.search.service.common.HRContextCache;
import kd.hrmp.hrss.business.domain.search.service.datasync.DtsService;
import kd.hrmp.hrss.business.domain.search.service.datasync.IDtsDataSyncService;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjDtsBusinessType;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjEsOperateService;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class SearchObjDataSyncService
implements IDtsDataSyncService {
    private static final Log LOGGER = LogFactory.getLog(SearchObjDataSyncService.class);
    private static volatile SearchObjDataSyncService instance = null;

    private SearchObjDataSyncService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchObjDataSyncService getInstance() {
        if (instance != null) return instance;
        Class<SearchObjDataSyncService> clazz = SearchObjDataSyncService.class;
        synchronized (SearchObjDataSyncService.class) {
            if (instance != null) return instance;
            instance = new SearchObjDataSyncService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public int startFullSync(Long searchObjId, String searchObjNumber, Long synRecordId) throws KDBizException {
        long startTime = System.currentTimeMillis();
        LOGGER.info("SS_DTS_SFS searchObjId:{},searchObjNumber:{},startTime:{}", new Object[]{searchObjId, searchObjNumber, startTime});
        if (!DataSyncCheckUtil.esServiceConfig()) {
            throw new KDBizException("elasticsearch.server.hr the fulltext service is not configured");
        }
        if (!DataSyncCheckUtil.dtsEnable()) {
            throw new KDBizException("DTS not enabled");
        }
        if (!DataSyncCheckUtil.checkEsAnalyzer()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5ES\u670d\u52a1\u5668\u662f\u5426\u5b89\u88c5ik_smart\uff0cik_max_word\u5206\u8bcd\u5668\u3002", (String)"SearchObjDataSyncService_3", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        HRComplexObjContext context = HRContextCache.getComplexObjContext(searchObjId);
        if (context == null) {
            throw new KDBizException("search object error");
        }
        if (this.isFullSync(searchObjNumber, context.getEntityNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5168\u91cf\u540c\u6b65\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"SearchObjDataSyncService_2", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        String mappingRule = this.getMappingRule(searchObjNumber);
        String businessType = this.getBusinessTypeCode();
        String lockKey = EsCommonUtils.getLockPath((String)"hr", (String)searchObjNumber) + "_lock";
        DLock lock = DLock.create((String)lockKey);
        try {
            boolean locked = lock.tryLock();
            if (!locked) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5168\u91cf\u540c\u6b65\u4e2d\uff0c\u65e0\u6cd5\u83b7\u53d6\u9501\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"SearchObjDataSyncService_1", (String)"hrmp-hrss-business", (Object[])new Object[0]));
            }
            SearchObjEsOperateService esCreateMapping = new SearchObjEsOperateService();
            String indexName = EsCommonUtils.getSearchObjEsIndexName((String)"hr", (Long)searchObjId, (Long)synRecordId);
            esCreateMapping.createMapping(context, indexName);
            LOGGER.info("SS_DTS_SFS create Mapping success,indexName:{}", (Object)indexName);
            this.saveDtsConfig(mappingRule, businessType, context);
            LOGGER.info("SS_DTS_SFS dts config save success,mappingRule:{}", (Object)mappingRule);
        }
        catch (KDBizException e) {
            LOGGER.error("SS_DTS_SFS_exception: ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("SS_DTS_SFS_exception:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65ES\u6570\u636e\u62a5\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SearchObjDataSyncService_0", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        finally {
            try {
                lock.unlock();
            }
            catch (Exception ignore) {
                LOGGER.error("SS_DTS_SFS lock.unlock()_exception: {}", (Object)CommonUtil.getStackTrace((Exception)ignore));
            }
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("SS_DTS_SFS searchObjNumber:{}, total time:{} ms", (Object)searchObjNumber, (Object)(endTime - startTime));
        return 0;
    }

    @Override
    public boolean isFullSync(String searchObjNumber, String mainEntityName) {
        String mappingRule = this.getMappingRule(searchObjNumber);
        DtsConfigOperator dtsConfigOperator = DtsConfigOperatorFactory.getDefault();
        LOGGER.info("check full sync ,mainEntityName:{}, mappingRule:{}", (Object)mainEntityName, (Object)mappingRule);
        return dtsConfigOperator.isFullSync(mainEntityName, "hr", DtsDestTypeEnum.FULLTEXT.getCode(), mappingRule);
    }

    @Override
    public void stopIncrement(String searchObjNumber, String mainEntityName) {
        String mappingRule = this.getMappingRule(searchObjNumber);
        String businessType = this.getBusinessTypeCode();
        LOGGER.info("deleteDtsConfig:mappingRule:{}", (Object)mappingRule);
        DtsService.disableDtsConfig(false, businessType, "hr", mappingRule);
    }

    @Override
    public void deleteDtsConfig(String searchObjNumber, String mainEntityName) {
        String mappingRule = this.getMappingRule(searchObjNumber);
        String businessType = this.getBusinessTypeCode();
        LOGGER.info("deleteDtsConfig:mappingRule:{}", (Object)mappingRule);
        DtsService.deleteDtsConfig(mainEntityName, businessType, "hr", mappingRule);
    }

    private String getBusinessTypeCode() {
        SearchObjDtsBusinessType dtsBusinessType = new SearchObjDtsBusinessType();
        return dtsBusinessType.getBusinessTypeCode();
    }

    private void saveDtsConfig(String mappingRule, String businessType, HRComplexObjContext context) {
        String mainEntityNumber = context.getEntityNumber();
        LOGGER.info("deleteDtsConfig:mappingRule:{}", (Object)mappingRule);
        DtsService.deleteDtsConfig(mainEntityNumber, businessType, "hr", mappingRule);
        Map<String, Set<String>> entityFieldMap = this.getQueryEntitySelectFileds(context);
        ArrayList<DtsConfigOperatorInfo> configOperatorInfoList = new ArrayList<DtsConfigOperatorInfo>(10);
        entityFieldMap.forEach((entityNumber, fieldSet) -> {
            DtsConfigOperatorInfo dtsConfOpInfo = this.getDtsConfigOperatorInfo((String)entityNumber, mappingRule, businessType, (Set<String>)fieldSet);
            if (dtsConfOpInfo != null) {
                configOperatorInfoList.add(dtsConfOpInfo);
            }
        });
        LOGGER.info("saveDtsConfig:mappingRule:{}", (Object)mappingRule);
        DtsService.saveDtsConfig(configOperatorInfoList);
    }

    private Map<String, Set<String>> getQueryEntitySelectFileds(HRComplexObjContext context) {
        HashMap entityFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        Map<String, String> relEntityAliasMap = context.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        HashSet setSelectField = Sets.newHashSetWithExpectedSize((int)10);
        List complexObjFieldInfoList = context.getComplexObjFieldInfoList();
        for (HRComplexObjFieldInfo fieldInfo : complexObjFieldInfoList) {
            String fieldAlias = fieldInfo.getAlias();
            String[] aliasArr = fieldAlias.split("\\.");
            fieldAlias = aliasArr.length >= 2 && relEntityAliasMap.containsKey(aliasArr[0]) ? aliasArr[0] + "." + aliasArr[1] : aliasArr[0];
            setSelectField.add(fieldAlias);
        }
        HashSet dealFieldSet = Sets.newHashSetWithExpectedSize((int)10);
        relEntityAliasMap.forEach((relEntityAlias, relEntityNumber) -> {
            MainEntityType entityType = mainEntityTypeUtil.getMainEntityType(relEntityNumber);
            DataEntityPropertyCollection dataEntityPropertyCollection = entityType.getProperties();
            HashSet<String> entityFieldSet = (HashSet<String>)entityFieldMap.get(relEntityNumber);
            if (entityFieldSet == null) {
                entityFieldSet = new HashSet<String>(10);
            }
            entityFieldSet.add(entityType.getPrimaryKey().getName());
            String prex = relEntityAlias + ".";
            Map propertyMap = dataEntityPropertyCollection.stream().collect(Collectors.toMap(IMetadata::getName, Function.identity()));
            for (String fieldAlias : setSelectField) {
                if (!fieldAlias.startsWith(prex)) continue;
                dealFieldSet.add(fieldAlias);
                fieldAlias = fieldAlias.replace(prex, "");
                IDataEntityProperty dataEntityProperty = (IDataEntityProperty)propertyMap.get(fieldAlias);
                entityFieldSet.add(dataEntityProperty.getName());
            }
            entityFieldMap.put(relEntityNumber, entityFieldSet);
        });
        setSelectField.removeAll(dealFieldSet);
        String mainEntityName = context.getEntityNumber();
        MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(mainEntityName);
        DataEntityPropertyCollection mainDataEntityPropertyCollection = mainEntityType.getProperties();
        HashSet<String> entityFieldSet = (HashSet<String>)entityFieldMap.get(mainEntityName);
        if (entityFieldSet == null) {
            entityFieldSet = new HashSet<String>(16);
        }
        Map mainPropertyMap = mainDataEntityPropertyCollection.stream().collect(Collectors.toMap(IMetadata::getName, Function.identity()));
        for (String fieldAlias : setSelectField) {
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)mainPropertyMap.get(fieldAlias);
            entityFieldSet.add(dataEntityProperty.getName());
        }
        entityFieldMap.put(mainEntityName, entityFieldSet);
        return entityFieldMap;
    }

    private String getMappingRule(String searchObjPkStr) {
        return String.format(Locale.ROOT, "hrsearchobjmapping#searchObjNumber=%s", searchObjPkStr);
    }

    private DtsConfigOperatorInfo getDtsConfigOperatorInfo(String entityName, String mappingRule, String businessType, Set<String> entityFieldSet) {
        if (entityFieldSet == null) {
            return null;
        }
        DtsConfigOperatorInfo info = new DtsConfigOperatorInfo();
        info.setRegion("hr");
        info.setEntityFields(entityFieldSet.toArray(new String[0]));
        info.setMappingRule(mappingRule);
        info.setEnable("1");
        info.setDtsDestType(DtsDestTypeEnum.FULLTEXT);
        info.setEntityNumber(entityName);
        info.setBusinessType(businessType);
        info.setTimingSequence("");
        return info;
    }
}

