/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.datasync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.query.es.EsBatchValue;
import kd.hr.hbp.business.service.query.es.EsDataType;
import kd.hr.hbp.business.service.query.es.EsPropertyValue;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.query.BosEsErrorCode;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFieldBo;
import kd.hr.hbp.common.util.EsCommonUtils;
import kd.hrmp.hrss.business.domain.search.service.common.ContextParseService;
import kd.hrmp.hrss.business.domain.search.service.common.FieldParseUtil;
import kd.hrmp.hrss.business.domain.search.service.common.HRContextCache;
import kd.hrmp.hrss.business.domain.search.service.common.LocalCacheMrg;
import kd.hrmp.hrss.business.domain.search.service.common.SystemParamUtil;
import kd.hrmp.hrss.business.domain.search.service.datasync.EntityDataLoadService;
import kd.hrmp.hrss.business.domain.search.service.datasync.LabelLoadBo;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjDataSyncService;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjEsOperateService;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjSyncConfService;
import kd.hrmp.hrss.business.domain.search.service.query.SearchObjQueryService;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;
import kd.hrmp.hrss.common.enums.EnumDataChangeType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class SearchObjDataTransService {
    private static final Log LOGGER = LogFactory.getLog(SearchObjDataTransService.class);

    private static List<List<Object>> splitListIntoChunks(List<Object> originalList, int chunkSize) {
        ArrayList<List<Object>> chunks = new ArrayList<List<Object>>(10);
        for (int i = 0; i < originalList.size(); i += chunkSize) {
            chunks.add(originalList.subList(i, Math.min(originalList.size(), i + chunkSize)));
        }
        return chunks;
    }

    public static void deltaUpdateDate(String searchObjNumber, String entityName, String dataChangeType, List<Object> idList) {
        int batchSize = SystemParamUtil.getBatchSize();
        LOGGER.info("DATA_SYNC dts.fulltext.init.batchsize:{}", (Object)batchSize);
        if (idList.size() <= batchSize) {
            SearchObjDataTransService.deltaUpdateDateByChunk(searchObjNumber, entityName, dataChangeType, idList);
        } else {
            List<List<Object>> chunks = SearchObjDataTransService.splitListIntoChunks(idList, batchSize);
            LOGGER.info("DATA_SYNC splitListIntoChunks param:[searchObjNumber:{},entityName:{},dataChangeType:{},chunks:{}]", new Object[]{searchObjNumber, entityName, dataChangeType, chunks.size()});
            for (List<Object> chunkIdList : chunks) {
                LOGGER.info("DATA_SYNC deltaUpdateDateByChunk param:[searchObjNumber:{},entityName:{},dataChangeType:{},chunks:{}]", new Object[]{searchObjNumber, entityName, dataChangeType, chunkIdList.size()});
                SearchObjDataTransService.deltaUpdateDateByChunk(searchObjNumber, entityName, dataChangeType, chunkIdList);
            }
        }
    }

    private static void deltaUpdateDateByChunk(String searchObjNumber, String entityName, String dataChangeType, List<Object> idList) {
        SearchObjectService searchObjectService = SearchObjectService.getInstance();
        Long searchObjId = searchObjectService.getSearchObjId(searchObjNumber);
        HRComplexObjContext context = HRContextCache.getComplexObjContext(searchObjId);
        if (context == null) {
            throw new KDBizException("HRComplexObjContext is null");
        }
        List<Object> docIdList = SearchObjDataTransService.getDocIds(context, searchObjId, entityName, dataChangeType, idList);
        if (CollectionUtils.isEmpty(docIdList)) {
            return;
        }
        SearchObjEsOperateService esOperateService = new SearchObjEsOperateService();
        if (EnumDataChangeType.LABEL_UPDATE.getType().equals(dataChangeType)) {
            SearchObjDataTransService.checkAndMappingLabelField(searchObjId, esOperateService);
        }
        if (EnumDataChangeType.DELETE.getType().equals(dataChangeType) && entityName.equals(context.getEntityNumber())) {
            esOperateService.deleteDataByMainEntityId(searchObjId, docIdList);
        } else {
            List<EsBatchValue> batchValueList = SearchObjDataTransService.buildBatchValueNew(context, docIdList, searchObjId);
            esOperateService.deleteDataByMainEntityId(searchObjId, docIdList);
            esOperateService.batchSave(searchObjId, null, batchValueList);
        }
    }

    private static void checkAndMappingLabelField(Long searchObjId, SearchObjEsOperateService esOperateService) {
        List<SearchFieldBo> labelFieldList = SearchObjectService.getInstance().queryAllLabelFields(searchObjId, false);
        if (CollectionUtils.isEmpty(labelFieldList)) {
            // empty if block
        }
        List allLabelFieldList = labelFieldList.stream().filter(SearchFieldBo::isLabelField).map(SearchFieldBo::getFieldAlias).collect(Collectors.toList());
        Map<String, String> relEntityAliasMap = SearchObjectService.getInstance().queryRelEntityAliasMap(searchObjId);
        HashMap<String, Set<String>> pathFieldMap = new HashMap<String, Set<String>>(16);
        for (String fieldAlias : allLabelFieldList) {
            HashSet<String> fieldSet;
            String[] split = fieldAlias.split("\\.");
            String path = null;
            String labelField = fieldAlias;
            if (relEntityAliasMap.containsKey(split[0])) {
                path = split[0];
                labelField = labelField.replaceFirst(path + "\\.", "");
            }
            if ((fieldSet = (HashSet<String>)pathFieldMap.get(path)) == null) {
                fieldSet = new HashSet<String>(16);
            }
            fieldSet.add(labelField);
            pathFieldMap.put(path, fieldSet);
        }
        if (MapUtils.isEmpty(pathFieldMap)) {
            return;
        }
        Map<String, Set<String>> notExistsFieldMap = esOperateService.findNotExistsField(searchObjId, pathFieldMap);
        if (MapUtils.isEmpty(notExistsFieldMap)) {
            return;
        }
        LOGGER.info("LABEL_UPDATE start add Label Field Mapping:{}", notExistsFieldMap);
        esOperateService.addLabelMapping(searchObjId, notExistsFieldMap);
        LocalCacheMrg.clearSObjCache(searchObjId);
    }

    public static void batchImportData(String searchObjNumber, List<Object> idList) {
        List<EsBatchValue> batchValueList;
        Long searchObjId = SearchObjectService.getInstance().getSearchObjId(searchObjNumber);
        HRComplexObjContext context = HRContextCache.getComplexObjContext(searchObjId);
        Long synRecordId = null;
        try {
            synRecordId = SearchObjSyncConfService.queryAndStartSync(searchObjId);
            if (synRecordId == null && SearchObjDataSyncService.getInstance().isFullSync(searchObjNumber, context.getEntityNumber())) {
                LOGGER.warn("batchImportData isFullSync but not exists synRecord : searchObjNumber:{}", (Object)searchObjNumber);
                throw new KDBizException("isFullSync_not_exists_synRecord");
            }
            long startTime = System.currentTimeMillis();
            LOGGER.info("batchImportData start searchObjNumber:{},synRecordId:{}datasize:{}", new Object[]{searchObjNumber, synRecordId, idList.size()});
            batchValueList = SearchObjDataTransService.buildBatchValueNew(context, idList, searchObjId);
            long genDataTime = System.currentTimeMillis();
            LOGGER.info("SO_DTS_COSTbatchImportData buildBatchValueNew searchObjNumber:{}, time:{}", (Object)searchObjNumber, (Object)(genDataTime - startTime));
            SearchObjEsOperateService esOperateService = new SearchObjEsOperateService();
            esOperateService.batchSave(searchObjId, synRecordId, batchValueList);
            LOGGER.info("SO_DTS_COSTbatchImportData sync es searchObjNumber:{},synRecordId:{},time:{}", new Object[]{searchObjNumber, synRecordId, System.currentTimeMillis() - genDataTime});
        }
        catch (Exception exception) {
            LOGGER.error("DTS_batchImportData fail", (Throwable)exception);
            SearchObjDataTransService.excpStopSync(synRecordId, exception.getMessage(), searchObjNumber, context.getEntityNumber());
            throw exception;
        }
        if (batchValueList != null && batchValueList.size() > 0 && synRecordId != null) {
            int addDataSize = batchValueList.size();
            LOGGER.info("syncAddSyncCount searchObjNumber:{},addData:{},FID:{}", new Object[]{searchObjNumber, addDataSize, synRecordId});
            SearchObjDataTransService.syncAddSyncCount(synRecordId, addDataSize, searchObjNumber);
        }
    }

    public static String getLockPath(String searchObjNumber, Long synRecordId) throws KDException {
        String index = (String)EsCommonUtils.getServerConfig((String)"hr").get("index");
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        if (StringUtils.isEmpty((String)accountId)) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{"getAccountIdtr error:" + accountId});
        }
        StringBuilder sbPath = new StringBuilder(index);
        sbPath.append("/");
        if (!StringUtils.isEmpty((String)tenantId)) {
            sbPath.append(tenantId);
            sbPath.append("/");
        }
        sbPath.append(accountId.replace("/", ""));
        sbPath.append("/searchobjsync/");
        sbPath.append(searchObjNumber);
        sbPath.append("/").append(synRecordId);
        return sbPath.toString().toLowerCase();
    }

    private static void syncAddSyncCount(Long synRecordId, int addDataSize, String searchObjNumber) {
        LOGGER.info("DTS_batchImportData syncAddSyncCount param:[synRecordId:{}, addDataSize:{}]", (Object)synRecordId, (Object)addDataSize);
        String traceId = RequestContext.get().getTraceId();
        ThreadPools.executeOnce((String)"batchImportData_syncAddSyncCount_DTS", () -> {
            LOGGER.info("batchImportData_syncAddSyncCount_DTS trigger-traceId:{}", (Object)traceId);
            String lockKey = SearchObjDataTransService.getLockPath(searchObjNumber, synRecordId) + "_lock";
            DLock lock = DLock.create((String)lockKey);
            try {
                boolean locked = lock.tryLock();
                if (!locked) {
                    throw new KDBizException("syncAddSyncCount get lock fail!");
                }
                LOGGER.info("batchImportData_syncAddSyncCount_DTS start param:[synRecordId:{}, addDataSize:{}]", (Object)synRecordId, (Object)addDataSize);
                SearchObjSyncConfService.addSyncDataCount(synRecordId, addDataSize);
                LOGGER.info("batchImportData_syncAddSyncCount_DTS success param:[synRecordId:{}, addDataSize:{}]", (Object)synRecordId, (Object)addDataSize);
            }
            finally {
                try {
                    lock.unlock();
                }
                catch (Exception ignore) {
                    LOGGER.error("batchImportData_syncAddSyncCount_DTS lock.unlock()_exception: {}", (Object)CommonUtil.getStackTrace((Exception)ignore));
                }
            }
        });
    }

    private static void excpStopSync(Long synRecordId, String errorMsg, String searchObjNumber, String mainEntityName) {
        LOGGER.info("DTS_batchImportData exception stop sync param:[synRecordId:{}, errorMsg:{}]", (Object)synRecordId, (Object)errorMsg);
        if (synRecordId != null) {
            SearchObjSyncConfService.syncException(synRecordId, errorMsg);
        }
        String traceId = RequestContext.get().getTraceId();
        ThreadPools.executeOnce((String)"batchImportDataAsycStopDTS", () -> {
            LOGGER.info("batchImportDataAsycStopDTS trigger-traceId:{}", (Object)traceId);
            LOGGER.info("DTS_batchImportData startStopDTS param:[searchObjNumber:{}]", (Object)searchObjNumber);
            if (SearchObjDataSyncService.getInstance().isFullSync(searchObjNumber, mainEntityName)) {
                SearchObjDataSyncService.getInstance().stopIncrement(searchObjNumber, mainEntityName);
                LOGGER.info("DTS_batchImportData endStopDTS param:[searchObjNumber:{}]", (Object)searchObjNumber);
            }
        });
    }

    public static List<EsBatchValue> buildBatchValueNew(HRComplexObjContext context, List<Object> idList, Long searchObjId) {
        if (CollectionUtils.isEmpty(idList)) {
            return null;
        }
        MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();
        Map<String, Set<String>> allNeedQueryFieldMap = ContextParseService.getAllNeedQueryFieldMap(context, entityTypeUtil);
        long startTime = System.currentTimeMillis();
        HashMap<String, LabelLoadBo> labelLoadBoMap = new HashMap<String, LabelLoadBo>(16);
        Map<String, Map<String, DynamicObject[]>> idEntityDataMap = EntityDataLoadService.loadSearchObjAllEntityDataMap(context, allNeedQueryFieldMap, idList, labelLoadBoMap, searchObjId);
        long endLoadData = System.currentTimeMillis();
        LOGGER.info("SO_DTS_COSTbuildBatchValueNew load allData time:{}", (Object)(endLoadData - startTime));
        if (idEntityDataMap == null || idEntityDataMap.size() == 0) {
            return null;
        }
        ArrayList<EsBatchValue> batchValues = new ArrayList<EsBatchValue>(10);
        HashSet privacyEnpPropCache = new HashSet(16);
        HashMap propCacheMap = new HashMap(16);
        HashMap fieldRmvEntityMap = new HashMap(16);
        idEntityDataMap.forEach((mainId, entityDataMap) -> {
            Object esPropertyValues;
            long signStartTime = System.currentTimeMillis();
            ArrayList<EsPropertyValue> esPropValues = new ArrayList<EsPropertyValue>(10);
            HashSet<String> allLabelVals = new HashSet<String>(16);
            String mainEntityNumber = context.getEntityNumber();
            DynamicObject[] dynamicObjects = (DynamicObject[])entityDataMap.get(mainEntityNumber);
            DynamicObject mainEntityDyo = dynamicObjects[0];
            Set mainEntityFieldS = (Set)allNeedQueryFieldMap.get(mainEntityNumber);
            HashMap<String, Map<Object, List<EsPropertyValue>>> entryPkEsPropMap = new HashMap<String, Map<Object, List<EsPropertyValue>>>(16);
            for (String mainEntityField : mainEntityFieldS) {
                SearchObjDataTransService.fillEsPropVal(mainEntityDyo, esPropValues, (DynamicObjectType)entityTypeUtil.getMainEntityType(mainEntityNumber), mainEntityField, privacyEnpPropCache, entityTypeUtil, entryPkEsPropMap, propCacheMap, fieldRmvEntityMap);
            }
            entryPkEsPropMap.forEach((entryName, pkEsPropMap) -> {
                EsPropertyValue entryProp = new EsPropertyValue(entryName, EsDataType.NESTED, null);
                for (List entryPropVal : pkEsPropMap.values()) {
                    entryProp.nests.add(entryPropVal);
                }
                esPropValues.add(entryProp);
            });
            LabelLoadBo labelLoadBo = (LabelLoadBo)labelLoadBoMap.get(mainEntityNumber);
            if (labelLoadBo != null && (esPropertyValues = SearchObjDataTransService.getLabelEsPropertyValues(labelLoadBo, mainId)) != null) {
                esPropValues.addAll((Collection<EsPropertyValue>)esPropertyValues);
                allLabelVals.addAll(SearchObjDataTransService.getAllLabelVals((List<EsPropertyValue>)esPropertyValues));
            }
            for (HRComplexObjJoinRelation joinRelation : context.getJoinRelationList()) {
                String relEntityAlias = joinRelation.getRelEntityAlias();
                DynamicObject[] relEntityArr = (DynamicObject[])entityDataMap.get(relEntityAlias);
                if (relEntityArr == null) continue;
                EsPropertyValue relEsPropVal = new EsPropertyValue(relEntityAlias, EsDataType.NESTED, null);
                Set relEntityFields = (Set)allNeedQueryFieldMap.get(relEntityAlias);
                for (DynamicObject relEntityDyo : relEntityArr) {
                    List<EsPropertyValue> esRelPropertyValues;
                    ArrayList<EsPropertyValue> relEsPropValues = new ArrayList<EsPropertyValue>();
                    HashMap<String, Map<Object, List<EsPropertyValue>>> relEntryPkEsPropMap = new HashMap<String, Map<Object, List<EsPropertyValue>>>(16);
                    for (String relEntityField : relEntityFields) {
                        String fullPropName = fieldRmvEntityMap.computeIfAbsent(relEntityField, f -> f.replaceFirst(relEntityAlias + "\\.", ""));
                        SearchObjDataTransService.fillEsPropVal(relEntityDyo, relEsPropValues, (DynamicObjectType)entityTypeUtil.getMainEntityType(joinRelation.getRelEntityNumber()), fullPropName, privacyEnpPropCache, entityTypeUtil, relEntryPkEsPropMap, propCacheMap, fieldRmvEntityMap);
                    }
                    relEntryPkEsPropMap.forEach((entryName, pkEsPropMap) -> {
                        EsPropertyValue entryProp = new EsPropertyValue(entryName, EsDataType.NESTED, null);
                        for (List entryPropVal : pkEsPropMap.values()) {
                            entryProp.nests.add(entryPropVal);
                        }
                        relEsPropValues.add(entryProp);
                    });
                    LabelLoadBo relLabelLoadBo = (LabelLoadBo)labelLoadBoMap.get(relEntityAlias);
                    Object relEntityPk = relEntityDyo.getPkValue();
                    if (relLabelLoadBo != null && (esRelPropertyValues = SearchObjDataTransService.getLabelEsPropertyValues(relLabelLoadBo, relEntityPk)) != null) {
                        relEsPropValues.addAll(esRelPropertyValues);
                        allLabelVals.addAll(SearchObjDataTransService.getAllLabelVals(esRelPropertyValues));
                    }
                    relEsPropVal.nests.add(relEsPropValues);
                }
                esPropValues.add(relEsPropVal);
            }
            allLabelVals.remove(null);
            String allLabelValStr = String.join((CharSequence)",", allLabelVals);
            esPropValues.add(new EsPropertyValue("all_label_val_txt", (Object)allLabelValStr));
            EsBatchValue batchValue = new EsBatchValue(mainId, esPropValues.toArray(new EsPropertyValue[0]));
            batchValues.add(batchValue);
            long signEndTime = System.currentTimeMillis();
            long cost = signEndTime - signStartTime;
            if (cost > 500L) {
                LOGGER.info("SO_DTS_COSTbuildBatchValueNew deal mainid:{}, time:{}", mainId, (Object)cost);
            }
        });
        LOGGER.info("SO_DTS_COSTbuildBatchValueNew deal EsBatchValue time:{}", (Object)(System.currentTimeMillis() - endLoadData));
        return batchValues;
    }

    private static Set<String> getAllLabelVals(List<EsPropertyValue> esPropertyValues) {
        HashSet<String> allLabelVals = new HashSet<String>(16);
        for (EsPropertyValue nestEsProp : esPropertyValues) {
            List labelValList;
            EsPropertyValue esPropertyValue;
            Object nestObj;
            List nests = nestEsProp.nests;
            if (CollectionUtils.isEmpty((Collection)nests) || !((nestObj = nests.get(0)) instanceof Collection) || (esPropertyValue = (EsPropertyValue)(labelValList = (List)nestObj).stream().filter(prop -> prop.getPropertyName().equals("labelValues")).findAny().orElse(null)) == null) continue;
            Object labelValObj = esPropertyValue.getValue();
            if (labelValObj instanceof Collection) {
                allLabelVals.addAll((Collection)labelValObj);
                continue;
            }
            allLabelVals.add(String.valueOf(labelValObj));
        }
        return allLabelVals;
    }

    private static List<EsPropertyValue> getLabelEsPropertyValues(LabelLoadBo relLabelLoadBo, Object relEntityPk) {
        Map<Object, List<EsPropertyValue>> relEsDataMap = relLabelLoadBo.getEsDataMap();
        List<EsPropertyValue> esPropertyValues = relEsDataMap.get(relEntityPk);
        if (esPropertyValues == null) {
            esPropertyValues = relEsDataMap.get(String.valueOf(relEntityPk));
        }
        return esPropertyValues;
    }

    private static void fillEsPropVal(DynamicObject dyo, List<EsPropertyValue> properyValues, DynamicObjectType dynamicObjectType, String fullFieldName, Set<String> privacyEnpPropCache, MainEntityTypeUtil mainEntityTypeUtil, Map<String, Map<Object, List<EsPropertyValue>>> entryPkEsPropMap, Map<String, IDataEntityProperty> propCacheMap, Map<String, String> fieldRmvEntityMap) {
        String cacheKey = dynamicObjectType.getName() + "_" + fullFieldName;
        IDataEntityProperty fieldProperty = propCacheMap.get(cacheKey);
        if (fieldProperty == null) {
            fieldProperty = FieldParseUtil.getFieldProperty(dynamicObjectType, fullFieldName, mainEntityTypeUtil);
            propCacheMap.put(cacheKey, fieldProperty);
        }
        if (fieldProperty instanceof EntryProp) {
            EntryType entryType = (EntryType)((EntryProp)fieldProperty).getItemType();
            String entryName = fieldProperty.getName();
            Map<Object, List<EsPropertyValue>> pkEsPropMap = entryPkEsPropMap.get(entryName);
            if (pkEsPropMap == null) {
                pkEsPropMap = new HashMap<Object, List<EsPropertyValue>>(16);
            }
            DynamicObjectCollection dynamicObjectCollection = dyo.getDynamicObjectCollection(entryName);
            for (DynamicObject entryDyo : dynamicObjectCollection) {
                String curFullFieldName = fieldRmvEntityMap.computeIfAbsent(fullFieldName, n -> n.replaceFirst(entryName + "\\.", ""));
                List<EsPropertyValue> entryPropList = pkEsPropMap.get(entryDyo.getPkValue());
                if (entryPropList == null) {
                    entryPropList = new ArrayList<EsPropertyValue>(10);
                }
                SearchObjDataTransService.fillEsPropVal(entryDyo, entryPropList, (DynamicObjectType)entryType, curFullFieldName, privacyEnpPropCache, mainEntityTypeUtil, entryPkEsPropMap, propCacheMap, fieldRmvEntityMap);
                pkEsPropMap.put(entryDyo.getPkValue(), entryPropList);
            }
            entryPkEsPropMap.put(entryName, pkEsPropMap);
            return;
        }
        if (fieldProperty == null) {
            return;
        }
        String propStr = fieldProperty.getParent().getName() + "_" + fieldProperty.getName();
        if (fieldProperty instanceof ISimpleProperty && (privacyEnpPropCache.contains(propStr) || PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)fieldProperty))) {
            privacyEnpPropCache.add(propStr);
            return;
        }
        Object objVal = dyo.get(fullFieldName);
        if (null == objVal) {
            return;
        }
        if (fieldProperty instanceof MuliLangTextProp) {
            OrmLocaleValue dy = (OrmLocaleValue)objVal;
            for (String key : dy.keySet()) {
                properyValues.add(new EsPropertyValue(fullFieldName + "_l." + key, (Object)dy.get((Object)key)));
            }
            properyValues.add(new EsPropertyValue(fullFieldName, (Object)dy.getLocaleValue()));
        } else if (fieldProperty instanceof ComboProp) {
            properyValues.add(new EsPropertyValue(fullFieldName + "_store_value4es", objVal));
            ComboProp comboProp = (ComboProp)fieldProperty;
            String itemByName = comboProp.getItemByName(String.valueOf(objVal));
            properyValues.add(new EsPropertyValue(fullFieldName, (Object)itemByName));
            ValueMapItem valueMapItem = comboProp.getComboItems().stream().filter(item -> item.getValue().equals(String.valueOf(objVal))).findFirst().orElse(null);
            if (valueMapItem != null) {
                LocaleString localeStr = valueMapItem.getName();
                for (String key : localeStr.keySet()) {
                    properyValues.add(new EsPropertyValue(fullFieldName + "_l." + key, localeStr.get((Object)key)));
                }
                if (!localeStr.containsKey((Object)"GLang")) {
                    properyValues.add(new EsPropertyValue(fullFieldName + "_l.GLang", (Object)itemByName));
                }
            }
        } else if (fieldProperty instanceof DateTimeProp) {
            DateTimeProp dateTimeProp = (DateTimeProp)fieldProperty;
            properyValues.add(new EsPropertyValue(fullFieldName + "_store_value4es", objVal));
            properyValues.add(new EsPropertyValue(fullFieldName, (Object)dateTimeProp.getDateFormat().format(objVal)));
        } else if (fieldProperty instanceof TimeProp) {
            TimeProp timeProp = (TimeProp)fieldProperty;
            properyValues.add(new EsPropertyValue(fullFieldName + "_store_value4es", objVal));
            properyValues.add(new EsPropertyValue(fullFieldName, (Object)timeProp.getDateFormat().format(objVal)));
        } else if (fieldProperty instanceof DynamicSimpleProperty) {
            properyValues.add(new EsPropertyValue(fullFieldName, objVal));
        }
    }

    public static void resetEsIndexAlias(String searchObjNumber) {
        Long synRecordId = SearchObjSyncConfService.querySyncIngData(searchObjNumber);
        if (synRecordId == null) {
            throw new KDBizException("not exists synIngRecord-searchObjNumber:" + searchObjNumber);
        }
        SearchObjEsOperateService esCreateMapping = new SearchObjEsOperateService();
        SearchObjectService searchObjectService = SearchObjectService.getInstance();
        Long searchObjId = searchObjectService.getSearchObjId(searchObjNumber);
        esCreateMapping.resetEsIndexAlias(searchObjId, synRecordId);
        Object syncSchemeId = SearchObjSyncConfService.upRecordFinishGetScheme(synRecordId);
        SearchObjSyncConfService.upSchemeStatus(syncSchemeId);
        HRContextCache.clearSearchObjConfCache(searchObjId);
    }

    private static List<Object> getDocIds(HRComplexObjContext context, Long searchObjId, String optEntityName, String dataChangeType, List<Object> idList) {
        if (optEntityName.equals(context.getEntityNumber())) {
            return idList;
        }
        HRComplexObjContext copyOnlyRelList = ContextParseService.optimizeRelEntity(context, optEntityName);
        Set relEntityAliasSet = copyOnlyRelList.getJoinRelationList().stream().filter(relEntity -> relEntity.getRelEntityNumber().equals(optEntityName)).map(HRComplexObjJoinRelation::getRelEntityAlias).collect(Collectors.toSet());
        if (EnumDataChangeType.DELETE.getType().equals(dataChangeType)) {
            ArrayList<EsFilterField> listEsFilterField = new ArrayList<EsFilterField>(10);
            EsFilterField orField = null;
            for (String relEntityAlias : relEntityAliasSet) {
                EsFilterField esFilterField = new EsFilterField(relEntityAlias, relEntityAlias + ".id", "in", idList.toArray());
                if (orField == null) {
                    orField = esFilterField;
                    continue;
                }
                orField.or(esFilterField);
            }
            listEsFilterField.add(orField);
            SearchObjEsOperateService esOperateService = new SearchObjEsOperateService();
            return esOperateService.queryDocFields(searchObjId, "id", listEsFilterField);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)context.getEntityNumber());
        DataTypeEnum dataType = dataEntityType.getPrimaryKey().getPropertyType() == String.class ? DataTypeEnum.STRING : DataTypeEnum.LONG;
        ArrayList<HRComplexObjFieldInfo> complexObjFieldInfoList = new ArrayList<HRComplexObjFieldInfo>(10);
        HRComplexObjFieldInfo idField = new HRComplexObjFieldInfo("id", "1", "id", dataType, null);
        complexObjFieldInfoList.add(idField);
        copyOnlyRelList.setComplexObjFieldInfoList(complexObjFieldInfoList);
        QFilter qFilter = null;
        for (String relEntityAlias : relEntityAliasSet) {
            if (qFilter == null) {
                qFilter = new QFilter(relEntityAlias + ".id", "in", idList);
                continue;
            }
            qFilter.or(new QFilter(relEntityAlias + ".id", "in", idList));
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(qFilter);
        copyOnlyRelList.setQfilterList(qFilterList);
        return SearchObjQueryService.queryFieldValues(copyOnlyRelList);
    }
}

