/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.datasync;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.query.es.EsBatchValue;
import kd.hr.hbp.business.service.query.es.EsDataType;
import kd.hr.hbp.business.service.query.es.EsMappingProperty;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.business.service.query.es.storage.EsResultVo;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.query.BosEsErrorCode;
import kd.hr.hbp.common.util.EsCommonUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.common.AnalyzerUtil;
import kd.hrmp.hrss.business.domain.search.service.common.FieldParseUtil;
import kd.hrmp.hrss.business.domain.search.service.common.LabelFieldUtil;
import kd.hrmp.hrss.business.domain.search.service.common.LangUtil;
import kd.hrmp.hrss.business.domain.search.service.datasync.IEsOperateService;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjContextParseService;
import kd.hrmp.hrss.business.domain.search.service.es.SmartSearchEsEsStorage;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;

public class SearchObjEsOperateService
implements IEsOperateService {
    private static final Log LOGGER = LogFactory.getLog(SearchObjEsOperateService.class);
    private final MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();

    @Override
    public void createMapping(HRComplexObjContext context, String indexName) {
        SmartSearchEsEsStorage esEsStorage = new SmartSearchEsEsStorage();
        if (esEsStorage.isIndexExist(indexName).booleanValue()) {
            esEsStorage.deleteIndex(indexName);
        }
        LOGGER.info("es createMapping, indexName:{}", (Object)indexName);
        try {
            esEsStorage.createIndex("hr", indexName, null);
        }
        catch (ElasticsearchStatusException e) {
            LOGGER.error("SearchObj create es mapping exception: {}", (Object)CommonUtil.getStackTrace((Exception)((Object)e)));
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efaES\u7d22\u5f15\u62a5\u9519,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SearchObjEsOperateService_0", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        List<EsMappingProperty> propertys = this.buildMappingPropertys(context);
        esEsStorage.addMappingIndex(indexName, "t_data", "false", propertys.toArray(new EsMappingProperty[0]));
    }

    @Override
    public void resetEsIndexAlias(Long searchObjId, Long synRecordId) {
        String aliasName = EsCommonUtils.getAISearchIndexAliasName((String)"hr", (Long)searchObjId);
        String indexName = EsCommonUtils.getSearchObjEsIndexName((String)"hr", (Long)searchObjId, (Long)synRecordId);
        LOGGER.info("es reset index aliasName:{}, indexName:{}", (Object)aliasName, (Object)indexName);
        SmartSearchEsEsStorage esEsStorage = new SmartSearchEsEsStorage();
        esEsStorage.removeAndAddAliases(indexName, aliasName);
    }

    @Override
    public Map<String, Set<String>> findNotExistsField(Long searchObjId, Map<String, Set<String>> pathFieldMap) {
        String indexName = EsCommonUtils.getAISearchIndexAliasName((String)"hr", (Long)searchObjId);
        SmartSearchEsEsStorage esEsStorage = new SmartSearchEsEsStorage();
        return esEsStorage.findNotExistsField(indexName, pathFieldMap);
    }

    @Override
    public void addLabelMapping(Long searchObjId, Map<String, Set<String>> pathFieldMap) {
        String indexName = EsCommonUtils.getAISearchIndexAliasName((String)"hr", (Long)searchObjId);
        SmartSearchEsEsStorage esEsStorage = new SmartSearchEsEsStorage();
        List<EsMappingProperty> propertys = this.buildLabelMapping(pathFieldMap);
        if (CollectionUtils.isEmpty(propertys)) {
            return;
        }
        LOGGER.info("addLabelMapping:indexName{},propertysize:{}", (Object)indexName, (Object)propertys.size());
        esEsStorage.addMappingIndex(indexName, "t_data", "false", propertys.toArray(new EsMappingProperty[0]));
    }

    @Override
    public void batchSave(Long searchObjId, Long synRecordId, List<EsBatchValue> batchValue) {
        if (CollectionUtils.isEmpty(batchValue)) {
            return;
        }
        String indexName = synRecordId == null || synRecordId == 0L ? EsCommonUtils.getAISearchIndexAliasName((String)"hr", (Long)searchObjId) : EsCommonUtils.getSearchObjEsIndexName((String)"hr", (Long)searchObjId, (Long)synRecordId);
        LOGGER.info("es batchSave, indexName:{}", (Object)indexName);
        SmartSearchEsEsStorage esEsStorage = new SmartSearchEsEsStorage();
        esEsStorage.batchSave(indexName, "t_data", batchValue.toArray(new EsBatchValue[0]));
    }

    @Override
    public List<Object> queryDocFields(Long searchObjId, String queryField, List<EsFilterField> esFilterFields) {
        if (CollectionUtils.isEmpty(esFilterFields)) {
            return null;
        }
        String indexName = EsCommonUtils.getAISearchIndexAliasName((String)"hr", (Long)searchObjId);
        LOGGER.info("es queryDocFields, indexName:{}", (Object)indexName);
        SmartSearchEsEsStorage esEsStorage = new SmartSearchEsEsStorage();
        EsResultVo esResultVo = esEsStorage.query(indexName, "t_data", new String[]{queryField}, esFilterFields, null, true, 0, 1);
        List listIdResult = esResultVo.getResultData();
        if (CollectionUtils.isEmpty((Collection)listIdResult) && listIdResult.size() != 1) {
            return null;
        }
        return listIdResult.stream().map(map -> map.get(queryField)).collect(Collectors.toList());
    }

    @Override
    public void deleteDataByMainEntityId(Long searchObjId, List<Object> mainEntityIdList) {
        if (CollectionUtils.isEmpty(mainEntityIdList) || searchObjId == null || searchObjId == 0L) {
            return;
        }
        String indexName = EsCommonUtils.getAISearchIndexAliasName((String)"hr", (Long)searchObjId);
        LOGGER.info("es deleteDataByMainEntityId, indexName:{}", (Object)indexName);
        ArrayList<EsFilterField> listEsFilterField = new ArrayList<EsFilterField>();
        EsFilterField esFilterField = new EsFilterField("id", "in", mainEntityIdList.toArray());
        listEsFilterField.add(esFilterField);
        SmartSearchEsEsStorage esEsStorage = new SmartSearchEsEsStorage();
        esEsStorage.deleteByQuery(indexName, "t_data", listEsFilterField);
    }

    @Override
    public SearchResponse search(Long searchObjId, List<String> searchField, QueryBuilder queryBuilder, String highLightPreTag, String highLightPostTag, QueryBuilder lightHighQb, int start, int limit) {
        String indexName = EsCommonUtils.getAISearchIndexAliasName((String)"hr", (Long)searchObjId);
        String[] fieldArr = searchField.toArray(new String[0]);
        try {
            SmartSearchEsEsStorage esEsStorage = new SmartSearchEsEsStorage();
            return esEsStorage.search(indexName, fieldArr, queryBuilder, highLightPreTag, highLightPostTag, lightHighQb, start, limit);
        }
        catch (Exception exception) {
            LOGGER.error("es query fail: ", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"ES\u67e5\u8be2\u5931\u8d25", (String)"SearchObjEsOperateService_1", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
    }

    @Override
    public SearchResponse searchAfter(Long searchObjId, List<String> searchField, QueryBuilder queryBuilder, String highLightPreTag, String highLightPostTag, int limit, Object[] objSortValues) {
        String indexName = EsCommonUtils.getAISearchIndexAliasName((String)"hr", (Long)searchObjId);
        String[] fieldArr = searchField.toArray(new String[0]);
        try {
            SmartSearchEsEsStorage esEsStorage = new SmartSearchEsEsStorage();
            return esEsStorage.searchAfter(indexName, fieldArr, queryBuilder, highLightPreTag, highLightPostTag, limit, objSortValues);
        }
        catch (Exception exception) {
            LOGGER.error("es query fail: ", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"ES\u67e5\u8be2\u5931\u8d25", (String)"SearchObjEsOperateService_1", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
    }

    @Override
    public Object[] getObjSortValues(SearchResponse searchResponse) {
        SearchHit[] hits = searchResponse.getHits().getHits();
        Object[] objSortValuesResult = null;
        if (hits != null && hits.length > 0) {
            objSortValuesResult = hits[hits.length - 1].getSortValues();
        }
        return objSortValuesResult;
    }

    @Override
    public List<Map<String, Object>> getHighLightResult(List<String> searchFieldList, SearchResponse searchResponse) {
        SearchHit[] hits = searchResponse.getHits().getHits();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        String langStr = RequestContext.get().getLang().name();
        for (SearchHit hit : hits) {
            Map source = hit.getSourceAsMap();
            Map highlightFields = hit.getHighlightFields();
            HashMap<String, HighlightField> realhighlightFields = new HashMap<String, HighlightField>(16);
            for (String fieldAlias : searchFieldList) {
                HighlightField nameField = SearchObjEsOperateService.getHighlightField(langStr, highlightFields, fieldAlias);
                if (nameField == null) continue;
                realhighlightFields.put(fieldAlias, nameField);
            }
            HighlightField allLabelHighLight = (HighlightField)highlightFields.get("all_label_val_txt");
            if (allLabelHighLight != null) {
                realhighlightFields.put("all_label_val_txt", allLabelHighLight);
            }
            source.put("_highlightFields", realhighlightFields);
            source.forEach((key, val) -> {
                if (!LabelFieldUtil.isLabelField(key) || val instanceof List) {
                    // empty if block
                }
            });
            result.add(source);
        }
        return result;
    }

    private static HighlightField getHighlightField(String langStr, Map<String, HighlightField> highlightFields, String fieldAlias) {
        HighlightField nameField = highlightFields.get(fieldAlias);
        if (nameField == null) {
            nameField = highlightFields.get(fieldAlias + ".keyword");
        }
        if (nameField == null) {
            nameField = highlightFields.get(fieldAlias + "_l." + langStr);
        }
        if (nameField == null) {
            nameField = highlightFields.get(fieldAlias + "_l." + langStr + ".keyword");
        }
        if (nameField == null && LabelFieldUtil.isLabelField(fieldAlias) && (nameField = highlightFields.get(fieldAlias + ".labelValues")) == null) {
            nameField = highlightFields.get(fieldAlias + ".labelValues.keyword");
        }
        return nameField;
    }

    @Override
    public Boolean existsValidIndex(Long searchObjId) {
        String aliasName = EsCommonUtils.getAISearchIndexAliasName((String)"hr", (Long)searchObjId);
        SmartSearchEsEsStorage esEsStorage = new SmartSearchEsEsStorage();
        return esEsStorage.isIndexExist(aliasName);
    }

    private List<EsMappingProperty> buildLabelMapping(Map<String, Set<String>> pathFieldMap) {
        ArrayList<EsMappingProperty> esMappingPropertyList = new ArrayList<EsMappingProperty>(10);
        pathFieldMap.forEach((path, fieldSet) -> {
            ArrayList<EsMappingProperty> allFieldEsProp = new ArrayList<EsMappingProperty>(10);
            for (String field : fieldSet) {
                EsMappingProperty esMappingProperty = this.genEsMapping(field, EsDataType.OBJECT);
                this.addLabelSubEsProp(esMappingProperty);
                allFieldEsProp.add(esMappingProperty);
            }
            if (CollectionUtils.isEmpty(allFieldEsProp)) {
                return;
            }
            if (HRStringUtils.isEmpty((String)path)) {
                esMappingPropertyList.addAll(allFieldEsProp);
            } else {
                EsMappingProperty nestPropertys = new EsMappingProperty(path, EsDataType.NESTED);
                nestPropertys.nests.addAll(allFieldEsProp);
                esMappingPropertyList.add(nestPropertys);
            }
        });
        return esMappingPropertyList;
    }

    private List<EsMappingProperty> buildMappingPropertys(HRComplexObjContext context) throws KDBizException {
        HashSet<String> mainProps = new HashSet<String>(16);
        HashSet<String> nestProps = new HashSet<String>(16);
        SearchObjContextParseService.parseSelectField(context, mainProps, nestProps);
        ArrayList<EsMappingProperty> esMappingPropertyList = new ArrayList<EsMappingProperty>(10);
        List joinRelationList = context.getJoinRelationList();
        for (Object joinRelation : joinRelationList) {
            String joinEntityName = joinRelation.getRelEntityNumber();
            String relEntityAlias = joinRelation.getRelEntityAlias();
            List<String> joinSelectListNew = this.filterPropertys(nestProps, relEntityAlias);
            if (joinSelectListNew.size() == 0) continue;
            EsMappingProperty nestPropertys = new EsMappingProperty(relEntityAlias, EsDataType.NESTED);
            MainEntityType relationEntityType = this.mainEntityTypeUtil.getMainEntityType(joinEntityName);
            for (String select : joinSelectListNew) {
                this.buildProperty((DynamicObjectType)relationEntityType, select, nestPropertys.nests, this.mainEntityTypeUtil);
            }
            List<EsMappingProperty> relEntityEsMappingProp = this.getLabelEsMappingProp(joinEntityName);
            if (CollectionUtils.isNotEmpty(relEntityEsMappingProp)) {
                nestPropertys.nests.addAll(relEntityEsMappingProp);
            }
            if (nestPropertys.nests.size() <= 0) continue;
            esMappingPropertyList.add(nestPropertys);
        }
        mainProps.removeAll(nestProps);
        MainEntityType mainEntityType = this.mainEntityTypeUtil.getMainEntityType(context.getEntityNumber());
        for (String property : mainProps) {
            this.buildProperty((DynamicObjectType)mainEntityType, property, esMappingPropertyList, this.mainEntityTypeUtil);
        }
        List<EsMappingProperty> mainEntityEsMappingProp = this.getLabelEsMappingProp(context.getEntityNumber());
        if (CollectionUtils.isNotEmpty(mainEntityEsMappingProp)) {
            esMappingPropertyList.addAll(mainEntityEsMappingProp);
        }
        EsMappingProperty allLabelValProp = this.genEsMapping("all_label_val_txt", EsDataType.TEXT, true);
        esMappingPropertyList.add(allLabelValProp);
        return esMappingPropertyList;
    }

    private List<EsMappingProperty> getLabelEsMappingProp(String entityNumber) {
        ArrayList result = Lists.newArrayListWithCapacity((int)16);
        Map gptLabelResult = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSLabelService", (String)"queryLabelObjectsByEntityNumber", (Object[])new Object[]{entityNumber});
        boolean success = (Boolean)gptLabelResult.get("success");
        if (!success) {
            throw new KDBizException((String)gptLabelResult.get("msg"));
        }
        ArrayList resultList = (ArrayList)gptLabelResult.get("resultList");
        ArrayList allLabels = Lists.newArrayListWithCapacity((int)16);
        EsMappingProperty labelProperty = new EsMappingProperty("all_label_keys", EsDataType.KEYWORD);
        result.add(labelProperty);
        for (Map stringObjectMap : resultList) {
            Object labels = stringObjectMap.get("labels");
            if (labels == null) continue;
            ArrayList labelList = (ArrayList)labels;
            allLabels.addAll(labelList);
        }
        Map<Object, List<Map>> labelGroup = allLabels.stream().collect(Collectors.groupingBy(allLabel -> allLabel.get("labelId")));
        for (Map.Entry<Object, List<Map>> labelMap : labelGroup.entrySet()) {
            Object key = labelMap.getKey();
            EsMappingProperty esMappingProperty = this.genEsMapping("label_" + key.toString(), EsDataType.OBJECT);
            this.addLabelSubEsProp(esMappingProperty);
            result.add(esMappingProperty);
        }
        return result;
    }

    private void addLabelSubEsProp(EsMappingProperty esMappingProperty) {
        EsMappingProperty labelNameProperty = this.genEsMapping("labelName", EsDataType.KEYWORD);
        EsMappingProperty labelTypeProperty = this.genEsMapping("labelType", EsDataType.KEYWORD);
        EsMappingProperty labelObjectIdsProperty = this.genEsMapping("labelObjectIds", EsDataType.LONG);
        EsMappingProperty labelValuesProperty = this.genEsMapping("labelValues", EsDataType.TEXT);
        EsMappingProperty labelValuePksProperty = this.genEsMapping("labelValuePks", EsDataType.LONG);
        EsMappingProperty labelValPkNameProp = this.genEsMapping("labelValuePkNames", EsDataType.KEYWORD);
        esMappingProperty.nests.add(labelNameProperty);
        esMappingProperty.nests.add(labelTypeProperty);
        esMappingProperty.nests.add(labelObjectIdsProperty);
        esMappingProperty.nests.add(labelValuesProperty);
        esMappingProperty.nests.add(labelValuePksProperty);
        esMappingProperty.nests.add(labelValPkNameProp);
    }

    public List<String> filterPropertys(Set<String> nestProps, String entityAlias) {
        ArrayList joinSelectListNew = Lists.newArrayListWithCapacity((int)16);
        List joinSelectList = nestProps.stream().filter(property -> property.contains(entityAlias)).collect(Collectors.toList());
        if (0 == joinSelectList.size()) {
            return joinSelectListNew;
        }
        for (String joinSelect : joinSelectList) {
            joinSelectListNew.add(joinSelect.replace(entityAlias + ".", ""));
        }
        return joinSelectListNew;
    }

    private void buildProperty(DynamicObjectType entityType, String property, List<EsMappingProperty> esMappingPropertyList, MainEntityTypeUtil mainEntityTypeUtil) throws KDBizException {
        IDataEntityProperty dataEntityProperty = FieldParseUtil.getFieldProperty(entityType, property, mainEntityTypeUtil);
        if (dataEntityProperty instanceof EntryProp) {
            EntryType entryType = (EntryType)((EntryProp)dataEntityProperty).getItemType();
            String entryName = dataEntityProperty.getName();
            EsMappingProperty entryProp = esMappingPropertyList.stream().filter(prop -> prop.getPropertyName().equals(entryName)).findFirst().orElse(null);
            if (entryProp == null) {
                entryProp = new EsMappingProperty(entryName, EsDataType.NESTED);
                esMappingPropertyList.add(entryProp);
            }
            property = property.replace(entryName + ".", "");
            this.buildProperty((DynamicObjectType)entryType, property, entryProp.nests, mainEntityTypeUtil);
            return;
        }
        if (null == dataEntityProperty) {
            return;
        }
        if (dataEntityProperty instanceof DynamicSimpleProperty) {
            DynamicSimpleProperty dynamicSimpleProperty = (DynamicSimpleProperty)dataEntityProperty;
            boolean isEncrypt = dynamicSimpleProperty.isEncrypt();
            if (isEncrypt) {
                EsMappingProperty enpEsMappingProperty = this.genEsMapping(property + "_enp", EsDataType.KEYWORD);
                esMappingPropertyList.add(enpEsMappingProperty);
            }
            if (dynamicSimpleProperty instanceof MuliLangTextProp || dynamicSimpleProperty instanceof ComboProp) {
                this.addMulField(property, esMappingPropertyList);
            }
            if (dynamicSimpleProperty instanceof ComboProp || dynamicSimpleProperty instanceof DateTimeProp || dynamicSimpleProperty instanceof TimeProp) {
                EsMappingProperty comboNameEsMapping = this.genEsMapping(property + "_store_value4es", EsDataType.KEYWORD);
                esMappingPropertyList.add(comboNameEsMapping);
                EsMappingProperty esMappingProperty = this.genEsMapping(property, EsDataType.TEXT);
                esMappingPropertyList.add(esMappingProperty);
                return;
            }
        }
        EsMappingProperty esMappingProperty = this.genEsMapping(property, this.convertPropertyType(dataEntityProperty, property));
        esMappingPropertyList.add(esMappingProperty);
    }

    private void addMulField(String property, List<EsMappingProperty> esMappingPropertyList) {
        Set<String> enableLangNums = LangUtil.getEnableLangNums();
        for (String langNum : enableLangNums) {
            boolean resetAnalyzer = false;
            if (langNum.equals(Lang.zh_CN.name()) || langNum.equals(Lang.zh_TW.name())) {
                resetAnalyzer = true;
            }
            EsMappingProperty langMappingProperty = this.genEsMapping(property + "_l." + langNum, EsDataType.TEXT, resetAnalyzer);
            esMappingPropertyList.add(langMappingProperty);
        }
        EsMappingProperty langMappingProperty = this.genEsMapping(property + "_l.GLang", EsDataType.TEXT);
        esMappingPropertyList.add(langMappingProperty);
    }

    public EsDataType convertPropertyType(IDataEntityProperty srcProp, String realProp) {
        EsDataType dataType = EsDataType.getTypeOf((String)srcProp.getPropertyType().getSimpleName());
        if (null != dataType) {
            return dataType;
        }
        if (srcProp instanceof DateTimeProp) {
            dataType = EsDataType.DATE;
        } else if (srcProp instanceof DecimalProp) {
            dataType = srcProp instanceof IntegerProp ? EsDataType.INTEGER : EsDataType.DOUBLE;
        } else if (srcProp instanceof ComboProp) {
            dataType = EsDataType.TEXT;
        } else if (srcProp instanceof FieldProp) {
            dataType = EsDataType.TEXT;
        } else {
            if (srcProp instanceof BasedataProp) {
                if (StringUtils.isNotEmpty((CharSequence)realProp)) {
                    String baseEntityId = ((BasedataProp)srcProp).getBaseEntityId();
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                    IDataEntityProperty property = this.findProperty(dataEntityType, realProp);
                    if (property == null) {
                        return this.convertPropertyType(this.findProperty(dataEntityType, "id"), null);
                    }
                    return this.convertPropertyType(property, null);
                }
                return EsDataType.LONG;
            }
            throw new KDException(BosEsErrorCode.esException, new Object[]{"the DataType (" + srcProp.getPropertyType().getSimpleName() + ") does not support."});
        }
        return dataType;
    }

    public IDataEntityProperty findProperty(MainEntityType relationEntityType, String propertyName) {
        DynamicProperty dataEntityProperty = null;
        String[] nameKeys = propertyName.split("\\.");
        for (int i = 0; i < nameKeys.length && null == (dataEntityProperty = relationEntityType.getProperty(nameKeys[i])); ++i) {
        }
        return dataEntityProperty;
    }

    private EsMappingProperty genEsMapping(String property, EsDataType esDataType) {
        return this.genEsMapping(property, esDataType, true);
    }

    private EsMappingProperty genEsMapping(String property, EsDataType esDataType, boolean resetAnalyzer) {
        EsMappingProperty esMappingProperty = new EsMappingProperty(property, esDataType);
        if (resetAnalyzer) {
            AnalyzerUtil.fitAnalyzer(esMappingProperty);
        }
        return esMappingProperty;
    }

    public void deleteOldIndex(Long searchObjId, Set<Long> keepRecordIds) {
        String indexName;
        String aliasName = EsCommonUtils.getAISearchIndexAliasName((String)"hr", (Long)searchObjId).toLowerCase(Locale.ROOT);
        SmartSearchEsEsStorage esEsStorage = new SmartSearchEsEsStorage();
        Map<String, Set<AliasMetaData>> allIndexMap = esEsStorage.getAllIndex();
        if (allIndexMap == null) {
            return;
        }
        HashSet<String> canRemoveIdxs = new HashSet<String>(16);
        for (Long l : keepRecordIds) {
            indexName = EsCommonUtils.getSearchObjEsIndexName((String)"hr", (Long)searchObjId, (Long)l);
            canRemoveIdxs.add(indexName);
        }
        for (Map.Entry entry : allIndexMap.entrySet()) {
            indexName = (String)entry.getKey();
            Set aliasMetaData = (Set)entry.getValue();
            if (CollectionUtils.isNotEmpty((Collection)aliasMetaData) || canRemoveIdxs.contains(indexName) || !indexName.startsWith(aliasName) || indexName.endsWith("_lbsgt")) continue;
            LOGGER.info("AIQ deleteOldIndex indexName:{}", (Object)indexName);
            esEsStorage.deleteIndex(indexName);
        }
    }
}

