/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.datasync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.common.ContextParseService;
import kd.hrmp.hrss.business.domain.search.service.common.HRContextCache;
import kd.hrmp.hrss.business.domain.search.service.query.SearchObjQueryService;
import org.apache.commons.collections.CollectionUtils;

public class SearchObjSyncConfService {
    private static final Log LOGGER = LogFactory.getLog(SearchObjSyncConfService.class);
    private static final String SYNSTATUS_SYNCING = "2";
    private static final String SYNSTATUS_SYNCFINISH = "3";
    private static final String SYNSTATUS_EXCEPTION = "5";
    private static final String FIELD_SYNSTATUS = "synstatus";
    private static final String ENTITY_HRSS_ESSYNRECORD = "hrss_essynrecord";

    public static void upSchemeStatus(Object syncSchemeId) {
        try (TXHandle txHandle = TX.requiresNew();){
            String sql = "update t_hrss_essyncscheme set fessynstatus = ? where fid = ? and fessynstatus != ?";
            HRDBUtil.execute((DBRoute)DBRoute.of((String)"hmp"), (String)sql, (Object[])new Object[]{SYNSTATUS_SYNCFINISH, syncSchemeId, SYNSTATUS_SYNCFINISH});
        }
    }

    public static Object upRecordFinishGetScheme(Long synRecordId) {
        try (TXHandle txHandle = TX.requiresNew();){
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_HRSS_ESSYNRECORD);
            DynamicObject synRecordDyo = serviceHelper.queryOne("id,essyncschemeid,actualfinishtime,synstatus,syncount", new QFilter("id", "=", (Object)synRecordId));
            Object syncSchemeId = synRecordDyo.getDynamicObject("essyncschemeid").getPkValue();
            synRecordDyo.set(FIELD_SYNSTATUS, (Object)SYNSTATUS_SYNCFINISH);
            synRecordDyo.set("actualfinishtime", (Object)new Date());
            serviceHelper.updateDataOne(synRecordDyo);
            Object object = syncSchemeId;
            return object;
        }
    }

    public static Long queryAndStartSync(Long searchObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_HRSS_ESSYNRECORD);
        QFilter qFilter = new QFilter("essyncschemeid.searchobj", "=", (Object)searchObjId);
        QFilter typeFilter = new QFilter(FIELD_SYNSTATUS, "=", (Object)SYNSTATUS_SYNCING);
        DynamicObject dynamicObject = serviceHelper.queryOne("id,actualsyntime1", new QFilter[]{qFilter, typeFilter});
        if (dynamicObject == null) {
            return null;
        }
        Date actualSynTime = dynamicObject.getDate("actualsyntime1");
        if (actualSynTime == null) {
            try (TXHandle txHandle = TX.requiresNew();){
                dynamicObject.set("actualsyntime1", (Object)new Date());
                serviceHelper.updateOne(dynamicObject);
            }
        }
        return dynamicObject.getLong("id");
    }

    public static Long querySyncIngData(String searchObjNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_HRSS_ESSYNRECORD);
        QFilter qFilter = new QFilter("essyncschemeid.searchobj.number", "=", (Object)searchObjNumber);
        QFilter typeFilter = new QFilter(FIELD_SYNSTATUS, "=", (Object)SYNSTATUS_SYNCING);
        DynamicObject dynamicObject = serviceHelper.queryOriginalOne("id", new QFilter[]{qFilter, typeFilter});
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getLong("id");
    }

    public static void addSyncDataCount(Long synRecordId, int increase) {
        if (increase <= 0) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_HRSS_ESSYNRECORD);
        DynamicObject dyo = serviceHelper.queryOne("id,syncount", new QFilter[]{new QFilter("id", "=", (Object)synRecordId), new QFilter(FIELD_SYNSTATUS, "=", (Object)SYNSTATUS_SYNCING)});
        try (TXHandle txHandle = TX.requiresNew();){
            dyo.set("syncount", (Object)(dyo.getInt("syncount") + increase));
            serviceHelper.updateOne(dyo);
        }
    }

    public static int queryNeedSyncDataCount(Long searchObjId) {
        HRComplexObjContext idQueryContent;
        HRComplexObjContext context = HRContextCache.getComplexObjContext(searchObjId);
        Set<String> relEntityAliasSet = context.getJoinRelationList().stream().map(HRComplexObjJoinRelation::getRelEntityAlias).collect(Collectors.toSet());
        List qfilterList = context.getQfilterList();
        if (CollectionUtils.isNotEmpty((Collection)qfilterList) && ContextParseService.containMainFilter(relEntityAliasSet, qfilterList)) {
            LOGGER.info("filterMainDataId_ query mainentity data mainEntityNumber:{}, idList.size:{}", (Object)context.getEntityNumber());
            idQueryContent = ContextParseService.optimizeRelEntity(context, qfilterList);
            idQueryContent.setQfilterList(qfilterList);
        } else {
            idQueryContent = new HRComplexObjContext();
            idQueryContent.setEntityTable(context.getEntityTable());
            idQueryContent.setEntityNumber(context.getEntityNumber());
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)context.getEntityNumber());
            DataTypeEnum dataType = dataEntityType.getPrimaryKey().getPropertyType() == String.class ? DataTypeEnum.STRING : DataTypeEnum.LONG;
            ArrayList<HRComplexObjFieldInfo> complexObjFieldInfoList = new ArrayList<HRComplexObjFieldInfo>(10);
            HRComplexObjFieldInfo idField = new HRComplexObjFieldInfo("id", "1", "id", dataType, null);
            complexObjFieldInfoList.add(idField);
            idQueryContent.setComplexObjFieldInfoList(complexObjFieldInfoList);
        }
        if (idQueryContent.getJoinRelationList() == null) {
            idQueryContent.setJoinRelationList(new ArrayList(0));
        }
        List<Object> idList = SearchObjQueryService.queryFieldValues(idQueryContent);
        return (int)idList.stream().distinct().count();
    }

    public static int querySyncDataCount(Long synRecordId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_HRSS_ESSYNRECORD);
        DynamicObject dyo = serviceHelper.queryOne("id,syncount", (Object)synRecordId);
        if (dyo == null) {
            return 0;
        }
        return dyo.getInt("syncount");
    }

    public static void syncException(Long synRecordId, String errorMsg) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_HRSS_ESSYNRECORD);
        DynamicObject dyo = serviceHelper.queryOne("id,synstatus", new QFilter[]{new QFilter("id", "=", (Object)synRecordId), new QFilter(FIELD_SYNSTATUS, "=", (Object)SYNSTATUS_SYNCING)});
        if (dyo == null) {
            return;
        }
        dyo.set(FIELD_SYNSTATUS, (Object)SYNSTATUS_EXCEPTION);
        serviceHelper.updateDataOne(dyo);
        if (HRStringUtils.isNotEmpty((String)errorMsg) && errorMsg.length() > 1000) {
            errorMsg = errorMsg.substring(0, 999);
        }
        String insertSql = "insert into T_HRSS_SYNCERRORLOG (FID, FESSYNRECORDID, FTRACEID, FERRORMSG) values(?, ?, ?, ?)";
        HRDBUtil.execute((DBRoute)DBRoute.of((String)"hmp"), (String)insertSql, (Object[])new Object[]{IDService.get().genLongId(), synRecordId, RequestContext.get().getTraceId(), errorMsg});
    }

    public static Set<Long> queryFinishSyncId(Long searchObjId, int topN) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_HRSS_ESSYNRECORD);
        QFilter qFilter = new QFilter("essyncschemeid.searchobj", "=", (Object)searchObjId);
        QFilter typeFilter = new QFilter(FIELD_SYNSTATUS, "=", (Object)SYNSTATUS_SYNCFINISH);
        QFilter syncTimeFilter = new QFilter("actualfinishtime", "is not null", null);
        DynamicObject[] dynamicObjects = serviceHelper.query("id", new QFilter[]{qFilter, typeFilter, syncTimeFilter}, "actualfinishtime desc,createtime desc", topN);
        if (dynamicObjects == null) {
            return null;
        }
        return Arrays.stream(dynamicObjects).map(dyo -> dyo.getLong("id")).collect(Collectors.toSet());
    }

    public static Set<Long> queryAllSyncIngData(Long searchObjId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_HRSS_ESSYNRECORD);
        QFilter qFilter = new QFilter("essyncschemeid.searchobj", "=", (Object)searchObjId);
        QFilter typeFilter = new QFilter(FIELD_SYNSTATUS, "=", (Object)SYNSTATUS_SYNCING);
        DynamicObject[] dynamicObjects = serviceHelper.query("id", new QFilter[]{qFilter, typeFilter});
        if (dynamicObjects == null) {
            return null;
        }
        return Arrays.stream(dynamicObjects).map(dyo -> dyo.getLong("id")).collect(Collectors.toSet());
    }
}

