/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.es;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.query.BosEsErrorCode;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.es.ElasticsearchClientUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.ParsedComposite;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedNested;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionBuilder;
import org.elasticsearch.search.suggest.completion.context.CategoryQueryContext;

public class SmartSearchEsAccess {
    private static final Log LOGGER = LogFactory.getLog(SmartSearchEsAccess.class);
    private static final String RETRY_ON_CONFLICT_KEY = "fulltext.retryonconflict";
    private static final long MAX_BULK_SIZE = 10000000L;
    private static final long ALL_MAX_BULK = 100000000L;

    private SmartSearchEsAccess() {
    }

    private static List<HttpHost> getHttpHosts(Map<String, String> connConfig) {
        ArrayList<HttpHost> httpHosts = new ArrayList<HttpHost>(10);
        int port = Integer.parseInt(connConfig.get("port"));
        String ip = connConfig.get("ip");
        String urls = connConfig.get("urls");
        String schema = connConfig.get("schema");
        LOGGER.info("connect to es:ip{},urls:{}", (Object)ip, (Object)urls);
        if (HRStringUtils.isNotEmpty((String)urls)) {
            String[] urlArr;
            for (String url : urlArr = urls.split(",")) {
                try {
                    httpHosts.add(HttpHost.create((String)url));
                }
                catch (Exception exception) {
                    LOGGER.warn("HttpHost.create exception:url:{}", (Object)url);
                }
            }
        }
        if (CollectionUtils.isEmpty(httpHosts)) {
            httpHosts.add(new HttpHost(ip, port, schema));
        }
        return httpHosts;
    }

    public static RestHighLevelClient createRestHighLevelClient(Map<String, String> connConfig) {
        List<HttpHost> httpHosts = SmartSearchEsAccess.getHttpHosts(connConfig);
        String username = connConfig.get("username");
        String password = connConfig.get("password");
        LOGGER.info("createRestHighLevelClient httpHosts:{}", httpHosts);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts.toArray(new HttpHost[0]));
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (username != null && password != null) {
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        }
        builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(5000).setSocketTimeout(60000).setConnectionRequestTimeout(5000));
        builder.setHttpClientConfigCallback(arg_0 -> SmartSearchEsAccess.lambda$createRestHighLevelClient$2((CredentialsProvider)credentialsProvider, arg_0));
        return new RestHighLevelClient(builder);
    }

    public static boolean existsAnalyzer(RestHighLevelClient client, String analyzer) {
        try {
            AnalyzeRequest analyzeRequest = new AnalyzeRequest();
            analyzeRequest.analyzer(analyzer);
            analyzeRequest.text(new String[]{"es analyzer test"});
            AnalyzeResponse analyze = client.indices().analyze(analyzeRequest, RequestOptions.DEFAULT);
            List tokens = analyze.getTokens();
            return !tokens.isEmpty();
        }
        catch (Exception e) {
            LOGGER.error("existsAnalyzer Exception ", (Throwable)e);
            return false;
        }
    }

    public static Map<String, Set<String>> findNotExistsField(RestHighLevelClient client, String indexName, Map<String, Set<String>> pathFieldMap) {
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        getMappingsRequest.indices(new String[]{indexName});
        try {
            Map mappings = client.indices().getMapping(getMappingsRequest, RequestOptions.DEFAULT).mappings();
            MappingMetaData mappingMetaData = mappings.values().stream().findFirst().orElse(null);
            if (mappingMetaData == null) {
                LOGGER.info("findNotExistsField mapping isnull,indexName:{}", (Object)indexName);
                return null;
            }
            Map sourceAsMap = mappingMetaData.getSourceAsMap();
            Map propMap = (Map)sourceAsMap.get("properties");
            if (propMap == null) {
                LOGGER.info("findNotExistsField prop isnull,indename:{}", (Object)indexName);
                return null;
            }
            HashMap<String, Set<String>> notExistsFieldMap = new HashMap<String, Set<String>>(16);
            pathFieldMap.forEach((path, fieldSet) -> {
                try {
                    Map tempProp;
                    if (HRStringUtils.isNotEmpty((String)path) && propMap.containsKey(path)) {
                        Map tempPathMap = (Map)propMap.get(path);
                        if (MapUtils.isEmpty((Map)tempPathMap)) {
                            return;
                        }
                        tempProp = (Map)tempPathMap.get("properties");
                    } else {
                        tempProp = propMap;
                    }
                    if (MapUtils.isEmpty((Map)tempProp)) {
                        return;
                    }
                    Set notExistsField = fieldSet.stream().filter(field -> !tempProp.containsKey(field)).collect(Collectors.toSet());
                    if (CollectionUtils.isNotEmpty(notExistsField)) {
                        notExistsFieldMap.put((String)path, notExistsField);
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("findNotExistsField skip indexName:{}, path:{}:", (Object)indexName, path);
                }
            });
            return notExistsFieldMap;
        }
        catch (Exception e) {
            LOGGER.error("findNotExistsField error:", (Throwable)e);
            return null;
        }
    }

    public static List<Map<String, Object>> distinctQuery(RestHighLevelClient client, String indexName, String nestedPath, List<String> distinctFieldList, boolean missBucket) {
        SearchResponse searchResponse;
        String compName = "distinct_dim";
        String nestDataName = "nested_data";
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.size(0);
        if (HRStringUtils.isNotEmpty((String)nestedPath)) {
            NestedAggregationBuilder nestedAggBuilder = AggregationBuilders.nested((String)nestDataName, (String)nestedPath);
            ArrayList sources = new ArrayList(3);
            for (String distinctField : distinctFieldList) {
                TermsValuesSourceBuilder terms = (TermsValuesSourceBuilder)((TermsValuesSourceBuilder)new TermsValuesSourceBuilder(distinctField).field(distinctField)).missingBucket(missBucket);
                sources.add(terms);
            }
            CompositeAggregationBuilder composite = new CompositeAggregationBuilder(compName, (List)sources);
            composite.size(10000);
            nestedAggBuilder.subAggregation((AggregationBuilder)composite);
            searchSourceBuilder.aggregation((AggregationBuilder)nestedAggBuilder);
        } else {
            ArrayList<TermsValuesSourceBuilder> sources = new ArrayList<TermsValuesSourceBuilder>(3);
            for (String distinctField : distinctFieldList) {
                TermsValuesSourceBuilder termsValuesSourceBuilder = (TermsValuesSourceBuilder)((TermsValuesSourceBuilder)new TermsValuesSourceBuilder(distinctField).field(distinctField)).missingBucket(missBucket);
                sources.add(termsValuesSourceBuilder);
            }
            CompositeAggregationBuilder composite = new CompositeAggregationBuilder(compName, sources);
            composite.size(10000);
            searchSourceBuilder.aggregation((AggregationBuilder)composite);
        }
        LOGGER.info("Es distinctQuery indexName : {} ", (Object)indexName);
        LOGGER.info("Es distinctQuery DSL : {} ", (Object)searchSourceBuilder.toString());
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            LOGGER.error("distinctQuery Exception: ", (Throwable)e);
            throw new KDException(BosEsErrorCode.esException, new Object[]{e});
        }
        Aggregations aggregations = searchResponse.getAggregations();
        ParsedComposite parsedComposite = HRStringUtils.isNotEmpty((String)nestedPath) ? (ParsedComposite)((ParsedNested)aggregations.get(nestDataName)).getAggregations().get(compName) : (ParsedComposite)aggregations.get(compName);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        if (parsedComposite != null) {
            List list = parsedComposite.getBuckets();
            for (ParsedComposite.ParsedBucket parsedBucket : list) {
                HashMap<String, Long> data = new HashMap<String, Long>(10);
                data.putAll(parsedBucket.getKey());
                data.put("count", parsedBucket.getDocCount());
                result.add(data);
            }
        }
        return result;
    }

    public static List<Map<String, Object>> suggest(RestHighLevelClient client, String indexName, String suggestField, String completionName, String suggestPrefix, List<String> contexts, List<String> retHitField, int size) {
        SearchResponse searchResponse;
        String suggestName = "my-suggest";
        CompletionSuggestionBuilder completionSuggestionBuilder = (CompletionSuggestionBuilder)SuggestBuilders.completionSuggestion((String)suggestField).prefix(suggestPrefix).skipDuplicates(true).size(size);
        if (CollectionUtils.isNotEmpty(contexts)) {
            ArrayList<CategoryQueryContext> contextList = new ArrayList<CategoryQueryContext>(contexts.size());
            for (String context : contexts) {
                contextList.add(CategoryQueryContext.builder().setCategory(context).setPrefix(false).build());
            }
            ConcurrentHashMap<String, ArrayList<CategoryQueryContext>> filterMap = new ConcurrentHashMap<String, ArrayList<CategoryQueryContext>>();
            filterMap.put(completionName, contextList);
            completionSuggestionBuilder.contexts(filterMap);
        }
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        suggestBuilder.addSuggestion(suggestName, (SuggestionBuilder)completionSuggestionBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.source().suggest(suggestBuilder);
        LOGGER.info("Es suggest indexName : {} ", (Object)indexName);
        LOGGER.info("Es suggest DSL : {} ", (Object)suggestBuilder.toString());
        try {
            searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            LOGGER.error("suggest Exception: ", (Throwable)e);
            throw new KDException(BosEsErrorCode.esException, new Object[]{e});
        }
        Suggest.Suggestion orderSuggest = searchResponse.getSuggest().getSuggestion(suggestName);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        CompletionSuggestion.Entry entry = (CompletionSuggestion.Entry)orderSuggest.getEntries().get(0);
        List optionList = entry.getOptions();
        for (CompletionSuggestion.Entry.Option option : optionList) {
            HashMap<String, String> data = new HashMap<String, String>(16);
            String text = option.getText().toString();
            data.put("text", text);
            if (CollectionUtils.isNotEmpty(retHitField)) {
                Map sourceAsMap = option.getHit().getSourceAsMap();
                for (String field : retHitField) {
                    data.put(field, (String)sourceAsMap.get(field));
                }
            }
            resultList.add(data);
        }
        return resultList;
    }

    public static SearchResponse searchAfter(RestHighLevelClient client, String index, String[] selectFields, QueryBuilder filterQb, String preTag, String postTag, int size, Object[] objSortValues) {
        Object queryBuilder = null == filterQb ? QueryBuilders.matchAllQuery() : filterQb;
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)queryBuilder);
        sourceBuilder.from(0);
        sourceBuilder.size(size);
        sourceBuilder.fetchSource(selectFields, null);
        sourceBuilder.sort("_id", SortOrder.ASC);
        if (objSortValues == null || objSortValues.length == 0) {
            sourceBuilder.searchAfter();
        } else {
            sourceBuilder.searchAfter(objSortValues);
        }
        SmartSearchEsAccess.highlighBuilder(sourceBuilder, preTag, postTag, null);
        searchRequest.source(sourceBuilder);
        LOGGER.info("Es search withhighlight indexName : {} ", (Object)index);
        if (queryBuilder instanceof BoolQueryBuilder) {
            LOGGER.info("Es DSL statement: {}", (Object)((BoolQueryBuilder)queryBuilder).toString(false));
        } else {
            LOGGER.info("Es DSL statement: {}", (Object)queryBuilder.toString());
        }
        try {
            return client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            LOGGER.error("searchAfter Exception: ", (Throwable)e);
            throw new KDException(BosEsErrorCode.esException, new Object[]{e});
        }
    }

    public static SearchResponse querySearchHits(RestHighLevelClient client, String index, String[] selectFields, QueryBuilder filterQb, String preTag, String postTag, QueryBuilder lighthighQb, int start, int size, boolean withHighLight) {
        Object queryBuilder = null == filterQb ? QueryBuilders.matchAllQuery() : filterQb;
        SearchRequest req = new SearchRequest(new String[]{index});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)queryBuilder).from(start).size(size).fetchSource(selectFields, null);
        if (withHighLight) {
            SmartSearchEsAccess.highlighBuilder(sourceBuilder, preTag, postTag, lighthighQb);
        }
        req.source(sourceBuilder);
        LOGGER.info("Es search withhighlight indexName : {} ", (Object)index);
        if (queryBuilder instanceof BoolQueryBuilder) {
            LOGGER.info("Es DSL statement: {}", (Object)((BoolQueryBuilder)queryBuilder).toString(false));
        } else {
            LOGGER.info("Es DSL statement: {}", (Object)queryBuilder.toString());
        }
        try {
            return client.search(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            LOGGER.error("search Exception: ", (Throwable)e);
            throw new KDException(BosEsErrorCode.esException, new Object[]{e});
        }
    }

    public static List<BulkItemResponse> batchSave(RestHighLevelClient client, String index, String type, List<Map<String, Object>> listMap) {
        BulkRequest req = new BulkRequest();
        req.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ArrayList<BulkRequest> listBulkRequest = new ArrayList<BulkRequest>();
        int count = 0;
        for (Map<String, Object> map : listMap) {
            Object id = map.get("_id");
            map.remove("_id", id);
            IndexRequest indexRequest = new IndexRequest(index, type, String.valueOf(id)).source(map);
            UpdateRequest updateRequest = new UpdateRequest(index, type, String.valueOf(id)).upsert(indexRequest);
            updateRequest.doc(indexRequest);
            updateRequest.retryOnConflict(Integer.parseInt(System.getProperty(RETRY_ON_CONFLICT_KEY, "5")));
            req.add(updateRequest);
            long size = req.estimatedSizeInBytes();
            if (size > 100000000L) {
                LOGGER.error("data sync fail, id:{}, Data greater than 100M, data size ", id, (Object)size);
            }
            ++count;
            if (size < 10000000L) continue;
            listBulkRequest.add(req);
            count = 0;
            req = new BulkRequest();
            req.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        if (count > 0) {
            listBulkRequest.add(req);
        }
        ArrayList<BulkItemResponse> failureRes = new ArrayList<BulkItemResponse>();
        BulkResponse res = null;
        LOGGER.info("batchSave bulk batchsize:{}", (Object)listBulkRequest.size());
        long startTime = System.currentTimeMillis();
        for (BulkRequest bulkRequest : listBulkRequest) {
            try {
                res = client.bulk(bulkRequest, RequestOptions.DEFAULT);
            }
            catch (IOException ioExp1) {
                LOGGER.warn("batchSave Reconnection warn, time:{}", (Object)(System.currentTimeMillis() - startTime));
                LOGGER.warn("batchSave Reconnection warn: {} ", (Object)ioExp1.getMessage());
                try {
                    client = ElasticsearchClientUtil.getClient();
                    res = client.bulk(bulkRequest, RequestOptions.DEFAULT);
                }
                catch (IOException ioExp2) {
                    LOGGER.error("batchSave error:", (Throwable)ioExp2);
                    throw new KDException((Throwable)ioExp2, BosEsErrorCode.esException, new Object[0]);
                }
            }
            if (!res.hasFailures()) continue;
            for (BulkItemResponse resp : res.getItems()) {
                if (!resp.isFailed()) continue;
                failureRes.add(resp);
            }
        }
        return failureRes;
    }

    private static void highlighBuilder(SearchSourceBuilder ssb, String preTag, String postTag, QueryBuilder lighthighQb) {
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        ((HighlightBuilder)highlightBuilder.preTags(new String[]{preTag})).postTags(new String[]{postTag});
        highlightBuilder.field("*");
        if (lighthighQb != null) {
            highlightBuilder.highlightQuery(lighthighQb);
        }
        ssb.highlighter(highlightBuilder);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createRestHighLevelClient$2(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setMaxConnTotal(100);
        httpClientBuilder.setMaxConnPerRoute(100);
        httpClientBuilder.disableAuthCaching();
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        httpClientBuilder.setKeepAliveStrategy((response, context) -> TimeUnit.MINUTES.toMillis(5L)).setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(2).setSoKeepAlive(true).build());
        return httpClientBuilder;
    }
}

