/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.es;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.query.es.EsBatchValue;
import kd.hr.hbp.business.service.query.es.EsContext;
import kd.hr.hbp.business.service.query.es.EsDataType;
import kd.hr.hbp.business.service.query.es.EsMappingProperty;
import kd.hr.hbp.business.service.query.es.EsPropertyValue;
import kd.hr.hbp.business.service.query.es.EsTokenizerType;
import kd.hr.hbp.business.service.query.es.storage.BaseEsStorage;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.business.service.query.es.storage.EsResultVo;
import kd.hr.hbp.business.service.query.es.storage.SortField;
import kd.hr.hbp.business.service.query.es.storage.highlevel.EsAccess;
import kd.hr.hbp.common.model.query.BosEsErrorCode;
import kd.hr.hbp.common.util.EsCommonUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.es.ElasticsearchClientUtil;
import kd.hrmp.hrss.business.domain.search.service.es.SmartSearchEsAccess;
import org.apache.commons.collections.MapUtils;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;

public class SmartSearchEsEsStorage
extends BaseEsStorage {
    private static final Log LOGGER = LogFactory.getLog(SmartSearchEsEsStorage.class);
    private static final String strDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final RestHighLevelClient client = ElasticsearchClientUtil.getClient();

    public void createIndex(String region, String indexName, Map<String, Object> settingsMap) {
        if (MapUtils.isEmpty(settingsMap)) {
            settingsMap = EsCommonUtils.getIndexSettings((String)region);
        }
        if (!EsAccess.isIndexExist((RestHighLevelClient)this.client, (String)indexName)) {
            EsAccess.createIndex((RestHighLevelClient)this.client, (String)indexName, (Map)settingsMap);
        }
    }

    public List<Map<String, Object>> suggest(String indexName, String suggestField, String completionName, String suggestPrefix, List<String> contexts, List<String> retHitField, int size) {
        return SmartSearchEsAccess.suggest(this.client, indexName, suggestField, completionName, suggestPrefix, contexts, retHitField, size);
    }

    public List<Map<String, Object>> distinctComposite(String indexName, String nestedPath, List<String> distinctFieldList, boolean missBucket) {
        return SmartSearchEsAccess.distinctQuery(this.client, indexName, nestedPath, distinctFieldList, missBucket);
    }

    public SearchResponse search(String indexName, String[] selectFileds, QueryBuilder queryBuilder, int start, int size) {
        return SmartSearchEsAccess.querySearchHits(this.client, indexName, selectFileds, queryBuilder, null, null, null, start, size, false);
    }

    public SearchResponse search(String indexName, String[] selectFileds, QueryBuilder queryBuilder, String preTag, String postTag, QueryBuilder lightHighQb, int start, int size) {
        return SmartSearchEsAccess.querySearchHits(this.client, indexName, selectFileds, queryBuilder, preTag, postTag, lightHighQb, start, size, true);
    }

    public SearchResponse searchAfter(String indexName, String[] selectFileds, QueryBuilder queryBuilder, String preTag, String postTag, int size, Object[] objSortValues) {
        return SmartSearchEsAccess.searchAfter(this.client, indexName, selectFileds, queryBuilder, preTag, postTag, size, objSortValues);
    }

    public boolean existsAnalyzer(String analyzer) {
        return SmartSearchEsAccess.existsAnalyzer(this.client, analyzer);
    }

    public Map<String, Set<String>> findNotExistsField(String indexName, Map<String, Set<String>> pathFieldMap) {
        return SmartSearchEsAccess.findNotExistsField(this.client, indexName, pathFieldMap);
    }

    public void addMappingIndex(String indexName, String typeName, String mappingDynamic, EsMappingProperty ... esMappingIndexs) {
        try {
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().startObject();
            this.getFieldsMapping(jsonBuilder, typeName, esMappingIndexs);
            if (HRStringUtils.isNotEmpty((String)mappingDynamic)) {
                jsonBuilder.field("dynamic", mappingDynamic);
            }
            jsonBuilder.endObject();
            EsAccess.createIndexMapping((RestHighLevelClient)this.client, (String)indexName, (String)typeName, (XContentBuilder)jsonBuilder);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
            throw new KDBizException(BosEsErrorCode.esException, new Object[]{"addMappingIndex fail:" + e.getMessage()});
        }
    }

    public void batchSave(String indexName, String typeName, EsBatchValue ... values) {
        ArrayList<BulkItemResponse> failureRespList = new ArrayList<BulkItemResponse>();
        ArrayList mapList = Lists.newArrayListWithCapacity((int)16);
        int batchFlag = 0;
        int saveSize = 0;
        for (EsBatchValue bv2 : values) {
            if (++batchFlag > 5000) {
                failureRespList.addAll(SmartSearchEsAccess.batchSave(this.client, indexName, typeName, mapList));
                batchFlag = 1;
                mapList.clear();
            }
            Map<String, Object> map = this.buidPropertyValue(bv2.getValues());
            map.put("_id", bv2.getId());
            ++saveSize;
            mapList.add(map);
        }
        failureRespList.addAll(SmartSearchEsAccess.batchSave(this.client, indexName, typeName, mapList));
        if (!failureRespList.isEmpty()) {
            try {
                String errFirstId = ((BulkItemResponse)failureRespList.get(0)).getId();
                EsBatchValue esBatchValue = Arrays.stream(values).filter(bv -> bv.getId().equals(errFirstId)).findFirst().orElse(null);
                if (esBatchValue != null) {
                    LOGGER.error("ES batchSave fail:indexname:{}", (Object)indexName);
                    LOGGER.error("ES batchSave fail:first data:{}", (Object)SerializationUtils.toJsonString(this.buidPropertyValue(esBatchValue.getValues())));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new KDException(BosEsErrorCode.esException, new Object[]{this.buildBulkFailureMessage(saveSize, failureRespList)});
        }
    }

    public EsResultVo query(String indexName, String typeName, String[] selectFileds, List<EsFilterField> filters, SortField[] sortFields, boolean score, int start, int size) {
        QueryBuilder queryBuilder = this.buidQueryBuilder(filters);
        return EsAccess.query((RestHighLevelClient)this.client, (String)indexName, (String)typeName, (String[])selectFileds, (QueryBuilder)queryBuilder, (SortField[])sortFields, (boolean)score, (int)start, (int)size, null);
    }

    public void deleteByQuery(String indexName, String typeName, List<EsFilterField> filters) {
        EsAccess.deleteByQuery((RestHighLevelClient)this.client, (String)indexName, (String)typeName, (QueryBuilder)this.buidQueryBuilder(filters));
    }

    public boolean deleteIndex(String indexName) {
        return EsAccess.deleteIndex((RestHighLevelClient)this.client, (String)indexName);
    }

    public boolean removeAndAddAliases(String indexName, String aliasName) {
        Map<String, Set<AliasMetaData>> map = this.getAliasIndex(aliasName);
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        if (map != null) {
            for (Map.Entry<String, Set<AliasMetaData>> entry : map.entrySet()) {
                String oldIndex = entry.getKey();
                IndicesAliasesRequest.AliasActions removeAliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(oldIndex).alias(aliasName);
                request.addAliasAction(removeAliasAction);
            }
        }
        IndicesAliasesRequest.AliasActions addAliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(indexName).alias(aliasName).writeIndex(Boolean.valueOf(true));
        request.addAliasAction(addAliasAction);
        try {
            AcknowledgedResponse indicesAliasesResponse = this.client.indices().updateAliases(request, RequestOptions.DEFAULT);
            boolean acknowledged = indicesAliasesResponse.isAcknowledged();
            return acknowledged;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
    }

    public Boolean isIndexExist(String indexName) {
        return EsAccess.isIndexExist((RestHighLevelClient)this.client, (String)indexName);
    }

    public Map<String, Set<AliasMetaData>> getAliasIndex(String aliasName) {
        GetAliasesRequest request = new GetAliasesRequest(new String[]{aliasName});
        Map map = null;
        try {
            GetAliasesResponse getAliasesResponse = this.client.indices().getAlias(request, RequestOptions.DEFAULT);
            map = getAliasesResponse.getAliases();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
        return map;
    }

    public boolean ping() throws IOException {
        return this.client.ping(RequestOptions.DEFAULT);
    }

    public Map<String, Set<AliasMetaData>> getAllIndex() {
        GetAliasesRequest request = new GetAliasesRequest();
        Map map = null;
        try {
            GetAliasesResponse getAliasesResponse = this.client.indices().getAlias(request, RequestOptions.DEFAULT);
            map = getAliasesResponse.getAliases();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
        return map;
    }

    protected QueryBuilder buidQueryBuilderBase(EsFilterField filter) {
        Object[] keywords = filter.getKeywords();
        if (keywords != null && keywords.length > 0 && keywords[0] instanceof Date) {
            ArrayList<String> dateStrList = new ArrayList<String>(10);
            for (Object keyword : keywords) {
                dateStrList.add(this.formatDate(keyword));
            }
            filter = new EsFilterField(filter.getPath(), filter.getName(), filter.getCp(), dateStrList.toArray());
        }
        return super.buidQueryBuilderBase(filter);
    }

    private String formatDate(Object object) {
        if (object instanceof Date) {
            return this.simpleDateFormat.format((Date)object);
        }
        return null;
    }

    private Map<String, Object> buidPropertyValue(Object[] upFields) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object object : upFields) {
            List obj;
            EsPropertyValue pv = (EsPropertyValue)object;
            String name = pv.getPropertyName();
            Map<String, Object> value = pv.getValue();
            if (value instanceof Date) {
                String strDate = this.formatDate(value);
                map.put(name, strDate);
                continue;
            }
            if (EsDataType.NESTED == pv.getDataType()) {
                List objectList = pv.nests;
                ArrayList<Map<String, Object>> nestList = new ArrayList<Map<String, Object>>();
                HashMap<String, Object> nestMap = new HashMap<String, Object>();
                for (Object nestObject : objectList) {
                    if (nestObject instanceof List) {
                        List nestObjectList = (List)nestObject;
                        nestList.add(this.buidPropertyValue(nestObjectList.toArray()));
                        continue;
                    }
                    if (!(nestObject instanceof EsPropertyValue)) continue;
                    EsPropertyValue nestPropertyValue = (EsPropertyValue)nestObject;
                    nestMap.put(nestPropertyValue.getPropertyName(), nestPropertyValue.getValue());
                }
                if (nestList.size() > 0) {
                    value = nestList;
                } else if (nestMap.size() > 0) {
                    value = nestMap;
                }
            } else if (EsDataType.OBJECT == pv.getDataType() && (obj = pv.nests) != null) {
                List nestObjectList = (List)obj.get(0);
                value = this.buidPropertyValue(nestObjectList.toArray());
            }
            map.put(name, value);
        }
        return map;
    }

    protected XContentBuilder getFieldsMapping(XContentBuilder jsonBuilder, String coreName, EsMappingProperty ... esMappingIndexs) throws IOException {
        jsonBuilder.startObject("properties");
        for (EsMappingProperty mappingProperty : esMappingIndexs) {
            jsonBuilder.startObject(mappingProperty.getPropertyName()).field("type", (Object)mappingProperty.getDataType());
            if (EsDataType.STRING == mappingProperty.getDataType() || EsDataType.TEXT == mappingProperty.getDataType()) {
                if (EsTokenizerType.STANDARD != mappingProperty.getTokenizerType()) {
                    jsonBuilder.field("analyzer", (Object)mappingProperty.getTokenizerType());
                }
                if (EsTokenizerType.STANDARD != mappingProperty.getSearchTokenizerType()) {
                    jsonBuilder.field("search_analyzer", (Object)mappingProperty.getSearchTokenizerType());
                }
                jsonBuilder.startObject("fields").startObject("keyword").field("type", "keyword").field("ignore_above", mappingProperty.getPropertySize()).endObject().endObject();
            } else if (EsDataType.DATE != mappingProperty.getDataType()) {
                List esContextList;
                if (EsDataType.NESTED == mappingProperty.getDataType() || EsDataType.OBJECT == mappingProperty.getDataType()) {
                    this.getFieldsMapping(jsonBuilder, null, mappingProperty.nests.toArray(new EsMappingProperty[0]));
                } else if (EsDataType.COMPLETION == mappingProperty.getDataType() && (esContextList = mappingProperty.getEsContextList()) != null && esContextList.size() > 0) {
                    jsonBuilder.field("analyzer", (Object)mappingProperty.getTokenizerType()).startObject("contexts");
                    for (EsContext esContext : esContextList) {
                        jsonBuilder.field("name", esContext.getName()).field("type", esContext.getType()).field("path", esContext.getPath());
                    }
                    jsonBuilder.endObject();
                }
            }
            jsonBuilder.endObject();
        }
        jsonBuilder.endObject();
        return jsonBuilder;
    }
}

