/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.enums.smartsearch.CustomFilterTypeEnum;
import kd.hr.hbp.common.model.smartsearch.scene.SearchCustomFilterBo;
import kd.hrmp.hrss.business.domain.search.service.filter.CustomFilterRuleService;
import kd.hrmp.hrss.business.domain.search.service.searchscene.SearchSceneBusQueryService;

public class CustomQFilterFunction
implements Function<QFilter, QFilter> {
    private final Long sceneId;
    private DynamicObject sceneDyo;
    private Map<Long, List<SearchCustomFilterBo>> customFieldMap;
    private static final Log LOGGER = LogFactory.getLog(CustomQFilterFunction.class);

    public CustomQFilterFunction(Long sceneId) {
        this.sceneId = sceneId;
    }

    @Override
    public QFilter apply(QFilter qFilter) {
        QFilter nowFilter;
        String property = qFilter.getProperty();
        if (!property.contains("$")) {
            return qFilter;
        }
        String[] split = property.split("\\$");
        if (split.length != 2) {
            throw new KDBizException("custom filter error:" + qFilter.getProperty());
        }
        String fieldAlias = split[0];
        DynamicObject curSceneDyo = this.getSceneDyo();
        DynamicObjectCollection searchFilterColl = curSceneDyo.getDynamicObjectCollection("filterentryentity");
        DynamicObject searchFilterDyo = searchFilterColl.stream().filter(dyo -> dyo.getDynamicObject("customfilter") != null && fieldAlias.equals(dyo.getString("searchobjfield.fieldalias"))).findAny().orElse(null);
        if (searchFilterDyo == null) {
            throw new KDBizException("custom filter error:" + qFilter.getProperty());
        }
        DynamicObject customFilterDyo = searchFilterDyo.getDynamicObject("customfilter");
        String customFieldKey = split[1];
        List<SearchCustomFilterBo> customFilterList = this.getCustomFilterList(customFilterDyo.getLong("id"));
        SearchCustomFilterBo customFilter = customFilterList.stream().filter(cf -> cf.getKey().equals(customFieldKey)).findAny().orElse(null);
        if (customFilter == null) {
            throw new KDBizException("custom filter error:" + qFilter.getProperty());
        }
        String filterRule = customFilter.getFilterRule();
        LOGGER.info("custom filter trans param:[filterRule:{}, type:{}, fieldAlias:{}]", new Object[]{filterRule, customFilter.getCustomFilterType(), fieldAlias});
        if (customFilter.getCustomFilterType() == CustomFilterTypeEnum.RULE_CONFIG) {
            nowFilter = CustomFilterRuleService.getQFilterByRule(filterRule, fieldAlias);
        } else if (customFilter.getCustomFilterType() == CustomFilterTypeEnum.PARSE_CLASS) {
            try {
                nowFilter = CustomFilterRuleService.getQFilterByClass(filterRule, fieldAlias);
            }
            catch (Exception e) {
                LOGGER.error("getQFilterByClass fail:", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        } else {
            throw new KDBizException("custom filter error:" + qFilter.getProperty());
        }
        LOGGER.info("custom filter trans result:{}", (Object)nowFilter);
        return nowFilter;
    }

    private List<SearchCustomFilterBo> getCustomFilterList(Long customFilterPk) {
        List<SearchCustomFilterBo> customFilterList;
        if (this.customFieldMap == null) {
            this.customFieldMap = new HashMap<Long, List<SearchCustomFilterBo>>(16);
        }
        if ((customFilterList = this.customFieldMap.get(customFilterPk)) == null) {
            customFilterList = SearchSceneBusQueryService.genCustomFilterList(customFilterPk);
            this.customFieldMap.put(customFilterPk, customFilterList);
        }
        return customFilterList;
    }

    private DynamicObject getSceneDyo() {
        if (this.sceneDyo == null) {
            this.sceneDyo = SearchSceneBusQueryService.loadSceneConf(this.sceneId);
        }
        return this.sceneDyo;
    }
}

