/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.query;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.constants.smartsearch.HRSmartSearchConstants;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFieldBo;
import kd.hr.hbp.common.model.smartsearch.search.LabelValCompResp;
import kd.hr.hbp.common.model.smartsearch.search.SearchParam;
import kd.hr.hbp.common.model.smartsearch.search.SmartSearchData;
import kd.hr.hbp.common.model.smartsearch.search.SmartSearchResp;
import kd.hr.hbp.common.model.smartsearch.search.SmartSearchRowData;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.common.AppMetaUtil;
import kd.hrmp.hrss.business.domain.search.service.common.HRContextCache;
import kd.hrmp.hrss.business.domain.search.service.common.LabelFieldUtil;
import kd.hrmp.hrss.business.domain.search.service.datasync.SearchObjEsOperateService;
import kd.hrmp.hrss.business.domain.search.service.query.QFilterQueryBuilder;
import kd.hrmp.hrss.business.domain.search.service.query.SearchQBuilderService;
import kd.hrmp.hrss.business.domain.search.service.searchlog.UserSearchLogService;
import kd.hrmp.hrss.business.domain.search.service.searchobj.SearchObjectService;
import kd.hrmp.hrss.business.domain.search.service.searchscene.SearchSceneBusQueryService;
import kd.hrmp.hrss.common.model.search.GptAndDslBo;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class ESSearchService {
    private static final Log LOGGER = LogFactory.getLog(ESSearchService.class);
    private static final Set<String> enableLangNums;

    public static SmartSearchResp search(SearchParam searchParam, List<String> searchField, QFilter[] qFilters, String highLightPreTag, String highLightPostTag, int start, int limit) {
        SmartSearchResp searchResp = ESSearchService.doSearch(searchParam, searchField, qFilters, highLightPreTag, highLightPostTag, start, limit, false, null);
        LOGGER.info("DO_SEARCH_LOGsearch data total:{}", (Object)searchResp.getTotalHits());
        List rowDataList = searchResp.getRowDataList();
        if (CollectionUtils.isNotEmpty((Collection)rowDataList)) {
            for (int i = 0; i < rowDataList.size() && i < 2; ++i) {
                SmartSearchRowData smartSearchRowData = (SmartSearchRowData)rowDataList.get(i);
                LOGGER.info("DO_SEARCH_LOGsearch data result top 2:{}", (Object)smartSearchRowData.getHighLightData());
            }
        }
        return searchResp;
    }

    public static SmartSearchResp searchAfter(SearchParam searchParam, List<String> searchField, QFilter[] qFilters, String highLightPreTag, String highLightPostTag, Object[] objSortValues, int limit) {
        SmartSearchResp searchResp = ESSearchService.doSearch(searchParam, searchField, qFilters, highLightPreTag, highLightPostTag, 0, limit, true, objSortValues);
        LOGGER.info("DO_SEARCH_LOGsearch data total:{}", (Object)searchResp.getTotalHits());
        return searchResp;
    }

    private static SmartSearchResp doSearch(SearchParam searchParam, List<String> searchField, QFilter[] qFilters, String highLightPreTag, String highLightPostTag, int start, int limit, boolean searchAfter, Object[] objSortValues) {
        if (limit > 10000) {
            limit = 10000;
        }
        LOGGER.info("DO_SEARCH_LOGsearch param[searchParam:{}]", (Object)searchParam);
        List<SearchFieldBo> allSearchFieldList = ESSearchService.checkParamAndQueryField(searchParam, qFilters);
        HRComplexObjContext complexObjContext = HRContextCache.getComplexObjContext(searchParam.getSearchObjId());
        if (complexObjContext == null) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u641c\u7d22\u5bf9\u8c61\u914d\u7f6e\u9519\u8bef\u3002", (String)"ESSearchService_0", (String)"hrmp-hrss-business", (Object[])new Object[0])});
        }
        if (CollectionUtils.isEmpty(searchField)) {
            searchField = allSearchFieldList.stream().filter(SearchFieldBo::isDisplayView).map(SearchFieldBo::getFieldAlias).collect(Collectors.toList());
        }
        LOGGER.info("DO_SEARCH_LOGsearch fields:{}", searchField);
        SearchObjEsOperateService esOperateService = new SearchObjEsOperateService();
        if (!esOperateService.existsValidIndex(searchParam.getSearchObjId()).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u672a\u5b8c\u6210\u3002", (String)"ESSearchService_4", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        List qfilterList = complexObjContext.getQfilterList();
        String permCtlDymNum = searchParam.getPermCtlDymNum();
        QFilter permQfilter = ESSearchService.getDymPermQfilter(permCtlDymNum, searchParam.getPermCtlAppNum());
        if (permQfilter != null) {
            qfilterList.add(permQfilter);
        }
        qFilters = ESSearchService.mergeQFilter(qfilterList, qFilters);
        SmartSearchResp smartSearchResp = ESSearchService.execSearch(searchParam, searchField, qFilters, highLightPreTag, highLightPostTag, start, limit, complexObjContext, allSearchFieldList, searchAfter, objSortValues);
        return smartSearchResp;
    }

    private static List<QFilter> getLabelCompFilter(SearchParam searchParam) {
        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>(10);
        List labelValCompSelList = searchParam.getLabelValCompSelList();
        if (labelValCompSelList != null) {
            for (LabelValCompResp labelValCompResp : labelValCompSelList) {
                qfilterList.add(new QFilter(labelValCompResp.getFieldAlias(), "=", (Object)labelValCompResp.getDisplayName()));
            }
        }
        return qfilterList;
    }

    private static List<SearchFieldBo> checkParamAndQueryField(SearchParam searchParam, QFilter[] qFilters) {
        long dbVersion;
        String permCtlDymNum = searchParam.getPermCtlDymNum();
        if (HRStringUtils.isEmpty((String)permCtlDymNum)) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u67e5\u5230\u5f53\u524d\u641c\u7d22\u573a\u666f\u672a\u7ef4\u62a4\u201c\u524d\u7aef\u4e1a\u52a1\u641c\u7d22\u9875\u9762\u201d\uff0c\u65e0\u6cd5\u6267\u884c\u641c\u7d22\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ESSearchService_5", (String)"hrmp-hrss-business", (Object[])new Object[0])});
        }
        if (HRStringUtils.isEmpty((String)searchParam.getSearchContent()) && (qFilters == null || qFilters.length == 0)) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u641c\u7d22\u6761\u4ef6\u3002", (String)"ESSearchService_2", (String)"hrmp-hrss-business", (Object[])new Object[0])});
        }
        if (!SearchObjectService.getInstance().isExistsSearchObj(searchParam.getSearchObjId())) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u641c\u7d22\u5bf9\u8c61\u914d\u7f6e\u9519\u8bef\u3002", (String)"ESSearchService_0", (String)"hrmp-hrss-business", (Object[])new Object[0])});
        }
        DynamicObject sceneDyo = SearchSceneBusQueryService.loadSceneConf(searchParam.getSceneId());
        if (sceneDyo == null) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u641c\u7d22\u573a\u666f\u914d\u7f6e\u9519\u8bef\u3002", (String)"ESSearchService_1", (String)"hrmp-hrss-business", (Object[])new Object[0])});
        }
        long sceneVersion = searchParam.getSceneVersion();
        if (sceneVersion > 0L && sceneVersion != (dbVersion = sceneDyo.getDate("modifytime").getTime())) {
            throw new KDBizException(HRSmartSearchConstants.SCENE_CONFIG_MODIFY, new Object[0]);
        }
        List<SearchFieldBo> searchFieldBoList = SearchSceneBusQueryService.genSearchFieldList(sceneDyo, searchParam.getSearchObjId());
        Set queryFieldSet = searchFieldBoList.stream().map(SearchFieldBo::getFieldAlias).collect(Collectors.toSet());
        List<SearchFieldBo> labelFieldList = SearchObjectService.getInstance().queryAllLabelFields(searchParam.getSearchObjId());
        labelFieldList.stream().filter(labelField -> !queryFieldSet.contains(labelField.getFieldAlias())).forEachOrdered(labelField -> {
            searchFieldBoList.add((SearchFieldBo)labelField);
            queryFieldSet.add(labelField.getFieldAlias());
        });
        return searchFieldBoList;
    }

    private static QFilter getDymPermQfilter(String permCtlDymNum, String appNumber) {
        if (permCtlDymNum.equals("hrss_searchscenetest")) {
            return null;
        }
        String appId = AppMetaUtil.getEntityAppId(permCtlDymNum, appNumber);
        HashMap customParam = Maps.newHashMapWithExpectedSize((int)16);
        return (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appId, permCtlDymNum, "47150e89000000ac", customParam});
    }

    private static SmartSearchResp execSearch(SearchParam searchParam, List<String> searchFieldList, QFilter[] qFilters, String highLightPreTag, String highLightPostTag, int start, int limit, HRComplexObjContext complexObjContext, List<SearchFieldBo> allSearchFieldList, boolean searchAfter, Object[] objSortValues) {
        SearchResponse searchResponse;
        QueryBuilder keyWordSearchBuilder = null;
        GptAndDslBo gptAndDslBo = null;
        try {
            SearchQBuilderService searchQBuilderService = new SearchQBuilderService();
            gptAndDslBo = searchQBuilderService.genKeyWordSearchBuilder(searchParam, complexObjContext);
            if (gptAndDslBo != null) {
                keyWordSearchBuilder = gptAndDslBo.getInputQueryBuilder();
            }
        }
        catch (Exception exception) {
            LOGGER.error("DO_SEARCH_LOGgenKeyWordSearchBuilder exception:", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u5168\u6587\u68c0\u7d22\u6761\u4ef6\u751f\u6210\u5f02\u5e38\u3002", (String)"ESSearchService_6", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        LOGGER.info("DO_SEARCH_LOGgenKeyWordSearchBuilder result:{}", (Object)keyWordSearchBuilder);
        BoolQueryBuilder smartSearchQueryBuilder = null;
        if (keyWordSearchBuilder instanceof BoolQueryBuilder) {
            smartSearchQueryBuilder = (BoolQueryBuilder)keyWordSearchBuilder;
        } else if (keyWordSearchBuilder != null) {
            smartSearchQueryBuilder = QueryBuilders.boolQuery().must(keyWordSearchBuilder);
        }
        QueryBuilder highLightBuilder = ESSearchService.buildHighLightBuilder(searchParam, complexObjContext, smartSearchQueryBuilder);
        List<QFilter> labelCompFilter = ESSearchService.getLabelCompFilter(searchParam);
        qFilters = ESSearchService.mergeQFilter(labelCompFilter, qFilters);
        SearchQBuilderService service = new SearchQBuilderService();
        QueryBuilder queryBuilder = service.assemblyKeyWordAndQFilter(searchParam.getSceneId(), complexObjContext, smartSearchQueryBuilder, qFilters);
        if (queryBuilder == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u672a\u68c0\u6d4b\u5230\u6709\u6548\u7684\u67e5\u8be2\u6761\u4ef6\u3002", (String)"ESSearchService_7", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        SearchObjEsOperateService esOperateService = new SearchObjEsOperateService();
        SmartSearchResp searchResp = new SmartSearchResp();
        ArrayList<String> esQueryFieldList = new ArrayList<String>(searchFieldList.size());
        Map<String, SearchFieldBo> queryFieldMap = allSearchFieldList.stream().collect(Collectors.toMap(SearchFieldBo::getFieldAlias, Function.identity()));
        for (String fieldAlias : searchFieldList) {
            esQueryFieldList.add(fieldAlias);
            if (ESSearchService.hasMulField(queryFieldMap, fieldAlias)) {
                esQueryFieldList.add(fieldAlias + "_l");
            }
            if (!ESSearchService.hasComboField(queryFieldMap, fieldAlias)) continue;
            esQueryFieldList.add(fieldAlias + "_store_value4es");
        }
        if (searchAfter) {
            searchResponse = esOperateService.searchAfter(searchParam.getSearchObjId(), esQueryFieldList, queryBuilder, highLightPreTag, highLightPostTag, limit, objSortValues);
            searchResp.setObjSortValues(esOperateService.getObjSortValues(searchResponse));
        } else {
            searchResponse = esOperateService.search(searchParam.getSearchObjId(), esQueryFieldList, queryBuilder, highLightPreTag, highLightPostTag, highLightBuilder, start, limit);
        }
        List<String> allFieldAliasList = allSearchFieldList.stream().map(SearchFieldBo::getFieldAlias).collect(Collectors.toList());
        List<Map<String, Object>> highLightResultList = esOperateService.getHighLightResult(allFieldAliasList, searchResponse);
        searchResp.setTotalHits(searchResponse.getHits().getTotalHits());
        boolean highLight = HRStringUtils.isNotEmpty((String)searchParam.getSearchContent());
        if (highLight) {
            ESSearchService.highLightRstTrans(highLightResultList);
        }
        List<SmartSearchRowData> smartSearchRowData = ESSearchService.genRowDataList(highLightResultList, searchFieldList, queryFieldMap, complexObjContext, highLight);
        searchResp.setRowDataList(smartSearchRowData);
        LOGGER.info("DO_SEARCH_LOGRecordSearchLog:{}", (Object)searchParam.isRecordSearchLog());
        if (searchParam.isRecordSearchLog()) {
            QFilter gptFilterResult = null;
            if (gptAndDslBo != null && gptAndDslBo.getInputFilterAnalysisRst() != null) {
                gptFilterResult = gptAndDslBo.getInputFilterAnalysisRst().getGptFilterResult();
            }
            UserSearchLogService.asynSaveUserSearchLog(searchParam, qFilters, allSearchFieldList, gptFilterResult, queryBuilder);
        }
        return searchResp;
    }

    private static QueryBuilder buildHighLightBuilder(SearchParam searchParam, HRComplexObjContext complexObjContext, BoolQueryBuilder smartSearchQueryBuilder) {
        QueryBuilder labelCompQueryBuilder;
        List<QFilter> lightLgComFilterList;
        BoolQueryBuilder highLightBuilder = null;
        if (smartSearchQueryBuilder != null) {
            highLightBuilder = QueryBuilders.boolQuery();
            smartSearchQueryBuilder.must().forEach(arg_0 -> ((BoolQueryBuilder)highLightBuilder).must(arg_0));
            smartSearchQueryBuilder.should().forEach(arg_0 -> ((BoolQueryBuilder)highLightBuilder).should(arg_0));
            smartSearchQueryBuilder.filter().forEach(arg_0 -> ((BoolQueryBuilder)highLightBuilder).filter(arg_0));
        }
        if (CollectionUtils.isNotEmpty(lightLgComFilterList = ESSearchService.getLabelCompFilter(searchParam)) && (labelCompQueryBuilder = QFilterQueryBuilder.getQueryBuilder(searchParam.getSceneId(), complexObjContext, lightLgComFilterList.toArray(new QFilter[0]))) != null) {
            if (highLightBuilder == null) {
                return QueryBuilders.constantScoreQuery((QueryBuilder)labelCompQueryBuilder);
            }
            highLightBuilder.filter(labelCompQueryBuilder);
        }
        return highLightBuilder;
    }

    private static QFilter[] mergeQFilter(List<QFilter> qfilterList, QFilter[] qFilters) {
        if (CollectionUtils.isEmpty(qfilterList)) {
            return qFilters;
        }
        if (qFilters != null && qFilters.length > 0) {
            qfilterList.addAll(Arrays.asList(qFilters));
        }
        return qfilterList.toArray(new QFilter[0]);
    }

    private static boolean hasMulField(Map<String, SearchFieldBo> queryFieldMap, String fieldAlias) {
        SearchFieldBo searchFieldBo = queryFieldMap.get(fieldAlias);
        if (searchFieldBo == null) {
            return false;
        }
        return FieldControlType.MUL_LANG_TEXT.getValue().equals(searchFieldBo.getControlType()) || FieldControlType.COMBO.getValue().equals(searchFieldBo.getControlType()) || FieldControlType.MUL_COMBO.getValue().equals(searchFieldBo.getControlType());
    }

    private static boolean hasComboField(Map<String, SearchFieldBo> queryFieldMap, String fieldAlias) {
        SearchFieldBo searchFieldBo = queryFieldMap.get(fieldAlias);
        if (searchFieldBo == null) {
            return false;
        }
        return FieldControlType.COMBO.getValue().equals(searchFieldBo.getControlType()) || FieldControlType.MUL_COMBO.getValue().equals(searchFieldBo.getControlType());
    }

    private static boolean isExtField(String fieldAlias) {
        for (String langNum : enableLangNums) {
            if (!fieldAlias.endsWith("_l." + langNum)) continue;
            return true;
        }
        return fieldAlias.endsWith("_l.GLang") || fieldAlias.endsWith("_store_value4es");
    }

    private static void fillFieldTypeProp(Map<String, SearchFieldBo> queryFieldMap, String fieldAlias, SmartSearchData smartSearchData) {
        SearchFieldBo searchFieldBo = queryFieldMap.get(fieldAlias);
        if (searchFieldBo != null) {
            smartSearchData.setControlType(searchFieldBo.getControlType());
            smartSearchData.setComplexType(searchFieldBo.getComplexType());
            smartSearchData.setValueType(searchFieldBo.getValueType());
        }
    }

    private static String getDbStoreVal(Map<String, SearchFieldBo> queryFieldMap, String fieldAlias, String dataMapKey, Map<String, Object> sourceAsMap) {
        if (ESSearchService.hasComboField(queryFieldMap, fieldAlias)) {
            return (String)sourceAsMap.get(dataMapKey + "_store_value4es");
        }
        return null;
    }

    private static String getMulFieldVal(Map<String, SearchFieldBo> queryFieldMap, String fieldAlias, String dataMapKey, Map<String, Object> sourceAsMap) {
        if (!ESSearchService.hasMulField(queryFieldMap, fieldAlias)) {
            return null;
        }
        String mulFieldPrex = dataMapKey + "_l.";
        String val = (String)sourceAsMap.get(mulFieldPrex + Lang.get().toString());
        if (val == null && (val = (String)sourceAsMap.get(mulFieldPrex + "GLang")) == null) {
            val = (String)sourceAsMap.get(mulFieldPrex + Lang.zh_CN);
        }
        return val;
    }

    private static void highLightRstTrans(List<Map<String, Object>> highLightResultList) {
        for (Map<String, Object> dataMap : highLightResultList) {
            Map highlightFields = (Map)dataMap.get("_highlightFields");
            HashMap highLightDataMap = new HashMap(16);
            highlightFields.forEach((fieldAlias, highlightField) -> {
                Text[] fragments = highlightField.getFragments();
                if (fragments.length == 1) {
                    highLightDataMap.put(fieldAlias, fragments[0].toString());
                } else {
                    ArrayList<String> list = new ArrayList<String>(16);
                    for (Text fragment : fragments) {
                        list.add(fragment.toString());
                    }
                    highLightDataMap.put(fieldAlias, list);
                }
            });
            dataMap.put("_highlightFields", highLightDataMap);
        }
    }

    private static List<SmartSearchRowData> genRowDataList(List<Map<String, Object>> resultList, List<String> searchField, Map<String, SearchFieldBo> queryFieldMap, HRComplexObjContext complexObjContext, boolean highLight) {
        Map<String, String> relEntityMap = complexObjContext.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();
        ArrayList<SmartSearchRowData> searchRstList = new ArrayList<SmartSearchRowData>(resultList.size());
        for (Map<String, Object> sourceAsMap : resultList) {
            Map highlightFields = (Map)sourceAsMap.get("_highlightFields");
            SmartSearchRowData rowData = new SmartSearchRowData();
            HashMap mainEntityDataMap = new HashMap(16);
            HashMap nestEntityDataMap = new HashMap(16);
            sourceAsMap.forEach((fieldName, dataValue) -> {
                if (ESSearchService.isExtField(fieldName)) {
                    return;
                }
                if (relEntityMap.containsKey(fieldName) && dataValue instanceof Collection) {
                    String entityAlias = fieldName;
                    ArrayList<SmartSearchRowData> smartSearchRowData = new ArrayList<SmartSearchRowData>(16);
                    List subEntityDataList = (List)dataValue;
                    String relEntityNumber = (String)relEntityMap.get(entityAlias);
                    for (Map subEntityDataMap : subEntityDataList) {
                        SmartSearchRowData subRowData = new SmartSearchRowData();
                        HashMap curEntityDataMap = new HashMap(16);
                        subEntityDataMap.forEach((subKey, subValue) -> {
                            if (ESSearchService.isExtField(subKey)) {
                                return;
                            }
                            String fieldAlias = entityAlias + "." + subKey;
                            String mulFieldVal = ESSearchService.getMulFieldVal(queryFieldMap, fieldAlias, subKey, subEntityDataMap);
                            Object rstVal = HRStringUtils.isEmpty((String)mulFieldVal) ? subValue : mulFieldVal;
                            SmartSearchData smartSearchData = ESSearchService.genSmartSearchData(subKey, entityAlias, rstVal);
                            smartSearchData.setEntry(ESSearchService.isEntry(relEntityNumber, subKey, entityTypeUtil));
                            String dbStoreVal = ESSearchService.getDbStoreVal(queryFieldMap, fieldAlias, subKey, subEntityDataMap);
                            smartSearchData.setDbStoreValue(dbStoreVal);
                            ESSearchService.fillFieldTypeProp(queryFieldMap, fieldAlias, smartSearchData);
                            curEntityDataMap.put(subKey, smartSearchData);
                        });
                        subRowData.setRowData(curEntityDataMap);
                        smartSearchRowData.add(subRowData);
                    }
                    nestEntityDataMap.put(entityAlias, smartSearchRowData);
                } else if (searchField.contains(fieldName)) {
                    String mulFieldVal = ESSearchService.getMulFieldVal(queryFieldMap, fieldName, fieldName, sourceAsMap);
                    Object rstVal = HRStringUtils.isEmpty((String)mulFieldVal) ? dataValue : mulFieldVal;
                    SmartSearchData smartSearchData = ESSearchService.genSmartSearchData(fieldName, null, rstVal);
                    String dbStoreVal = ESSearchService.getDbStoreVal(queryFieldMap, fieldName, fieldName, sourceAsMap);
                    smartSearchData.setDbStoreValue(dbStoreVal);
                    ESSearchService.fillFieldTypeProp(queryFieldMap, fieldName, smartSearchData);
                    mainEntityDataMap.put(fieldName, smartSearchData);
                } else if (ESSearchService.isEntry(complexObjContext.getEntityNumber(), fieldName, entityTypeUtil)) {
                    SmartSearchData entryDataBo = ESSearchService.genSmartSearchData(fieldName, null, dataValue);
                    entryDataBo.setEntry(true);
                    ESSearchService.fillFieldTypeProp(queryFieldMap, fieldName, entryDataBo);
                    mainEntityDataMap.put(fieldName, entryDataBo);
                }
            });
            rowData.setRowData(mainEntityDataMap);
            if (highLight) {
                rowData.setHighLightData(highlightFields);
            } else {
                rowData.setHighLightData(new HashMap(0));
            }
            rowData.setNestEntityData(nestEntityDataMap);
            searchRstList.add(rowData);
        }
        return searchRstList;
    }

    private static boolean isEntry(String entityNumber, String field, MainEntityTypeUtil entityTypeUtil) {
        MainEntityType entityType = entityTypeUtil.getMainEntityType(entityNumber);
        if (entityType == null) {
            return false;
        }
        DynamicProperty property = entityType.getProperty(field);
        return property instanceof EntryProp;
    }

    private static SmartSearchData genSmartSearchData(String curField, String subEntityAlias, Object data) {
        SmartSearchData smartSearchData = new SmartSearchData();
        String fieldAlias = curField;
        if (HRStringUtils.isNotEmpty((String)subEntityAlias)) {
            fieldAlias = subEntityAlias + "." + fieldAlias;
        }
        smartSearchData.setFieldAlias(fieldAlias);
        smartSearchData.setFieldWithOutEntityAlias(curField);
        if (LabelFieldUtil.isLabelField(curField)) {
            smartSearchData.setLabel(true);
            if (data instanceof List) {
                Map labelDataMap = (Map)((List)data).get(0);
                Object listObj = labelDataMap.get("labelValues");
                if (listObj instanceof Collection) {
                    smartSearchData.setArray(true);
                }
                smartSearchData.setValue(listObj);
            }
        } else {
            if (data instanceof Collection) {
                smartSearchData.setArray(true);
            }
            smartSearchData.setValue(data);
        }
        return smartSearchData;
    }

    static {
        InteServiceImpl inteService = new InteServiceImpl();
        List enabledLang = inteService.getEnabledLang();
        enableLangNums = enabledLang.stream().map(EnabledLang::getNumber).collect(Collectors.toSet());
    }
}

