/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.util.FieldFullPathParseUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryKSqlUtil;

public class EntityQueryFieldTransfer {
    public static List<EntityFieldInfo> transfer(HRComplexObjContext complexObjCont) {
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        List fieldInfoList = complexObjCont.getComplexObjFieldInfoList().stream().filter(fi -> "1".equals(fi.getFieldType())).collect(Collectors.toList());
        HashSet<String> transCacheSet = new HashSet<String>(16);
        HashMap<String, String> tablePk = new HashMap<String, String>(16);
        Map<String, String> relEntityMap = complexObjCont.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        String entityNumber = complexObjCont.getEntityNumber();
        MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(entityNumber);
        ArrayList<EntityFieldInfo> entityFieldInfoList = new ArrayList<EntityFieldInfo>(fieldInfoList.size());
        for (HRComplexObjFieldInfo fieldInfo : fieldInfoList) {
            String fieldAlias = fieldInfo.getAlias();
            if (transCacheSet.contains(fieldAlias)) continue;
            transCacheSet.add(fieldAlias);
            EntityFieldInfo entityFieldInfo = EntityQueryFieldTransfer.getEntityFieldInfo(tablePk, relEntityMap, entityNumber, mainEntityType, fieldInfo, mainEntityTypeUtil);
            entityFieldInfoList.add(entityFieldInfo);
        }
        return entityFieldInfoList;
    }

    private static EntityFieldInfo getEntityFieldInfo(Map<String, String> tablePk, Map<String, String> relEntityMap, String entityNumber, MainEntityType mainEntityType, HRComplexObjFieldInfo fieldInfo, MainEntityTypeUtil mainEntityTypeUtil) {
        String fieldAlias = fieldInfo.getAlias();
        DataTypeEnum dataType = fieldInfo.getDataType();
        EntityFieldInfo entityFieldInfo = new EntityFieldInfo();
        entityFieldInfo.setAlias(fieldAlias);
        entityFieldInfo.setDataType(dataType);
        String relEntityNumber = FieldFullPathParseUtil.getFieldEntityNumber(relEntityMap, (String)fieldAlias);
        if (HRStringUtils.isEmpty((String)relEntityNumber)) {
            if (fieldAlias.startsWith(entityNumber + ".")) {
                fieldAlias = fieldAlias.replaceFirst(entityNumber + "\\.", "");
            }
            entityFieldInfo.setFieldEntityNumber(entityNumber);
            entityFieldInfo.setFieldEntityAlias(entityNumber);
            EntityQueryFieldTransfer.parseProp((DynamicObjectType)mainEntityType, fieldAlias, fieldAlias, entityFieldInfo, "", tablePk);
        } else {
            entityFieldInfo.setFieldEntityNumber(relEntityNumber);
            MainEntityType joinEntityType = mainEntityTypeUtil.getMainEntityType(relEntityNumber);
            String[] fieldAliasArr = fieldAlias.split("\\.");
            String relEntityAlias = fieldAliasArr[0];
            entityFieldInfo.setFieldEntityAlias(relEntityAlias);
            String fieldPrex = relEntityAlias + ".";
            String realField = fieldAlias.replaceFirst(relEntityAlias + "\\.", "");
            EntityQueryFieldTransfer.parseProp((DynamicObjectType)joinEntityType, fieldAlias, realField, entityFieldInfo, fieldPrex, tablePk);
        }
        return entityFieldInfo;
    }

    private static void parseProp(DynamicObjectType dynamicObjectType, String fieldAlias, String originField, EntityFieldInfo entityFieldInfo, String fieldPrex, Map<String, String> tablePk) {
        String[] fieldAliasArr = originField.split("\\.");
        DynamicProperty property = dynamicObjectType.getProperty(originField);
        if (property == null) {
            property = dynamicObjectType.getProperty(fieldAliasArr[0]);
        }
        if (property == null) {
            return;
        }
        String mainTable = dynamicObjectType.getAlias();
        String mainTablePk = dynamicObjectType.getPrimaryKey().getAlias();
        String prefixNoDot = fieldPrex;
        if (fieldPrex.endsWith(".")) {
            prefixNoDot = fieldPrex.substring(0, fieldPrex.length() - 1);
        }
        String convertFieldAlias = QueryKSqlUtil.convertFieldAlias((DynamicObjectType)dynamicObjectType, (String)prefixNoDot, (String)originField);
        entityFieldInfo.setDbField(property.getAlias());
        entityFieldInfo.setConvertField(convertFieldAlias);
        entityFieldInfo.setOriginField(originField);
        entityFieldInfo.setTable(mainTable);
        entityFieldInfo.setPkDbField(mainTablePk);
        entityFieldInfo.setPkField(dynamicObjectType.getPrimaryKey().getName());
        Class propertyType = dynamicObjectType.getPrimaryKey().getPropertyType();
        String pkType = propertyType == String.class ? "string" : "bigint";
        entityFieldInfo.setPkType(pkType);
        tablePk.put(mainTable, mainTablePk);
        if (property instanceof ISimpleProperty && PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)property)) {
            entityFieldInfo.setPrivacyField(true);
        }
        EntityQueryFieldTransfer.setMulOrGroupProp(property, fieldAlias, entityFieldInfo, mainTable, fieldPrex, tablePk);
    }

    private static void setMulOrGroupProp(DynamicProperty property, String fieldAlias, EntityFieldInfo entityFieldInfo, String mainTable, String fieldPrex, Map<String, String> tablePk) {
        if (Objects.isNull(entityFieldInfo)) {
            return;
        }
        if (property instanceof EntryProp) {
            DynamicProperty tempProp;
            entityFieldInfo.setEntryField(true);
            String originField = entityFieldInfo.getOriginField();
            String[] split = originField.split("\\.");
            String entityAlias = split[0] + ".";
            DynamicObjectType entryProp = ((EntryProp)property).getDynamicCollectionItemPropertyType();
            String entryTable = entryProp.getAlias();
            originField = originField.replaceFirst(split[0] + "\\.", "");
            entityFieldInfo.setTable(entryTable);
            tablePk.put(entryTable, entryProp.getPrimaryKey().getAlias());
            if (split.length >= 2 && (tempProp = entryProp.getProperty(split[1])) instanceof SubEntryProp) {
                String subEntryAlias = split[1] + ".";
                entryProp = ((SubEntryProp)tempProp).getDynamicCollectionItemPropertyType();
                originField = originField.replaceFirst(split[1] + "\\.", "");
                entityFieldInfo.setEntryField(false);
                entityFieldInfo.setSubEntryField(true);
                entityFieldInfo.setSubEntryParentTb(entryProp.getParent().getAlias());
                entityFieldInfo.setSubEntryParentTbPk(entryProp.getParent().getPrimaryKey().getAlias());
                entityAlias = entityAlias + subEntryAlias;
            }
            fieldPrex = fieldPrex + entityAlias;
            EntityQueryFieldTransfer.parseProp(entryProp, fieldAlias, originField, entityFieldInfo, fieldPrex, tablePk);
            entityFieldInfo.setPkField(entityAlias + entityFieldInfo.getPkField());
        } else if (property instanceof MuliLangTextProp) {
            entityFieldInfo.setMultiLangField(true);
            entityFieldInfo.setTable(mainTable);
            entityFieldInfo.setMultiLanguageTb(mainTable + "_L");
        } else {
            String tableGroup = property.getTableGroup();
            if (HRStringUtils.isNotEmpty((String)tableGroup)) {
                entityFieldInfo.setSplitField(true);
                entityFieldInfo.setTable(mainTable + "_" + tableGroup);
            }
        }
    }
}

