/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.query;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.enums.ESSearchTypeEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchCategoryEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchKeyLogicEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.smartsearch.SmartSearchBoostGroup;
import kd.hr.hbp.common.model.smartsearch.SmartSearchWordConfig;
import kd.hr.hbp.common.model.smartsearch.scene.SearchRangFieldBo;
import kd.hr.hbp.common.model.smartsearch.search.SearchParam;
import kd.hrmp.hrss.business.domain.search.service.common.SearchParamUtil;
import kd.hrmp.hrss.business.domain.search.service.query.EsQueryBuilder;
import kd.hrmp.hrss.business.domain.search.service.query.ISearchBuilderItemService;
import kd.hrmp.hrss.business.domain.search.service.searchweight.SearchWeightConfHelper;
import kd.hrmp.hrss.common.model.search.InputFilterAnalysisRst;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class EntitySearchBuilderService
implements ISearchBuilderItemService {
    @Override
    public BoolQueryBuilder createSearchBuilder(SearchParam searchParam, HRComplexObjContext complexObjContext, InputFilterAnalysisRst inputFilterAnalysisRst) {
        BoolQueryBuilder itemQueryBuilder = QueryBuilders.boolQuery();
        ESSearchTypeEnum searchTypeEnum = ESSearchTypeEnum.MATCH;
        if (searchParam.getCategory() == SearchCategoryEnum.PHRASE_SEARCH) {
            searchTypeEnum = ESSearchTypeEnum.MATCH_PHRASE;
        }
        List searchRangFieldList = searchParam.getSearchRangFieldList();
        Set<String> searchEntitySet = searchRangFieldList.stream().map(SearchRangFieldBo::getRangeNumber).collect(Collectors.toSet());
        QueryBuilder searchKeyQueryBuilder = null;
        if (inputFilterAnalysisRst != null && inputFilterAnalysisRst.getGptFilterResult() != null) {
            searchKeyQueryBuilder = EsQueryBuilder.getQueryBuilder(complexObjContext, searchTypeEnum, inputFilterAnalysisRst.getGptFilterResult(), this.filterWeightConfigure(searchEntitySet, inputFilterAnalysisRst.getSearchWordConfigList()));
        }
        if (searchKeyQueryBuilder != null) {
            return itemQueryBuilder.should(searchKeyQueryBuilder);
        }
        List<SmartSearchBoostGroup> defWeightConfig = SearchWeightConfHelper.getInstance().getDefWeightConfig(searchParam.getSceneId());
        if (CollectionUtils.isEmpty(defWeightConfig)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u9ed8\u8ba4\u6392\u5e8f\u6743\u91cd\u201d\u3002", (String)"SearchQBuilderService_1", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        List<String> searchContentList = SearchParamUtil.getSearchContentList(searchParam);
        for (String searchContent : searchContentList) {
            QueryBuilder queryBuilder = EsQueryBuilder.parseWordConfig(searchTypeEnum, searchContent, complexObjContext, this.filterBoostGroupList(searchEntitySet, defWeightConfig));
            if (searchParam.getSearchKeyLogic() == SearchKeyLogicEnum.AND) {
                itemQueryBuilder.must(queryBuilder);
                continue;
            }
            itemQueryBuilder.should(queryBuilder);
        }
        return itemQueryBuilder;
    }

    private List<SmartSearchWordConfig> filterWeightConfigure(Set<String> searchEntitySet, List<SmartSearchWordConfig> wordConfigs) {
        if (wordConfigs == null) {
            return Collections.emptyList();
        }
        ArrayList newWordConfigList = Lists.newArrayListWithCapacity((int)10);
        for (SmartSearchWordConfig wordConfig : wordConfigs) {
            List<SmartSearchBoostGroup> boostGroupListCopy = this.filterBoostGroupList(searchEntitySet, wordConfig.getBoostGroupList());
            if (boostGroupListCopy.isEmpty()) continue;
            SmartSearchWordConfig wordConfigCopy = new SmartSearchWordConfig(wordConfig.getAiField());
            wordConfigCopy.setGptkwAnalysisBO(wordConfig.getGptkwAnalysisBO());
            wordConfigCopy.setBoostGroupList(boostGroupListCopy);
            newWordConfigList.add(wordConfigCopy);
        }
        return newWordConfigList;
    }

    private List<SmartSearchBoostGroup> filterBoostGroupList(Set<String> searchEntitySet, List<SmartSearchBoostGroup> boostGroupList) {
        ArrayList boostGroupListCopy = Lists.newArrayListWithCapacity((int)boostGroupList.size());
        for (SmartSearchBoostGroup boostGroup : boostGroupList) {
            List collect = boostGroup.getEntityList().stream().filter(entity -> searchEntitySet.contains(entity.getEntityAlias())).collect(Collectors.toList());
            if (collect.isEmpty()) continue;
            SmartSearchBoostGroup boostGroupCopy = new SmartSearchBoostGroup(boostGroup.getBoostValue());
            boostGroupCopy.setEntityList(collect);
            boostGroupListCopy.add(boostGroupCopy);
        }
        return boostGroupListCopy;
    }
}

