/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.QFilterUtil;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import org.apache.commons.collections.CollectionUtils;

public class EsFilterFieldTransfer {
    public List<EsFilterField> transferQFilter(HRComplexObjContext complexObjContext, QFilter[] filters) {
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>();
        if (filters == null) {
            return esFilterFields;
        }
        int n = filters.length;
        for (int i = 0; i < n; ++i) {
            if (null == filters[i]) continue;
            EsFilterField esFilterField = this.qFilterToEsFilter(complexObjContext, filters[i]);
            esFilterFields.add(esFilterField);
        }
        return esFilterFields;
    }

    public String getEsPath(HRComplexObjContext complexObjContext, String fullPropertyName) {
        String[] split = fullPropertyName.split("\\.");
        if (split.length < 2) {
            return null;
        }
        Map<String, String> relEntityMap = complexObjContext.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        return relEntityMap.get(split[0]);
    }

    public EsFilterField qFilterToEsFilter(HRComplexObjContext complexObjContext, QFilter filter) {
        EsFilterField firstAnd;
        String path = this.getEsPath(complexObjContext, filter.getProperty());
        if (filter.getCP().equalsIgnoreCase(QFilterUtil.hrEmptyDecimal)) {
            firstAnd = new EsFilterField(path, filter.getProperty(), "is null", new Object[0]);
            firstAnd.or(new EsFilterField(path, filter.getProperty(), "=", new Object[]{0}));
        } else if (filter.getCP().equalsIgnoreCase(QFilterUtil.hrEmptyText)) {
            firstAnd = new EsFilterField(path, filter.getProperty(), "is null", new Object[0]);
            firstAnd.or(new EsFilterField(path, filter.getProperty(), "=", new Object[]{""}));
            firstAnd.or(new EsFilterField(path, filter.getProperty(), "=", new Object[]{" "}));
        } else if (filter.getCP().equalsIgnoreCase(QFilterUtil.hrEmptyFieldText)) {
            String propStr = filter.getProperty() + ".keyword";
            firstAnd = new EsFilterField(path, propStr, "is null", new Object[0]);
            firstAnd.or(new EsFilterField(path, propStr, "=", new Object[]{""}));
            firstAnd.or(new EsFilterField(path, propStr, "=", new Object[]{" "}));
        } else {
            firstAnd = this.buildSingleFilterField(path, filter);
        }
        List nests = filter.getNests(false);
        if (CollectionUtils.isEmpty((Collection)nests)) {
            return firstAnd;
        }
        for (QFilter.QFilterNest nest : nests) {
            if (nest.isAnd()) {
                firstAnd.and(this.qFilterToEsFilter(complexObjContext, nest.getFilter()));
                continue;
            }
            firstAnd.or(this.qFilterToEsFilter(complexObjContext, nest.getFilter()));
        }
        return firstAnd;
    }

    private EsFilterField buildSingleFilterField(String path, QFilter qFilter) {
        boolean useKeyWord;
        StringBuilder name = new StringBuilder();
        name.append(qFilter.getProperty());
        Object value = qFilter.getValue();
        boolean bl = useKeyWord = !qFilter.getProperty().endsWith("_store_value4es");
        if (value instanceof String && useKeyWord) {
            name.append(".keyword");
        } else {
            if (value instanceof Object[]) {
                Object[] valueArr = (Object[])qFilter.getValue();
                if (valueArr != null && valueArr[0] instanceof String && useKeyWord) {
                    name.append(".keyword");
                }
                return new EsFilterField(path, name.toString(), qFilter.getCP(), valueArr);
            }
            if (value instanceof List) {
                List valueList = (List)qFilter.getValue();
                Object[] valueListArr = valueList.toArray();
                if (valueListArr[0] instanceof String && useKeyWord) {
                    name.append(".keyword");
                }
                return new EsFilterField(path, name.toString(), qFilter.getCP(), valueListArr);
            }
            if (value instanceof Set) {
                Set valueSet = (Set)qFilter.getValue();
                Object[] valueSetArr = valueSet.toArray();
                if (valueSetArr[0] instanceof String && useKeyWord) {
                    name.append(".keyword");
                }
                return new EsFilterField(path, name.toString(), qFilter.getCP(), valueSetArr);
            }
        }
        return new EsFilterField(path, name.toString(), qFilter.getCP(), new Object[]{value});
    }
}

