/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.query;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.model.Tuple2;
import kd.hr.hbp.business.service.complexobj.util.DataTypeConvertUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.query.es.storage.EsFilterField;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.common.enums.ESSearchTypeEnum;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.smartsearch.GPTKWAnalysisBO;
import kd.hr.hbp.common.model.smartsearch.SmartSearchBoostGroup;
import kd.hr.hbp.common.model.smartsearch.SmartSearchEntity;
import kd.hr.hbp.common.model.smartsearch.SmartSearchWordConfig;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryEntityUtil;
import kd.hrmp.hrss.business.domain.search.service.common.LabelFieldUtil;
import kd.hrmp.hrss.business.domain.search.service.es.SmartSearchEsEsStorage;
import kd.hrmp.hrss.business.domain.search.service.query.EsFilterFieldTransfer;
import kd.hrmp.hrss.common.enums.GPTCompareEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class EsQueryBuilder {
    private static final Log LOGGER = LogFactory.getLog(EsQueryBuilder.class);

    public static QueryBuilder getQueryBuilder(HRComplexObjContext complexObjContext, ESSearchTypeEnum searchType, QFilter gptFilterResult, List<SmartSearchWordConfig> searchWordConfigList) {
        if (searchWordConfigList == null || searchWordConfigList.isEmpty() || gptFilterResult == null) {
            return null;
        }
        Map<String, List<SmartSearchBoostGroup>> aiFieldBoostMap = searchWordConfigList.stream().collect(Collectors.toMap(SmartSearchWordConfig::getAiField, SmartSearchWordConfig::getBoostGroupList));
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        int recursion = 0;
        return EsQueryBuilder.genQueryBuilderByAiFieldFilter(searchType, complexObjContext, gptFilterResult, aiFieldBoostMap, mainEntityTypeUtil, recursion);
    }

    private static boolean is1Eq1(QFilter gptFilterResult) {
        return gptFilterResult.getProperty().equals("1") && String.valueOf(gptFilterResult.getValue()).equals("1");
    }

    private static QueryBuilder genQueryBuilderByAiFieldFilter(ESSearchTypeEnum searchType, HRComplexObjContext complexObjContext, QFilter gptFilterResult, Map<String, List<SmartSearchBoostGroup>> aiFieldBoostMap, MainEntityTypeUtil mainEntityTypeUtil, int recursion) {
        if (recursion > 100) {
            LOGGER.info("The recursion level is too deep qfilter:{}", (Object)gptFilterResult);
            return null;
        }
        BoolQueryBuilder boolQueryBuilder = null;
        if (!EsQueryBuilder.is1Eq1(gptFilterResult)) {
            String property = gptFilterResult.getProperty();
            List<SmartSearchBoostGroup> smartSearchBoostGroups = aiFieldBoostMap.get(property);
            if (CollectionUtils.isEmpty(smartSearchBoostGroups)) {
                LOGGER.info("fieldCategory entityFiled config not exists property:{}", (Object)property);
                return null;
            }
            for (SmartSearchBoostGroup smartSearchBoostGroup : smartSearchBoostGroups) {
                float boostValue;
                List<QueryBuilder> queryBuilderList = EsQueryBuilder.parseBoostGroup(searchType, gptFilterResult, complexObjContext, (List<SmartSearchEntity>)smartSearchBoostGroup.getEntityList(), mainEntityTypeUtil);
                QueryBuilder singleQueryBuilder = EsQueryBuilder.boostQueryBuilder(queryBuilderList, boostValue = smartSearchBoostGroup.getBoostValue());
                if (singleQueryBuilder == null) continue;
                if (boolQueryBuilder == null) {
                    boolQueryBuilder = QueryBuilders.boolQuery();
                }
                boolQueryBuilder.should(singleQueryBuilder);
            }
        }
        List nests = gptFilterResult.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            String op;
            QFilter filter = nest.getFilter();
            QueryBuilder nestBuilder = EsQueryBuilder.genQueryBuilderByAiFieldFilter(searchType, complexObjContext, filter, aiFieldBoostMap, mainEntityTypeUtil, ++recursion);
            if (boolQueryBuilder == null) {
                boolQueryBuilder = QueryBuilders.boolQuery();
            }
            if ("AND".equalsIgnoreCase(op = nest.getOp())) {
                boolQueryBuilder.must(nestBuilder);
                continue;
            }
            boolQueryBuilder.should(nestBuilder);
        }
        return boolQueryBuilder;
    }

    private static QueryBuilder genQueryBuilderByWordConfig(ESSearchTypeEnum searchType, String searchKey, HRComplexObjContext complexObjContext, SmartSearchWordConfig wordConfig) {
        GPTKWAnalysisBO gptkwAnalysisBO = wordConfig.getGptkwAnalysisBO();
        if (gptkwAnalysisBO == null) {
            return EsQueryBuilder.parseWordConfig(searchType, searchKey, complexObjContext, wordConfig.getBoostGroupList());
        }
        String operator = gptkwAnalysisBO.getOperator();
        GPTCompareEnum gptCompareEnum = GPTCompareEnum.getEnum((String)operator);
        if (gptCompareEnum == null || gptCompareEnum == GPTCompareEnum.CONTAINS || gptCompareEnum == GPTCompareEnum.NOT_CONTAINS) {
            LOGGER.info("searchBuilder match:{}", (Object)gptkwAnalysisBO);
            QueryBuilder queryBuilder = EsQueryBuilder.parseWordConfig(searchType, gptkwAnalysisBO.getStdValue(), complexObjContext, wordConfig.getBoostGroupList());
            if (gptCompareEnum == GPTCompareEnum.NOT_CONTAINS) {
                queryBuilder = QueryBuilders.boolQuery().mustNot(queryBuilder);
            }
            return queryBuilder;
        }
        LOGGER.info("searchBuilder filter:{}", (Object)gptkwAnalysisBO);
        return EsQueryBuilder.genFilterByWordConfig(searchType, complexObjContext, wordConfig);
    }

    private static QueryBuilder genFilterByWordConfig(ESSearchTypeEnum searchType, HRComplexObjContext complexObjContext, SmartSearchWordConfig wordConfig) {
        GPTKWAnalysisBO gptkwAnalysisBO = wordConfig.getGptkwAnalysisBO();
        String operator = gptkwAnalysisBO.getOperator();
        GPTCompareEnum gptCompareEnum = GPTCompareEnum.getEnum((String)operator);
        List boostGroupList = wordConfig.getBoostGroupList();
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        BoolQueryBuilder boolQueryBuilder = null;
        for (SmartSearchBoostGroup smartSearchBoostGroup : boostGroupList) {
            float boostValue;
            List<QueryBuilder> queryBuilderList = EsQueryBuilder.parseBoostGroupByFilter(smartSearchBoostGroup.getEntityList(), gptCompareEnum, gptkwAnalysisBO.getStdValue(), complexObjContext, searchType, mainEntityTypeUtil);
            QueryBuilder singleQueryBuilder = EsQueryBuilder.boostQueryBuilder(queryBuilderList, boostValue = smartSearchBoostGroup.getBoostValue());
            if (singleQueryBuilder == null) continue;
            if (boolQueryBuilder == null) {
                boolQueryBuilder = QueryBuilders.boolQuery();
            }
            boolQueryBuilder.should(singleQueryBuilder);
        }
        return boolQueryBuilder;
    }

    public static QueryBuilder parseWordConfig(ESSearchTypeEnum searchType, String searchKey, HRComplexObjContext complexObjContext, List<SmartSearchBoostGroup> boostGroupList) {
        BoolQueryBuilder boolQueryBuilder = null;
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        for (SmartSearchBoostGroup smartSearchBoostGroup : boostGroupList) {
            float boostValue;
            List<QueryBuilder> queryBuilderList = EsQueryBuilder.parseBoostGroup(searchType, searchKey, complexObjContext, (List<SmartSearchEntity>)smartSearchBoostGroup.getEntityList(), mainEntityTypeUtil);
            QueryBuilder singleQueryBuilder = EsQueryBuilder.boostQueryBuilder(queryBuilderList, boostValue = smartSearchBoostGroup.getBoostValue());
            if (singleQueryBuilder == null) continue;
            if (boolQueryBuilder == null) {
                boolQueryBuilder = QueryBuilders.boolQuery();
            }
            boolQueryBuilder.should(singleQueryBuilder);
        }
        return boolQueryBuilder;
    }

    private static QueryBuilder boostQueryBuilder(List<QueryBuilder> queryBuilderList, float boostValue) {
        if (CollectionUtils.isEmpty(queryBuilderList)) {
            return null;
        }
        if (queryBuilderList.size() == 1) {
            return queryBuilderList.get(0).boost(boostValue);
        }
        BoolQueryBuilder boolQueryBuilder = null;
        for (QueryBuilder queryBuilder : queryBuilderList) {
            if (boolQueryBuilder == null) {
                boolQueryBuilder = QueryBuilders.boolQuery();
                boolQueryBuilder.boost(boostValue);
            }
            boolQueryBuilder.should(queryBuilder);
        }
        return boolQueryBuilder;
    }

    private static List<QueryBuilder> parseBoostGroupByFilter(List<SmartSearchEntity> entityList, GPTCompareEnum gptCompareEnum, String stdValue, HRComplexObjContext complexObjContext, ESSearchTypeEnum searchType, MainEntityTypeUtil mainEntityTypeUtil) {
        Map<String, String> relEntityMap = complexObjContext.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        ArrayList queryBuilderList = Lists.newArrayListWithCapacity((int)entityList.size());
        for (SmartSearchEntity smartSearchEntity : entityList) {
            QueryBuilder queryBuilder;
            String subEntityNumber;
            String entityAlias = smartSearchEntity.getEntityAlias();
            String realEntityNumber = subEntityNumber = relEntityMap.get(entityAlias);
            String nestPath = null;
            String fieldAliasStr = smartSearchEntity.getFieldAliasStr();
            if (HRStringUtils.isNotEmpty((String)subEntityNumber)) {
                nestPath = entityAlias;
            } else {
                realEntityNumber = complexObjContext.getEntityNumber();
            }
            if ((queryBuilder = HRStringUtils.isEmpty((String)fieldAliasStr) ? EsQueryBuilder.genFullEntitySearchBuilder(stdValue, searchType, nestPath) : EsQueryBuilder.genMultiFieldFilterBuilder(complexObjContext, fieldAliasStr, gptCompareEnum, stdValue, entityAlias, mainEntityTypeUtil.getMainEntityType(realEntityNumber))) == null) continue;
            queryBuilderList.add(queryBuilder);
        }
        return queryBuilderList;
    }

    private static List<QueryBuilder> parseBoostGroup(ESSearchTypeEnum searchType, String searchKey, HRComplexObjContext complexObjContext, List<SmartSearchEntity> entityList, MainEntityTypeUtil mainEntityTypeUtil) {
        Map<String, String> relEntityMap = complexObjContext.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        ArrayList queryBuilderList = Lists.newArrayListWithCapacity((int)entityList.size());
        for (SmartSearchEntity smartSearchEntity : entityList) {
            QueryBuilder queryBuilder;
            String subEntityNumber;
            String entityAlias = smartSearchEntity.getEntityAlias();
            String realEntityNumber = subEntityNumber = relEntityMap.get(entityAlias);
            String nestPath = null;
            String fieldAliasStr = smartSearchEntity.getFieldAliasStr();
            if (HRStringUtils.isNotEmpty((String)subEntityNumber)) {
                nestPath = entityAlias;
            } else {
                realEntityNumber = complexObjContext.getEntityNumber();
            }
            if ((queryBuilder = HRStringUtils.isEmpty((String)fieldAliasStr) ? EsQueryBuilder.genFullEntitySearchBuilder(searchKey, searchType, nestPath) : EsQueryBuilder.genMultiFieldSearchBuilder(searchType, searchKey, entityAlias, mainEntityTypeUtil.getMainEntityType(realEntityNumber), nestPath, fieldAliasStr)) == null) continue;
            queryBuilderList.add(queryBuilder);
        }
        return queryBuilderList;
    }

    private static List<QueryBuilder> parseBoostGroup(ESSearchTypeEnum searchType, QFilter gptFilterResult, HRComplexObjContext complexObjContext, List<SmartSearchEntity> groupEntityList, MainEntityTypeUtil mainEntityTypeUtil) {
        Map<String, String> relEntityMap = complexObjContext.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        ArrayList queryBuilderList = Lists.newArrayListWithCapacity((int)groupEntityList.size());
        for (SmartSearchEntity smartSearchEntity : groupEntityList) {
            QueryBuilder queryBuilder;
            String subEntityNumber;
            String entityAlias = smartSearchEntity.getEntityAlias();
            String realEntityNumber = subEntityNumber = relEntityMap.get(entityAlias);
            String nestPath = null;
            String fieldAliasStr = smartSearchEntity.getFieldAliasStr();
            if (HRStringUtils.isNotEmpty((String)subEntityNumber)) {
                nestPath = entityAlias;
            } else {
                realEntityNumber = complexObjContext.getEntityNumber();
            }
            if (HRStringUtils.isEmpty((String)fieldAliasStr)) {
                LOGGER.info("FULL_ENTITY search fieldCategory\uff1a{}, entityAlias:{}, value:{}", new Object[]{gptFilterResult.getProperty(), entityAlias, gptFilterResult.getValue()});
                queryBuilder = EsQueryBuilder.genFullEntitySearchBuilder(gptFilterResult.getValue().toString(), searchType, nestPath);
            } else {
                queryBuilder = EsQueryBuilder.genMultiFieldFilterBuilder(complexObjContext, fieldAliasStr, gptFilterResult.getCP(), gptFilterResult.getValue(), entityAlias, mainEntityTypeUtil.getMainEntityType(realEntityNumber));
            }
            if (queryBuilder == null) continue;
            queryBuilderList.add(queryBuilder);
        }
        return queryBuilderList;
    }

    private static QFilter gptFilterTransQFilter(String fullFieldStr, String fieldAlias, String cp, Object compareVal, MainEntityType mainentityType) {
        if (LabelFieldUtil.isLabelField(fieldAlias)) {
            fieldAlias = fieldAlias + ".labelValues";
        } else {
            IDataEntityProperty fieldProperty = QueryEntityUtil.getFieldProperty((MainEntityType)mainentityType, (String)fullFieldStr);
            if (fieldProperty == null) {
                LOGGER.warn("fullFieldStr:{} entityType is null", (Object)fullFieldStr);
                return null;
            }
            try {
                if ("in".equals(cp) || "not in".equals(cp)) {
                    Object[] objectArr = QFilterUtilHR.getWithoutDuplicateInValues((Object)compareVal);
                    ArrayList<Object> filterValList = new ArrayList<Object>(10);
                    for (Object singleVal : objectArr) {
                        filterValList.add(EsQueryBuilder.transStdValue(singleVal, fieldProperty));
                    }
                    compareVal = filterValList;
                } else {
                    compareVal = EsQueryBuilder.transStdValue(compareVal, fieldProperty);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("transStdValue fieldAlias:{},stdValue:{},exception:{}", new Object[]{fieldAlias, compareVal, exception.getMessage()});
            }
        }
        return new QFilter(fieldAlias, cp, (Object)compareVal);
    }

    private static QFilter gptFilterTransQFilter(String fullFieldStr, String fieldAlias, GPTCompareEnum gptCompareEnum, String stdValue, MainEntityType mainentityType) {
        ArrayList<Object> compareVal = stdValue;
        if (LabelFieldUtil.isLabelField(fieldAlias)) {
            fieldAlias = fieldAlias + ".labelValues";
        } else {
            IDataEntityProperty fieldProperty = QueryEntityUtil.getFieldProperty((MainEntityType)mainentityType, (String)fullFieldStr);
            if (fieldProperty == null) {
                LOGGER.warn("fullFieldStr:{} entityType is null", (Object)fullFieldStr);
                return null;
            }
            try {
                if (gptCompareEnum == GPTCompareEnum.IN || gptCompareEnum == GPTCompareEnum.NOT_IN) {
                    String[] split = stdValue.split(",");
                    ArrayList<Object> filterValList = new ArrayList<Object>(10);
                    for (String singleVal : split) {
                        filterValList.add(EsQueryBuilder.transStdValue(singleVal, fieldProperty));
                    }
                    compareVal = filterValList;
                } else {
                    compareVal = EsQueryBuilder.transStdValue(stdValue, fieldProperty);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("transStdValue fieldAlias:{},stdValue:{},exception:{}", new Object[]{fieldAlias, stdValue, exception.getMessage()});
            }
        }
        return new QFilter(fieldAlias, gptCompareEnum.getQFilterOp(), (Object)compareVal);
    }

    private static QueryBuilder genMultiFieldFilterBuilder(HRComplexObjContext complexObjContext, String allFieldAlias, GPTCompareEnum gptCompareEnum, String keyword, String entityAlias, MainEntityType mainEntityType) {
        BoolQueryBuilder entityQueryBuilder;
        String entityFieldPrex = entityAlias + ".";
        String[] fields = allFieldAlias.split(",");
        ArrayList<QFilter> orQFilterList = new ArrayList<QFilter>(10);
        for (String fieldAlias : fields) {
            try {
                String fullFieldStr = fieldAlias;
                if (fullFieldStr.startsWith(entityFieldPrex)) {
                    fullFieldStr = fullFieldStr.replace(entityFieldPrex, "");
                }
                QFilter qFilter = EsQueryBuilder.gptFilterTransQFilter(fullFieldStr, fieldAlias, gptCompareEnum, keyword, mainEntityType);
                orQFilterList.add(qFilter);
            }
            catch (Exception exception) {
                LOGGER.warn("transQFilter fieldAlias:{},stdValue:{},exception:{}", new Object[]{fieldAlias, keyword, exception.getMessage()});
            }
        }
        if (orQFilterList.size() == 0) {
            return null;
        }
        EsFilterFieldTransfer esFilterFieldTransfer = new EsFilterFieldTransfer();
        ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
        SmartSearchEsEsStorage esStorage = new SmartSearchEsEsStorage();
        for (QFilter qFilter : orQFilterList) {
            EsFilterField esFilterField = esFilterFieldTransfer.qFilterToEsFilter(complexObjContext, qFilter);
            QueryBuilder queryBuilder = esStorage.buidNestQueryBuilder(esFilterField);
            if (null == queryBuilder) continue;
            queryBuilders.add(queryBuilder);
        }
        if (queryBuilders.size() == 0) {
            entityQueryBuilder = null;
        } else if (queryBuilders.size() == 1) {
            entityQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)queryBuilders.get(0));
        } else {
            entityQueryBuilder = QueryBuilders.boolQuery();
            for (QueryBuilder singleBuilder : queryBuilders) {
                entityQueryBuilder.should(singleBuilder);
            }
        }
        return entityQueryBuilder;
    }

    private static QueryBuilder genMultiFieldFilterBuilder(HRComplexObjContext complexObjContext, String allFieldAlias, String cp, Object filterVal, String entityAlias, MainEntityType mainEntityType) {
        BoolQueryBuilder entityQueryBuilder;
        String entityFieldPrex = entityAlias + ".";
        String[] fields = allFieldAlias.split(",");
        ArrayList<QFilter> orQFilterList = new ArrayList<QFilter>(10);
        for (String fieldAlias : fields) {
            try {
                String fullFieldStr = fieldAlias;
                if (fullFieldStr.startsWith(entityFieldPrex)) {
                    fullFieldStr = fullFieldStr.replace(entityFieldPrex, "");
                }
                QFilter qFilter = EsQueryBuilder.gptFilterTransQFilter(fullFieldStr, fieldAlias, cp, filterVal, mainEntityType);
                orQFilterList.add(qFilter);
            }
            catch (Exception exception) {
                LOGGER.warn("transQFilter fieldAlias:{},stdValue:{},exception:{}", new Object[]{fieldAlias, filterVal, exception.getMessage()});
            }
        }
        if (orQFilterList.size() == 0) {
            return null;
        }
        EsFilterFieldTransfer esFilterFieldTransfer = new EsFilterFieldTransfer();
        ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
        SmartSearchEsEsStorage esStorage = new SmartSearchEsEsStorage();
        for (QFilter qFilter : orQFilterList) {
            EsFilterField esFilterField = esFilterFieldTransfer.qFilterToEsFilter(complexObjContext, qFilter);
            QueryBuilder queryBuilder = esStorage.buidNestQueryBuilder(esFilterField);
            if (null == queryBuilder) continue;
            queryBuilders.add(queryBuilder);
        }
        if (queryBuilders.size() == 0) {
            entityQueryBuilder = null;
        } else if (queryBuilders.size() == 1) {
            entityQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)queryBuilders.get(0));
        } else {
            entityQueryBuilder = QueryBuilders.boolQuery();
            for (QueryBuilder singleBuilder : queryBuilders) {
                entityQueryBuilder.should(singleBuilder);
            }
        }
        return entityQueryBuilder;
    }

    private static QueryBuilder genFullEntitySearchBuilder(String stdValue, ESSearchTypeEnum searchType, String nestPath) {
        MultiMatchQueryBuilder multiMatchQuery = QueryBuilders.multiMatchQuery((Object)stdValue, (String[])new String[0]);
        if (ESSearchTypeEnum.MATCH_PHRASE == searchType) {
            multiMatchQuery.type(MultiMatchQueryBuilder.Type.PHRASE);
        }
        Object queryBuilder = HRStringUtils.isEmpty((String)nestPath) ? multiMatchQuery : QueryBuilders.nestedQuery((String)nestPath, (QueryBuilder)multiMatchQuery, (ScoreMode)ScoreMode.Max);
        return queryBuilder;
    }

    private static QueryBuilder genMultiFieldSearchBuilder(ESSearchTypeEnum searchType, String searchKey, String entityAlias, MainEntityType mainEntityType, String nestPath, String fieldAliasStr) {
        QueryBuilder queryBuilder;
        String entityFieldPrex = entityAlias + ".";
        String[] fields = fieldAliasStr.split(",");
        if (fields.length > 1) {
            String[] fieldsArrCopy = new String[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String fieldName = fields[i];
                if (fieldName.startsWith(entityFieldPrex)) {
                    fieldName = fieldName.replace(entityFieldPrex, "");
                }
                fieldsArrCopy[i] = fieldName;
            }
            queryBuilder = EsQueryBuilder.genMultiMatchQueryBuilder(mainEntityType, fieldsArrCopy, searchKey, searchType, nestPath);
            queryBuilder = EsQueryBuilder.buildNestQuery(queryBuilder, nestPath);
        } else {
            BoolQueryBuilder entityQueryBuilder = null;
            for (String fieldName : fields) {
                QueryBuilder singleFieldQueryBuilder;
                String fullFieldStr = fieldName;
                if (fullFieldStr.startsWith(entityFieldPrex)) {
                    fullFieldStr = fullFieldStr.replace(entityFieldPrex, "");
                }
                if ((singleFieldQueryBuilder = EsQueryBuilder.genSingleEntityQueryBuilder(mainEntityType, fullFieldStr, fieldName, searchType, searchKey, nestPath)) == null) continue;
                if (entityQueryBuilder == null) {
                    entityQueryBuilder = QueryBuilders.boolQuery();
                }
                entityQueryBuilder.should(singleFieldQueryBuilder);
            }
            queryBuilder = EsQueryBuilder.buildNestQuery(entityQueryBuilder, nestPath);
        }
        return queryBuilder;
    }

    public static QueryBuilder genMultiMatchQueryBuilder(MainEntityType mainEntityType, String[] fullFieldArr, String searchKey, ESSearchTypeEnum searchType, String parentPath) {
        HashSet<String> queryFieldSet = new HashSet<String>(10);
        HashMap<String, Set> nestFieldMap = new HashMap<String, Set>(16);
        String[] stringArray = fullFieldArr;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String fullFieldStr;
            String fieldAlias = fullFieldStr = stringArray[i];
            if (HRStringUtils.isNotEmpty((String)parentPath)) {
                fieldAlias = parentPath + '.' + fullFieldStr;
            }
            if (LabelFieldUtil.isLabelField(fieldAlias)) {
                fieldAlias = fieldAlias + ".labelValues.keyword";
            } else {
                IDataEntityProperty fieldProperty = QueryEntityUtil.getFieldProperty((MainEntityType)mainEntityType, (String)fullFieldStr);
                if (fieldProperty == null) {
                    LOGGER.warn("fullFieldStr:{} entityType is null", (Object)fullFieldStr);
                    continue;
                }
                Tuple2<String, String> tuple2 = EsQueryBuilder.getEsFullFieldStr(fieldAlias, fieldProperty);
                if (tuple2 == null || HRStringUtils.isEmpty((String)((String)tuple2.t1))) continue;
                fieldAlias = (String)tuple2.t1;
                String entryPath = (String)tuple2.t2;
                if (HRStringUtils.isNotEmpty((String)entryPath)) {
                    HashSet<String> fieldSet2;
                    if (HRStringUtils.isNotEmpty((String)parentPath)) {
                        entryPath = parentPath + '.' + entryPath;
                    }
                    if ((fieldSet2 = (HashSet<String>)nestFieldMap.get(entryPath)) == null) {
                        fieldSet2 = new HashSet<String>(10);
                    }
                    fieldSet2.add(fieldAlias);
                    nestFieldMap.put(entryPath, fieldSet2);
                    continue;
                }
            }
            queryFieldSet.add(fieldAlias);
        }
        if (queryFieldSet.isEmpty() && nestFieldMap.isEmpty()) {
            return null;
        }
        MultiMatchQueryBuilder multiMatchQuery = null;
        if (!queryFieldSet.isEmpty()) {
            multiMatchQuery = QueryBuilders.multiMatchQuery((Object)searchKey, (String[])queryFieldSet.toArray(new String[0]));
            if (ESSearchTypeEnum.MATCH_PHRASE == searchType) {
                multiMatchQuery.type(MultiMatchQueryBuilder.Type.PHRASE);
            }
        }
        if (!nestFieldMap.isEmpty()) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            if (multiMatchQuery != null) {
                boolQueryBuilder.should((QueryBuilder)multiMatchQuery);
            }
            nestFieldMap.forEach((path, fieldSet) -> {
                MultiMatchQueryBuilder entryQueryBuilder = QueryBuilders.multiMatchQuery((Object)searchKey, (String[])fieldSet.toArray(new String[0]));
                if (ESSearchTypeEnum.MATCH_PHRASE == searchType) {
                    entryQueryBuilder.type(MultiMatchQueryBuilder.Type.PHRASE);
                }
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.nestedQuery((String)path, (QueryBuilder)entryQueryBuilder, (ScoreMode)ScoreMode.Max));
            });
            return boolQueryBuilder;
        }
        return multiMatchQuery;
    }

    public static QueryBuilder genSingleEntityQueryBuilder(MainEntityType mainEntityType, String fullFieldStr, String fieldAlias, ESSearchTypeEnum searchType, String searchKey, String parentPath) {
        if (LabelFieldUtil.isLabelField(fieldAlias)) {
            fieldAlias = fieldAlias + ".labelValues";
        } else {
            IDataEntityProperty fieldProperty = QueryEntityUtil.getFieldProperty((MainEntityType)mainEntityType, (String)fullFieldStr);
            Tuple2<String, String> tuple2 = EsQueryBuilder.getEsFullFieldStr(fieldAlias, fieldProperty);
            if (tuple2 == null || HRStringUtils.isEmpty((String)((String)tuple2.t1))) {
                return null;
            }
            fieldAlias = (String)tuple2.t1;
            String entryPath = (String)tuple2.t2;
            if (HRStringUtils.isNotEmpty((String)entryPath)) {
                QueryBuilder queryBuilder;
                if (HRStringUtils.isNotEmpty((String)parentPath)) {
                    entryPath = parentPath + '.' + entryPath;
                }
                if ((queryBuilder = EsQueryBuilder.buidQueryBuilderBase(fieldAlias, searchType, searchKey)) == null) {
                    return null;
                }
                return QueryBuilders.nestedQuery((String)entryPath, (QueryBuilder)queryBuilder, (ScoreMode)ScoreMode.Max);
            }
        }
        return EsQueryBuilder.buidQueryBuilderBase(fieldAlias, searchType, searchKey);
    }

    private static Object transStdValue(Object stdValue, IDataEntityProperty fieldProperty) {
        Class propertyType = fieldProperty.getPropertyType();
        if (propertyType.equals(BigDecimal.class)) {
            return DataTypeConvertUtil.toConvert((DataTypeEnum)DataTypeEnum.BIGDECIMAL, (Object)stdValue);
        }
        if (propertyType.equals(Integer.class) || propertyType.equals(Integer.TYPE)) {
            return DataTypeConvertUtil.toConvert((DataTypeEnum)DataTypeEnum.INTEGER, (Object)stdValue);
        }
        if (propertyType.equals(Long.class) || propertyType.equals(Long.TYPE)) {
            return DataTypeConvertUtil.toConvert((DataTypeEnum)DataTypeEnum.LONG, (Object)stdValue);
        }
        if (propertyType.equals(String.class) || propertyType.equals(ILocaleString.class)) {
            return DataTypeConvertUtil.toConvert((DataTypeEnum)DataTypeEnum.STRING, (Object)stdValue);
        }
        if (propertyType.equals(Boolean.class)) {
            return DataTypeConvertUtil.toConvert((DataTypeEnum)DataTypeEnum.BOOLEAN, (Object)stdValue);
        }
        if (propertyType.equals(Date.class)) {
            return DataTypeConvertUtil.toConvert((DataTypeEnum)DataTypeEnum.DATETIME, (Object)stdValue);
        }
        return stdValue;
    }

    private static Tuple2<String, String> getEsFullFieldStr(String fullFieldStr, IDataEntityProperty fieldProperty) {
        if (fieldProperty == null) {
            return null;
        }
        if (fieldProperty instanceof MuliLangTextProp) {
            String langStr = RequestContext.get().getLang().name();
            fullFieldStr = fullFieldStr + "_l." + langStr;
        } else {
            if (fieldProperty instanceof DecimalProp || fieldProperty instanceof BooleanProp || fieldProperty instanceof LongProp) {
                return null;
            }
            if (fieldProperty instanceof EntryProp) {
                EntryType entryType = (EntryType)((EntryProp)fieldProperty).getItemType();
                String entryName = fieldProperty.getName();
                int index = fullFieldStr.indexOf(entryName + ".");
                if (index < 0) {
                    return null;
                }
                String replace = fullFieldStr.substring(index).replace(entryName + ".", "");
                IDataEntityProperty property = entryType.findProperty(replace);
                Tuple2<String, String> entryTuple2 = EsQueryBuilder.getEsFullFieldStr(fullFieldStr, property);
                if (entryTuple2 == null) {
                    return null;
                }
                return new Tuple2(entryTuple2.t1, (Object)entryName);
            }
        }
        return new Tuple2((Object)fullFieldStr, null);
    }

    public static QueryBuilder buildNestQuery(QueryBuilder queryBuilder, String path) {
        if (StringUtils.isNotBlank((CharSequence)path) && null != queryBuilder) {
            queryBuilder = QueryBuilders.nestedQuery((String)path, (QueryBuilder)queryBuilder, (ScoreMode)ScoreMode.Max);
        }
        return queryBuilder;
    }

    private static QueryBuilder buidQueryBuilderBase(String fieldStr, ESSearchTypeEnum esSearchype, String searchKey) {
        MatchQueryBuilder queryBuilder = null;
        if (ESSearchTypeEnum.MATCH == esSearchype) {
            queryBuilder = QueryBuilders.matchQuery((String)fieldStr, (Object)searchKey);
        } else if (ESSearchTypeEnum.MATCH_PHRASE == esSearchype) {
            queryBuilder = QueryBuilders.matchPhraseQuery((String)fieldStr, (Object)searchKey);
        } else if (ESSearchTypeEnum.TERMS == esSearchype) {
            if (!fieldStr.endsWith(".keyword")) {
                fieldStr = fieldStr + ".keyword";
            }
            queryBuilder = QueryBuilders.termQuery((String)fieldStr, (String)searchKey);
        } else if (ESSearchTypeEnum.WILDCARD == esSearchype) {
            if (!fieldStr.endsWith(".keyword")) {
                fieldStr = fieldStr + ".keyword";
            }
            queryBuilder = QueryBuilders.wildcardQuery((String)fieldStr, (String)("*" + searchKey + "*"));
        }
        return queryBuilder;
    }
}

