/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.query;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.complexobj.util.QFilterUtil;
import kd.hr.hbp.common.enums.ESSearchTypeEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchCategoryEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchModeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.smartsearch.SmartSearchBoostGroup;
import kd.hr.hbp.common.model.smartsearch.SmartSearchWordConfig;
import kd.hr.hbp.common.model.smartsearch.scene.SearchRangFieldBo;
import kd.hr.hbp.common.model.smartsearch.search.SearchParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrss.business.domain.search.service.common.SearchParamUtil;
import kd.hrmp.hrss.business.domain.search.service.query.EsQueryBuilder;
import kd.hrmp.hrss.business.domain.search.service.query.ISearchBuilderItemService;
import kd.hrmp.hrss.common.model.search.InputFilterAnalysisRst;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class FieldSearchBuilderService
implements ISearchBuilderItemService {
    @Override
    public BoolQueryBuilder createSearchBuilder(SearchParam searchParam, HRComplexObjContext complexObjContext, InputFilterAnalysisRst inputFilterAnalysisRst) {
        BoolQueryBuilder itemQueryBuilder = QueryBuilders.boolQuery();
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        List searchRangFieldList = searchParam.getSearchRangFieldList();
        for (SearchRangFieldBo searchRangField : searchRangFieldList) {
            ESSearchTypeEnum searchTypeEnum = ESSearchTypeEnum.TERMS;
            if (searchRangField.getSearchMode() == SearchModeEnum.FUZZY_SEARCH) {
                searchTypeEnum = ESSearchTypeEnum.WILDCARD;
            } else if (searchRangField.getSearchMode() == SearchModeEnum.WORD_OR_PHRASE_SEARCH) {
                searchTypeEnum = ESSearchTypeEnum.MATCH;
                if (searchParam.getCategory() == SearchCategoryEnum.PHRASE_SEARCH) {
                    searchTypeEnum = ESSearchTypeEnum.MATCH_PHRASE;
                }
            }
            String searchFieldAlias = searchRangField.getRangeNumber();
            String entityNumber = QFilterUtil.getSubEntityName((String)searchFieldAlias, (HRComplexObjContext)complexObjContext);
            String nestPath = QFilterUtil.getFieldEntityAlias((String)searchFieldAlias, (HRComplexObjContext)complexObjContext);
            if (HRStringUtils.isEmpty((String)entityNumber)) {
                entityNumber = complexObjContext.getEntityNumber();
                nestPath = null;
            }
            String entityFieldPrex = nestPath + ".";
            String fullFieldStr = searchFieldAlias;
            if (HRStringUtils.isNotEmpty((String)nestPath) && fullFieldStr.startsWith(entityFieldPrex)) {
                fullFieldStr = fullFieldStr.replace(entityFieldPrex, "");
            }
            QueryBuilder searchKeyQueryBuilder = EsQueryBuilder.genSingleEntityQueryBuilder(mainEntityTypeUtil.getMainEntityType(entityNumber), fullFieldStr, searchFieldAlias, searchTypeEnum, SearchParamUtil.getSearchContent(searchParam), nestPath);
            if ((searchKeyQueryBuilder = EsQueryBuilder.buildNestQuery(searchKeyQueryBuilder, nestPath)) == null) continue;
            itemQueryBuilder.should(searchKeyQueryBuilder);
        }
        return itemQueryBuilder;
    }

    private List<SmartSearchWordConfig> filterWeightConfigure(Set<String> searchEntitySet, List<SmartSearchWordConfig> wordConfigs) {
        if (wordConfigs == null) {
            return Collections.emptyList();
        }
        ArrayList newWordConfigList = Lists.newArrayListWithCapacity((int)10);
        for (SmartSearchWordConfig wordConfig : wordConfigs) {
            List<SmartSearchBoostGroup> boostGroupListCopy = this.filterBoostGroupList(searchEntitySet, wordConfig.getBoostGroupList());
            if (boostGroupListCopy.isEmpty()) continue;
            SmartSearchWordConfig wordConfigCopy = new SmartSearchWordConfig(wordConfig.getAiField());
            wordConfigCopy.setGptkwAnalysisBO(wordConfig.getGptkwAnalysisBO());
            wordConfigCopy.setBoostGroupList(boostGroupListCopy);
            newWordConfigList.add(wordConfigCopy);
        }
        return newWordConfigList;
    }

    private List<SmartSearchBoostGroup> filterBoostGroupList(Set<String> searchEntitySet, List<SmartSearchBoostGroup> boostGroupList) {
        ArrayList boostGroupListCopy = Lists.newArrayListWithCapacity((int)boostGroupList.size());
        for (SmartSearchBoostGroup boostGroup : boostGroupList) {
            List collect = boostGroup.getEntityList().stream().filter(entity -> searchEntitySet.contains(entity.getEntityAlias())).collect(Collectors.toList());
            if (collect.isEmpty()) continue;
            SmartSearchBoostGroup boostGroupCopy = new SmartSearchBoostGroup(boostGroup.getBoostValue());
            boostGroupCopy.setEntityList(collect);
            boostGroupListCopy.add(boostGroupCopy);
        }
        return boostGroupListCopy;
    }
}

