/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrss.business.domain.search.service.query;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.enums.ESSearchTypeEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchCategoryEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchKeyLogicEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.smartsearch.SmartSearchBoostGroup;
import kd.hr.hbp.common.model.smartsearch.search.SearchParam;
import kd.hrmp.hrss.business.domain.search.service.common.SearchParamUtil;
import kd.hrmp.hrss.business.domain.search.service.query.EsQueryBuilder;
import kd.hrmp.hrss.business.domain.search.service.query.ISearchBuilderItemService;
import kd.hrmp.hrss.business.domain.search.service.searchweight.SearchWeightConfHelper;
import kd.hrmp.hrss.common.model.search.InputFilterAnalysisRst;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class FulltextSearchBuilderService
implements ISearchBuilderItemService {
    @Override
    public BoolQueryBuilder createSearchBuilder(SearchParam searchParam, HRComplexObjContext complexObjContext, InputFilterAnalysisRst inputFilterAnalysisRst) {
        BoolQueryBuilder itemQueryBuilder = QueryBuilders.boolQuery();
        ESSearchTypeEnum searchTypeEnum = ESSearchTypeEnum.MATCH;
        if (searchParam.getCategory() == SearchCategoryEnum.PHRASE_SEARCH) {
            searchTypeEnum = ESSearchTypeEnum.MATCH_PHRASE;
        }
        QueryBuilder searchKeyQueryBuilder = null;
        if (inputFilterAnalysisRst != null && inputFilterAnalysisRst.getGptFilterResult() != null) {
            searchKeyQueryBuilder = EsQueryBuilder.getQueryBuilder(complexObjContext, searchTypeEnum, inputFilterAnalysisRst.getGptFilterResult(), inputFilterAnalysisRst.getSearchWordConfigList());
        }
        if (searchKeyQueryBuilder != null) {
            return itemQueryBuilder.should(searchKeyQueryBuilder);
        }
        List<SmartSearchBoostGroup> defWeightConfig = SearchWeightConfHelper.getInstance().getDefWeightConfig(searchParam.getSceneId());
        if (CollectionUtils.isEmpty(defWeightConfig)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u9ed8\u8ba4\u6392\u5e8f\u6743\u91cd\u201d\u3002", (String)"SearchQBuilderService_1", (String)"hrmp-hrss-business", (Object[])new Object[0]));
        }
        List<String> searchContentList = SearchParamUtil.getSearchContentList(searchParam);
        for (String searchContent : searchContentList) {
            QueryBuilder queryBuilder = EsQueryBuilder.parseWordConfig(searchTypeEnum, searchContent, complexObjContext, defWeightConfig);
            if (searchParam.getSearchKeyLogic() == SearchKeyLogicEnum.AND) {
                itemQueryBuilder.must(queryBuilder);
                continue;
            }
            itemQueryBuilder.should(queryBuilder);
        }
        return itemQueryBuilder;
    }
}

